/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.DBConnector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class Experiment
implements Serializable {
    private static String[] fieldNames;
    private static int[] fieldTypes;
    private int experimentID;
    private int applicationID;
    private String name;
    private String[] fields;

    public Experiment() {
        this.fields = fieldNames == null ? new String[0] : new String[fieldNames.length];
    }

    public Experiment(Experiment experiment) {
        this.name = experiment.getName();
        this.applicationID = experiment.getApplicationID();
        this.experimentID = experiment.getID();
        this.fields = (String[])experiment.fields.clone();
    }

    public void reallocMetaData() {
        this.fields = fieldNames == null ? new String[0] : new String[fieldNames.length];
    }

    public String[] getFields() {
        return this.fields;
    }

    public void setFields(String[] stringArray) {
        this.fields = stringArray;
    }

    public static void getMetaData(DB dB) {
        if (fieldNames != null) {
            return;
        }
        try {
            int n;
            ResultSet resultSet = null;
            Object var2_3 = null;
            Object var3_4 = null;
            DatabaseMetaData databaseMetaData = dB.getMetaData();
            resultSet = dB.getDBType().compareTo("oracle") == 0 || dB.getDBType().compareTo("derby") == 0 || dB.getDBType().compareTo("db2") == 0 ? databaseMetaData.getColumns(null, null, "EXPERIMENT", "%") : databaseMetaData.getColumns(null, null, "experiment", "%");
            Vector<String> vector = new Vector<String>();
            Vector<Integer> vector2 = new Vector<Integer>();
            boolean bl = false;
            while (resultSet.next()) {
                n = resultSet.getInt("DATA_TYPE");
                String string = resultSet.getString("COLUMN_NAME");
                String string2 = resultSet.getString("TYPE_NAME");
                if (string.equals("ID")) {
                    if (bl) break;
                    bl = true;
                }
                if (!DBConnector.isReadAbleType(n) || string.toUpperCase().compareTo("ID") == 0 || string.toUpperCase().compareTo("NAME") == 0 || string.toUpperCase().compareTo("APPLICATION") == 0) continue;
                vector.add(resultSet.getString("COLUMN_NAME"));
                vector2.add(new Integer(n));
            }
            resultSet.close();
            fieldNames = new String[vector.size()];
            fieldTypes = new int[vector2.size()];
            for (n = 0; n < vector2.size(); ++n) {
                Experiment.fieldNames[n] = (String)vector.get(n);
                Experiment.fieldTypes[n] = (Integer)vector2.get(n);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public String getFieldName(int n) {
        return fieldNames[n];
    }

    public String getField(int n) {
        return this.fields[n];
    }

    public int getFieldType(int n) {
        return fieldTypes[n];
    }

    public void setField(int n, String string) {
        if (DBConnector.isIntegerType(fieldTypes[n]) && string != null) {
            try {
                int n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        if (DBConnector.isFloatingPointType(fieldTypes[n]) && string != null) {
            try {
                double d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        this.fields[n] = string;
    }

    public int getID() {
        return this.experimentID;
    }

    public int getApplicationID() {
        return this.applicationID;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setID(int n) {
        this.experimentID = n;
    }

    public void setApplicationID(int n) {
        this.applicationID = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public static String[] getFieldNames(DB dB) throws DatabaseException {
        Experiment.getMetaData(dB);
        return fieldNames;
    }

    public static Vector getExperimentList(DB dB, String string) throws DatabaseException {
        try {
            Experiment.getMetaData(dB);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select id, application, name");
            for (int i = 0; i < fieldNames.length; ++i) {
                stringBuffer.append(", " + fieldNames[i]);
            }
            stringBuffer.append(" from ");
            stringBuffer.append(dB.getSchemaPrefix());
            stringBuffer.append("experiment ");
            stringBuffer.append(string);
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append(" order by dbms_lob.substr(name) asc");
            } else if (dB.getDBType().compareTo("derby") == 0) {
                stringBuffer.append(" order by cast(name as varchar(256)) asc");
            } else if (dB.getDBType().compareTo("db2") == 0) {
                stringBuffer.append(" order by cast(name as varchar(256)) asc");
            } else {
                stringBuffer.append(" order by name asc ");
            }
            Vector<Experiment> vector = new Vector<Experiment>();
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                Experiment experiment = new Experiment();
                experiment.setID(resultSet.getInt(1));
                experiment.setApplicationID(resultSet.getInt(2));
                experiment.setName(resultSet.getString(3));
                for (int i = 0; i < fieldNames.length; ++i) {
                    experiment.setField(i, resultSet.getString(i + 4));
                }
                vector.addElement(experiment);
            }
            resultSet.close();
            return vector;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Error getting experiment list", sQLException);
        }
    }

    public int saveExperiment(DB dB) throws SQLException {
        int n;
        boolean bl = this.exists(dB);
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("UPDATE " + dB.getSchemaPrefix() + "experiment SET application = ?, name = ?");
            for (n = 0; n < this.getNumFields(); ++n) {
                if (!DBConnector.isWritableType(this.getFieldType(n))) continue;
                stringBuffer.append(", " + this.getFieldName(n) + " = ?");
            }
            stringBuffer.append(" WHERE id = ?");
        } else {
            stringBuffer.append("INSERT INTO " + dB.getSchemaPrefix() + "experiment (application, name");
            for (n = 0; n < this.getNumFields(); ++n) {
                if (!DBConnector.isWritableType(this.getFieldType(n))) continue;
                stringBuffer.append(", " + this.getFieldName(n));
            }
            stringBuffer.append(") VALUES (?, ?");
            for (n = 0; n < this.getNumFields(); ++n) {
                if (!DBConnector.isWritableType(this.getFieldType(n))) continue;
                stringBuffer.append(", ?");
            }
            stringBuffer.append(")");
        }
        PreparedStatement preparedStatement = dB.prepareStatement(stringBuffer.toString());
        int n3 = 1;
        preparedStatement.setInt(n3++, this.applicationID);
        preparedStatement.setString(n3++, this.name);
        for (int i = 0; i < this.getNumFields(); ++i) {
            if (!DBConnector.isWritableType(this.getFieldType(i))) continue;
            preparedStatement.setString(n3++, this.getField(i));
        }
        if (bl) {
            preparedStatement.setInt(n3++, this.getID());
        }
        preparedStatement.executeUpdate();
        preparedStatement.close();
        if (bl) {
            n2 = this.experimentID;
        } else {
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM experiment" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM experiment" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "experiment_id_seq.currval FROM dual" : "select currval('experiment_id_seq');")));
            n2 = Integer.parseInt(dB.getDataItem(string));
        }
        return n2;
    }

    private boolean exists(DB dB) throws SQLException {
        boolean bl = false;
        PreparedStatement preparedStatement = dB.prepareStatement("SELECT application FROM " + dB.getSchemaPrefix() + "experiment WHERE id = ?");
        preparedStatement.setInt(1, this.experimentID);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        return bl;
    }

    public static void deleteExperiment(DB dB, int n) throws DatabaseException {
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("delete from " + dB.getSchemaPrefix() + "experiment where id = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Error deleting experiment", sQLException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (fieldNames == null) {
            fieldNames = (String[])objectInputStream.readObject();
        }
        if (fieldTypes == null) {
            fieldTypes = (int[])objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(fieldNames);
        objectOutputStream.writeObject(fieldTypes);
    }
}

