/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Function
implements Serializable,
Comparable {
    private String name = null;
    private String reversedName = null;
    private int id = -1;
    private List groups = new ArrayList();
    private boolean phase = false;
    private Function actualPhase;
    private Function parentPhase;
    boolean callpathFunction = false;
    boolean callpathFunctionSet = false;
    private FunctionProfile meanProfile;
    private FunctionProfile stddevProfile;
    private FunctionProfile totalProfile;
    private boolean colorFlag = false;
    private Color color = null;
    private Color specificColor = null;

    public Function(String string, int n, int n2) {
        this.name = string;
        this.id = n;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getReversedName() {
        if (this.reversedName == null) {
            if (!this.isCallPathFunction()) {
                this.reversedName = this.name;
            } else {
                String string = this.name;
                int n = string.lastIndexOf("=>");
                this.reversedName = "";
                while (n != -1) {
                    String string2 = string.substring(n + 3, string.length());
                    string2 = string2.trim();
                    this.reversedName = this.reversedName + string2;
                    if ((n = (string = string.substring(0, n)).lastIndexOf("=>")) == -1) continue;
                    this.reversedName = this.reversedName + " <= ";
                }
                this.reversedName = this.reversedName + " <= " + string;
            }
        }
        return this.reversedName.trim();
    }

    public String toString() {
        return this.name;
    }

    public void addGroup(Group group) {
        if (this.isGroupMember(group)) {
            return;
        }
        this.groups.add(group);
    }

    public boolean isGroupMember(Group group) {
        return this.groups.contains(group);
    }

    public List getGroups() {
        return this.groups;
    }

    public String getGroupString() {
        String string = "";
        for (int i = 0; i < this.groups.size(); ++i) {
            Group group = (Group)this.groups.get(i);
            string = i == 0 ? group.getName() : string + " | " + group.getName();
        }
        return string;
    }

    public boolean isPhaseMember(Function function) {
        if (function == this) {
            return true;
        }
        if (function == null) {
            return true;
        }
        if (!this.isCallPathFunction()) {
            return false;
        }
        int n = this.name.indexOf("=>");
        String string = this.name.substring(0, n).trim();
        return string.compareTo(function.getName()) == 0;
    }

    public boolean isCallPathFunction() {
        if (!this.callpathFunctionSet) {
            if (this.name.indexOf("=>") > 0) {
                this.callpathFunction = true;
            }
            this.callpathFunctionSet = true;
        }
        return this.callpathFunction;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        if (this.colorFlag) {
            return this.specificColor;
        }
        return this.color;
    }

    public void setColorFlag(boolean bl) {
        this.colorFlag = bl;
    }

    public boolean isColorFlagSet() {
        return this.colorFlag;
    }

    public void setSpecificColor(Color color) {
        this.specificColor = color;
    }

    public void setStddevProfile(FunctionProfile functionProfile) {
        this.stddevProfile = functionProfile;
    }

    public FunctionProfile getStddevProfile() {
        return this.stddevProfile;
    }

    public void setMeanProfile(FunctionProfile functionProfile) {
        this.meanProfile = functionProfile;
    }

    public FunctionProfile getMeanProfile() {
        return this.meanProfile;
    }

    public double getMeanInclusive(int n) {
        return this.meanProfile.getInclusive(n);
    }

    public double getMeanExclusive(int n) {
        return this.meanProfile.getExclusive(n);
    }

    public double getMeanInclusivePercent(int n) {
        return this.meanProfile.getInclusivePercent(n);
    }

    public double getMeanExclusivePercent(int n) {
        return this.meanProfile.getExclusivePercent(n);
    }

    public double getMeanNumCalls() {
        return this.meanProfile.getNumCalls();
    }

    public double getMeanNumSubr() {
        return this.meanProfile.getNumSubr();
    }

    public double getMeanInclusivePerCall(int n) {
        return this.meanProfile.getInclusivePerCall(n);
    }

    public double getTotalInclusive(int n) {
        return this.totalProfile.getInclusive(n);
    }

    public double getTotalExclusive(int n) {
        return this.totalProfile.getExclusive(n);
    }

    public double getTotalInclusivePercent(int n) {
        return this.totalProfile.getInclusivePercent(n);
    }

    public double getTotalExclusivePercent(int n) {
        return this.totalProfile.getExclusivePercent(n);
    }

    public double getTotalNumCalls() {
        return this.totalProfile.getNumCalls();
    }

    public double getTotalNumSubr() {
        return this.totalProfile.getNumSubr();
    }

    public double getTotalInclusivePerCall(int n) {
        return this.totalProfile.getInclusivePerCall(n);
    }

    public void setTotalProfile(FunctionProfile functionProfile) {
        this.totalProfile = functionProfile;
    }

    public FunctionProfile getTotalProfile() {
        return this.totalProfile;
    }

    public int compareTo(Object object) {
        return this.id - ((Function)object).getID();
    }

    public boolean isPhase() {
        return this.phase;
    }

    public void setPhase(boolean bl) {
        this.phase = bl;
    }

    public Function getActualPhase() {
        return this.actualPhase;
    }

    public void setActualPhase(Function function) {
        this.actualPhase = function;
    }

    public Function getParentPhase() {
        return this.parentPhase;
    }

    public void setParentPhase(Function function) {
        this.parentPhase = function;
    }
}

