/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.barchart.BarChartPanel;
import edu.uoregon.tau.paraprof.barchart.GlobalBarChartModel;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.perfdmf.Function;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;

public class GlobalDataWindow
extends JFrame
implements ActionListener,
Observer,
ChangeListener,
ParaProfWindow {
    private ParaProfTrial ppTrial;
    private Function phase;
    private BarChartPanel panel;
    private GlobalBarChartModel model;
    private DataSorter dataSorter;
    private JMenu optionsMenu;
    private JCheckBoxMenuItem nameCheckBox = new JCheckBoxMenuItem("Sort By Name", false);
    private JCheckBoxMenuItem normalizeCheckBox = new JCheckBoxMenuItem("Normalize Bars", true);
    private JCheckBoxMenuItem orderByMeanCheckBox = new JCheckBoxMenuItem("Order By Mean", true);
    private JCheckBoxMenuItem orderCheckBox = new JCheckBoxMenuItem("Descending Order", true);
    private JCheckBoxMenuItem stackBarsCheckBox = new JCheckBoxMenuItem("Stack Bars Together", true);
    private JCheckBoxMenuItem slidersCheckBox;
    private JCheckBoxMenuItem metaDataCheckBox;
    private JLabel barLengthLabel = new JLabel("Bar Width");
    private JSlider barLengthSlider = new JSlider(0, 2000, 600);
    private boolean visible = false;
    private static int defaultWidth = 750;
    private static int defaultHeight = 410;

    public GlobalDataWindow(ParaProfTrial paraProfTrial, Function function) {
        try {
            this.ppTrial = paraProfTrial;
            this.phase = function;
            paraProfTrial.addObserver(this);
            this.dataSorter = new DataSorter(paraProfTrial);
            this.dataSorter.setPhase(function);
            if (function == null) {
                this.setTitle("ParaProf: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
            } else {
                this.setTitle("ParaProf: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()) + " Phase: " + function.getName());
            }
            ((Component)this).setSize(ParaProfUtils.checkSize(new Dimension(defaultWidth, defaultHeight)));
            ((Component)this).setLocation(WindowPlacer.getGlobalDataWindowPosition(this));
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    GlobalDataWindow.this.thisWindowClosing(windowEvent);
                }
            });
            if (ParaProf.demoMode) {
                this.barLengthSlider.setValue(500);
            }
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.model = new GlobalBarChartModel(this, this.dataSorter, paraProfTrial);
            this.panel = new BarChartPanel(this.model, null);
            this.setupMenus();
            this.panel.getBarChart().setLeftJustified(true);
            this.panel.getBarChart().setBarLength(this.barLengthSlider.getValue());
            this.panel.getVerticalScrollBar().setUnitIncrement(35);
            this.setHeader();
            this.barLengthSlider.setPaintTicks(true);
            this.barLengthSlider.setMajorTickSpacing(400);
            this.barLengthSlider.setMinorTickSpacing(50);
            this.barLengthSlider.setPaintLabels(true);
            this.barLengthSlider.addChangeListener(this);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            ParaProfUtils.addCompItem(this, (Component)this.panel, gridBagConstraints, 0, 0, 1, 1);
            this.sortLocalData();
            this.panel.repaint();
            ParaProf.incrementNumWindows();
        }
        catch (Error error) {
            error.printStackTrace();
        }
    }

    public GlobalBarChartModel getModel() {
        return this.model;
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        this.optionsMenu = new JMenu("Options");
        this.slidersCheckBox = new JCheckBoxMenuItem("Show Width Slider", false);
        this.slidersCheckBox.addActionListener(this);
        this.optionsMenu.add(this.slidersCheckBox);
        this.metaDataCheckBox = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
        this.metaDataCheckBox.addActionListener(this);
        this.optionsMenu.add(this.metaDataCheckBox);
        this.optionsMenu.add(new JSeparator());
        this.nameCheckBox.addActionListener(this);
        this.optionsMenu.add(this.nameCheckBox);
        this.normalizeCheckBox.addActionListener(this);
        this.optionsMenu.add(this.normalizeCheckBox);
        this.orderByMeanCheckBox.addActionListener(this);
        this.optionsMenu.add(this.orderByMeanCheckBox);
        this.orderCheckBox.addActionListener(this);
        this.optionsMenu.add(this.orderCheckBox);
        this.stackBarsCheckBox.addActionListener(this);
        this.optionsMenu.add(this.stackBarsCheckBox);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this.panel, this.panel));
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        if (ParaProf.scripts.size() > 0) {
            jMenuBar.add(ParaProfUtils.createScriptMenu(this.ppTrial, this));
        }
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Sort By Name")) {
                    this.setSortByName(this.nameCheckBox.isSelected());
                } else if (string.equals("Normalize Bars")) {
                    this.setNormalized(this.normalizeCheckBox.isSelected());
                } else if (string.equals("Stack Bars Together")) {
                    this.setStackBars(this.stackBarsCheckBox.isSelected());
                } else if (string.equals("Order By Mean")) {
                    this.setSortByMean(this.orderByMeanCheckBox.isSelected());
                } else if (string.equals("Descending Order")) {
                    this.setDescendingOrder(this.orderCheckBox.isSelected());
                } else if (string.equals("Show Width Slider")) {
                    this.showWidthSlider(this.slidersCheckBox.isSelected());
                } else if (string.equals("Show Meta Data in Panel")) {
                    this.setShowMetaData(this.metaDataCheckBox.isSelected());
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.setBarLength(this.barLengthSlider.getValue());
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public int getBarLength() {
        return this.barLengthSlider.getValue();
    }

    public void setBarLength(int n) {
        this.barLengthSlider.setValue(n);
        this.panel.getBarChart().setBarLength(this.barLengthSlider.getValue());
        this.panel.repaint();
    }

    public boolean getWidthSliderShown() {
        return this.slidersCheckBox.isSelected();
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            this.sortLocalData();
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("subWindowCloseEvent") && this != this.ppTrial.getFullDataWindow()) {
            this.closeThisWindow();
        }
    }

    public Dimension getViewportSize() {
        return this.panel.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.panel.getViewport().getViewRect();
    }

    public void setHeader() {
        if (this.metaDataCheckBox.isSelected()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            jTextArea.setMargin(new Insets(3, 3, 3, 3));
            jTextArea.setFont(ParaProf.preferencesWindow.getFont());
            jTextArea.append(this.getHeaderString());
            this.panel.setColumnHeaderView(jTextArea);
        } else {
            this.panel.setColumnHeaderView(null);
        }
    }

    public String getHeaderString() {
        if (this.phase != null) {
            return "Phase: " + this.phase + "\nMetric: " + this.ppTrial.getMetricName(this.ppTrial.getDefaultMetricID()) + "\nValue: " + "Exclusive" + "\n";
        }
        return "Metric: " + this.ppTrial.getMetricName(this.ppTrial.getDefaultMetricID()) + "\nValue: " + "Exclusive" + "\n";
    }

    public void showWidthSlider(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.slidersCheckBox.setSelected(bl);
        if (bl) {
            this.getContentPane().remove(this.panel);
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.01;
            ParaProfUtils.addCompItem(this, (Component)this.barLengthLabel, gridBagConstraints, 0, 0, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.7;
            gridBagConstraints.weighty = 0.01;
            ParaProfUtils.addCompItem(this, (Component)this.barLengthSlider, gridBagConstraints, 1, 0, 1, 1);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.99;
            ParaProfUtils.addCompItem(this, (Component)this.panel, gridBagConstraints, 0, 1, 2, 1);
        } else {
            this.getContentPane().remove(this.barLengthLabel);
            this.getContentPane().remove(this.barLengthSlider);
            this.getContentPane().remove(this.panel);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            ParaProfUtils.addCompItem(this, (Component)this.panel, gridBagConstraints, 0, 0, 1, 1);
        }
        this.validate();
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    private void sortLocalData() {
        this.dataSorter.setSelectedMetricID(this.ppTrial.getDefaultMetricID());
        this.dataSorter.setValueType(ValueType.EXCLUSIVE);
        if (this.nameCheckBox.isSelected()) {
            this.dataSorter.setSortType(SortType.NAME);
        } else if (this.orderByMeanCheckBox.isSelected()) {
            this.dataSorter.setSortType(SortType.MEAN_VALUE);
        } else {
            this.dataSorter.setSortType(SortType.MEAN_VALUE);
        }
        this.dataSorter.setDescendingOrder(this.orderCheckBox.isSelected());
        this.model.reloadData();
    }

    public void addNotify() {
        super.addNotify();
        if (this.visible) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            ((Component)this).setSize(dimension);
        }
        this.visible = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        try {
            ((Component)this).setVisible(false);
            if (this != this.ppTrial.getFullDataWindow()) {
                this.ppTrial.deleteObserver(this);
                this.dispose();
            }
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void help(boolean bl) {
        ParaProf.helpWindow.show();
    }

    public Function getPhase() {
        return this.phase;
    }

    public boolean getSortByName() {
        return this.nameCheckBox.isSelected();
    }

    public void setSortByName(boolean bl) {
        this.nameCheckBox.setSelected(bl);
        this.sortLocalData();
        this.panel.repaint();
    }

    public boolean getNormalized() {
        return this.normalizeCheckBox.isSelected();
    }

    public void setNormalized(boolean bl) {
        this.normalizeCheckBox.setSelected(bl);
        this.panel.getBarChart().setNormalized(this.normalizeCheckBox.isSelected());
        this.panel.repaint();
    }

    public boolean getSortByMean() {
        return this.orderByMeanCheckBox.isSelected();
    }

    public void setSortByMean(boolean bl) {
        this.orderByMeanCheckBox.setSelected(bl);
        this.sortLocalData();
        this.panel.repaint();
    }

    public boolean getDescendingOrder() {
        return this.orderCheckBox.isSelected();
    }

    public void setDescendingOrder(boolean bl) {
        this.orderCheckBox.setSelected(bl);
        this.sortLocalData();
        this.panel.repaint();
    }

    public boolean getShowMetaData() {
        return this.metaDataCheckBox.isSelected();
    }

    public void setShowMetaData(boolean bl) {
        this.metaDataCheckBox.setSelected(bl);
        this.setHeader();
    }

    public boolean getStackBars() {
        return this.stackBarsCheckBox.isSelected();
    }

    public void setStackBars(boolean bl) {
        this.stackBarsCheckBox.setSelected(bl);
        if (bl) {
            this.normalizeCheckBox.setEnabled(true);
            this.orderByMeanCheckBox.setEnabled(true);
            this.panel.getBarChart().setNormalized(this.getNormalized());
            this.panel.getBarChart().setStacked(true);
        } else {
            this.normalizeCheckBox.setSelected(false);
            this.normalizeCheckBox.setEnabled(false);
            this.orderByMeanCheckBox.setSelected(true);
            this.orderByMeanCheckBox.setEnabled(false);
            this.panel.getBarChart().setNormalized(this.getNormalized());
            this.panel.getBarChart().setStacked(false);
        }
        this.sortLocalData();
        this.panel.repaint();
    }
}

