/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.JVMDependent;
import edu.uoregon.tau.paraprof.interfaces.ScrollBarController;
import edu.uoregon.tau.paraprof.interfaces.Searchable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class Searcher
implements Searchable,
MouseListener,
MouseMotionListener,
ClipboardOwner {
    private List searchLines = new ArrayList();
    private String searchString = "";
    private int searchLine;
    private int searchColumn;
    private boolean searchHighlight;
    private boolean searchMatchCase;
    private boolean searchUp;
    private int lineHeight = 1;
    private int maxDescent;
    private JComponent panel;
    private ScrollBarController scrollBarController;
    private int firstVisibleLine;
    private int lastVisibleLine;
    private Graphics2D g2d;
    private int xOffset;
    private int topMargin;
    private String selectionString = "";
    private boolean selectionReversed;
    private int selectionStartLine = -1;
    private int selectionEndLine = -1;
    private int selectionStartX;
    private int selectionStartY;
    private int selectionEndX;
    private int selectionEndY;

    public Searcher(JComponent jComponent, ScrollBarController scrollBarController) {
        this.panel = jComponent;
        this.scrollBarController = scrollBarController;
    }

    public void setVisibleLines(int n, int n2) {
        this.firstVisibleLine = n;
        this.lastVisibleLine = n2;
    }

    public void setSearchHighlight(boolean bl) {
        this.searchHighlight = bl;
        this.panel.repaint();
    }

    public void setSearchMatchCase(boolean bl) {
        this.searchMatchCase = bl;
        this.panel.repaint();
    }

    public boolean searchNext() {
        ++this.searchColumn;
        this.setSearchString(this.searchString);
        return false;
    }

    public boolean searchPrevious() {
        this.searchUp = true;
        this.setSearchString(this.searchString);
        this.searchUp = false;
        return false;
    }

    public void setSearchLines(List list) {
        this.searchLines = list;
    }

    public List getSearchLines() {
        return this.searchLines;
    }

    public boolean setSearchString(String string) {
        this.searchString = string;
        if (this.searchLines == null) {
            return false;
        }
        if (string.length() == 0) {
            this.searchLine = 0;
            this.searchColumn = 0;
            this.panel.repaint();
            return true;
        }
        if (!this.searchMatchCase) {
            string = string.toUpperCase();
        }
        boolean bl = false;
        if (this.searchUp) {
            int n = this.searchLine;
            while (n >= 0) {
                String string2 = (String)this.searchLines.get(n);
                if (!this.searchMatchCase) {
                    string2 = string2.toUpperCase();
                }
                this.searchColumn = n != this.searchLine ? string2.length() : --this.searchColumn;
                if (string2.lastIndexOf(string, this.searchColumn) != -1) {
                    this.searchLine = n;
                    this.searchColumn = string2.lastIndexOf(string, this.searchColumn);
                    bl = true;
                    break;
                }
                --n;
            }
            if (!bl) {
                int n2 = this.searchLines.size() - 1;
                while (n2 >= 0) {
                    String string3 = (String)this.searchLines.get(n2);
                    if (!this.searchMatchCase) {
                        string3 = string3.toUpperCase();
                    }
                    this.searchColumn = n2 != this.searchLine ? string3.length() : --this.searchColumn;
                    if (string3.lastIndexOf(string, this.searchColumn) != -1) {
                        this.searchLine = n2;
                        this.searchColumn = string3.lastIndexOf(string, this.searchColumn);
                        bl = true;
                        break;
                    }
                    --n2;
                }
            }
        } else {
            int n = this.searchLine;
            while (n < this.searchLines.size()) {
                String string4 = (String)this.searchLines.get(n);
                if (!this.searchMatchCase) {
                    string4 = string4.toUpperCase();
                }
                if (string4.indexOf(string, this.searchColumn) != -1) {
                    this.searchLine = n;
                    this.searchColumn = string4.indexOf(string, this.searchColumn);
                    bl = true;
                    break;
                }
                this.searchColumn = 0;
                ++n;
            }
            if (!bl) {
                int n3 = 0;
                while (n3 < this.searchLines.size()) {
                    String string5 = (String)this.searchLines.get(n3);
                    if (!this.searchMatchCase) {
                        string5 = string5.toUpperCase();
                    }
                    this.searchColumn = n3 == this.searchLine ? ++this.searchColumn : 0;
                    if (string5.indexOf(string, this.searchColumn) != -1) {
                        this.searchLine = n3;
                        this.searchColumn = string5.indexOf(string, this.searchColumn);
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
        }
        if (!bl) {
            this.panel.repaint();
            return false;
        }
        this.checkSearchStringVisibility();
        this.panel.repaint();
        return true;
    }

    private void checkSearchStringVisibility() {
        Object object;
        String string = this.searchString;
        if (this.searchLine <= this.firstVisibleLine || this.searchLine >= this.lastVisibleLine - 1) {
            object = this.scrollBarController.getThisViewportSize();
            this.scrollBarController.setVerticalScrollBarPosition(this.searchLine * this.lineHeight - (int)((Dimension)object).getHeight() / 2);
        }
        object = (String)this.searchLines.get(this.searchLine);
        if (!this.searchMatchCase) {
            string = this.searchString.toUpperCase();
            object = ((String)object).toUpperCase();
        }
        TextLayout textLayout = new TextLayout((String)object, this.g2d.getFont(), this.g2d.getFontRenderContext());
        Shape shape = textLayout.getLogicalHighlightShape(((String)object).indexOf(string, this.searchColumn), ((String)object).indexOf(string, this.searchColumn) + string.length());
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.xOffset, this.searchLine * this.lineHeight);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        this.scrollBarController.setHorizontalScrollBarPosition(0);
        this.panel.scrollRectToVisible(shape2.getBounds());
    }

    public void drawHighlights(Graphics2D graphics2D, int n, int n2, int n3) {
        Object object;
        Object object2;
        Object object3;
        String string = (String)this.searchLines.get(n3);
        String string2 = (String)this.searchLines.get(n3);
        TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
        String string3 = this.searchString;
        if (!this.searchMatchCase) {
            string = string.toUpperCase();
            string3 = this.searchString.toUpperCase();
        }
        if (this.searchHighlight && string3.length() > 0) {
            int n4 = 0;
            while (string.indexOf(string3, n4) != -1) {
                n4 = string.indexOf(string3, n4);
                object3 = textLayout.getLogicalHighlightShape(string.indexOf(string3, n4), string.indexOf(string3, n4) + string3.length());
                object2 = AffineTransform.getTranslateInstance(n, n2);
                object = ((AffineTransform)object2).createTransformedShape((Shape)object3);
                graphics2D.setPaint(Searchable.highlightColor);
                graphics2D.fill((Shape)object);
                ++n4;
            }
        }
        if (n3 == this.searchLine && string.indexOf(string3, this.searchColumn) != -1 && string3.length() > 0) {
            Shape shape = textLayout.getLogicalHighlightShape(string.indexOf(string3, this.searchColumn), string.indexOf(string3, this.searchColumn) + string3.length());
            object3 = AffineTransform.getTranslateInstance(n, n2);
            object2 = ((AffineTransform)object3).createTransformedShape(shape);
            graphics2D.setPaint(Searchable.searchColor);
            graphics2D.fill((Shape)object2);
        }
        if (n3 >= this.selectionStartLine || n3 <= this.selectionEndLine) {
            if (this.selectionStartLine == this.selectionEndLine && n3 == this.selectionStartLine) {
                int n5 = Math.min(this.selectionStartX, this.selectionEndX);
                int n6 = Math.max(this.selectionStartX, this.selectionEndX);
                object2 = textLayout.hitTestChar(n5 - n, this.selectionStartY);
                object = textLayout.hitTestChar(n6 - n, this.selectionEndY);
                int n7 = 0;
                int n8 = textLayout.getCharacterCount();
                if (object2 != null) {
                    n7 = ((TextHitInfo)object2).getInsertionIndex();
                }
                if (object != null) {
                    n8 = ((TextHitInfo)object).getInsertionIndex();
                }
                Shape shape = textLayout.getLogicalHighlightShape(n7, n8);
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n2);
                Shape shape2 = affineTransform.createTransformedShape(shape);
                graphics2D.setPaint(Searchable.selectionColor);
                Rectangle rectangle = shape2.getBounds();
                rectangle.grow(0, this.lineHeight - rectangle.height);
                graphics2D.fill(rectangle);
            } else {
                Rectangle rectangle;
                Shape shape;
                if (n3 == this.selectionStartLine) {
                    int n9 = this.selectionStartX;
                    if (this.selectionReversed) {
                        n9 = this.selectionEndX;
                    }
                    if ((object3 = textLayout.hitTestChar(n9 - n, this.selectionStartY)) != null) {
                        object2 = textLayout.getLogicalHighlightShape(((TextHitInfo)object3).getInsertionIndex(), textLayout.getCharacterCount());
                        object = AffineTransform.getTranslateInstance(n, n2);
                        shape = ((AffineTransform)object).createTransformedShape((Shape)object2);
                        rectangle = shape.getBounds();
                        rectangle.grow(0, this.lineHeight - rectangle.height);
                        graphics2D.setPaint(new Color(184, 207, 229));
                        graphics2D.fill(rectangle);
                    }
                }
                if (n3 > this.selectionStartLine && n3 < this.selectionEndLine) {
                    Shape shape3 = textLayout.getLogicalHighlightShape(0, textLayout.getCharacterCount());
                    object3 = AffineTransform.getTranslateInstance(n, n2);
                    object2 = ((AffineTransform)object3).createTransformedShape(shape3);
                    object = object2.getBounds();
                    ((Rectangle)object).grow(0, this.lineHeight - ((Rectangle)object).height);
                    graphics2D.setPaint(new Color(184, 207, 229));
                    graphics2D.fill((Shape)object);
                }
                if (n3 == this.selectionEndLine) {
                    int n10 = this.selectionEndX;
                    if (this.selectionReversed) {
                        n10 = this.selectionStartX;
                    }
                    if ((object3 = textLayout.hitTestChar(n10 - n, this.selectionStartY)) != null) {
                        object2 = textLayout.getLogicalHighlightShape(0, ((TextHitInfo)object3).getInsertionIndex());
                        object = AffineTransform.getTranslateInstance(n, n2);
                        shape = ((AffineTransform)object).createTransformedShape((Shape)object2);
                        rectangle = shape.getBounds();
                        rectangle.grow(0, this.lineHeight - rectangle.height);
                        graphics2D.setPaint(new Color(184, 207, 229));
                        graphics2D.fill(rectangle);
                    }
                }
            }
        }
    }

    public String getSelectionString() {
        return this.selectionString;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.selectionStartX = mouseEvent.getX();
        this.selectionStartY = mouseEvent.getY() - this.topMargin;
        this.selectionStartLine = (mouseEvent.getY() - this.topMargin) / this.lineHeight;
    }

    private void determineSelection() {
        this.selectionString = "";
        int n = this.selectionStartLine;
        while (n <= this.selectionEndLine) {
            int n2;
            if (n >= this.searchLines.size()) break;
            if (n < 0 || n >= this.searchLines.size()) {
                return;
            }
            String string = (String)this.searchLines.get(n);
            TextLayout textLayout = new TextLayout(string, this.g2d.getFont(), this.g2d.getFontRenderContext());
            if (this.selectionStartLine == this.selectionEndLine && n == this.selectionStartLine) {
                n2 = Math.min(this.selectionStartX, this.selectionEndX);
                int n3 = Math.max(this.selectionStartX, this.selectionEndX);
                TextHitInfo textHitInfo = textLayout.hitTestChar(n2 - this.xOffset, this.selectionStartY);
                TextHitInfo textHitInfo2 = textLayout.hitTestChar(n3 - this.xOffset, this.selectionEndY);
                int n4 = 0;
                int n5 = textLayout.getCharacterCount();
                if (textHitInfo != null) {
                    n4 = textHitInfo.getInsertionIndex();
                }
                if (textHitInfo2 != null) {
                    n5 = textHitInfo2.getInsertionIndex();
                }
                this.selectionString = string.substring(n4, n5);
            } else {
                if (n == this.selectionStartLine) {
                    TextHitInfo textHitInfo;
                    n2 = this.selectionStartX;
                    if (this.selectionReversed) {
                        n2 = this.selectionEndX;
                    }
                    if ((textHitInfo = textLayout.hitTestChar(n2 - this.xOffset, this.selectionStartY)) != null) {
                        this.selectionString = this.selectionString + string.substring(textHitInfo.getInsertionIndex()) + "\n";
                    }
                }
                if (n > this.selectionStartLine && n < this.selectionEndLine) {
                    this.selectionString = this.selectionString + string + "\n";
                }
                if (n == this.selectionEndLine) {
                    TextHitInfo textHitInfo;
                    n2 = this.selectionEndX;
                    if (this.selectionReversed) {
                        n2 = this.selectionStartX;
                    }
                    if ((textHitInfo = textLayout.hitTestChar(n2 - this.xOffset, this.selectionStartY)) != null) {
                        this.selectionString = this.selectionString + string.substring(0, textHitInfo.getInsertionIndex());
                    }
                }
            }
            ++n;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.selectionEndX = mouseEvent.getX();
        this.selectionEndY = mouseEvent.getY() - this.topMargin;
        if (this.selectionStartY < this.selectionEndY) {
            this.selectionStartLine = this.selectionStartY / this.lineHeight;
            this.selectionEndLine = this.selectionEndY / this.lineHeight;
        } else {
            this.selectionEndLine = this.selectionStartY / this.lineHeight;
            this.selectionStartLine = this.selectionEndY / this.lineHeight;
        }
        this.determineSelection();
        JVMDependent.setClipboardContents(this.selectionString, this);
        this.panel.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.selectionEndX = mouseEvent.getX();
        this.selectionEndY = mouseEvent.getY() - this.topMargin - this.maxDescent;
        if (this.selectionStartY < this.selectionEndY) {
            this.selectionStartLine = this.selectionStartY / this.lineHeight;
            this.selectionEndLine = this.selectionEndY / this.lineHeight;
            this.selectionReversed = false;
        } else {
            this.selectionEndLine = this.selectionStartY / this.lineHeight;
            this.selectionStartLine = this.selectionEndY / this.lineHeight;
            this.selectionReversed = true;
        }
        Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 1, 1);
        this.panel.scrollRectToVisible(rectangle);
        this.panel.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        this.selectionStartY = -1;
        this.selectionEndY = -1;
        this.selectionStartLine = -1;
        this.selectionEndLine = -1;
        this.panel.repaint();
    }

    public void setXOffset(int n) {
        this.xOffset = n;
    }

    public void setG2d(Graphics2D graphics2D) {
        this.g2d = graphics2D;
    }

    public void setLineHeight(int n) {
        this.lineHeight = Math.max(1, n);
    }

    public void setMaxDescent(int n) {
        this.maxDescent = n;
    }

    public void setTopMargin(int n) {
        this.topMargin = n;
    }
}

