/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.CallPathDrawObject;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Searcher;
import edu.uoregon.tau.paraprof.interfaces.ImageExport;
import edu.uoregon.tau.perfdmf.CallPathUtilFuncs;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class CallPathTextWindowPanel
extends JPanel
implements MouseListener,
Printable,
ImageExport {
    private int xPanelSize = 625;
    private int yPanelSize = 0;
    private boolean calculatePanelSize = true;
    private Thread thread;
    private ParaProfTrial ppTrial = null;
    private CallPathTextWindow window = null;
    private Font monoFont = null;
    private FontMetrics fontMetrics = null;
    private Vector drawObjectsComplete = null;
    private Vector drawObjects = null;
    private int base = 20;
    private int startPosition = 0;
    private int excPos = 0;
    private int incPos = 0;
    private int callsPos1 = 0;
    private int namePos = 0;
    private int yHeightNeeded = 0;
    private int xWidthNeeded = 0;
    private int rowHeight = 10;
    private int lastHeaderEndPosition = 0;
    private Searcher searcher;
    private String normalHeader = "      Exclusive        Inclusive      Calls/Tot.Calls     Name[id]";
    private String normalDashString = "      --------------------------------------------------------------------------------";

    public CallPathTextWindowPanel(ParaProfTrial paraProfTrial, Thread thread, CallPathTextWindow callPathTextWindow) {
        this.thread = thread;
        this.ppTrial = paraProfTrial;
        this.window = callPathTextWindow;
        this.setAutoscrolls(true);
        this.searcher = new Searcher(this, callPathTextWindow);
        this.addMouseListener(this.searcher);
        this.addMouseMotionListener(this.searcher);
        this.setBackground(Color.white);
        this.addMouseListener(this);
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.export((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.export((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    private void createDrawObjectsComplete() {
        this.drawObjectsComplete = new Vector();
        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
        ListIterator listIterator = this.window.getDataIterator();
        while (listIterator.hasNext()) {
            Iterator iterator;
            Object object;
            PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)listIterator.next();
            if (pPFunctionProfile.isCallPathObject()) continue;
            Iterator iterator2 = pPFunctionProfile.getParentProfiles();
            while (iterator2.hasNext()) {
                Object object2;
                object = (FunctionProfile)iterator2.next();
                iterator = pPFunctionProfile.getFunctionProfile().getParentProfileCallPathIterator((FunctionProfile)object);
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                while (iterator.hasNext()) {
                    object2 = (FunctionProfile)iterator.next();
                    d += object2.getExclusive(this.ppTrial.getDefaultMetricID());
                    d2 += object2.getInclusive(this.ppTrial.getDefaultMetricID());
                    d3 += object2.getNumCalls();
                }
                object2 = new CallPathDrawObject(object.getFunction(), true, false, false);
                ((CallPathDrawObject)object2).setExclusiveValue(d);
                ((CallPathDrawObject)object2).setInclusiveValue(d2);
                ((CallPathDrawObject)object2).setNumberOfCallsFromCallPathObjects(d3);
                ((CallPathDrawObject)object2).setNumberOfCalls(pPFunctionProfile.getNumberOfCalls());
                this.drawObjectsComplete.add(object2);
            }
            object = new CallPathDrawObject(pPFunctionProfile.getFunction(), false, false, false);
            ((CallPathDrawObject)object).setExclusiveValue(pPFunctionProfile.getExclusiveValue());
            ((CallPathDrawObject)object).setInclusiveValue(pPFunctionProfile.getInclusiveValue());
            ((CallPathDrawObject)object).setNumberOfCalls(pPFunctionProfile.getNumberOfCalls());
            this.drawObjectsComplete.add(object);
            iterator = pPFunctionProfile.getChildProfiles();
            while (iterator.hasNext()) {
                FunctionProfile functionProfile = (FunctionProfile)iterator.next();
                double d = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                Iterator iterator3 = pPFunctionProfile.getFunctionProfile().getChildProfileCallPathIterator(functionProfile);
                while (iterator3.hasNext()) {
                    FunctionProfile functionProfile2 = (FunctionProfile)iterator3.next();
                    d += functionProfile2.getExclusive(this.ppTrial.getDefaultMetricID());
                    d4 += functionProfile2.getInclusive(this.ppTrial.getDefaultMetricID());
                    d5 += functionProfile2.getNumCalls();
                }
                object = new CallPathDrawObject(functionProfile.getFunction(), false, true, false);
                ((CallPathDrawObject)object).setExclusiveValue(d);
                ((CallPathDrawObject)object).setInclusiveValue(d4);
                ((CallPathDrawObject)object).setNumberOfCallsFromCallPathObjects(d5);
                ((CallPathDrawObject)object).setNumberOfCalls(functionProfile.getNumCalls());
                this.drawObjectsComplete.add(object);
            }
            this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
            this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
        }
    }

    private void createDrawObjects() {
        this.drawObjects = new Vector();
        Vector<CallPathDrawObject> vector = new Vector<CallPathDrawObject>();
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        if (this.window.showCollapsedView()) {
            Enumeration enumeration = this.drawObjectsComplete.elements();
            while (enumeration.hasMoreElements()) {
                CallPathDrawObject callPathDrawObject = (CallPathDrawObject)enumeration.nextElement();
                n = callPathDrawObject.isSpacer() ? 0 : (callPathDrawObject.isParent() ? (bl ? 1 : 2) : (callPathDrawObject.isChild() ? (bl ? 3 : 4) : (bl ? 5 : 6)));
                switch (n) {
                    case 0: {
                        this.drawObjects.add(callPathDrawObject);
                        break;
                    }
                    case 1: {
                        bl = false;
                        vector.add(callPathDrawObject);
                        break;
                    }
                    case 2: {
                        vector.add(callPathDrawObject);
                        break;
                    }
                    case 3: {
                        this.drawObjects.add(callPathDrawObject);
                        break;
                    }
                    case 5: {
                        n2 = vector.size();
                        int n3 = 0;
                        while (n3 < n2) {
                            this.drawObjects.add(vector.elementAt(n3));
                            ++n3;
                        }
                        vector.clear();
                        this.drawObjects.add(callPathDrawObject);
                        if (callPathDrawObject.isExpanded()) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 6: {
                        if (callPathDrawObject.isExpanded()) {
                            n2 = vector.size();
                            int n4 = 0;
                            while (n4 < n2) {
                                this.drawObjects.add(vector.elementAt(n4));
                                ++n4;
                            }
                            vector.clear();
                            bl = true;
                        } else {
                            vector.clear();
                        }
                        this.drawObjects.add(callPathDrawObject);
                        break;
                    }
                }
            }
        } else {
            this.drawObjects = this.drawObjectsComplete;
        }
    }

    private void setSearchLines() {
        if (this.searcher.getSearchLines() == null) {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < this.drawObjects.size()) {
                Function function;
                String string;
                CallPathDrawObject callPathDrawObject = (CallPathDrawObject)this.drawObjects.elementAt(n);
                if (n == 1) {
                    string = this.normalHeader;
                } else if (n == 2) {
                    string = this.normalDashString;
                } else if (!callPathDrawObject.isParentChild() && !callPathDrawObject.isSpacer()) {
                    function = callPathDrawObject.getFunction();
                    string = "--> " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getExclusiveValue(), (int)11) + "      " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getInclusiveValue(), (int)11) + "      " + UtilFncs.formatDouble((double)callPathDrawObject.getNumberOfCalls(), (int)7, (boolean)false);
                    string = UtilFncs.pad((String)string, (int)58) + callPathDrawObject.getName() + "[" + function.getID() + "]";
                } else if (callPathDrawObject.isSpacer()) {
                    string = " ";
                } else {
                    function = callPathDrawObject.getFunction();
                    string = "    " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getExclusiveValue(), (int)11) + "      " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getInclusiveValue(), (int)11) + "      " + UtilFncs.formatDouble((double)callPathDrawObject.getNumberOfCallsFromCallPathObjects(), (int)7, (boolean)false) + "/" + UtilFncs.formatDouble((double)callPathDrawObject.getNumberOfCalls(), (int)7, (boolean)false);
                    string = UtilFncs.pad((String)string, (int)58) + callPathDrawObject.getName() + "[" + function.getID() + "]";
                }
                vector.add(string);
                ++n;
            }
            this.searcher.setSearchLines(vector);
        }
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2 = 0;
        this.monoFont = new Font("Monospaced", this.ppTrial.getPreferencesWindow().getFontStyle(), ParaProf.preferencesWindow.getFontSize());
        this.fontMetrics = graphics2D.getFontMetrics(this.monoFont);
        int n3 = this.fontMetrics.getMaxAscent();
        int n4 = this.fontMetrics.getMaxDescent();
        graphics2D.setFont(this.monoFont);
        this.rowHeight = this.fontMetrics.getHeight();
        this.searcher.setXOffset(this.base);
        this.searcher.setG2d(graphics2D);
        this.searcher.setLineHeight(this.rowHeight);
        CallPathDrawObject callPathDrawObject = null;
        CallPathUtilFuncs.buildThreadRelations((DataSource)this.ppTrial.getDataSource(), (Thread)this.thread);
        if (this.drawObjectsComplete == null) {
            this.createDrawObjectsComplete();
        }
        if (this.drawObjects == null) {
            this.createDrawObjects();
            this.searcher.setSearchLines(null);
            this.setSearchLines();
        }
        if (this.calculatePanelSize) {
            int n5 = 0;
            Enumeration enumeration = this.drawObjects.elements();
            while (enumeration.hasMoreElements()) {
                callPathDrawObject = (CallPathDrawObject)enumeration.nextElement();
                this.yHeightNeeded += this.rowHeight;
                if (callPathDrawObject.isSpacer()) continue;
                n5 = Math.max(n5, callPathDrawObject.getName().length());
            }
            n = this.fontMetrics.stringWidth("A");
            this.startPosition = this.fontMetrics.stringWidth("--> ") + this.base;
            this.excPos = this.base + n * 4;
            this.incPos = this.excPos + n * 17;
            this.callsPos1 = this.incPos + n * 17;
            this.namePos = this.callsPos1 + n * 20;
            this.xWidthNeeded = n5 * n + this.namePos + 30;
            boolean bl4 = false;
            if (this.xWidthNeeded > this.xPanelSize) {
                this.xPanelSize = this.xWidthNeeded + 10;
                bl4 = true;
            }
            if (this.yHeightNeeded > this.yPanelSize) {
                this.yPanelSize = this.yHeightNeeded + 10;
                bl4 = true;
            }
            if (bl4 && bl) {
                this.revalidate();
            }
            this.calculatePanelSize = false;
        }
        int[] nArray = ParaProfUtils.computeClipping(graphics2D.getClipBounds(), this.window.getViewRect(), bl, bl2, this.drawObjects.size(), this.rowHeight, n2);
        int n6 = nArray[0];
        n = nArray[1];
        n2 = nArray[2];
        graphics2D.setColor(Color.black);
        if (bl3) {
            JScrollPane jScrollPane = this.window.getScrollPane();
            jScrollPane.getColumnHeader().paintAll(graphics2D);
            graphics2D.translate(0, jScrollPane.getColumnHeader().getHeight());
        }
        n2 += this.rowHeight;
        int n7 = n6;
        while (n7 <= n) {
            Function function;
            String string;
            this.searcher.drawHighlights(graphics2D, this.base, n2, n7);
            graphics2D.setColor(Color.black);
            callPathDrawObject = (CallPathDrawObject)this.drawObjects.elementAt(n7);
            if (n7 == 1) {
                string = this.normalHeader;
                graphics2D.drawString(string, this.base, n2);
            } else if (n7 == 2) {
                string = this.normalDashString;
                graphics2D.drawString(string, this.base, n2);
            } else if (!callPathDrawObject.isParentChild() && !callPathDrawObject.isSpacer()) {
                string = "--> " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getExclusiveValue(), (int)11) + "      " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getInclusiveValue(), (int)11) + "      " + UtilFncs.formatDouble((double)callPathDrawObject.getNumberOfCalls(), (int)7, (boolean)false);
                graphics2D.drawString(string, this.base, n2);
                function = callPathDrawObject.getFunction();
                if (this.ppTrial.getHighlightedFunction() == function) {
                    graphics2D.setColor(Color.red);
                }
                graphics2D.drawString(callPathDrawObject.getName() + "[" + function.getID() + "]", this.namePos, n2);
            } else if (!callPathDrawObject.isSpacer()) {
                string = "    " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getExclusiveValue(), (int)11) + "      " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getInclusiveValue(), (int)11) + "      " + UtilFncs.formatDouble((double)callPathDrawObject.getNumberOfCallsFromCallPathObjects(), (int)7, (boolean)false) + "/" + UtilFncs.formatDouble((double)callPathDrawObject.getNumberOfCalls(), (int)7, (boolean)false);
                function = callPathDrawObject.getFunction();
                if (this.ppTrial.getHighlightedFunction() == function) {
                    graphics2D.setColor(Color.red);
                }
                String string2 = callPathDrawObject.getName() + "[" + function.getID() + "]";
                string = UtilFncs.pad((String)string, (int)58) + string2;
                graphics2D.drawString(string, this.base, n2);
            }
            n2 += this.rowHeight;
            ++n7;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            CallPathDrawObject callPathDrawObject;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = (n2 - 1) / this.rowHeight;
            if (n3 < this.drawObjects.size() && !(callPathDrawObject = (CallPathDrawObject)this.drawObjects.elementAt(n3)).isSpacer()) {
                if (ParaProfUtils.rightClick(mouseEvent)) {
                    JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(this.ppTrial, callPathDrawObject.getFunction(), this.thread, this);
                    JMenuItem jMenuItem = new JMenuItem("Goto Function");
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                Function function = callPathDrawObject.getFunction();
                                int n = CallPathTextWindowPanel.this.drawObjects.size();
                                int n2 = 0;
                                while (n2 < n) {
                                    CallPathDrawObject callPathDrawObject2 = (CallPathDrawObject)CallPathTextWindowPanel.this.drawObjects.elementAt(n2);
                                    if (callPathDrawObject2.getFunction() == function && !callPathDrawObject2.isParentChild()) {
                                        Dimension dimension = CallPathTextWindowPanel.this.window.getViewportSize();
                                        CallPathTextWindowPanel.this.window.setVerticalScrollBarPosition(n2 * CallPathTextWindowPanel.this.rowHeight - (int)dimension.getHeight() / 2);
                                        CallPathTextWindowPanel.this.ppTrial.setHighlightedFunction(function);
                                        return;
                                    }
                                    ++n2;
                                }
                            }
                            catch (Exception exception) {
                                ParaProfUtils.handleException(exception);
                            }
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    if (n < this.startPosition) {
                        if (!callPathDrawObject.isParentChild()) {
                            if (callPathDrawObject.isExpanded()) {
                                callPathDrawObject.setExpanded(false);
                            } else {
                                callPathDrawObject.setExpanded(true);
                            }
                        }
                        this.drawObjects = null;
                    }
                    this.ppTrial.toggleHighlightedFunction(callPathDrawObject.getFunction());
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.window.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    public void resetAllDrawObjects() {
        this.drawObjectsComplete.clear();
        this.drawObjectsComplete = null;
        this.drawObjects.clear();
        this.drawObjects = null;
        this.searcher.setSearchLines(null);
        this.calculatePanelSize = true;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }

    public Searcher getSearcher() {
        return this.searcher;
    }
}

