/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.SearchPanel;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.barchart.BarChart;
import edu.uoregon.tau.paraprof.barchart.BarChartModel;
import edu.uoregon.tau.paraprof.barchart.BarChartPanel;
import edu.uoregon.tau.paraprof.barchart.ComparisonBarChartModel;
import edu.uoregon.tau.paraprof.barchart.FunctionBarChartModel;
import edu.uoregon.tau.paraprof.barchart.LegendPanel;
import edu.uoregon.tau.paraprof.barchart.ThreadBarChartModel;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.SearchableOwner;
import edu.uoregon.tau.paraprof.interfaces.UnitListener;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class FunctionBarChartWindow
extends JFrame
implements KeyListener,
SearchableOwner,
ActionListener,
MenuListener,
Observer,
ChangeListener,
ParaProfWindow,
UnitListener {
    private ParaProfTrial ppTrial;
    private DataSorter dataSorter;
    private Function function;
    private JMenu optionsMenu;
    private JMenu unitsSubMenu;
    private JCheckBoxMenuItem sortByNCTCheckbox;
    private JCheckBoxMenuItem sortByNameCheckBox;
    private JCheckBoxMenuItem descendingOrderCheckBox;
    private JCheckBoxMenuItem showValuesAsPercent;
    private JCheckBoxMenuItem showMetaData;
    private JCheckBoxMenuItem showFindPanelBox;
    private JLabel barLengthLabel = new JLabel("Bar Width");
    private JSlider barLengthSlider = new JSlider(0, 2000, 400);
    private BarChartPanel panel;
    private int units = ParaProf.preferences.getUnits();
    private BarChartModel model;
    private Thread phaseThread;
    private boolean phaseDisplay;
    private SearchPanel searchPanel;
    private PPThread ppThread;
    private Function phase;
    private boolean comparisonChart;

    public FunctionBarChartWindow(ParaProfTrial paraProfTrial, Function function, Component component) {
        this.ppTrial = paraProfTrial;
        this.function = function;
        this.dataSorter = new DataSorter(paraProfTrial);
        this.model = new FunctionBarChartModel(this, this.dataSorter, function);
        this.panel = new BarChartPanel(this.model, null);
        this.initialize(component);
        this.setTitle("Function Data Window: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
    }

    public FunctionBarChartWindow(ParaProfTrial paraProfTrial, Thread thread, Function function, Component component) {
        this.ppTrial = paraProfTrial;
        this.ppThread = new PPThread(thread, paraProfTrial);
        this.phase = function;
        this.dataSorter = new DataSorter(paraProfTrial);
        this.dataSorter.setPhase(function);
        this.barLengthSlider.setValue(250);
        this.model = new ThreadBarChartModel(this, this.dataSorter, this.ppThread);
        this.panel = new BarChartPanel(this.model, null);
        this.initialize(component);
        this.panel.getBarChart().setLeftJustified(false);
        String string = "";
        if (function != null) {
            string = " Phase: " + function.getName();
        }
        if (thread.getNodeID() == -1) {
            this.setTitle("Mean Data - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()) + string);
        } else if (thread.getNodeID() == -2) {
            this.setTitle("Total Data - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()) + string);
        } else if (thread.getNodeID() == -3) {
            this.setTitle("Standard Deviation Data - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()) + string);
        } else {
            this.setTitle(this.ppThread.getName() + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()) + string);
        }
    }

    private FunctionBarChartWindow() {
    }

    public static FunctionBarChartWindow CreateComparisonWindow(ParaProfTrial paraProfTrial, Thread thread, Component component) {
        FunctionBarChartWindow functionBarChartWindow = new FunctionBarChartWindow();
        functionBarChartWindow.setTitle("Comparison Window");
        functionBarChartWindow.dataSorter = new DataSorter(paraProfTrial);
        functionBarChartWindow.ppTrial = paraProfTrial;
        functionBarChartWindow.comparisonChart = true;
        functionBarChartWindow.model = new ComparisonBarChartModel(functionBarChartWindow, paraProfTrial, thread, functionBarChartWindow.dataSorter);
        functionBarChartWindow.panel = new BarChartPanel(functionBarChartWindow.model, null);
        functionBarChartWindow.initialize(component);
        functionBarChartWindow.panel.getBarChart().setLeftJustified(false);
        functionBarChartWindow.panel.getBarChart().setSingleLine(false);
        functionBarChartWindow.setHeader();
        return functionBarChartWindow;
    }

    public void addThread(ParaProfTrial paraProfTrial, Thread thread) {
        paraProfTrial.addObserver(this);
        ComparisonBarChartModel comparisonBarChartModel = (ComparisonBarChartModel)this.model;
        comparisonBarChartModel.addThread(paraProfTrial, thread);
        comparisonBarChartModel.reloadData();
        this.setHeader();
    }

    private void initialize(Component component) {
        this.ppTrial.addObserver(this);
        this.panel.getBarChart().setBarLength(this.barLengthSlider.getValue());
        int n = 650;
        int n2 = 550;
        ((Component)this).setSize(ParaProfUtils.checkSize(new Dimension(n, n2)));
        ((Component)this).setLocation(WindowPlacer.getNewLocation(this, component));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FunctionBarChartWindow.this.thisWindowClosing(windowEvent);
            }
        });
        this.dataSorter.setSelectedMetricID(this.ppTrial.getDefaultMetricID());
        this.dataSorter.setValueType(ValueType.EXCLUSIVE_PERCENT);
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        BarChart barChart = this.panel.getBarChart();
        JScrollBar jScrollBar = this.panel.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        this.addKeyListener(this);
        this.setupMenus();
        this.setHeader();
        this.sortLocalData();
        this.barLengthSlider.setPaintTicks(true);
        this.barLengthSlider.setMajorTickSpacing(400);
        this.barLengthSlider.setMinorTickSpacing(50);
        this.barLengthSlider.setPaintLabels(true);
        this.barLengthSlider.setSnapToTicks(false);
        this.barLengthSlider.addChangeListener(this);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        this.addCompItem(this.panel, gridBagConstraints, 0, 0, 1, 1);
        ParaProf.incrementNumWindows();
    }

    public void changeToPhaseDisplay(Thread thread) {
        this.phaseThread = thread;
        this.phaseDisplay = true;
        this.setTitle(ParaProfUtils.getThreadIdentifier(thread) + " - Function Data: " + this.ppTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        this.function = this.ppTrial.getDataSource().getFunction(UtilFncs.getLeftSide((String)this.function.getName()));
        this.phase = null;
        this.setHeader();
        this.sortByNCTCheckbox.setSelected(false);
        this.optionsMenu.remove(this.sortByNCTCheckbox);
        this.descendingOrderCheckBox.setSelected(true);
        this.sortLocalData();
    }

    private Component createMetricMenu(final ValueType valueType, boolean bl, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        if (this.ppTrial.getNumberOfMetrics() == 1) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(valueType.toString(), bl);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FunctionBarChartWindow.this.dataSorter.setValueType(valueType);
                    FunctionBarChartWindow.this.sortLocalData();
                    FunctionBarChartWindow.this.panel.repaint();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            return jRadioButtonMenuItem;
        }
        JMenu jMenu = new JMenu(valueType.toString() + "...");
        int n = 0;
        while (n < this.ppTrial.getNumberOfMetrics()) {
            jRadioButtonMenuItem = n == this.dataSorter.getSelectedMetricID() && bl ? new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName(), true) : new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName());
            final int n2 = n++;
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FunctionBarChartWindow.this.dataSorter.setSelectedMetricID(n2);
                    FunctionBarChartWindow.this.dataSorter.setValueType(valueType);
                    FunctionBarChartWindow.this.sortLocalData();
                    FunctionBarChartWindow.this.panel.repaint();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.addKeyListener(this);
        JMenu jMenu = null;
        Object var3_3 = null;
        this.optionsMenu = new JMenu("Options");
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Width Slider", false);
        jCheckBoxMenuItem.addActionListener(this);
        this.optionsMenu.add(jCheckBoxMenuItem);
        this.showFindPanelBox = new JCheckBoxMenuItem("Show Find Panel", false);
        this.showFindPanelBox.addActionListener(this);
        this.optionsMenu.add(this.showFindPanelBox);
        this.showMetaData = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
        this.showMetaData.addActionListener(this);
        this.optionsMenu.add(this.showMetaData);
        this.optionsMenu.add(new JSeparator());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionBarChartWindow.this.sortLocalData();
                FunctionBarChartWindow.this.panel.repaint();
            }
        };
        if (this.function != null) {
            this.sortByNCTCheckbox = new JCheckBoxMenuItem("Sort By N,C,T", false);
            this.sortByNCTCheckbox.addActionListener(actionListener);
            this.optionsMenu.add(this.sortByNCTCheckbox);
        } else {
            this.sortByNameCheckBox = new JCheckBoxMenuItem("Sort By Name", false);
            this.sortByNameCheckBox.addActionListener(actionListener);
            this.optionsMenu.add(this.sortByNameCheckBox);
        }
        this.descendingOrderCheckBox = new JCheckBoxMenuItem("Descending Order", true);
        this.descendingOrderCheckBox.addActionListener(actionListener);
        this.optionsMenu.add(this.descendingOrderCheckBox);
        this.showValuesAsPercent = new JCheckBoxMenuItem("Show Values as Percent", ParaProf.preferences.getShowValuesAsPercent());
        this.showValuesAsPercent.addActionListener(actionListener);
        this.optionsMenu.add(this.showValuesAsPercent);
        this.unitsSubMenu = ParaProfUtils.createUnitsMenu(this, this.units, true);
        this.optionsMenu.add(this.unitsSubMenu);
        jMenu = new JMenu("Select Metric...");
        buttonGroup = new ButtonGroup();
        jMenu.add(this.createMetricMenu(ValueType.EXCLUSIVE, this.dataSorter.getValueType() == ValueType.EXCLUSIVE || this.dataSorter.getValueType() == ValueType.EXCLUSIVE_PERCENT, buttonGroup));
        jMenu.add(this.createMetricMenu(ValueType.INCLUSIVE, this.dataSorter.getValueType() == ValueType.INCLUSIVE || this.dataSorter.getValueType() == ValueType.INCLUSIVE_PERCENT, buttonGroup));
        jMenu.add(this.createMetricMenu(ValueType.INCLUSIVE_PER_CALL, this.dataSorter.getValueType() == ValueType.INCLUSIVE_PER_CALL, buttonGroup));
        jMenu.add(this.createMetricMenu(ValueType.EXCLUSIVE_PER_CALL, this.dataSorter.getValueType() == ValueType.EXCLUSIVE_PER_CALL, buttonGroup));
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", this.dataSorter.getValueType() == ValueType.NUMCALLS);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionBarChartWindow.this.dataSorter.setValueType(ValueType.NUMCALLS);
                FunctionBarChartWindow.this.sortLocalData();
                FunctionBarChartWindow.this.panel.repaint();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", this.dataSorter.getValueType() == ValueType.NUMSUBR);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionBarChartWindow.this.dataSorter.setValueType(ValueType.NUMSUBR);
                FunctionBarChartWindow.this.sortLocalData();
                FunctionBarChartWindow.this.panel.repaint();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        this.optionsMenu.addMenuListener(this);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this.panel, this.panel));
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block9: {
            try {
                Object object = actionEvent.getSource();
                if (!(object instanceof JMenuItem)) break block9;
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Width Slider")) {
                    if (((JCheckBoxMenuItem)object).isSelected()) {
                        this.showWidthSlider(true);
                    } else {
                        this.showWidthSlider(false);
                    }
                    break block9;
                }
                if (string.equals("Show Meta Data in Panel")) {
                    this.setHeader();
                    break block9;
                }
                if (string.equals("Show Find Panel")) {
                    if (this.showFindPanelBox.isSelected()) {
                        this.showSearchPanel(true);
                    } else {
                        this.showSearchPanel(false);
                    }
                    break block9;
                }
                throw new ParaProfException("Menu system not implemented properly: " + string);
            }
            catch (Exception exception) {
                ParaProfUtils.handleException(exception);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.panel.getBarChart().setBarLength(this.barLengthSlider.getValue());
            this.panel.repaint();
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.dataSorter.getValueType() == ValueType.EXCLUSIVE || this.dataSorter.getValueType() == ValueType.INCLUSIVE || this.dataSorter.getValueType() == ValueType.EXCLUSIVE_PERCENT || this.dataSorter.getValueType() == ValueType.INCLUSIVE_PERCENT) {
                this.showValuesAsPercent.setEnabled(true);
                if (this.showValuesAsPercent.isSelected()) {
                    this.unitsSubMenu.setEnabled(false);
                } else {
                    String string = this.ppTrial.getMetricName(this.dataSorter.getSelectedMetricID());
                    string = string.toUpperCase();
                    if (this.dataSorter.isTimeMetric()) {
                        this.unitsSubMenu.setEnabled(true);
                    } else {
                        this.unitsSubMenu.setEnabled(false);
                    }
                }
            } else {
                this.showValuesAsPercent.setEnabled(false);
                if (this.dataSorter.getValueType() == ValueType.EXCLUSIVE_PER_CALL || this.dataSorter.getValueType() == ValueType.INCLUSIVE_PER_CALL) {
                    if (this.dataSorter.isTimeMetric()) {
                        this.unitsSubMenu.setEnabled(true);
                    } else {
                        this.unitsSubMenu.setEnabled(false);
                    }
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            this.dataSorter.setSelectedMetricID(this.ppTrial.getDefaultMetricID());
            this.setupMenus();
            this.validate();
            this.sortLocalData();
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        }
    }

    public void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        if (this.function != null) {
            ParaProf.helpWindow.writeText("This is the function data window for:");
            ParaProf.helpWindow.writeText(ParaProfUtils.getFunctionName(this.function));
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("This window shows you this function's statistics across all the threads.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("Right click anywhere within this window to bring up a popup");
            ParaProf.helpWindow.writeText("menu. In this menu you can change or reset the default color");
            ParaProf.helpWindow.writeText("for this function.");
        } else {
            ParaProf.helpWindow.writeText("This is the thread data window");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("This window shows you the values for all functions on this thread.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("Right click on any function within this window to bring up a popup");
            ParaProf.helpWindow.writeText("menu. In this menu you can change or reset the default color");
            ParaProf.helpWindow.writeText("for the function, or to show more details about the function.");
            ParaProf.helpWindow.writeText("You can also left click any function to highlight it in the system.");
        }
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    public void sortLocalData() {
        this.dataSorter.setDescendingOrder(this.descendingOrderCheckBox.isSelected());
        if (this.function != null) {
            if (this.sortByNCTCheckbox.isSelected()) {
                this.dataSorter.setSortType(SortType.NCT);
            } else {
                this.dataSorter.setSortType(SortType.VALUE);
            }
        } else if (this.sortByNameCheckBox.isSelected()) {
            this.dataSorter.setSortType(SortType.NAME);
        } else {
            this.dataSorter.setSortType(SortType.VALUE);
        }
        if (this.showValuesAsPercent.isSelected()) {
            if (this.dataSorter.getValueType() == ValueType.EXCLUSIVE) {
                this.dataSorter.setValueType(ValueType.EXCLUSIVE_PERCENT);
            } else if (this.dataSorter.getValueType() == ValueType.INCLUSIVE) {
                this.dataSorter.setValueType(ValueType.INCLUSIVE_PERCENT);
            }
        } else if (this.dataSorter.getValueType() == ValueType.EXCLUSIVE_PERCENT) {
            this.dataSorter.setValueType(ValueType.EXCLUSIVE);
        } else if (this.dataSorter.getValueType() == ValueType.INCLUSIVE_PERCENT) {
            this.dataSorter.setValueType(ValueType.INCLUSIVE);
        }
        this.setHeader();
        this.model.reloadData();
    }

    public int units() {
        if (this.showValuesAsPercent.isEnabled() && this.showValuesAsPercent.isSelected()) {
            return 0;
        }
        if (!this.dataSorter.isTimeMetric()) {
            return 0;
        }
        if (this.dataSorter.getValueType() == ValueType.NUMCALLS || this.dataSorter.getValueType() == ValueType.NUMSUBR) {
            return 0;
        }
        return this.units;
    }

    public Dimension getViewportSize() {
        return this.panel.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.panel.getViewport().getViewRect();
    }

    public void setVerticalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.panel.getVerticalScrollBar();
        jScrollBar.setValue(n);
    }

    public void setHeader() {
        if (this.showMetaData.isSelected()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            jTextArea.setFont(ParaProf.preferencesWindow.getFont());
            jTextArea.append(this.getHeaderString());
            jTextArea.addKeyListener(this);
            jTextArea.setMargin(new Insets(3, 3, 3, 3));
            if (this.comparisonChart) {
                LegendPanel legendPanel = new LegendPanel(((ComparisonBarChartModel)this.model).getLegendModel());
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                ParaProfUtils.addCompItem(jPanel, jTextArea, gridBagConstraints, 0, 0, 1, 1);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 17;
                ParaProfUtils.addCompItem(jPanel, legendPanel, gridBagConstraints, 1, 0, 1, 1);
                this.panel.setColumnHeaderView(jPanel);
            } else {
                this.panel.setColumnHeaderView(jTextArea);
            }
        } else {
            this.panel.setColumnHeaderView(null);
        }
    }

    public String getHeaderString() {
        if (this.function != null) {
            String string = "";
            string = this.ppTrial.getDataSource().getPhasesPresent() && this.function.isCallPathFunction() ? string + "Phase: " + UtilFncs.getLeftSide((String)this.function.getName()) + "\nName: " + UtilFncs.getRightSide((String)this.function.getName()) : string + "Name: " + this.function.getName();
            string = string + "\nMetric Name: " + this.ppTrial.getMetricName(this.dataSorter.getSelectedMetricID()) + "\nValue: " + this.dataSorter.getValueType();
            if (this.dataSorter.getValueType() != ValueType.NUMCALLS && this.dataSorter.getValueType() != ValueType.NUMSUBR && !this.showValuesAsPercent.isSelected()) {
                string = string + "\nUnits: " + UtilFncs.getUnitsString((int)this.units, (boolean)this.dataSorter.isTimeMetric(), (boolean)this.dataSorter.isDerivedMetric());
            }
            return string + "\n";
        }
        String string = this.phase != null ? "Phase: " + this.phase + "\nMetric: " + this.ppTrial.getMetricName(this.dataSorter.getSelectedMetricID()) + "\n" + "Value: " + this.dataSorter.getValueType() : "Metric: " + this.ppTrial.getMetricName(this.dataSorter.getSelectedMetricID()) + "\n" + "Value: " + this.dataSorter.getValueType();
        if (this.dataSorter.getValueType() == ValueType.NUMCALLS || this.dataSorter.getValueType() == ValueType.NUMSUBR || this.showValuesAsPercent.isSelected()) {
            return string + "\n";
        }
        return string + "\nUnits: " + UtilFncs.getUnitsString((int)this.units, (boolean)this.dataSorter.isTimeMetric(), (boolean)this.dataSorter.isDerivedMetric()) + "\n";
    }

    private void showWidthSlider(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (bl) {
            this.getContentPane().remove(this.panel);
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, gridBagConstraints, 0, 0, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.7;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, gridBagConstraints, 1, 0, 1, 1);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.99;
            this.addCompItem(this.panel, gridBagConstraints, 0, 1, 2, 1);
        } else {
            this.getContentPane().remove(this.barLengthLabel);
            this.getContentPane().remove(this.barLengthSlider);
            this.getContentPane().remove(this.panel);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 100.0;
            this.addCompItem(this.panel, gridBagConstraints, 0, 0, 1, 1);
        }
        this.validate();
    }

    public void showSearchPanel(boolean bl) {
        if (bl) {
            if (this.searchPanel == null) {
                this.searchPanel = new SearchPanel(this, this.panel.getBarChart().getSearcher());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.weightx = 0.1;
                gridBagConstraints.weighty = 0.01;
                this.addCompItem(this.searchPanel, gridBagConstraints, 0, 3, 2, 1);
                this.searchPanel.setFocus();
            }
        } else {
            this.getContentPane().remove(this.searchPanel);
            this.searchPanel = null;
        }
        this.showFindPanelBox.setSelected(bl);
        this.validate();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        try {
            ((Component)this).setVisible(false);
            if (this.comparisonChart) {
                ParaProf.theComparisonWindow = null;
                List list = ((ComparisonBarChartModel)this.model).getPpTrials();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ParaProfTrial paraProfTrial = (ParaProfTrial)iterator.next();
                    paraProfTrial.deleteObserver(this);
                }
            } else {
                this.ppTrial.deleteObserver(this);
            }
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    public void setUnits(int n) {
        this.units = n;
        this.setHeader();
        this.model.reloadData();
        this.panel.repaint();
    }

    public boolean isPhaseDisplay() {
        return this.phaseDisplay;
    }

    public ParaProfTrial getPpTrial() {
        return this.ppTrial;
    }

    public Thread getPhaseThread() {
        return this.phaseThread;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 70) {
            this.showSearchPanel(true);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public Function getPhase() {
        return this.phase;
    }
}

