/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.DBConfiguration;
import edu.uoregon.tau.paraprof.DerivedMetricPanel;
import edu.uoregon.tau.paraprof.FunctionBarChartWindow;
import edu.uoregon.tau.paraprof.LoadTrialProgressWindow;
import edu.uoregon.tau.paraprof.LoadTrialWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfManagerTableModel;
import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfTreeCellRenderer;
import edu.uoregon.tau.paraprof.ParaProfTreeNodeUserObject;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.DBDataSource;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ParaProfManagerWindow
extends JFrame
implements ActionListener,
TreeSelectionListener,
TreeWillExpandListener {
    private JTree tree = null;
    private DefaultTreeModel treeModel = null;
    private DefaultMutableTreeNode standard = null;
    private DefaultMutableTreeNode runtime = null;
    private DefaultMutableTreeNode dbApps = null;
    private JSplitPane jSplitInnerPane = null;
    private JSplitPane jSplitOuterPane = null;
    private JCheckBoxMenuItem showApplyOperationItem = null;
    private DerivedMetricPanel pPMLPanel = new DerivedMetricPanel(this);
    private JScrollPane treeScrollPane;
    private Vector loadedDBTrials = new Vector();
    private Vector loadedTrials = new Vector();
    private boolean metaDataRetrieved;
    private JPopupMenu popup1 = new JPopupMenu();
    private JPopupMenu stdAppPopup = new JPopupMenu();
    private JPopupMenu stdExpPopup = new JPopupMenu();
    private JPopupMenu stdTrialPopup = new JPopupMenu();
    private JPopupMenu dbAppPopup = new JPopupMenu();
    private JPopupMenu dbExpPopup = new JPopupMenu();
    private JPopupMenu dbTrialPopup = new JPopupMenu();
    private JPopupMenu runtimePopup = new JPopupMenu();
    private Object clickedOnObject = null;
    private ParaProfMetric operand1 = null;
    private ParaProfMetric operand2 = null;
    private List runtimeApps = new ArrayList();

    public ParaProfManagerWindow() {
        int n = 800;
        int n2 = 515;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n3 = dimension.height;
        int n4 = dimension.width;
        Point point = ParaProf.preferences.getManagerWindowPosition();
        if (point == null || point.x + n > n4 || point.y + n2 > n3) {
            int n5 = (n4 - n) / 2;
            int n6 = (n3 - n2) / 2;
            if (n5 > 50) {
                n5 -= 50;
            }
            if (n6 > 50) {
                n6 -= 50;
            }
            ((Component)this).setLocation(n5, n6);
        } else {
            ((Component)this).setLocation(point);
        }
        if (ParaProf.demoMode) {
            ((Component)this).setLocation(0, 0);
        }
        ((Component)this).setSize(ParaProfUtils.checkSize(new Dimension(n, n2)));
        this.setTitle("ParaProf Manager");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ParaProfManagerWindow.this.thisWindowClosing(windowEvent);
            }
        });
        this.setupMenus();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Applications");
        this.standard = new DefaultMutableTreeNode("Standard Applications");
        this.runtime = new DefaultMutableTreeNode("Runtime Applications");
        this.dbApps = new DefaultMutableTreeNode("DB Applications");
        defaultMutableTreeNode.add(this.standard);
        defaultMutableTreeNode.add(this.dbApps);
        this.treeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.treeModel.setAsksAllowsChildren(true);
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        ParaProfTreeCellRenderer paraProfTreeCellRenderer = new ParaProfTreeCellRenderer();
        this.tree.setCellRenderer(paraProfTreeCellRenderer);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    int n = ParaProfManagerWindow.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    TreePath treePath = ParaProfManagerWindow.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                        Object object = defaultMutableTreeNode.getUserObject();
                        if (ParaProfUtils.rightClick(mouseEvent)) {
                            if (defaultMutableTreeNode == ParaProfManagerWindow.this.standard || defaultMutableTreeNode == ParaProfManagerWindow.this.dbApps) {
                                ParaProfManagerWindow.this.clickedOnObject = defaultMutableTreeNode;
                                ParaProfManagerWindow.this.popup1.show(ParaProfManagerWindow.this, mouseEvent.getX(), mouseEvent.getY() - ParaProfManagerWindow.this.treeScrollPane.getVerticalScrollBar().getValue());
                            } else if (defaultMutableTreeNode == ParaProfManagerWindow.this.runtime) {
                                ParaProfManagerWindow.this.runtimePopup.show(ParaProfManagerWindow.this, mouseEvent.getX(), mouseEvent.getY());
                            } else if (object instanceof ParaProfApplication) {
                                ParaProfManagerWindow.this.clickedOnObject = object;
                                if (((ParaProfApplication)object).dBApplication()) {
                                    ParaProfManagerWindow.this.dbAppPopup.show(ParaProfManagerWindow.this, mouseEvent.getX(), mouseEvent.getY() - ParaProfManagerWindow.this.treeScrollPane.getVerticalScrollBar().getValue());
                                } else {
                                    ParaProfManagerWindow.this.stdAppPopup.show(ParaProfManagerWindow.this, mouseEvent.getX(), mouseEvent.getY() - ParaProfManagerWindow.this.treeScrollPane.getVerticalScrollBar().getValue());
                                }
                            } else if (object instanceof ParaProfExperiment) {
                                ParaProfManagerWindow.this.clickedOnObject = object;
                                if (((ParaProfExperiment)object).dBExperiment()) {
                                    ParaProfManagerWindow.this.dbExpPopup.show(ParaProfManagerWindow.this, mouseEvent.getX(), mouseEvent.getY() - ParaProfManagerWindow.this.treeScrollPane.getVerticalScrollBar().getValue());
                                } else {
                                    ParaProfManagerWindow.this.stdExpPopup.show(ParaProfManagerWindow.this, mouseEvent.getX(), mouseEvent.getY() - ParaProfManagerWindow.this.treeScrollPane.getVerticalScrollBar().getValue());
                                }
                            } else if (object instanceof ParaProfTrial) {
                                ParaProfManagerWindow.this.clickedOnObject = object;
                                if (((ParaProfTrial)object).dBTrial()) {
                                    ParaProfManagerWindow.this.dbTrialPopup.show(ParaProfManagerWindow.this, mouseEvent.getX(), mouseEvent.getY() - ParaProfManagerWindow.this.treeScrollPane.getVerticalScrollBar().getValue());
                                } else {
                                    ParaProfManagerWindow.this.stdTrialPopup.show(ParaProfManagerWindow.this, mouseEvent.getX(), mouseEvent.getY() - ParaProfManagerWindow.this.treeScrollPane.getVerticalScrollBar().getValue());
                                }
                            }
                        } else if (mouseEvent.getClickCount() == 2 && object instanceof ParaProfMetric) {
                            ParaProfManagerWindow.this.metric((ParaProfMetric)object, true);
                        }
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        this.tree.addMouseListener(mouseAdapter);
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeWillExpandListener(this);
        this.treeScrollPane = new JScrollPane(this.tree);
        this.jSplitInnerPane = new JSplitPane(1, this.treeScrollPane, this.getPanelHelpMessage(0));
        this.jSplitInnerPane.setContinuousLayout(true);
        this.jSplitInnerPane.setResizeWeight(0.5);
        this.getContentPane().add((Component)this.jSplitInnerPane, "Center");
        this.show();
        this.jSplitInnerPane.setDividerLocation(0.5);
        ParaProf.incrementNumWindows();
    }

    void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Open...");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Preferences...");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Database Configuration");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close This Window");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit ParaProf!");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("Options");
        this.showApplyOperationItem = new JCheckBoxMenuItem("Show Derived Metric Panel", false);
        this.showApplyOperationItem.addActionListener(this);
        jMenu2.add(this.showApplyOperationItem);
        JMenu jMenu3 = new JMenu("Help");
        JMenuItem jMenuItem2 = new JMenuItem("Show Help Window");
        jMenuItem2.addActionListener(this);
        jMenu3.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("About ParaProf");
        jMenuItem3.addActionListener(this);
        jMenu3.add(jMenuItem3);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        JMenuItem jMenuItem4 = new JMenuItem("Add Application");
        jMenuItem4.addActionListener(this);
        this.popup1.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Add Experiment");
        jMenuItem4.addActionListener(this);
        this.popup1.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Add Trial");
        jMenuItem4.addActionListener(this);
        this.popup1.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Monitor Application");
        jMenuItem4.addActionListener(this);
        this.runtimePopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Add Experiment");
        jMenuItem4.addActionListener(this);
        this.stdAppPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Add Trial");
        jMenuItem4.addActionListener(this);
        this.stdAppPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Upload Application to DB");
        jMenuItem4.addActionListener(this);
        this.stdAppPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Delete");
        jMenuItem4.addActionListener(this);
        this.stdAppPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Add Experiment");
        jMenuItem4.addActionListener(this);
        this.dbAppPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Add Trial");
        jMenuItem4.addActionListener(this);
        this.dbAppPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Delete");
        jMenuItem4.addActionListener(this);
        this.dbAppPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Upload Experiment to DB");
        jMenuItem4.addActionListener(this);
        this.stdExpPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Add Trial");
        jMenuItem4.addActionListener(this);
        this.stdExpPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Delete");
        jMenuItem4.addActionListener(this);
        this.stdExpPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Add Trial");
        jMenuItem4.addActionListener(this);
        this.dbExpPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Delete");
        jMenuItem4.addActionListener(this);
        this.dbExpPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Upload Trial to DB");
        jMenuItem4.addActionListener(this);
        this.stdTrialPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Add Mean to Comparison Window");
        jMenuItem4.addActionListener(this);
        this.stdTrialPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Export as Packed Profile");
        jMenuItem4.addActionListener(this);
        this.stdTrialPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Delete");
        jMenuItem4.addActionListener(this);
        this.stdTrialPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Export as Packed Profile");
        jMenuItem4.addActionListener(this);
        this.dbTrialPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Add Mean to Comparison Window");
        jMenuItem4.addActionListener(this);
        this.dbTrialPopup.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Delete");
        jMenuItem4.addActionListener(this);
        this.dbTrialPopup.add(jMenuItem4);
    }

    public void recomputeStats() {
        int n = 0;
        while (n < this.loadedTrials.size()) {
            ParaProfTrial paraProfTrial = (ParaProfTrial)this.loadedTrials.get(n);
            paraProfTrial.getDataSource().generateDerivedData();
            ++n;
        }
    }

    public void handleDelete(Object object) throws SQLException, DatabaseException {
        if (object instanceof ParaProfApplication) {
            ParaProfApplication paraProfApplication = (ParaProfApplication)object;
            if (paraProfApplication.dBApplication()) {
                DatabaseAPI databaseAPI = this.getDatabaseAPI();
                if (databaseAPI != null) {
                    databaseAPI.deleteApplication(paraProfApplication.getID());
                    databaseAPI.terminate();
                    Enumeration enumeration = this.loadedDBTrials.elements();
                    while (enumeration.hasMoreElements()) {
                        ParaProfTrial paraProfTrial = (ParaProfTrial)enumeration.nextElement();
                        if (paraProfTrial.getApplicationID() != paraProfApplication.getID() || paraProfTrial.loading()) continue;
                        this.loadedDBTrials.remove(paraProfTrial);
                    }
                    this.treeModel.removeNodeFromParent(paraProfApplication.getDMTN());
                }
            } else {
                ParaProf.applicationManager.removeApplication(paraProfApplication);
                this.treeModel.removeNodeFromParent(paraProfApplication.getDMTN());
            }
        } else if (object instanceof ParaProfExperiment) {
            ParaProfExperiment paraProfExperiment = (ParaProfExperiment)object;
            if (paraProfExperiment.dBExperiment()) {
                DatabaseAPI databaseAPI = this.getDatabaseAPI();
                if (databaseAPI != null) {
                    databaseAPI.deleteExperiment(paraProfExperiment.getID());
                    databaseAPI.terminate();
                    Enumeration enumeration = this.loadedDBTrials.elements();
                    while (enumeration.hasMoreElements()) {
                        ParaProfTrial paraProfTrial = (ParaProfTrial)enumeration.nextElement();
                        if (paraProfTrial.getApplicationID() != paraProfExperiment.getApplicationID() || paraProfTrial.getExperimentID() != paraProfExperiment.getID() || paraProfTrial.loading()) continue;
                        this.loadedDBTrials.remove(paraProfTrial);
                    }
                    if (paraProfExperiment.getDMTN() != null) {
                        this.treeModel.removeNodeFromParent(paraProfExperiment.getDMTN());
                    }
                }
            } else {
                paraProfExperiment.getApplication().removeExperiment(paraProfExperiment);
                this.treeModel.removeNodeFromParent(paraProfExperiment.getDMTN());
            }
        } else if (object instanceof ParaProfTrial) {
            ParaProfTrial paraProfTrial = (ParaProfTrial)object;
            if (paraProfTrial.dBTrial()) {
                DatabaseAPI databaseAPI = this.getDatabaseAPI();
                if (databaseAPI != null) {
                    databaseAPI.deleteTrial(paraProfTrial.getID());
                    databaseAPI.terminate();
                    Enumeration enumeration = this.loadedDBTrials.elements();
                    while (enumeration.hasMoreElements()) {
                        ParaProfTrial paraProfTrial2 = (ParaProfTrial)enumeration.nextElement();
                        if (paraProfTrial2.getApplicationID() != paraProfTrial.getApplicationID() || paraProfTrial2.getExperimentID() != paraProfTrial.getID() || paraProfTrial2.getID() != paraProfTrial.getID() || paraProfTrial2.loading()) continue;
                        this.loadedDBTrials.remove(paraProfTrial2);
                    }
                    this.treeModel.removeNodeFromParent(paraProfTrial.getDMTN());
                }
            } else {
                paraProfTrial.getExperiment().removeTrial(paraProfTrial);
                this.treeModel.removeNodeFromParent(paraProfTrial.getDMTN());
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Exit ParaProf!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    ParaProf.exitParaProf(0);
                } else if (string.equals("Open...")) {
                    ParaProfApplication paraProfApplication = this.addApplication(false, this.standard);
                    if (paraProfApplication != null) {
                        this.expandApplicationType(0, paraProfApplication.getID(), paraProfApplication);
                        ParaProfExperiment paraProfExperiment = this.addExperiment(false, paraProfApplication);
                        if (paraProfExperiment != null) {
                            this.expandApplication(0, paraProfApplication.getID(), paraProfExperiment.getID(), null, paraProfExperiment);
                            new LoadTrialWindow(this, paraProfApplication, paraProfExperiment, true, true).show();
                        }
                    }
                } else if (string.equals("Preferences...")) {
                    ParaProf.preferencesWindow.showPreferencesWindow(this);
                } else if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Database Configuration")) {
                    new DBConfiguration(this).show();
                } else if (string.equals("Show Derived Metric Panel")) {
                    if (this.showApplyOperationItem.isSelected()) {
                        this.getContentPane().removeAll();
                        this.jSplitOuterPane = new JSplitPane(0, this.jSplitInnerPane, this.pPMLPanel);
                        this.getContentPane().add((Component)this.jSplitOuterPane, "Center");
                        this.validate();
                        this.jSplitOuterPane.setDividerLocation(0.75);
                    } else {
                        double d = this.jSplitInnerPane.getDividerLocation();
                        this.getContentPane().removeAll();
                        this.jSplitInnerPane = new JSplitPane(1, this.treeScrollPane, this.getPanelHelpMessage(0));
                        this.jSplitInnerPane.setContinuousLayout(true);
                        this.getContentPane().add((Component)this.jSplitInnerPane, "Center");
                        this.validate();
                        this.jSplitInnerPane.setDividerLocation(d / (double)this.getWidth());
                    }
                } else if (string.equals("About ParaProf")) {
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    ParaProf.helpWindow.show();
                    ParaProf.helpWindow.clearText();
                    ParaProf.helpWindow.writeText("This is ParaProf's manager window!");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("This window allows you to manage all of ParaProf's data sources, including loading data from local files, or from a database. We also support the generation of derived metrics. Please see the items below for more help.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("------------------");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("1) Navigation: The window is split into two halves, the left side gives a tree representation of all data. The right side gives information about items clicked on in the left half. You can also update information in the right half by double clicking in the fields, and entering new data.  This automatically updates the left half. Right-clicking on the tree nodes in the left half displays popup menus which allow you to add/delete applications, experiments, or trials.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("2) DB Configuration: By default, ParaProf looks in the .ParaProf home directory in your home directory for the database configuration file.  If that file is found, then you are done, and can just expand the DB Applications node.  If there was a problem finding the file, you can enter the location of the file by selecting File -> Database Configuration.  You can also override the configuration file password in the same manner.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("3) Deriving new metrics: By selecting Options -> Show Derived Metric Panel, you will display the apply operations window.  Clicking on the metrics of a trial will update the arguments to the selected operation.  Currently, you can only derive metrics from metric in the same trial (thus for example creating floating point operations per second by taking PAPI_FP_INS and dividing it by GET_TIME_OF_DAY). The 2nd argument is a user editable textbox and can be filled in with scalar  values using the keyword 'val' (e.g. \"val 1.5\".");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("------------------");
                    ParaProf.helpWindow.writeText("");
                } else if (string.equals("Delete")) {
                    this.handleDelete(this.clickedOnObject);
                } else if (string.equals("Add Application")) {
                    if (this.clickedOnObject == this.standard) {
                        ParaProfApplication paraProfApplication = this.addApplication(false, this.standard);
                        this.expandApplicationType(0, paraProfApplication.getID(), paraProfApplication);
                    } else if (this.clickedOnObject == this.dbApps) {
                        ParaProfApplication paraProfApplication = this.addApplication(true, this.dbApps);
                        this.expandApplicationType(2, paraProfApplication.getID(), paraProfApplication);
                    }
                } else if (string.equals("Add Experiment")) {
                    ParaProfExperiment paraProfExperiment;
                    ParaProfApplication paraProfApplication;
                    if (this.clickedOnObject == this.standard) {
                        paraProfApplication = this.addApplication(false, this.standard);
                        paraProfExperiment = this.addExperiment(false, paraProfApplication);
                        if (paraProfApplication != null || paraProfExperiment != null) {
                            this.expandApplicationType(0, paraProfApplication.getID(), paraProfApplication);
                            this.expandApplication(0, paraProfApplication.getID(), paraProfExperiment.getID(), paraProfApplication, paraProfExperiment);
                        }
                    } else if (this.clickedOnObject == this.dbApps) {
                        paraProfApplication = this.addApplication(true, this.dbApps);
                        paraProfExperiment = this.addExperiment(true, paraProfApplication);
                        if (paraProfApplication != null || paraProfExperiment != null) {
                            this.expandApplicationType(2, paraProfApplication.getID(), paraProfApplication);
                            this.expandApplication(2, paraProfApplication.getID(), paraProfExperiment.getID(), paraProfApplication, paraProfExperiment);
                        }
                    }
                    if (this.clickedOnObject instanceof ParaProfApplication) {
                        paraProfApplication = (ParaProfApplication)this.clickedOnObject;
                        if (paraProfApplication.dBApplication()) {
                            paraProfExperiment = this.addExperiment(true, paraProfApplication);
                            if (paraProfExperiment != null) {
                                this.expandApplication(2, paraProfApplication.getID(), paraProfExperiment.getID(), null, paraProfExperiment);
                            }
                        } else {
                            paraProfExperiment = this.addExperiment(false, paraProfApplication);
                            if (paraProfExperiment != null) {
                                this.expandApplication(0, paraProfApplication.getID(), paraProfExperiment.getID(), null, paraProfExperiment);
                            }
                        }
                    }
                } else if (string.equals("Add Trial")) {
                    if (this.clickedOnObject == this.standard) {
                        ParaProfApplication paraProfApplication = this.addApplication(false, this.standard);
                        if (paraProfApplication != null) {
                            this.expandApplicationType(0, paraProfApplication.getID(), paraProfApplication);
                            ParaProfExperiment paraProfExperiment = this.addExperiment(false, paraProfApplication);
                            if (paraProfExperiment != null) {
                                this.expandApplication(0, paraProfApplication.getID(), paraProfExperiment.getID(), null, paraProfExperiment);
                                new LoadTrialWindow(this, paraProfApplication, paraProfExperiment, true, true).show();
                            }
                        }
                    } else if (this.clickedOnObject == this.dbApps) {
                        ParaProfApplication paraProfApplication = this.addApplication(true, this.dbApps);
                        if (paraProfApplication != null) {
                            this.expandApplicationType(2, paraProfApplication.getID(), paraProfApplication);
                            ParaProfExperiment paraProfExperiment = this.addExperiment(true, paraProfApplication);
                            if (paraProfExperiment != null) {
                                this.expandApplication(2, paraProfApplication.getID(), paraProfExperiment.getID(), null, paraProfExperiment);
                                new LoadTrialWindow(this, paraProfApplication, paraProfExperiment, true, true).show();
                            }
                        }
                    } else if (this.clickedOnObject instanceof ParaProfApplication) {
                        ParaProfApplication paraProfApplication = (ParaProfApplication)this.clickedOnObject;
                        if (paraProfApplication.dBApplication()) {
                            ParaProfExperiment paraProfExperiment = this.addExperiment(true, paraProfApplication);
                            if (paraProfExperiment != null) {
                                this.expandApplication(2, paraProfApplication.getID(), paraProfExperiment.getID(), null, paraProfExperiment);
                                new LoadTrialWindow(this, null, paraProfExperiment, false, true).show();
                            }
                        } else {
                            ParaProfExperiment paraProfExperiment = this.addExperiment(false, paraProfApplication);
                            if (paraProfExperiment != null) {
                                this.expandApplication(0, paraProfApplication.getID(), paraProfExperiment.getID(), null, paraProfExperiment);
                                new LoadTrialWindow(this, null, paraProfExperiment, false, true).show();
                            }
                        }
                    } else if (this.clickedOnObject instanceof ParaProfExperiment) {
                        ParaProfExperiment paraProfExperiment = (ParaProfExperiment)this.clickedOnObject;
                        new LoadTrialWindow(this, null, paraProfExperiment, false, false).show();
                    }
                } else if (string.equals("Upload Application to DB")) {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            try {
                                ParaProfApplication paraProfApplication = (ParaProfApplication)ParaProfManagerWindow.this.clickedOnObject;
                                ParaProfManagerWindow.this.uploadApplication(paraProfApplication, true, true);
                            }
                            catch (Exception exception) {
                                EventQueue.invokeLater(new Runnable(this, exception){
                                    private final /* synthetic */ Exception val$e;
                                    private final /* synthetic */ 3 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$e = exception;
                                    }

                                    public void run() {
                                        ParaProfUtils.handleException(this.val$e);
                                    }
                                });
                            }
                        }
                    });
                    thread.start();
                } else if (string.equals("Upload Experiment to DB")) {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            try {
                                ParaProfExperiment paraProfExperiment = (ParaProfExperiment)ParaProfManagerWindow.this.clickedOnObject;
                                ParaProfManagerWindow.this.uploadExperiment(null, paraProfExperiment, true, true);
                            }
                            catch (Exception exception) {
                                EventQueue.invokeLater(new Runnable(this, exception){
                                    private final /* synthetic */ Exception val$e;
                                    private final /* synthetic */ 5 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$e = exception;
                                    }

                                    public void run() {
                                        ParaProfUtils.handleException(this.val$e);
                                    }
                                });
                            }
                        }
                    });
                    thread.start();
                } else if (string.equals("Upload Trial to DB")) {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            try {
                                ParaProfManagerWindow.this.uploadTrial(null, (ParaProfTrial)ParaProfManagerWindow.this.clickedOnObject);
                            }
                            catch (Exception exception) {
                                EventQueue.invokeLater(new Runnable(this, exception){
                                    private final /* synthetic */ Exception val$e;
                                    private final /* synthetic */ 7 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$e = exception;
                                    }

                                    public void run() {
                                        ParaProfUtils.handleException(this.val$e);
                                    }
                                });
                            }
                        }
                    });
                    thread.start();
                } else if (string.equals("Add Mean to Comparison Window")) {
                    ParaProfTrial paraProfTrial = (ParaProfTrial)this.clickedOnObject;
                    if (paraProfTrial.loading()) {
                        JOptionPane.showMessageDialog(this, "Cannot perform operation while loading");
                    } else {
                        boolean bl = true;
                        if (paraProfTrial.dBTrial()) {
                            bl = false;
                            Enumeration enumeration = this.loadedDBTrials.elements();
                            while (enumeration.hasMoreElements()) {
                                ParaProfTrial paraProfTrial2 = (ParaProfTrial)enumeration.nextElement();
                                if (paraProfTrial.getID() != paraProfTrial2.getID() || paraProfTrial.getExperimentID() != paraProfTrial2.getExperimentID() || paraProfTrial.getApplicationID() != paraProfTrial2.getApplicationID()) continue;
                                bl = true;
                            }
                        }
                        if (!bl) {
                            JOptionPane.showMessageDialog(this, "Please load the trial first (expand the tree)");
                        } else {
                            if (ParaProf.theComparisonWindow == null) {
                                ParaProf.theComparisonWindow = FunctionBarChartWindow.CreateComparisonWindow(paraProfTrial, paraProfTrial.getDataSource().getMeanData(), this);
                            } else {
                                ParaProf.theComparisonWindow.addThread(paraProfTrial, paraProfTrial.getDataSource().getMeanData());
                            }
                            ParaProf.theComparisonWindow.show();
                        }
                    }
                } else if (string.equals("Export as Packed Profile")) {
                    ParaProfTrial paraProfTrial = (ParaProfTrial)this.clickedOnObject;
                    if (paraProfTrial.loading()) {
                        JOptionPane.showMessageDialog(this, "Cannot export trial while loading");
                    } else {
                        boolean bl = true;
                        if (paraProfTrial.dBTrial()) {
                            bl = false;
                            Enumeration enumeration = this.loadedDBTrials.elements();
                            while (enumeration.hasMoreElements()) {
                                ParaProfTrial paraProfTrial3 = (ParaProfTrial)enumeration.nextElement();
                                if (paraProfTrial.getID() != paraProfTrial3.getID() || paraProfTrial.getExperimentID() != paraProfTrial3.getExperimentID() || paraProfTrial.getApplicationID() != paraProfTrial3.getApplicationID()) continue;
                                bl = true;
                            }
                        }
                        if (!bl) {
                            JOptionPane.showMessageDialog(this, "Please load the trial before exporting (expand the tree)");
                        } else {
                            ParaProfUtils.exportTrial(paraProfTrial, this);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private ParaProfApplication uploadApplication(ParaProfApplication paraProfApplication, boolean bl, boolean bl2) throws SQLException, DatabaseException {
        DatabaseAPI databaseAPI = this.getDatabaseAPI();
        if (databaseAPI != null) {
            Application application;
            boolean bl3 = false;
            ListIterator listIterator = databaseAPI.getApplicationList().listIterator();
            while (listIterator.hasNext()) {
                application = new ParaProfApplication((Application)listIterator.next());
                if (!application.getName().equals(paraProfApplication.getName())) continue;
                bl3 = true;
                if (bl) {
                    Object[] objectArray = new String[]{"Overwrite", "Don't overwrite", "Cancel"};
                    int n = JOptionPane.showOptionDialog(this, "An Application with the name \"" + paraProfApplication.getName() + "\" already exists, it will be updated new experiments/trials, should the metadata be overwritten?", "Upload Application", 0, 3, null, objectArray, objectArray[1]);
                    if (n == -1 || n == 2) {
                        return null;
                    }
                    if (n == 0) {
                        application.setFields(paraProfApplication.getFields());
                        databaseAPI.saveApplication(application);
                    }
                    if (bl2) {
                        ListIterator listIterator2 = paraProfApplication.getExperimentList();
                        while (listIterator2.hasNext()) {
                            ParaProfExperiment paraProfExperiment = (ParaProfExperiment)listIterator2.next();
                            this.uploadExperiment((ParaProfApplication)application, paraProfExperiment, true, true);
                        }
                    }
                }
                return application;
            }
            if (!bl3) {
                application = new Application((Application)paraProfApplication);
                application.setID(-1);
                ParaProfApplication paraProfApplication2 = new ParaProfApplication(application);
                paraProfApplication2.setDBApplication(true);
                paraProfApplication2.setID(databaseAPI.saveApplication((Application)paraProfApplication2));
                if (bl2) {
                    ListIterator listIterator3 = paraProfApplication.getExperimentList();
                    while (listIterator3.hasNext()) {
                        ParaProfExperiment paraProfExperiment = (ParaProfExperiment)listIterator3.next();
                        this.uploadExperiment(paraProfApplication2, paraProfExperiment, true, true);
                    }
                }
                return paraProfApplication2;
            }
        }
        return null;
    }

    private ParaProfExperiment uploadExperiment(ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, boolean bl, boolean bl2) throws SQLException, DatabaseException {
        Experiment experiment;
        DatabaseAPI databaseAPI = this.getDatabaseAPI();
        if (databaseAPI == null) {
            return null;
        }
        if (paraProfApplication == null) {
            paraProfApplication = this.uploadApplication(paraProfExperiment.getApplication(), false, false);
        }
        boolean bl3 = false;
        databaseAPI.setApplication((Application)paraProfApplication);
        ListIterator listIterator = databaseAPI.getExperimentList().listIterator();
        while (listIterator.hasNext()) {
            experiment = new ParaProfExperiment((Experiment)listIterator.next());
            if (!experiment.getName().equals(paraProfExperiment.getName())) continue;
            bl3 = true;
            if (bl) {
                Object[] objectArray = new String[]{"Overwrite", "Don't overwrite", "Cancel"};
                int n = JOptionPane.showOptionDialog(this, "An Experiment with the name \"" + paraProfExperiment.getName() + "\" already exists, it will be updated new trials, should the metadata be overwritten?", "Upload Application", 0, 3, null, objectArray, objectArray[1]);
                if (n == -1 || n == 2) {
                    return null;
                }
                if (n == 0) {
                    experiment.setFields(paraProfExperiment.getFields());
                    databaseAPI.saveExperiment(experiment);
                }
                if (bl2) {
                    ListIterator listIterator2 = paraProfExperiment.getTrialList();
                    while (listIterator2.hasNext()) {
                        ParaProfTrial paraProfTrial = (ParaProfTrial)listIterator2.next();
                        this.uploadTrial((ParaProfExperiment)experiment, paraProfTrial);
                    }
                }
            }
            return experiment;
        }
        if (!bl3) {
            experiment = new Experiment((Experiment)paraProfExperiment);
            ParaProfExperiment paraProfExperiment2 = new ParaProfExperiment(experiment);
            experiment.setID(-1);
            paraProfExperiment2.setDBExperiment(true);
            paraProfExperiment2.setApplicationID(paraProfApplication.getID());
            paraProfExperiment2.setID(databaseAPI.saveExperiment((Experiment)paraProfExperiment2));
            if (bl2) {
                ListIterator listIterator3 = paraProfExperiment.getTrialList();
                while (listIterator3.hasNext()) {
                    ParaProfTrial paraProfTrial = (ParaProfTrial)listIterator3.next();
                    this.uploadTrial(paraProfExperiment2, paraProfTrial);
                }
            }
            return paraProfExperiment2;
        }
        return null;
    }

    private ParaProfTrial uploadTrial(ParaProfExperiment paraProfExperiment, ParaProfTrial paraProfTrial) throws SQLException, DatabaseException {
        DatabaseAPI databaseAPI = this.getDatabaseAPI();
        if (databaseAPI == null) {
            return null;
        }
        if (paraProfExperiment == null) {
            paraProfExperiment = this.uploadExperiment(null, paraProfTrial.getExperiment(), false, false);
        }
        ParaProfTrial paraProfTrial2 = new ParaProfTrial(paraProfTrial.getTrial());
        paraProfTrial2.setID(-1);
        paraProfTrial2.setExperimentID(paraProfExperiment.getID());
        paraProfTrial2.setApplicationID(paraProfExperiment.getApplicationID());
        paraProfTrial2.getTrial().setDataSource(paraProfTrial.getDataSource());
        paraProfTrial2.setUpload(true);
        LoadTrialProgressWindow loadTrialProgressWindow = new LoadTrialProgressWindow(this, paraProfTrial2.getDataSource(), paraProfTrial2, true);
        loadTrialProgressWindow.show();
        loadTrialProgressWindow.waitForLoad();
        return paraProfTrial2;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        try {
            TreePath treePath = this.tree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (defaultMutableTreeNode.isRoot()) {
                this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(0));
                this.jSplitInnerPane.setDividerLocation(0.5);
            } else if (defaultMutableTreeNode2.isRoot()) {
                if (object.toString().equals("Standard Applications")) {
                    this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(1));
                    this.jSplitInnerPane.setDividerLocation(0.5);
                } else if (object.toString().equals("Runtime Applications")) {
                    this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(2));
                    this.jSplitInnerPane.setDividerLocation(0.5);
                } else if (object.toString().equals("DB Applications")) {
                    this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(3));
                    this.jSplitInnerPane.setDividerLocation(0.5);
                }
            } else if (object instanceof ParaProfApplication) {
                this.jSplitInnerPane.setRightComponent(this.getTable(object));
                this.jSplitInnerPane.setDividerLocation(0.5);
            } else if (object instanceof ParaProfExperiment) {
                this.jSplitInnerPane.setRightComponent(this.getTable(object));
                this.jSplitInnerPane.setDividerLocation(0.5);
            } else if (object instanceof ParaProfTrial) {
                this.jSplitInnerPane.setRightComponent(this.getTable(object));
                this.jSplitInnerPane.setDividerLocation(0.5);
            } else if (object instanceof ParaProfMetric) {
                this.metric((ParaProfMetric)object, false);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
        try {
            TreePath treePath = treeExpansionEvent.getPath();
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (defaultMutableTreeNode.isRoot()) {
                int n = this.standard.getChildCount();
                int n2 = 0;
                while (n2 < n) {
                    this.clearDefaultMutableTreeNodes((DefaultMutableTreeNode)this.standard.getChildAt(n2));
                    ++n2;
                }
                n = this.runtime.getChildCount();
                int n3 = 0;
                while (n3 < n) {
                    this.clearDefaultMutableTreeNodes((DefaultMutableTreeNode)this.runtime.getChildAt(n3));
                    ++n3;
                }
                n = this.dbApps.getChildCount();
                int n4 = 0;
                while (n4 < n) {
                    this.clearDefaultMutableTreeNodes((DefaultMutableTreeNode)this.dbApps.getChildAt(n4));
                    ++n4;
                }
            } else if (defaultMutableTreeNode2.isRoot()) {
                if (object.toString().equals("Standard Applications")) {
                    int n = this.standard.getChildCount();
                    int n5 = 0;
                    while (n5 < n) {
                        this.clearDefaultMutableTreeNodes((DefaultMutableTreeNode)this.standard.getChildAt(n5));
                        ++n5;
                    }
                } else if (object.toString().equals("Runtime Applications")) {
                    int n = this.runtime.getChildCount();
                    int n6 = 0;
                    while (n6 < n) {
                        this.clearDefaultMutableTreeNodes((DefaultMutableTreeNode)this.runtime.getChildAt(n6));
                        ++n6;
                    }
                } else if (object.toString().equals("DB Applications")) {
                    int n = this.dbApps.getChildCount();
                    int n7 = 0;
                    while (n7 < n) {
                        this.clearDefaultMutableTreeNodes((DefaultMutableTreeNode)this.dbApps.getChildAt(n7));
                        ++n7;
                    }
                }
            } else if (object instanceof ParaProfTreeNodeUserObject) {
                this.clearDefaultMutableTreeNodes(defaultMutableTreeNode);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        try {
            TreePath treePath = treeExpansionEvent.getPath();
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (defaultMutableTreeNode.isRoot()) {
                return;
            }
            if (defaultMutableTreeNode2.isRoot()) {
                if (object.toString().equals("Standard Applications")) {
                    this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(1));
                    this.jSplitInnerPane.setDividerLocation(0.5);
                    int n = this.standard.getChildCount();
                    while (n > 0) {
                        this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)this.standard.getChildAt(n - 1));
                        --n;
                    }
                    Iterator iterator = ParaProf.applicationManager.getApplications().iterator();
                    while (iterator.hasNext()) {
                        ParaProfApplication paraProfApplication = (ParaProfApplication)iterator.next();
                        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(paraProfApplication);
                        paraProfApplication.setDMTN(defaultMutableTreeNode3);
                        this.treeModel.insertNodeInto(defaultMutableTreeNode3, this.standard, this.standard.getChildCount());
                    }
                    return;
                }
                if (object.toString().equals("Runtime Applications")) {
                    this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(2));
                    this.jSplitInnerPane.setDividerLocation(0.5);
                } else if (object.toString().equals("DB Applications")) {
                    this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(3));
                    this.jSplitInnerPane.setDividerLocation(0.5);
                    int n = this.dbApps.getChildCount();
                    while (n > 0) {
                        this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)this.dbApps.getChildAt(n - 1));
                        --n;
                    }
                    DatabaseAPI databaseAPI = this.getDatabaseAPI();
                    if (databaseAPI != null) {
                        ListIterator listIterator = databaseAPI.getApplicationList().listIterator();
                        while (listIterator.hasNext()) {
                            ParaProfApplication paraProfApplication = new ParaProfApplication((Application)listIterator.next());
                            paraProfApplication.setDBApplication(true);
                            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(paraProfApplication);
                            paraProfApplication.setDMTN(defaultMutableTreeNode4);
                            this.treeModel.insertNodeInto(defaultMutableTreeNode4, this.dbApps, this.dbApps.getChildCount());
                        }
                        databaseAPI.terminate();
                    }
                    return;
                }
            } else if (object instanceof ParaProfApplication) {
                ParaProfApplication paraProfApplication = (ParaProfApplication)object;
                if (paraProfApplication.dBApplication()) {
                    int n = defaultMutableTreeNode.getChildCount();
                    while (n > 0) {
                        this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n - 1));
                        --n;
                    }
                    DatabaseAPI databaseAPI = this.getDatabaseAPI();
                    if (databaseAPI != null) {
                        databaseAPI.setApplication(paraProfApplication.getID());
                        ListIterator listIterator = databaseAPI.getExperimentList().listIterator();
                        while (listIterator.hasNext()) {
                            ParaProfExperiment paraProfExperiment = new ParaProfExperiment((Experiment)listIterator.next());
                            paraProfExperiment.setDBExperiment(true);
                            paraProfExperiment.setApplication(paraProfApplication);
                            DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(paraProfExperiment);
                            paraProfExperiment.setDMTN(defaultMutableTreeNode5);
                            this.treeModel.insertNodeInto(defaultMutableTreeNode5, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                        }
                        databaseAPI.terminate();
                    }
                } else {
                    int n = defaultMutableTreeNode.getChildCount();
                    while (n > 0) {
                        this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n - 1));
                        --n;
                    }
                    ListIterator listIterator = paraProfApplication.getExperimentList();
                    while (listIterator.hasNext()) {
                        ParaProfExperiment paraProfExperiment = (ParaProfExperiment)listIterator.next();
                        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(paraProfExperiment);
                        paraProfExperiment.setDMTN(defaultMutableTreeNode6);
                        this.treeModel.insertNodeInto(defaultMutableTreeNode6, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    }
                }
                this.jSplitInnerPane.setRightComponent(this.getTable(object));
                this.jSplitInnerPane.setDividerLocation(0.5);
            } else if (object instanceof ParaProfExperiment) {
                ParaProfExperiment paraProfExperiment = (ParaProfExperiment)object;
                if (paraProfExperiment.dBExperiment()) {
                    int n = defaultMutableTreeNode.getChildCount();
                    while (n > 0) {
                        this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n - 1));
                        --n;
                    }
                    DatabaseAPI databaseAPI = this.getDatabaseAPI();
                    if (databaseAPI != null) {
                        databaseAPI.setExperiment(paraProfExperiment.getID());
                        ListIterator listIterator = databaseAPI.getTrialList().listIterator();
                        while (listIterator.hasNext()) {
                            ParaProfTrial paraProfTrial = new ParaProfTrial((Trial)listIterator.next());
                            paraProfTrial.setDBTrial(true);
                            paraProfTrial.setExperiment(paraProfExperiment);
                            DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(paraProfTrial);
                            paraProfTrial.setDMTN(defaultMutableTreeNode7);
                            this.treeModel.insertNodeInto(defaultMutableTreeNode7, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                        }
                        databaseAPI.terminate();
                    }
                } else {
                    int n = defaultMutableTreeNode.getChildCount();
                    while (n > 0) {
                        this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n - 1));
                        --n;
                    }
                    ListIterator listIterator = paraProfExperiment.getTrialList();
                    while (listIterator.hasNext()) {
                        ParaProfTrial paraProfTrial = (ParaProfTrial)listIterator.next();
                        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(paraProfTrial);
                        paraProfTrial.setDMTN(defaultMutableTreeNode8);
                        this.treeModel.insertNodeInto(defaultMutableTreeNode8, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                        paraProfTrial.setTreePath(new TreePath(defaultMutableTreeNode8.getPath()));
                    }
                }
                this.jSplitInnerPane.setRightComponent(this.getTable(object));
                this.jSplitInnerPane.setDividerLocation(0.5);
            } else if (object instanceof ParaProfTrial) {
                DefaultMutableTreeNode defaultMutableTreeNode9;
                ParaProfTreeNodeUserObject paraProfTreeNodeUserObject;
                Object object2;
                int n;
                ParaProfTreeNodeUserObject paraProfTreeNodeUserObject2 = (ParaProfTrial)object;
                if (((ParaProfTrial)paraProfTreeNodeUserObject2).dBTrial()) {
                    n = 0;
                    object2 = this.loadedDBTrials.elements();
                    while (object2.hasMoreElements()) {
                        paraProfTreeNodeUserObject = (ParaProfTrial)object2.nextElement();
                        if (((ParaProfTrial)paraProfTreeNodeUserObject2).getID() != ((ParaProfTrial)paraProfTreeNodeUserObject).getID() || ((ParaProfTrial)paraProfTreeNodeUserObject2).getExperimentID() != ((ParaProfTrial)paraProfTreeNodeUserObject).getExperimentID() || ((ParaProfTrial)paraProfTreeNodeUserObject2).getApplicationID() != ((ParaProfTrial)paraProfTreeNodeUserObject).getApplicationID()) continue;
                        defaultMutableTreeNode.setUserObject(paraProfTreeNodeUserObject);
                        ((ParaProfTrial)paraProfTreeNodeUserObject).setDMTN(defaultMutableTreeNode);
                        paraProfTreeNodeUserObject2 = paraProfTreeNodeUserObject;
                        n = 1;
                    }
                    if (n == 0) {
                        if (((ParaProfTrial)paraProfTreeNodeUserObject2).loading()) {
                            return;
                        }
                        ((ParaProfTrial)paraProfTreeNodeUserObject2).setLoading(true);
                        paraProfTreeNodeUserObject = this.getDatabaseAPI();
                        if (paraProfTreeNodeUserObject != null) {
                            paraProfTreeNodeUserObject.setApplication(((ParaProfTrial)paraProfTreeNodeUserObject2).getApplicationID());
                            paraProfTreeNodeUserObject.setExperiment(((ParaProfTrial)paraProfTreeNodeUserObject2).getExperimentID());
                            paraProfTreeNodeUserObject.setTrial(((ParaProfTrial)paraProfTreeNodeUserObject2).getID());
                            defaultMutableTreeNode9 = new DBDataSource((Object)paraProfTreeNodeUserObject);
                            ((ParaProfTrial)paraProfTreeNodeUserObject2).getTrial().setDataSource((DataSource)defaultMutableTreeNode9);
                            DefaultMutableTreeNode defaultMutableTreeNode10 = defaultMutableTreeNode9;
                            ParaProfTreeNodeUserObject paraProfTreeNodeUserObject3 = paraProfTreeNodeUserObject2;
                            Thread thread = new Thread(new Runnable((DataSource)defaultMutableTreeNode10, (ParaProfTrial)paraProfTreeNodeUserObject3){
                                private final /* synthetic */ DataSource val$dataSource;
                                private final /* synthetic */ ParaProfTrial val$theTrial;
                                {
                                    this.val$dataSource = dataSource;
                                    this.val$theTrial = paraProfTrial;
                                }

                                public void run() {
                                    try {
                                        this.val$dataSource.load();
                                        this.val$theTrial.finishLoad();
                                        ParaProf.paraProfManagerWindow.populateTrialMetrics(this.val$theTrial);
                                    }
                                    catch (Exception exception) {
                                        EventQueue.invokeLater(new Runnable(this, exception){
                                            private final /* synthetic */ Exception val$e;
                                            private final /* synthetic */ 9 this$1;
                                            {
                                                this.this$1 = var1_1;
                                                this.val$e = exception;
                                            }

                                            public void run() {
                                                ParaProfUtils.handleException(this.val$e);
                                            }
                                        });
                                    }
                                }
                            });
                            thread.start();
                            this.loadedDBTrials.add(paraProfTreeNodeUserObject2);
                        }
                    }
                }
                if (!((ParaProfTrial)paraProfTreeNodeUserObject2).loading()) {
                    n = defaultMutableTreeNode.getChildCount();
                    while (n > 0) {
                        this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n - 1));
                        --n;
                    }
                    object2 = ((ParaProfTrial)paraProfTreeNodeUserObject2).getMetrics().iterator();
                    while (object2.hasNext()) {
                        paraProfTreeNodeUserObject = (ParaProfMetric)object2.next();
                        defaultMutableTreeNode9 = new DefaultMutableTreeNode(paraProfTreeNodeUserObject, false);
                        ((ParaProfMetric)paraProfTreeNodeUserObject).setDMTN(defaultMutableTreeNode9);
                        this.treeModel.insertNodeInto(defaultMutableTreeNode9, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    }
                    this.jSplitInnerPane.setRightComponent(this.getTable(object));
                    this.jSplitInnerPane.setDividerLocation(0.5);
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void metric(ParaProfMetric paraProfMetric, boolean bl) {
        this.jSplitInnerPane.setRightComponent(this.getTable(paraProfMetric));
        this.jSplitInnerPane.setDividerLocation(0.5);
        this.operand2 = this.operand1;
        this.pPMLPanel.setArg2Field(this.pPMLPanel.getArg1Field());
        this.operand1 = paraProfMetric;
        this.pPMLPanel.setArg1Field(paraProfMetric.getApplicationID() + ":" + paraProfMetric.getExperimentID() + ":" + paraProfMetric.getTrialID() + ":" + paraProfMetric.getID() + " - " + paraProfMetric.getName());
        if (bl) {
            this.showMetric(paraProfMetric);
        }
    }

    public ParaProfMetric getOperand1() {
        return this.operand1;
    }

    public ParaProfMetric getOperand2() {
        return this.operand2;
    }

    public void uploadMetric(ParaProfMetric paraProfMetric) {
        DatabaseAPI databaseAPI;
        if (paraProfMetric != null && (databaseAPI = this.getDatabaseAPI()) != null) {
            try {
                databaseAPI.saveTrial(paraProfMetric.getParaProfTrial().getTrial(), paraProfMetric.getID());
            }
            catch (DatabaseException databaseException) {
                ParaProfUtils.handleException((Exception)((Object)databaseException));
            }
            databaseAPI.terminate();
        }
    }

    public void clearDefaultMutableTreeNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            this.clearDefaultMutableTreeNodesHelper((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2));
            ++n2;
        }
    }

    public void clearDefaultMutableTreeNodesHelper(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            this.clearDefaultMutableTreeNodesHelper((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2));
            ++n2;
        }
        ((ParaProfTreeNodeUserObject)defaultMutableTreeNode.getUserObject()).clearDefaultMutableTreeNodes();
    }

    public int[] getSelectedDBExperiment() {
        if (ParaProf.preferences.getDatabaseConfigurationFile() == null || ParaProf.preferences.getDatabasePassword() == null) {
            JOptionPane.showMessageDialog(this, "Please set the database configuration information (file menu).", "DB Configuration Error!", 0);
            return null;
        }
        TreePath treePath = this.tree.getSelectionPath();
        boolean bl = false;
        if (treePath == null) {
            bl = true;
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof ParaProfExperiment) {
                ParaProfExperiment paraProfExperiment = (ParaProfExperiment)object;
                if (paraProfExperiment.dBExperiment()) {
                    int[] nArray = new int[]{paraProfExperiment.getApplicationID(), paraProfExperiment.getID()};
                    return nArray;
                }
                bl = true;
            } else {
                bl = true;
            }
        }
        if (bl) {
            JOptionPane.showMessageDialog(this, "Please select an db experiment first!", "DB Upload Error!", 0);
        }
        return null;
    }

    private Component getPanelHelpMessage(int n) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        switch (n) {
            case 0: {
                jTextArea.append("ParaProf Manager\n\n");
                jTextArea.append("This window allows you to manage all of ParaProf's loaded data.\n");
                jTextArea.append("Data can be static (ie, not updated at runtime), and loaded either remotely or locally.  You can also specify data to be uploaded at runtime.\n\n");
                break;
            }
            case 1: {
                jTextArea.append("ParaProf Manager\n\n");
                jTextArea.append("This is the Standard application section:\n\n");
                jTextArea.append("Standard - The classic ParaProf mode.  Data sets that are loaded at startup are placed under the default application automatically. Please see the ParaProf documentation for mre details.\n");
                break;
            }
            case 2: {
                jTextArea.append("ParaProf Manager\n\n");
                jTextArea.append("This is the Runtime application section:\n\n");
                jTextArea.append("Runtime - A new feature allowing ParaProf to update data at runtime.  Please see the ParaProf documentation if the options are not clear.\n");
                jTextArea.append("*** THIS FEATURE IS CURRENTLY OFF ***\n");
                break;
            }
            case 3: {
                jTextArea.append("ParaProf Manager\n\n");
                jTextArea.append("This is the DB Apps application section:\n\n");
                jTextArea.append("DB Apps - Another new feature allowing ParaProf to load data from a database.  Again, please see the ParaProf documentation if the options are not clear.\n");
                break;
            }
        }
        return new JScrollPane(jTextArea);
    }

    private Component getTable(Object object) {
        return new JScrollPane(new JTable(new ParaProfManagerTableModel(this, object, this.treeModel)));
    }

    public ParaProfApplication addApplication(boolean bl, DefaultMutableTreeNode defaultMutableTreeNode) throws SQLException {
        ParaProfApplication paraProfApplication = null;
        if (bl) {
            DatabaseAPI databaseAPI = this.getDatabaseAPI();
            if (databaseAPI != null) {
                paraProfApplication = new ParaProfApplication();
                paraProfApplication.setDBApplication(true);
                paraProfApplication.setName("New Application");
                paraProfApplication.setID(databaseAPI.saveApplication((Application)paraProfApplication));
                databaseAPI.terminate();
            }
        } else {
            paraProfApplication = ParaProf.applicationManager.addApplication();
            paraProfApplication.setName("New Application");
        }
        return paraProfApplication;
    }

    public ParaProfExperiment addExperiment(boolean bl, ParaProfApplication paraProfApplication) {
        ParaProfExperiment paraProfExperiment = null;
        if (bl) {
            DatabaseAPI databaseAPI = this.getDatabaseAPI();
            if (databaseAPI != null) {
                try {
                    paraProfExperiment = new ParaProfExperiment(databaseAPI.db());
                    paraProfExperiment.setDBExperiment(true);
                    paraProfExperiment.setApplicationID(paraProfApplication.getID());
                    paraProfExperiment.setName("New Experiment");
                    paraProfExperiment.setID(databaseAPI.saveExperiment((Experiment)paraProfExperiment));
                }
                catch (DatabaseException databaseException) {
                    ParaProfUtils.handleException((Exception)((Object)databaseException));
                }
                databaseAPI.terminate();
            }
        } else {
            paraProfExperiment = paraProfApplication.addExperiment();
            paraProfExperiment.setName("New Experiment");
        }
        return paraProfExperiment;
    }

    public void addTrial(ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, File[] fileArray, int n, boolean bl, boolean bl2) {
        ParaProfTrial paraProfTrial = null;
        DataSource dataSource = null;
        try {
            dataSource = UtilFncs.initializeDataSource((File[])fileArray, (int)n, (boolean)bl);
        }
        catch (DataSourceException dataSourceException) {
            if (fileArray == null || fileArray.length != 0) {
                ParaProfUtils.handleException((Exception)((Object)dataSourceException));
            }
            return;
        }
        paraProfTrial = new ParaProfTrial();
        paraProfTrial.getTrial().setDataSource(dataSource);
        paraProfTrial.setLoading(true);
        paraProfTrial.setMonitored(bl2);
        paraProfTrial.setExperiment(paraProfExperiment);
        paraProfTrial.setApplicationID(paraProfExperiment.getApplicationID());
        paraProfTrial.setExperimentID(paraProfExperiment.getID());
        if (fileArray.length != 0) {
            paraProfTrial.setPaths(fileArray[0].getPath());
        } else {
            paraProfTrial.setPaths(System.getProperty("user.dir"));
        }
        paraProfTrial.getTrial().setName(paraProfTrial.getPathReverse());
        if (paraProfExperiment.dBExperiment()) {
            this.loadedDBTrials.add(paraProfTrial);
            paraProfTrial.setUpload(true);
        } else {
            paraProfExperiment.addTrial(paraProfTrial);
        }
        LoadTrialProgressWindow loadTrialProgressWindow = new LoadTrialProgressWindow(this, dataSource, paraProfTrial, false);
        loadTrialProgressWindow.show();
    }

    private void showMetric(ParaProfMetric paraProfMetric) {
        try {
            ParaProfTrial paraProfTrial = paraProfMetric.getParaProfTrial();
            if (paraProfTrial.getDefaultMetricID() != paraProfMetric.getID()) {
                paraProfTrial.setDefaultMetricID(paraProfMetric.getID());
                paraProfTrial.updateRegisteredObjects("dataEvent");
            }
            paraProfTrial.showMainWindow();
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void populateTrialMetrics(final ParaProfTrial paraProfTrial) {
        try {
            this.loadedTrials.add(paraProfTrial);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    try {
                        if (paraProfTrial.upload()) {
                            paraProfTrial.setUpload(false);
                        }
                        if (paraProfTrial.dBTrial()) {
                            ParaProfManagerWindow.this.expandTrial(2, paraProfTrial.getApplicationID(), paraProfTrial.getExperimentID(), paraProfTrial.getID(), null, null, paraProfTrial);
                        } else {
                            ParaProfManagerWindow.this.expandTrial(0, paraProfTrial.getApplicationID(), paraProfTrial.getExperimentID(), paraProfTrial.getID(), null, null, paraProfTrial);
                        }
                    }
                    catch (Exception exception) {
                        ParaProfUtils.handleException(exception);
                    }
                }
            });
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public DefaultMutableTreeNode expandApplicationType(int n, int n2, ParaProfApplication paraProfApplication) {
        switch (n) {
            case 0: {
                DefaultMutableTreeNode defaultMutableTreeNode;
                if (!this.tree.isExpanded(new TreePath(this.standard.getPath()))) {
                    this.tree.expandPath(new TreePath(this.standard.getPath()));
                }
                int n3 = this.standard.getChildCount();
                while (n3 > 0) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)this.standard.getChildAt(n3 - 1);
                    if (n2 == ((ParaProfApplication)defaultMutableTreeNode.getUserObject()).getID()) {
                        return defaultMutableTreeNode;
                    }
                    --n3;
                }
                if (paraProfApplication != null) {
                    defaultMutableTreeNode = new DefaultMutableTreeNode(paraProfApplication);
                    paraProfApplication.setDMTN(defaultMutableTreeNode);
                    this.treeModel.insertNodeInto(defaultMutableTreeNode, this.standard, this.standard.getChildCount());
                    return defaultMutableTreeNode;
                }
                return null;
            }
            case 1: {
                DefaultMutableTreeNode defaultMutableTreeNode;
                if (!this.tree.isExpanded(new TreePath(this.runtime.getPath()))) {
                    this.tree.expandPath(new TreePath(this.runtime.getPath()));
                }
                int n4 = this.runtime.getChildCount();
                while (n4 > 0) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)this.dbApps.getChildAt(n4 - 1);
                    if (n2 == ((ParaProfTrial)defaultMutableTreeNode.getUserObject()).getID()) {
                        return defaultMutableTreeNode;
                    }
                    --n4;
                }
                if (paraProfApplication == null) break;
                defaultMutableTreeNode = new DefaultMutableTreeNode(paraProfApplication);
                paraProfApplication.setDMTN(defaultMutableTreeNode);
                this.treeModel.insertNodeInto(defaultMutableTreeNode, this.dbApps, this.dbApps.getChildCount());
                return defaultMutableTreeNode;
            }
            case 2: {
                DefaultMutableTreeNode defaultMutableTreeNode;
                if (!this.tree.isExpanded(new TreePath(this.dbApps.getPath()))) {
                    this.tree.expandPath(new TreePath(this.dbApps.getPath()));
                }
                int n5 = this.dbApps.getChildCount();
                while (n5 > 0) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)this.dbApps.getChildAt(n5 - 1);
                    if (n2 == ((ParaProfApplication)defaultMutableTreeNode.getUserObject()).getID()) {
                        return defaultMutableTreeNode;
                    }
                    --n5;
                }
                if (paraProfApplication != null) {
                    defaultMutableTreeNode = new DefaultMutableTreeNode(paraProfApplication);
                    paraProfApplication.setDMTN(defaultMutableTreeNode);
                    this.treeModel.insertNodeInto(defaultMutableTreeNode, this.dbApps, this.dbApps.getChildCount());
                    return defaultMutableTreeNode;
                }
                return null;
            }
        }
        return null;
    }

    public DefaultMutableTreeNode expandApplication(int n, int n2, int n3, ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.expandApplicationType(n, n2, paraProfApplication);
        if (defaultMutableTreeNode != null) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            this.tree.expandPath(new TreePath(this.standard.getPath()));
            int n4 = defaultMutableTreeNode.getChildCount();
            while (n4 > 0) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n4 - 1);
                if (n3 == ((ParaProfExperiment)defaultMutableTreeNode2.getUserObject()).getID()) {
                    return defaultMutableTreeNode2;
                }
                --n4;
            }
            if (paraProfExperiment != null) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(paraProfExperiment);
                paraProfExperiment.setDMTN(defaultMutableTreeNode2);
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                return defaultMutableTreeNode2;
            }
            return null;
        }
        return null;
    }

    public DefaultMutableTreeNode expandExperiment(int n, int n2, int n3, int n4, ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, ParaProfTrial paraProfTrial) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.expandApplication(n, n2, n3, paraProfApplication, paraProfExperiment);
        if (defaultMutableTreeNode != null) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            int n5 = defaultMutableTreeNode.getChildCount();
            while (n5 > 0) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n5 - 1);
                if (n4 == ((ParaProfTrial)defaultMutableTreeNode2.getUserObject()).getID()) {
                    return defaultMutableTreeNode2;
                }
                --n5;
            }
            if (paraProfTrial != null) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(paraProfTrial);
                paraProfTrial.setDMTN(defaultMutableTreeNode2);
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                return defaultMutableTreeNode2;
            }
            return null;
        }
        return null;
    }

    public void expandTrial(int n, int n2, int n3, int n4, ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, ParaProfTrial paraProfTrial) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.expandExperiment(n, n2, n3, n4, paraProfApplication, paraProfExperiment, paraProfTrial);
        if (defaultMutableTreeNode != null) {
            if (this.tree.isExpanded(new TreePath(defaultMutableTreeNode.getPath()))) {
                this.tree.collapsePath(new TreePath(defaultMutableTreeNode.getPath()));
            }
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    public DatabaseAPI getDatabaseAPI() {
        try {
            if (ParaProf.preferences.getDatabaseConfigurationFile() == null) {
                JOptionPane.showMessageDialog(this, "Please set the database configuration information (file menu).", "DB Configuration Error!", 0);
                return null;
            }
            File file = new File(ParaProf.preferences.getDatabaseConfigurationFile());
            file = new DatabaseAPI();
            if (ParaProf.preferences.getDatabasePassword() == null) {
                file.initialize(ParaProf.preferences.getDatabaseConfigurationFile(), false);
            } else {
                file.initialize(ParaProf.preferences.getDatabaseConfigurationFile(), ParaProf.preferences.getDatabasePassword());
            }
            if (!this.metaDataRetrieved) {
                this.metaDataRetrieved = true;
                Iterator iterator = ParaProf.applicationManager.getApplications().iterator();
                while (iterator.hasNext()) {
                    ParaProfApplication paraProfApplication = (ParaProfApplication)iterator.next();
                    if (paraProfApplication.dBApplication()) continue;
                    paraProfApplication.reallocMetaData();
                    ListIterator listIterator = paraProfApplication.getExperimentList();
                    while (listIterator.hasNext()) {
                        ParaProfExperiment paraProfExperiment = (ParaProfExperiment)listIterator.next();
                        paraProfExperiment.reallocMetaData();
                        ListIterator listIterator2 = paraProfExperiment.getTrialList();
                        while (listIterator2.hasNext()) {
                            ParaProfTrial paraProfTrial = (ParaProfTrial)listIterator2.next();
                            paraProfTrial.getTrial().reallocMetaData();
                        }
                    }
                }
            }
            return file;
        }
        catch (Exception exception) {
            ParaProf.helpWindow.show();
            ParaProf.helpWindow.clearText();
            ParaProf.helpWindow.writeText("There was an error connecting to the database!");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("Please see the help items below to try and resolve this issue. If none of those work, send an email to tau-bugs@cs.uoregon.edu including as complete a description of the problem as possible.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("------------------");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("1) JDBC driver issue: The JDBC driver is required in your classpath. If you ran ParaProf using the shell script provided in tau (paraprof), then the default. location used is $LOCATION_OF_TAU_ROOT/$ARCH/lib.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText(" If you ran ParaProf manually, make sure that the location of the JDBC driver is in your classpath (you can set this in your. environment, or as a commmand line option to java. As an example, PostgreSQL uses postgresql.jar as its JDBC driver name.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("2) Network connection issue: Check your ability to connect to the database. You might be connecting to the incorrect port (PostgreSQL uses port 5432 by default). Also make sure that if there exists a firewall on you network (or local machine), it is not blocking you connection. Also check your database logs to ensure that you have permission to connect to the server.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("3) Password issue: Make sure that your password is set correctly. If it is not in the perfdmf configuration file, you can enter it manually by selecting  File -> Database Configuration in the ParaProfManagerWindow window.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("------------------");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("The full error is given below:\n");
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.close();
            ParaProf.helpWindow.writeText(stringWriter.toString());
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ParaProf.helpWindow.getScrollPane().getVerticalScrollBar().setValue(0);
                }
            });
            this.tree.collapsePath(new TreePath(this.dbApps));
            return null;
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            ParaProf.preferences.setManagerWindowPosition(this.getLocation());
            ((Component)this).setVisible(false);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    public Vector getLoadedTrials() {
        return this.loadedTrials;
    }
}

