/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ColorChooser;
import edu.uoregon.tau.paraprof.GlobalDataWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfTreeNodeUserObject;
import edu.uoregon.tau.paraprof.PreferencesWindow;
import edu.uoregon.tau.paraprof.util.FileMonitor;
import edu.uoregon.tau.paraprof.util.FileMonitorListener;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.FileList;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UserEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ParaProfTrial
extends Observable
implements ParaProfTreeNodeUserObject {
    private Function highlightedFunction = null;
    private Group highlightedGroup = null;
    private UserEvent highlightedUserEvent = null;
    private DatabaseAPI dbAPI;
    private ParaProfExperiment experiment = null;
    private DefaultMutableTreeNode defaultMutableTreeNode = null;
    private TreePath treePath = null;
    private boolean dBTrial = false;
    private boolean upload = false;
    private boolean loading = false;
    private GlobalDataWindow fullDataWindow = null;
    private ColorChooser clrChooser = ParaProf.colorChooser;
    private PreferencesWindow preferencesWindow = ParaProf.preferencesWindow;
    private String path = null;
    private String pathReverse = null;
    private int defaultMetricID = 0;
    private Group selectedGroup;
    private int groupFilter = 0;
    private Trial trial;
    private boolean monitored;
    private FileMonitorListener fileMonitorListener;

    public ParaProfTrial() {
        this.trial = new Trial();
        this.trial.setID(-1);
        this.trial.setExperimentID(-1);
        this.trial.setApplicationID(-1);
        this.trial.setName("");
    }

    public ParaProfTrial(Trial trial) {
        this.trial = new Trial(trial);
    }

    public Trial getTrial() {
        return this.trial;
    }

    public int getApplicationID() {
        return this.trial.getApplicationID();
    }

    public int getExperimentID() {
        return this.trial.getExperimentID();
    }

    public int getID() {
        return this.trial.getID();
    }

    public void setApplicationID(int n) {
        this.trial.setApplicationID(n);
    }

    public void setExperimentID(int n) {
        this.trial.setExperimentID(n);
    }

    public void setID(int n) {
        this.trial.setID(n);
    }

    public String getName() {
        return this.trial.getName();
    }

    public DataSource getDataSource() {
        return this.trial.getDataSource();
    }

    public void setExperiment(ParaProfExperiment paraProfExperiment) {
        this.experiment = paraProfExperiment;
    }

    public ParaProfExperiment getExperiment() {
        return this.experiment;
    }

    public void setDMTN(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.defaultMutableTreeNode = defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDMTN() {
        return this.defaultMutableTreeNode;
    }

    public void setTreePath(TreePath treePath) {
        this.treePath = treePath;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public void setDBTrial(boolean bl) {
        this.dBTrial = bl;
    }

    public boolean dBTrial() {
        return this.dBTrial;
    }

    public void setUpload(boolean bl) {
        this.upload = bl;
    }

    public boolean upload() {
        return this.upload;
    }

    public void setLoading(boolean bl) {
        this.loading = bl;
    }

    public boolean loading() {
        return this.loading;
    }

    public String getIDString() {
        if (this.experiment != null) {
            return this.experiment.getIDString() + ":" + this.trial.getID();
        }
        return ":" + this.trial.getID();
    }

    public ColorChooser getColorChooser() {
        return this.clrChooser;
    }

    public PreferencesWindow getPreferencesWindow() {
        return this.preferencesWindow;
    }

    public String getTrialIdentifier(boolean bl) {
        if (this.path != null) {
            if (bl) {
                return this.pathReverse;
            }
            return this.path;
        }
        return "Application " + this.trial.getApplicationID() + ", Experiment " + this.trial.getExperimentID() + ", Trial " + this.trial.getID() + ".";
    }

    public void setPaths(String string) {
        this.path = string;
        this.pathReverse = FileList.getPathReverse((String)string);
    }

    public String getPath() {
        return this.path;
    }

    public String getPathReverse() {
        return this.pathReverse;
    }

    public String toString() {
        if (this.loading()) {
            return this.trial.getName() + " (Loading...)";
        }
        return this.trial.getName();
    }

    public void clearDefaultMutableTreeNodes() {
        this.setDMTN(null);
    }

    public GlobalDataWindow getFullDataWindow() {
        return this.fullDataWindow;
    }

    public void showMainWindow() {
        if (this.fullDataWindow == null) {
            this.fullDataWindow = new GlobalDataWindow(this, this.trial.getDataSource().getTopLevelPhase());
            ParaProf.incrementNumWindows();
            ((Component)this.fullDataWindow).setVisible(true);
        } else {
            ParaProf.incrementNumWindows();
            ((Component)this.fullDataWindow).setVisible(true);
        }
    }

    public void closeStaticMainWindow() {
        if (this.fullDataWindow != null) {
            this.deleteObserver(this.fullDataWindow);
            ((Component)this.fullDataWindow).setVisible(false);
        }
    }

    public void setDefaultMetricID(int n) {
        this.defaultMetricID = n;
    }

    public int getDefaultMetricID() {
        return this.defaultMetricID;
    }

    public boolean isTimeMetric() {
        String string = this.getMetricName(this.getDefaultMetricID());
        return (string = string.toUpperCase()).indexOf("TIME") != -1;
    }

    public boolean isDerivedMetric() {
        return this.getMetric(this.getDefaultMetricID()).getDerivedMetric();
    }

    public List getMetrics() {
        return this.trial.getDataSource().getMetrics();
    }

    public int getNumberOfMetrics() {
        return this.trial.getDataSource().getNumberOfMetrics();
    }

    public ParaProfMetric getMetric(int n) {
        return (ParaProfMetric)this.trial.getDataSource().getMetric(n);
    }

    public String getMetricName(int n) {
        return this.trial.getDataSource().getMetricName(n);
    }

    public ParaProfMetric addMetric() {
        ParaProfMetric paraProfMetric = new ParaProfMetric();
        this.trial.getDataSource().addMetric((Metric)paraProfMetric);
        return paraProfMetric;
    }

    public boolean groupNamesPresent() {
        return this.trial.getDataSource().getGroupNamesPresent();
    }

    public boolean userEventsPresent() {
        return this.trial.getDataSource().getUserEventsPresent();
    }

    public boolean callPathDataPresent() {
        return this.trial.getDataSource().getCallPathDataPresent();
    }

    public int[] getMaxNCTNumbers() {
        return this.trial.getDataSource().getMaxNCTNumbers();
    }

    public void setMeanData(int n) {
        this.trial.getDataSource().generateStatistics(n, n);
    }

    public List getDisplayedFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        Iterator iterator = this.getDataSource().getFunctions();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            if (!this.displayFunction(function)) continue;
            arrayList.add(function);
        }
        return arrayList;
    }

    public boolean displayFunction(Function function) {
        switch (this.groupFilter) {
            case 0: {
                return true;
            }
            case 1: {
                return function.isGroupMember(this.selectedGroup);
            }
            case 2: {
                return !function.isGroupMember(this.selectedGroup);
            }
        }
        return true;
    }

    public void setSelectedGroup(Group group) {
        this.selectedGroup = group;
    }

    public Group getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setGroupFilter(int n) {
        this.groupFilter = n;
    }

    public int getGroupFilter() {
        return this.groupFilter;
    }

    public void finishLoad() {
        int n = this.trial.getDataSource().getNumberOfMetrics();
        Vector<ParaProfMetric> vector = new Vector<ParaProfMetric>();
        int n2 = 0;
        while (n2 < n) {
            ParaProfMetric paraProfMetric = new ParaProfMetric();
            paraProfMetric.setName(this.trial.getDataSource().getMetricName(n2));
            paraProfMetric.setID(n2);
            paraProfMetric.setPpTrial(this);
            vector.add(paraProfMetric);
            ++n2;
        }
        this.trial.getDataSource().setMetrics(vector);
        int n3 = 0;
        while (n3 < n) {
            ParaProfMetric paraProfMetric = (ParaProfMetric)this.trial.getDataSource().getMetric(n3);
            if (paraProfMetric.isTimeMetric()) {
                this.setDefaultMetricID(n3);
                break;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            ParaProfMetric paraProfMetric = (ParaProfMetric)this.trial.getDataSource().getMetric(n4);
            if (paraProfMetric.getName().equalsIgnoreCase("Time")) {
                this.setDefaultMetricID(n4);
                break;
            }
            ++n4;
        }
        this.clrChooser.setColors(this, -1);
        this.setLoading(false);
    }

    public DatabaseAPI getDatabaseAPI() {
        return this.dbAPI;
    }

    public void setDatabaseAPI(DatabaseAPI databaseAPI) {
        this.dbAPI = databaseAPI;
    }

    public void setHighlightedFunction(Function function) {
        this.highlightedFunction = function;
        this.updateRegisteredObjects("colorEvent");
    }

    public Function getHighlightedFunction() {
        return this.highlightedFunction;
    }

    public void toggleHighlightedFunction(Function function) {
        this.highlightedFunction = this.highlightedFunction == function ? null : function;
        this.updateRegisteredObjects("colorEvent");
    }

    public void setHighlightedGroup(Group group) {
        this.highlightedGroup = group;
        this.updateRegisteredObjects("colorEvent");
    }

    public Group getHighlightedGroup() {
        return this.highlightedGroup;
    }

    public void toggleHighlightedGroup(Group group) {
        this.highlightedGroup = this.highlightedGroup == group ? null : group;
        this.updateRegisteredObjects("colorEvent");
    }

    public void setHighlightedUserEvent(UserEvent userEvent) {
        this.highlightedUserEvent = userEvent;
        this.updateRegisteredObjects("colorEvent");
    }

    public UserEvent getHighlightedUserEvent() {
        return this.highlightedUserEvent;
    }

    public void toggleHighlightedUserEvent(UserEvent userEvent) {
        this.highlightedUserEvent = this.highlightedUserEvent == userEvent ? null : userEvent;
        this.updateRegisteredObjects("colorEvent");
    }

    public boolean getMonitored() {
        return this.monitored;
    }

    public void setMonitored(boolean bl) {
        this.monitored = bl;
        if (bl) {
            FileMonitor fileMonitor = new FileMonitor(1000L);
            List list = this.trial.getDataSource().getFiles();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                fileMonitor.addFile(file);
            }
            this.fileMonitorListener = new FileMonitorListener(){

                public void fileChanged(File file) {
                    try {
                        while (ParaProfTrial.this.loading) {
                            Thread.sleep(1000L);
                        }
                        EventQueue.invokeAndWait(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                try {
                                    if (1.access$100(this.this$1).getDataSource().reloadData()) {
                                        ParaProfTrial.access$200(1.access$100(this.this$1)).setColors(1.access$100(this.this$1), -1);
                                        1.access$100(this.this$1).updateRegisteredObjects("dataEvent");
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                static /* synthetic */ ParaProfTrial access$100(1 var0) {
                    return var0.ParaProfTrial.this;
                }
            };
            fileMonitor.addListener(this.fileMonitorListener);
        }
    }

    public void updateRegisteredObjects(String string) {
        this.setChanged();
        this.notifyObservers(string);
    }

    static /* synthetic */ ColorChooser access$200(ParaProfTrial paraProfTrial) {
        return paraProfTrial.clrChooser;
    }
}

