/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.PPUserEventProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Searcher;
import edu.uoregon.tau.paraprof.StatWindow;
import edu.uoregon.tau.paraprof.interfaces.ImageExport;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JPanel;

public class StatWindowPanel
extends JPanel
implements MouseListener,
Printable,
ImageExport {
    private int xPanelSize = 800;
    private int yPanelSize = 600;
    private int newXPanelSize = 0;
    private int newYPanelSize = 0;
    private int startLocation = 0;
    private int maxFontAscent = 0;
    private int maxFontDescent = 0;
    private int spacing = 0;
    private ParaProfTrial ppTrial = null;
    private StatWindow window = null;
    private boolean userEventWindow;
    private List list = new ArrayList();
    private Font monoFont = null;
    private FontMetrics fmMonoFont = null;
    private Object clickedOnObject = null;
    private int lastHeaderEndPosition = 0;
    private int maxLinePixelWidth = 0;
    private Searcher searcher;
    private int charWidth = 0;
    private int xOffset = 20;

    public StatWindowPanel(ParaProfTrial paraProfTrial, StatWindow statWindow, boolean bl) {
        this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
        this.setBackground(Color.white);
        this.setAutoscrolls(true);
        this.searcher = new Searcher(this, statWindow);
        this.addMouseListener(this.searcher);
        this.addMouseMotionListener(this.searcher);
        this.ppTrial = paraProfTrial;
        this.window = statWindow;
        this.userEventWindow = bl;
        this.addMouseListener(this);
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.export((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.export((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    public static String getUserEventStatStringHeading() {
        int n = 18;
        return UtilFncs.pad((String)"NumSamples", (int)n) + UtilFncs.pad((String)"Max", (int)n) + UtilFncs.pad((String)"Min", (int)n) + UtilFncs.pad((String)"Mean", (int)n) + UtilFncs.pad((String)"Std. Dev", (int)n);
    }

    public void setSearchLines(String string, String string2) {
        if (this.searcher.getSearchLines() == null && this.list != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            arrayList.add(string);
            arrayList.add(string2);
            int n = 0;
            while (n < this.list.size()) {
                String string3;
                String string4;
                if (this.userEventWindow) {
                    string4 = ((PPUserEventProfile)this.list.get(n)).getUserEventName();
                    string3 = ((PPUserEventProfile)this.list.get(n)).getUserEventStatString(ParaProf.defaultNumberPrecision);
                    string3 = string3 + string4;
                } else {
                    string4 = ((PPFunctionProfile)this.list.get(n)).getFunctionName();
                    string3 = ((PPFunctionProfile)this.list.get(n)).getStatString(this.window.units());
                    string3 = string3 + "   " + string4;
                }
                this.maxLinePixelWidth = Math.max(this.maxLinePixelWidth, this.charWidth * string3.length() + this.xOffset);
                arrayList.add(string3);
                ++n;
            }
            this.searcher.setSearchLines(arrayList);
        }
    }

    private void setStatStringColor(Graphics2D graphics2D, PPUserEventProfile pPUserEventProfile, PPFunctionProfile pPFunctionProfile) {
        int n = -1;
        if (this.userEventWindow) {
            UserEvent userEvent = this.ppTrial.getHighlightedUserEvent();
            if (userEvent != null) {
                n = userEvent.getID();
            }
        } else {
            Function function = this.ppTrial.getHighlightedFunction();
            if (function != null) {
                n = function.getID();
            }
        }
        if (this.userEventWindow && pPUserEventProfile.getUserEvent().getID() == n || !this.userEventWindow && pPFunctionProfile.getFunction().getID() == n) {
            graphics2D.setColor(this.ppTrial.getColorChooser().getHighlightColor());
        } else if (!this.userEventWindow && pPFunctionProfile.isGroupMember(this.ppTrial.getHighlightedGroup())) {
            graphics2D.setColor(this.ppTrial.getColorChooser().getGroupHighlightColor());
        } else {
            graphics2D.setColor(Color.black);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        void var15_21;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.list = this.window.getData();
        if (this.list.size() == 0) {
            return;
        }
        Object object5 = 0;
        int n = this.ppTrial.getPreferencesWindow().getFontSize();
        this.monoFont = new Font("Monospaced", this.ppTrial.getPreferencesWindow().getFontStyle(), n);
        this.fmMonoFont = graphics2D.getFontMetrics(this.monoFont);
        this.maxFontAscent = this.fmMonoFont.getMaxAscent();
        this.maxFontDescent = this.fmMonoFont.getMaxDescent();
        this.spacing = this.fmMonoFont.getHeight();
        graphics2D.setFont(this.monoFont);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        if (this.spacing <= this.maxFontAscent + this.maxFontDescent) {
            ++this.spacing;
        }
        this.searcher.setLineHeight(this.spacing);
        if (bl3) {
            object4 = this.getInsets();
            object5 += this.spacing;
            String string = this.window.getHeaderString();
            object3 = new StringTokenizer(string, "'\n'");
            while (((StringTokenizer)object3).hasMoreTokens()) {
                AttributedString attributedString = new AttributedString(((StringTokenizer)object3).nextToken());
                attributedString.addAttribute(TextAttribute.FONT, this.monoFont);
                object2 = attributedString.getIterator();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer((AttributedCharacterIterator)object2, fontRenderContext);
                float f = this.getSize().width - ((Insets)object4).left - ((Insets)object4).right;
                float f2 = ((Insets)object4).left;
                float string2 = ((Insets)object4).right;
                while (lineBreakMeasurer.getPosition() < object2.getEndIndex()) {
                    object = lineBreakMeasurer.nextLayout(f);
                    ((TextLayout)object).draw(graphics2D, f2, (float)(object5 += this.spacing));
                    f2 = ((Insets)object4).left;
                }
            }
            this.lastHeaderEndPosition = object5;
        }
        object4 = this.userEventWindow ? StatWindowPanel.getUserEventStatStringHeading() : (this.ppTrial.isTimeMetric() ? PPFunctionProfile.getStatStringHeading("Time") : PPFunctionProfile.getStatStringHeading("Counts"));
        int n2 = this.fmMonoFont.stringWidth((String)object4) + this.xOffset;
        object4 = (String)object4 + "Name";
        object3 = "";
        int n3 = 0;
        while (n3 < ((String)object4).length()) {
            object3 = (String)object3 + "-";
            ++n3;
        }
        this.charWidth = this.fmMonoFont.stringWidth("A");
        this.setSearchLines((String)object4, (String)object3);
        this.searcher.setG2d(graphics2D);
        this.searcher.setXOffset(this.xOffset);
        graphics2D.setColor(Color.black);
        this.searcher.drawHighlights(graphics2D, this.xOffset, (int)(object5 += this.spacing), 0);
        graphics2D.setColor(Color.black);
        graphics2D.drawString((String)object3, this.xOffset, (int)object5);
        this.searcher.drawHighlights(graphics2D, this.xOffset, (int)(object5 += this.spacing), 1);
        graphics2D.setColor(Color.black);
        graphics2D.drawString((String)object4, this.xOffset, (int)object5);
        this.searcher.drawHighlights(graphics2D, this.xOffset, (int)(object5 += this.spacing), 2);
        graphics2D.setColor(Color.black);
        graphics2D.drawString((String)object3, this.xOffset, (int)object5);
        if (bl) {
            this.startLocation = object5;
        }
        this.newYPanelSize = object5 + (this.list.size() + 1) * this.spacing;
        object2 = ParaProfUtils.computeClipping(graphics2D.getClipBounds(), this.window.getViewRect(), bl, bl2, this.list.size(), this.spacing, object5);
        Object object6 = object2[0];
        Object object62 = object2[1];
        object5 = object2[2];
        this.searcher.setVisibleLines((int)object6, (int)object62);
        Object object7 = object6;
        while (var15_21 <= object62) {
            String string;
            Color color;
            String string2;
            object = null;
            PPUserEventProfile pPUserEventProfile = null;
            if (this.userEventWindow) {
                pPUserEventProfile = (PPUserEventProfile)this.list.get((int)var15_21);
                string2 = pPUserEventProfile.getUserEventStatString(ParaProf.defaultNumberPrecision);
            } else {
                object = (PPFunctionProfile)this.list.get((int)var15_21);
                string2 = ((PPFunctionProfile)object).getStatString(this.window.units());
            }
            object5 += this.spacing;
            if (this.userEventWindow) {
                color = pPUserEventProfile.getColor();
                string = pPUserEventProfile.getUserEventName();
            } else {
                color = ((PPFunctionProfile)object).getColor();
                string = ((PPFunctionProfile)object).getFunctionName();
                if (this.window.getPhase() != null) {
                    string = UtilFncs.getRightSide((String)string);
                }
            }
            this.searcher.drawHighlights(graphics2D, this.xOffset, (int)object5, (int)(var15_21 + 3));
            this.setStatStringColor(graphics2D, pPUserEventProfile, (PPFunctionProfile)object);
            new TextLayout(string2, this.monoFont, fontRenderContext).draw(graphics2D, this.xOffset, (float)object5);
            graphics2D.setColor(color);
            new TextLayout(string, this.monoFont, fontRenderContext).draw(graphics2D, n2, (float)object5);
            ++var15_21;
        }
        if (this.newYPanelSize != this.yPanelSize || this.maxLinePixelWidth >= this.xPanelSize) {
            this.yPanelSize = this.newYPanelSize + 1;
            this.xPanelSize = this.maxLinePixelWidth + 5;
            this.revalidate();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getY();
            int n2 = n - this.startLocation;
            int n3 = n2 / this.spacing;
            int n4 = (n3 + 1) * this.spacing;
            int n5 = n4 - this.maxFontAscent;
            if (n2 >= n5 && n2 <= n4 && n3 < this.list.size()) {
                if (this.userEventWindow) {
                    PPUserEventProfile pPUserEventProfile = null;
                    pPUserEventProfile = (PPUserEventProfile)this.list.get(n3);
                    if (ParaProfUtils.rightClick(mouseEvent)) {
                        ParaProfUtils.handleUserEventClick(this.ppTrial, pPUserEventProfile.getUserEvent(), this, mouseEvent);
                    } else {
                        this.ppTrial.toggleHighlightedUserEvent(pPUserEventProfile.getUserEvent());
                    }
                } else {
                    PPFunctionProfile pPFunctionProfile = null;
                    pPFunctionProfile = (PPFunctionProfile)this.list.get(n3);
                    if (ParaProfUtils.rightClick(mouseEvent)) {
                        ParaProfUtils.createFunctionClickPopUp(this.ppTrial, pPFunctionProfile.getFunction(), pPFunctionProfile.getThread(), this).show(this, mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        this.ppTrial.toggleHighlightedFunction(pPFunctionProfile.getFunction());
                    }
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void resetStringSize() {
        this.maxLinePixelWidth = 0;
        this.searcher.setSearchLines(null);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.window.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }

    public Searcher getSearcher() {
        return this.searcher;
    }
}

