/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Searcher;
import edu.uoregon.tau.paraprof.barchart.BarChartModel;
import edu.uoregon.tau.paraprof.barchart.BarChartModelListener;
import edu.uoregon.tau.paraprof.barchart.BarChartPanel;
import edu.uoregon.tau.paraprof.barchart.DrawObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public class BarChart
extends JPanel
implements MouseListener,
BarChartModelListener {
    private BarChartModel model;
    private int maxRowLabelStringWidth;
    private boolean maxRowLabelStringWidthSet;
    private int maxValueLabelStringWidth;
    private boolean maxValueLabelStringWidthSet;
    private boolean preferredSizeSet;
    private boolean dataProcessed;
    double[] maxRowValues;
    double[] maxSubValues;
    double maxRowSum;
    double maxOverallValue;
    double[] rowSums;
    private FontMetrics fontMetrics;
    private boolean leftJustified;
    private int barLength = 400;
    private int leftMargin = 8;
    private int rightMargin = 5;
    private int horizSpacing = 10;
    private int barVerticalSpacing = 4;
    private int barHeight;
    private int topMargin = 0;
    private int rowStart;
    private ArrayList rowLabelDrawObjects = new ArrayList();
    private ArrayList valueDrawObjects = new ArrayList();
    private BarChartPanel panel;
    private Searcher searcher;
    private int barHorizSpacing = 5;
    private int threshold = 2;
    private boolean stacked = true;
    private boolean normalized = true;
    private boolean singleLine = true;
    private int fontHeight;

    public BarChart(BarChartModel barChartModel, BarChartPanel barChartPanel) {
        this.model = barChartModel;
        this.panel = barChartPanel;
        barChartModel.addBarChartModelListener(this);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.searcher = new Searcher(this, barChartPanel);
        this.searcher.setTopMargin(this.topMargin);
        this.addMouseListener(this.searcher);
        this.addMouseMotionListener(this.searcher);
        this.setAutoscrolls(true);
        this.barChartChanged();
        this.setToolTipText("...");
    }

    public boolean getLeftJustified() {
        return this.leftJustified;
    }

    public void setLeftJustified(boolean bl) {
        this.leftJustified = bl;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.rowLabelDrawObjects.size();
        int n4 = 0;
        while (n4 < n3) {
            DrawObject drawObject = (DrawObject)this.rowLabelDrawObjects.get(n4);
            if (n >= drawObject.getXBeg() && n <= drawObject.getXEnd() && n2 >= drawObject.getYBeg() && n2 <= drawObject.getYEnd()) {
                return this.model.getRowLabelToolTipText(n4 + this.rowStart);
            }
            ++n4;
        }
        n3 = this.valueDrawObjects.size();
        int n5 = 0;
        while (n5 < n3) {
            ArrayList arrayList = (ArrayList)this.valueDrawObjects.get(n5);
            int n6 = arrayList.size();
            int n7 = 0;
            while (n7 < n6) {
                DrawObject drawObject = (DrawObject)arrayList.get(n7);
                if (drawObject != null && n >= drawObject.getXBeg() && n <= drawObject.getXEnd() && n2 >= drawObject.getYBeg() && n2 <= drawObject.getYEnd()) {
                    if (n7 == n6 - 1) {
                        return this.model.getOtherToolTopText(n5 + this.rowStart);
                    }
                    return this.model.getValueToolTipText(n5 + this.rowStart, n7);
                }
                ++n7;
            }
            ++n5;
        }
        return null;
    }

    protected void paintComponent(Graphics graphics) {
        try {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(Color.white);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.export((Graphics2D)graphics, true, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.rowLabelDrawObjects.size();
        int n4 = 0;
        while (n4 < n3) {
            DrawObject drawObject = (DrawObject)this.rowLabelDrawObjects.get(n4);
            if (n >= drawObject.getXBeg() && n <= drawObject.getXEnd() && n2 >= drawObject.getYBeg() && n2 <= drawObject.getYEnd()) {
                this.model.fireRowLabelClick(n4 + this.rowStart, mouseEvent, this);
                return;
            }
            ++n4;
        }
        n3 = this.valueDrawObjects.size();
        int n5 = 0;
        while (n5 < n3) {
            ArrayList arrayList = (ArrayList)this.valueDrawObjects.get(n5);
            int n6 = arrayList.size();
            int n7 = 0;
            while (n7 < n6) {
                DrawObject drawObject = (DrawObject)arrayList.get(n7);
                if (drawObject != null && n >= drawObject.getXBeg() && n <= drawObject.getXEnd() && n2 >= drawObject.getYBeg() && n2 <= drawObject.getYEnd() && n7 != n6 - 1) {
                    this.model.fireValueClick(n5 + this.rowStart, n7, mouseEvent, this);
                }
                ++n7;
            }
            ++n5;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private int getMaxRowLabelStringWidth() {
        if (!this.maxRowLabelStringWidthSet) {
            this.maxRowLabelStringWidth = 0;
            int n = 0;
            while (n < this.model.getNumRows()) {
                String string = this.model.getRowLabel(n);
                this.maxRowLabelStringWidth = Math.max(this.maxRowLabelStringWidth, this.fontMetrics.stringWidth(string));
                ++n;
            }
            this.maxRowLabelStringWidthSet = true;
        }
        return this.maxRowLabelStringWidth;
    }

    private int getMaxValueLabelStringWidth() {
        if (!this.maxValueLabelStringWidthSet) {
            this.maxValueLabelStringWidth = 0;
            int n = 0;
            while (n < this.model.getNumRows()) {
                String string = this.model.getValueLabel(n, 0);
                this.maxValueLabelStringWidth = Math.max(this.maxValueLabelStringWidth, this.fontMetrics.stringWidth(string));
                ++n;
            }
            this.maxValueLabelStringWidthSet = true;
        }
        return this.maxValueLabelStringWidth;
    }

    private void checkPreferredSize() {
        int n;
        if (this.preferredSizeSet) {
            return;
        }
        int n2 = this.model.getNumRows() * this.fontHeight + this.topMargin + this.fontMetrics.getMaxDescent() + this.fontMetrics.getLeading();
        if (this.model.getSubSize() == 1) {
            n = this.barLength + this.getMaxRowLabelStringWidth() + this.getMaxValueLabelStringWidth() + this.leftMargin + 2 * this.horizSpacing + this.rightMargin;
        } else if (this.singleLine) {
            if (this.stacked) {
                n = this.leftMargin + this.getMaxRowLabelStringWidth() + this.horizSpacing + this.barLength + this.rightMargin;
            } else {
                n = this.leftMargin + this.getMaxRowLabelStringWidth() + this.horizSpacing + this.rightMargin;
                int n3 = 0;
                while (n3 < this.model.getSubSize()) {
                    int n4 = (int)(this.maxSubValues[n3] / this.maxRowSum * (double)this.barLength);
                    n = (int)((double)n + (this.maxSubValues[n3] / this.maxRowSum * (double)this.barLength + (double)this.barHorizSpacing));
                    ++n3;
                }
            }
        } else {
            int n5 = this.fontHeight * this.model.getSubSize() + 10;
            n = this.barLength + this.getMaxRowLabelStringWidth() + this.getMaxValueLabelStringWidth() + this.leftMargin + 2 * this.horizSpacing + this.rightMargin;
            n2 = this.model.getNumRows() * n5;
        }
        super.setSize(new Dimension(n, n2 + 5));
        super.setPreferredSize(new Dimension(n, n2 + 5));
        this.preferredSizeSet = true;
        this.invalidate();
    }

    private void processData() {
        if (this.dataProcessed) {
            return;
        }
        this.dataProcessed = true;
        this.maxRowValues = new double[this.model.getNumRows()];
        this.maxSubValues = new double[this.model.getSubSize()];
        this.rowSums = new double[this.model.getNumRows()];
        this.maxRowSum = 0.0;
        this.maxOverallValue = 0.0;
        int n = 0;
        while (n < this.model.getNumRows()) {
            double d = 0.0;
            int n2 = 0;
            while (n2 < this.model.getSubSize()) {
                double d2 = Math.max(0.0, this.model.getValue(n, n2));
                this.maxRowValues[n] = Math.max(this.maxRowValues[n], d2);
                this.maxSubValues[n2] = Math.max(this.maxSubValues[n2], d2);
                d += d2;
                int n3 = n;
                this.rowSums[n3] = this.rowSums[n3] + d2;
                this.maxOverallValue = Math.max(this.maxOverallValue, d2);
                ++n2;
            }
            this.maxRowSum = Math.max(this.maxRowSum, d);
            ++n;
        }
    }

    private Color lighter(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = Math.max(n, n2);
        n4 = Math.max(n4, n3);
        n4 = Math.max(n4, 255);
        n += (int)((double)(n4 - n) / 2.36);
        n2 += (int)((double)(n4 - n2) / 2.36);
        n3 += (int)((double)(n4 - n3) / 2.36);
        return new Color(n, n2, n3);
    }

    private void drawBar(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color, Color color2) {
        boolean bl = true;
        if (bl && n4 > 4) {
            graphics2D.setColor(color);
            graphics2D.fillRect(n, n2, n3, n4 - 1);
            graphics2D.setColor(this.lighter(color));
            int n5 = n4 / 4;
            graphics2D.fillRect(n, n2 + n5 / 2 + 1, n3, n5);
            int n6 = n5 / 3;
            graphics2D.setColor(this.lighter(this.lighter(color)));
            graphics2D.fillRect(n, n2 + n5 / 2 + 1 + n6, n3, n6);
            graphics2D.setColor(Color.black);
            if (color2 != null) {
                graphics2D.setColor(color2);
                graphics2D.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 3);
            }
            graphics2D.drawRect(n, n2, n3, n4 - 1);
        } else {
            n4 = Math.max(n4, 1);
            graphics2D.setColor(color);
            graphics2D.fillRect(n, n2, n3, n4);
            if (n4 > 3) {
                graphics2D.setColor(Color.black);
                if (color2 != null) {
                    graphics2D.setColor(color2);
                    graphics2D.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                }
                graphics2D.drawRect(n, n2, n3, n4);
            }
        }
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2) {
        this.rowLabelDrawObjects.clear();
        this.valueDrawObjects.clear();
        Font font = ParaProf.preferencesWindow.getFont();
        graphics2D.setFont(font);
        this.fontMetrics = graphics2D.getFontMetrics(font);
        this.barVerticalSpacing = 0;
        this.fontHeight = this.fontMetrics.getHeight();
        int n = this.fontMetrics.getMaxDescent();
        int n2 = this.fontMetrics.getMaxAscent();
        int n3 = this.fontMetrics.getLeading();
        this.barHeight = n + n2 + n3 - 2;
        this.processData();
        int n4 = this.leftJustified ? this.leftMargin + this.getMaxRowLabelStringWidth() : this.leftMargin + this.getMaxValueLabelStringWidth() + this.horizSpacing + this.barLength + this.horizSpacing;
        int n5 = (int)((float)n2 - ((float)n + (float)n2 + (float)n3 - (float)this.barHeight) / 2.0f);
        this.checkPreferredSize();
        int n6 = this.fontHeight;
        int n7 = n6 + this.topMargin;
        if (!this.singleLine) {
            n6 = n6 * this.model.getSubSize() + 10;
        }
        this.searcher.setLineHeight(n6);
        this.searcher.setMaxDescent(this.fontMetrics.getMaxDescent());
        int[] nArray = ParaProfUtils.computeClipping(this.panel.getViewport().getViewRect(), this.panel.getViewport().getViewRect(), true, bl2, this.model.getNumRows(), n6, n7);
        this.rowStart = nArray[0];
        int n8 = nArray[1];
        n7 = nArray[2];
        double d = this.maxRowSum;
        this.searcher.setVisibleLines(this.rowStart, n8);
        this.searcher.setG2d(graphics2D);
        this.searcher.setXOffset(n4);
        int n9 = this.rowStart;
        while (n9 <= n8) {
            int n10;
            int n11;
            String string = this.model.getRowLabel(n9);
            int n12 = this.fontMetrics.stringWidth(string);
            ArrayList<DrawObject> arrayList = new ArrayList<DrawObject>();
            this.valueDrawObjects.add(arrayList);
            if (this.model.getSubSize() == 1) {
                int n13;
                int n14;
                String string2 = this.model.getValueLabel(n9, 0);
                double d2 = this.model.getValue(n9, 0);
                double d3 = d2 / d;
                int n15 = (int)(d3 * (double)this.barLength);
                int n16 = this.fontMetrics.stringWidth(string2);
                int n17 = n7 - n5;
                if (this.leftJustified) {
                    n14 = n4 + this.horizSpacing;
                    n13 = n4 - n12;
                    n11 = n4 + n15 + 2 * this.horizSpacing;
                } else {
                    n14 = n4 - n15 - this.horizSpacing;
                    n13 = n4;
                    n11 = n4 - n15 - n16 - 2 * this.horizSpacing;
                }
                this.drawBar(graphics2D, n14, n7 - n5, n15, this.barHeight, this.model.getValueColor(n9, 0), this.model.getValueHighlightColor(n9, 0));
                arrayList.add(new DrawObject(n14, n7 - n5, n14 + n15, n7 - n5 + this.barHeight));
                this.searcher.drawHighlights(graphics2D, n13, n7, n9);
                graphics2D.setColor(Color.black);
                graphics2D.drawString(string, n13, n7);
                this.rowLabelDrawObjects.add(new DrawObject(n13, n7 - this.fontHeight, n13 + n12, n7));
                graphics2D.drawString(string2, n11, n7);
                n7 += n6;
                arrayList.add(null);
            } else if (this.singleLine) {
                int n18;
                int n19 = n7 - n5;
                d = this.normalized ? this.rowSums[n9] : this.maxRowSum;
                if (this.leftJustified) {
                    n18 = n4 + this.horizSpacing;
                    n10 = n4 - n12;
                } else {
                    n18 = 0;
                    n10 = 0;
                }
                this.searcher.drawHighlights(graphics2D, n10, n7, n9);
                graphics2D.setColor(Color.black);
                graphics2D.drawString(string, n10, n7);
                this.rowLabelDrawObjects.add(new DrawObject(n10, n7 - this.fontHeight, n10 + n12, n7));
                if (d > 0.0) {
                    double d4 = 0.0;
                    double d5 = 0.0;
                    int n20 = 0;
                    while (n20 < this.model.getSubSize()) {
                        graphics2D.setColor(this.model.getValueColor(n9, n20));
                        double d6 = this.model.getValue(n9, n20);
                        Color color = this.model.getValueColor(n9, n20);
                        double d7 = d6 / d;
                        int n21 = (int)(d7 * (double)this.barLength + d5);
                        d5 = d7 * (double)this.barLength + d5 - (double)n21;
                        if (n21 < this.threshold && this.stacked) {
                            d4 += d6;
                            arrayList.add(null);
                        } else {
                            int n22 = (int)(this.maxSubValues[n20] / d * (double)this.barLength);
                            if (n22 < this.threshold) {
                                arrayList.add(null);
                                d4 += d6;
                            } else {
                                if (d6 < 0.0) {
                                    arrayList.add(null);
                                } else if (n21 < this.threshold) {
                                    arrayList.add(null);
                                    d4 += d6;
                                } else {
                                    this.drawBar(graphics2D, n18, n7 - n5, n21, this.barHeight, color, this.model.getValueHighlightColor(n9, n20));
                                    arrayList.add(new DrawObject(n18, n7 - n5, n18 + n21, n7 - n5 + this.barHeight));
                                }
                                n18 = !this.stacked ? (int)((double)n18 + (this.maxSubValues[n20] / d * (double)this.barLength + (double)this.barHorizSpacing)) : (n18 += n21);
                            }
                        }
                        ++n20;
                    }
                    if (this.normalized) {
                        n11 = this.barLength + n4 + this.horizSpacing - n18;
                    } else {
                        double d8 = d4 / d;
                        n11 = (int)(d8 * (double)this.barLength + d5);
                    }
                    this.drawBar(graphics2D, n18, n7 - n5, n11, this.barHeight, Color.black, null);
                    arrayList.add(new DrawObject(n18, n7 - n5, n18 + n11, n7 - n5 + this.barHeight));
                }
                n7 += n6;
            } else {
                d = this.maxOverallValue;
                this.leftJustified = false;
                int n23 = this.leftJustified ? n4 - n12 : n4;
                n10 = n7 + n6 / 2 - n2;
                this.searcher.drawHighlights(graphics2D, n23, n10, n9);
                graphics2D.setColor(Color.black);
                graphics2D.drawString(string, n23, n10);
                this.rowLabelDrawObjects.add(new DrawObject(n23, n10 - this.fontHeight, n23 + n12, n10));
                int n24 = n7;
                int n25 = 0;
                while (n25 < this.model.getSubSize()) {
                    double d9 = this.model.getValue(n9, n25);
                    if (d9 < 0.0) {
                        n24 += this.fontHeight;
                    } else {
                        int n26;
                        int n27;
                        String string3 = this.model.getValueLabel(n9, n25);
                        n11 = this.fontMetrics.stringWidth(string3);
                        double d10 = d9 / d;
                        int n28 = (int)(d10 * (double)this.barLength);
                        if (this.leftJustified) {
                            n27 = n4 + this.horizSpacing;
                            n26 = n4 + n28 + 2 * this.horizSpacing;
                        } else {
                            n27 = n4 - n28 - this.horizSpacing;
                            n26 = n4 - n28 - n11 - 2 * this.horizSpacing;
                        }
                        this.drawBar(graphics2D, n27, n24 - n5, n28, this.barHeight, this.model.getValueColor(n9, n25), this.model.getValueHighlightColor(n9, 0));
                        graphics2D.drawString(string3, n26, n24);
                        n24 += this.fontHeight;
                    }
                    ++n25;
                }
                n7 += n6;
            }
            ++n9;
        }
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        return null;
    }

    public void barChartChanged() {
        this.preferredSizeSet = false;
        this.maxValueLabelStringWidthSet = false;
        this.maxRowLabelStringWidthSet = false;
        this.dataProcessed = false;
        this.setSearchLines();
        this.repaint();
    }

    private void setSearchLines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.model.getNumRows()) {
            arrayList.add(this.model.getRowLabel(n));
            ++n;
        }
        this.searcher.setSearchLines(arrayList);
    }

    public int getBarLength() {
        return this.barLength;
    }

    public void setBarLength(int n) {
        this.barLength = n;
        this.preferredSizeSet = false;
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public boolean getNormalized() {
        return this.normalized;
    }

    public void setNormalized(boolean bl) {
        this.normalized = bl;
        this.preferredSizeSet = false;
    }

    public boolean getStacked() {
        return this.stacked;
    }

    public void setStacked(boolean bl) {
        this.stacked = bl;
        this.preferredSizeSet = false;
    }

    public boolean getSingleLine() {
        return this.singleLine;
    }

    public void setSingleLine(boolean bl) {
        this.singleLine = bl;
    }
}

