/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.FunctionBarChartWindow;
import edu.uoregon.tau.paraprof.GlobalDataWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.barchart.AbstractBarChartModel;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class GlobalBarChartModel
extends AbstractBarChartModel {
    private GlobalDataWindow window;
    private DataSorter dataSorter;
    private ParaProfTrial ppTrial;
    private List threads = new ArrayList();

    public GlobalBarChartModel(GlobalDataWindow globalDataWindow, DataSorter dataSorter, ParaProfTrial paraProfTrial) {
        this.window = globalDataWindow;
        this.dataSorter = dataSorter;
        this.ppTrial = paraProfTrial;
    }

    public int getNumRows() {
        return this.threads.size();
    }

    public int getSubSize() {
        if (this.threads != null && this.threads.size() >= 1) {
            return ((PPThread)this.threads.get(0)).getFunctionList().size();
        }
        return 0;
    }

    public String getRowLabel(int n) {
        PPThread pPThread = (PPThread)this.threads.get(n);
        return pPThread.getName();
    }

    public String getValueLabel(int n, int n2) {
        return "value";
    }

    public double getValue(int n, int n2) {
        PPThread pPThread = (PPThread)this.threads.get(n);
        if (n2 >= pPThread.getFunctionList().size()) {
            return -1.0;
        }
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)pPThread.getFunctionList().get(n2);
        if (pPFunctionProfile == null) {
            return -1.0;
        }
        return pPFunctionProfile.getValue();
    }

    public Color getValueColor(int n, int n2) {
        PPThread pPThread = (PPThread)this.threads.get(n);
        if (n2 >= pPThread.getFunctionList().size()) {
            return null;
        }
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)pPThread.getFunctionList().get(n2);
        if (pPFunctionProfile == null) {
            return null;
        }
        return pPFunctionProfile.getColor();
    }

    public Color getValueHighlightColor(int n, int n2) {
        PPThread pPThread = (PPThread)this.threads.get(n);
        if (n2 >= pPThread.getFunctionList().size()) {
            return null;
        }
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)pPThread.getFunctionList().get(n2);
        Function function = pPFunctionProfile.getFunction();
        if (function == this.ppTrial.getHighlightedFunction()) {
            return this.ppTrial.getColorChooser().getHighlightColor();
        }
        if (function.isGroupMember(this.ppTrial.getHighlightedGroup())) {
            return this.ppTrial.getColorChooser().getGroupHighlightColor();
        }
        return null;
    }

    public void fireValueClick(int n, int n2, MouseEvent mouseEvent, JComponent jComponent) {
        PPThread pPThread = (PPThread)this.threads.get(n);
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)pPThread.getFunctionList().get(n2);
        if (ParaProfUtils.rightClick(mouseEvent)) {
            JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(this.ppTrial, pPFunctionProfile.getFunction(), pPThread.getThread(), jComponent);
            jPopupMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.ppTrial.setHighlightedFunction(pPFunctionProfile.getFunction());
            FunctionBarChartWindow functionBarChartWindow = new FunctionBarChartWindow(this.ppTrial, pPFunctionProfile.getFunction(), jComponent);
            functionBarChartWindow.show();
        }
    }

    public void fireRowLabelClick(int n, MouseEvent mouseEvent, JComponent jComponent) {
        PPThread pPThread = (PPThread)this.threads.get(n);
        if (ParaProfUtils.rightClick(mouseEvent)) {
            ParaProfUtils.handleThreadClick(this.ppTrial, this.window.getPhase(), pPThread.getThread(), jComponent, mouseEvent);
        } else {
            FunctionBarChartWindow functionBarChartWindow = new FunctionBarChartWindow(this.ppTrial, pPThread.getThread(), this.window.getPhase(), jComponent);
            functionBarChartWindow.show();
        }
    }

    public String getValueToolTipText(int n, int n2) {
        PPThread pPThread = (PPThread)this.threads.get(n);
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)pPThread.getFunctionList().get(n2);
        if (this.ppTrial.getDataSource().getPhasesPresent()) {
            return UtilFncs.getRightSide((String)pPFunctionProfile.getFunctionName());
        }
        return pPFunctionProfile.getFunctionName();
    }

    public String getRowLabelToolTipText(int n) {
        PPThread pPThread = (PPThread)this.threads.get(n);
        if (ParaProf.helpWindow.isShowing()) {
            ParaProf.helpWindow.clearText();
            if (pPThread.getNodeID() == -1) {
                ParaProf.helpWindow.writeText("This line represents the mean statistics (over all threads).\n");
            } else if (pPThread.getNodeID() != -2) {
                if (pPThread.getNodeID() == -3) {
                    ParaProf.helpWindow.writeText("This line represents the standard deviation of each function (over threads).\n");
                } else {
                    ParaProf.helpWindow.writeText("n,c,t stands for: Node, Context and Thread.\n");
                }
            }
            ParaProf.helpWindow.writeText("Right click to display options for viewing the data.");
            ParaProf.helpWindow.writeText("Left click to go directly to the Thread Data Window");
        }
        return "Right click for options";
    }

    public void reloadData() {
        this.threads.clear();
        this.threads = this.dataSorter.getAllFunctionProfiles();
        if (this.threads.size() > 1 && !this.window.getStackBars()) {
            List list = ((PPThread)this.threads.get(0)).getFunctionList();
            int n = 0;
            while (n < this.threads.size()) {
                PPThread pPThread = (PPThread)this.threads.get(n);
                List list2 = pPThread.getFunctionList();
                int n2 = 0;
                int n3 = 0;
                while (n2 < list.size()) {
                    Function function = ((PPFunctionProfile)list.get(n2)).getFunction();
                    if (n3 >= list2.size()) {
                        list2.add(n3, null);
                    } else if (((PPFunctionProfile)list2.get(n3)).getFunction() != function) {
                        list2.add(n3, null);
                    }
                    ++n3;
                    ++n2;
                }
                ++n;
            }
        }
        this.fireModelChanged();
    }

    public String getOtherToolTopText(int n) {
        if (ParaProf.helpWindow.isShowing()) {
            ParaProf.helpWindow.clearText();
            ParaProf.helpWindow.writeText("Your mouse is over the misc. function section!\n");
            ParaProf.helpWindow.writeText("These are functions which have a non zero value, but whose screen representation is less than a pixel.\n");
            ParaProf.helpWindow.writeText("To view these function, right or left click to the left of this bar to bring up windows which will show more detailed information.");
        }
        return "Misc function section ... see help window for details";
    }
}

