/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl;

import java.awt.Component;
import java.lang.reflect.Field;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLCapabilitiesChooser;
import net.java.games.jogl.GLException;
import net.java.games.jogl.GLU;
import net.java.games.jogl.impl.Debug;
import net.java.games.jogl.impl.FunctionAvailabilityCache;
import net.java.games.jogl.impl.GLContextInitActionPair;
import net.java.games.jogl.impl.GLContextShareSet;
import net.java.games.jogl.impl.GLContextStack;
import net.java.games.jogl.impl.GLUImpl;
import net.java.games.jogl.impl.GLUProcAddressTable;
import net.java.games.jogl.impl.NativeLibLoader;
import net.java.games.jogl.impl.SingleThreadedWorkaround;

public abstract class GLContext {
    protected static final boolean DEBUG;
    protected Component component;
    protected boolean realized;
    protected GLCapabilities capabilities;
    protected GLCapabilitiesChooser chooser;
    protected GL gl;
    protected static final GLUProcAddressTable gluProcAddressTable;
    protected static boolean haveResetGLUProcAddressTable;
    protected GLU glu = new GLUImpl(gluProcAddressTable);
    protected Thread renderingThread;
    protected Runnable deferredReshapeAction;
    protected boolean deferredDestroy;
    protected boolean deferredSetRealized;
    protected static final ThreadLocal perThreadRenderingContext;
    protected volatile boolean willSetRenderingThread;
    protected boolean noAutoRedraw;
    protected boolean autoSwapBuffers = true;
    protected boolean pendingOffscreenResize;
    protected int pendingOffscreenWidth;
    protected int pendingOffscreenHeight;
    protected FunctionAvailabilityCache functionAvailability;
    protected static final ThreadLocal perThreadContextStack;
    protected static final ThreadLocal perThreadSavedCurrentContext;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GLContext(Component component, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) {
        this.component = component;
        this.capabilities = (GLCapabilities)gLCapabilities.clone();
        this.chooser = gLCapabilitiesChooser;
        this.setGL(this.createGL());
        this.functionAvailability = new FunctionAvailabilityCache(this);
        if (gLContext != null) {
            GLContextShareSet.registerSharing(this, gLContext);
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void invokeGL(Runnable runnable, boolean bl, Runnable runnable2) throws GLException {
        block61: {
            GLException gLException3222;
            boolean bl2;
            Throwable throwable;
            RuntimeException runtimeException;
            boolean bl3;
            Runnable runnable3;
            GLContext gLContext;
            Runnable runnable4;
            GLContext gLContext2;
            GLContextStack gLContextStack;
            block58: {
                Thread thread = Thread.currentThread();
                if (!this.isRealized() || this.willSetRenderingThread || this.renderingThread != null && this.renderingThread != thread) {
                    if (!this.isRealized() && this.deferredSetRealized) {
                        this.setRealized();
                        this.deferredSetRealized = false;
                    } else {
                        if (bl) {
                            this.deferredReshapeAction = runnable;
                        }
                        return;
                    }
                }
                if (bl && this.noAutoRedraw && !SingleThreadedWorkaround.doWorkaround()) {
                    this.deferredReshapeAction = runnable;
                    return;
                }
                if (this.deferredDestroy) {
                    this.deferredDestroy = false;
                    if (this.renderingThread != null) {
                        this.setRenderingThread(null, runnable2);
                    }
                    this.destroy();
                    return;
                }
                gLContextStack = GLContext.getPerThreadContextStack();
                gLContext2 = GLContext.getPerThreadSavedCurrentContext();
                runnable4 = GLContext.getPerThreadSavedInitAction();
                GLContext.setPerThreadSavedCurrentContext(null, null);
                if (gLContextStack.size() == 0 && gLContext2 != null) {
                    gLContextStack.push(gLContext2, runnable4);
                }
                gLContext = gLContextStack.peekContext();
                runnable3 = gLContextStack.peekInitAction();
                bl3 = true;
                if (gLContext == this) {
                    bl3 = false;
                }
                if (bl3) {
                    if (gLContext != null) {
                        if (DEBUG) {
                            System.err.println("Freeing context " + gLContext + " due to recursive makeCurrent");
                        }
                        gLContext.free();
                    }
                    if (!this.makeCurrent(runnable2)) {
                        if (bl) {
                            this.deferredReshapeAction = runnable;
                        }
                        if (gLContext != null) {
                            gLContext.makeCurrent(runnable3);
                        }
                        return;
                    }
                    if (DEBUG) {
                        System.err.println("Making context " + this + " current");
                    }
                }
                gLContextStack.push(this, runnable2);
                if (this.pendingOffscreenResize && this.renderingThread != null) {
                    gLContextStack.pop();
                    this.free();
                    if (!this.makeCurrent(runnable2)) {
                        throw new GLException("Error while resizing offscreen context");
                    }
                    gLContextStack.push(this, runnable2);
                }
                runtimeException = null;
                throwable = null;
                try {
                    block57: {
                        if (this.deferredReshapeAction != null) {
                            this.deferredReshapeAction.run();
                            this.deferredReshapeAction = null;
                        }
                        runnable.run();
                        if (!this.autoSwapBuffers || bl) break block57;
                        this.swapBuffers();
                    }
                    Object var15_13 = null;
                    if (runtimeException != null) {
                        this.renderingThread = null;
                    }
                    bl2 = false;
                    if (thread != this.renderingThread || gLContext != null) break block58;
                    bl2 = true;
                }
                catch (Throwable throwable2) {
                    GLException gLException22222;
                    Object var15_14 = null;
                    if (runtimeException != null) {
                        this.renderingThread = null;
                    }
                    boolean bl4 = false;
                    if (thread == this.renderingThread && gLContext == null) {
                        bl4 = true;
                        GLContext.setPerThreadSavedCurrentContext(this, runnable2);
                    }
                    gLContextStack.pop();
                    if (bl3 && !bl4) {
                        if (DEBUG) {
                            System.err.println("Freeing context " + this);
                        }
                        try {
                            this.free();
                        }
                        catch (GLException gLException22222) {
                            throwable = gLException22222;
                        }
                        if (gLContext != null) {
                            if (DEBUG) {
                                System.err.println("Making context " + gLContext + " current again");
                            }
                            try {
                                gLContext.makeCurrent(runnable3);
                            }
                            catch (GLException gLException22222) {
                                throwable = gLException22222;
                            }
                        }
                    }
                    if (gLContext2 != null) {
                        if (!$assertionsDisabled && gLContext2 != gLContext) {
                            throw new AssertionError();
                        }
                        gLContextStack.pop();
                        if (gLContext2.getRenderingThread() == null) {
                            try {
                                gLContext2.free();
                            }
                            catch (GLException gLException22222) {
                                throwable = gLException22222;
                            }
                        } else {
                            GLContext.setPerThreadSavedCurrentContext(gLContext2, runnable4);
                        }
                    }
                    if (throwable != null) {
                        if (runtimeException != null && throwable.getCause() == null) {
                            throwable.initCause(runtimeException);
                            throw throwable;
                        }
                        if (runtimeException == null) {
                            throw throwable;
                        }
                    }
                    throw throwable2;
                }
                GLContext.setPerThreadSavedCurrentContext(this, runnable2);
            }
            gLContextStack.pop();
            if (bl3 && !bl2) {
                if (DEBUG) {
                    System.err.println("Freeing context " + this);
                }
                try {
                    this.free();
                }
                catch (GLException gLException3222) {
                    throwable = gLException3222;
                }
                if (gLContext != null) {
                    if (DEBUG) {
                        System.err.println("Making context " + gLContext + " current again");
                    }
                    try {
                        gLContext.makeCurrent(runnable3);
                    }
                    catch (GLException gLException3222) {
                        throwable = gLException3222;
                    }
                }
            }
            if (gLContext2 != null) {
                if (!$assertionsDisabled && gLContext2 != gLContext) {
                    throw new AssertionError();
                }
                gLContextStack.pop();
                if (gLContext2.getRenderingThread() == null) {
                    try {
                        gLContext2.free();
                    }
                    catch (GLException gLException3222) {
                        throwable = gLException3222;
                    }
                } else {
                    GLContext.setPerThreadSavedCurrentContext(gLContext2, runnable4);
                }
            }
            if (throwable != null) {
                if (runtimeException != null && throwable.getCause() == null) {
                    throwable.initCause(runtimeException);
                    throw throwable;
                }
                if (runtimeException == null) {
                    throw throwable;
                }
            }
            break block61;
            {
                catch (RuntimeException runtimeException2) {
                    runtimeException = runtimeException2;
                    throw runtimeException;
                }
            }
        }
    }

    public GL getGL() {
        return this.gl;
    }

    public void setGL(GL gL) {
        this.gl = gL;
        ((GLUImpl)this.glu).setGL(gL);
    }

    public GLU getGLU() {
        return this.glu;
    }

    public void setGLU(GLU gLU) {
        this.glu = gLU;
    }

    public synchronized void willSetRenderingThread() {
        this.willSetRenderingThread = true;
    }

    public synchronized void setRenderingThread(Thread thread, Runnable runnable) {
        if (SingleThreadedWorkaround.doWorkaround()) {
            this.willSetRenderingThread = false;
            return;
        }
        Thread thread2 = Thread.currentThread();
        if (thread != null && thread != thread2) {
            throw new GLException("Argument must be either the current thread or null");
        }
        if (this.renderingThread != null && thread != null) {
            throw new GLException("Attempt to re-set or change rendering thread");
        }
        if (this.renderingThread == null && thread == null) {
            throw new GLException("Attempt to clear rendering thread when already cleared");
        }
        Object t = perThreadRenderingContext.get();
        if (thread != null && t != null && t != this) {
            throw new GLException("Attempt to call setRenderingThread on more than one drawable in this thread");
        }
        this.willSetRenderingThread = false;
        if (thread == null) {
            this.renderingThread = null;
            perThreadRenderingContext.set(null);
            this.invokeGL(new Runnable(){

                public void run() {
                }
            }, false, runnable);
        } else {
            this.renderingThread = thread;
            perThreadRenderingContext.set(this);
        }
    }

    public Thread getRenderingThread() {
        return this.renderingThread;
    }

    public void setNoAutoRedrawMode(boolean bl) {
        this.noAutoRedraw = bl;
    }

    public boolean getNoAutoRedrawMode() {
        return this.noAutoRedraw;
    }

    public void setAutoSwapBufferMode(boolean bl) {
        this.autoSwapBuffers = bl;
    }

    public boolean getAutoSwapBufferMode() {
        return this.autoSwapBuffers;
    }

    public abstract void swapBuffers() throws GLException;

    public void resizeOffscreenContext(int n, int n2) {
        if (!this.isOffscreen()) {
            throw new GLException("Should only call for offscreen OpenGL contexts");
        }
        this.pendingOffscreenResize = true;
        this.pendingOffscreenWidth = n;
        this.pendingOffscreenHeight = n2;
    }

    public int getFloatingPointMode() throws GLException {
        throw new GLException("Not supported on non-pbuffer contexts");
    }

    public abstract String getPlatformExtensionsString();

    protected void resetGLFunctionAvailability() {
        this.setGL(this.createGL());
        this.functionAvailability.flush();
        if (!haveResetGLUProcAddressTable) {
            if (DEBUG) {
                System.err.println("!!! Initializing GLU extension address table");
            }
            this.resetProcAddressTable(gluProcAddressTable);
            haveResetGLUProcAddressTable = true;
        }
        this.recomputeSingleThreadedWorkaround();
    }

    protected boolean isFunctionAvailable(String string) {
        return this.functionAvailability.isFunctionAvailable(this.mapToRealGLFunctionName(string));
    }

    public boolean isExtensionAvailable(String string) {
        return this.functionAvailability.isExtensionAvailable(this.mapToRealGLExtensionName(string));
    }

    public abstract boolean canCreatePbufferContext();

    public abstract GLContext createPbufferContext(GLCapabilities var1, int var2, int var3);

    public abstract void bindPbufferToTexture();

    public abstract void releasePbufferFromTexture();

    public void setSwapInterval(int n) {
    }

    protected abstract String mapToRealGLFunctionName(String var1);

    protected abstract String mapToRealGLExtensionName(String var1);

    protected abstract GL createGL();

    protected abstract boolean isOffscreen();

    public abstract int getOffscreenContextBufferedImageType();

    public abstract int getOffscreenContextReadBuffer();

    public abstract int getOffscreenContextWidth();

    public abstract int getOffscreenContextHeight();

    public abstract int getOffscreenContextPixelDataType();

    public abstract boolean offscreenImageNeedsVerticalFlip();

    protected abstract boolean makeCurrent(Runnable var1) throws GLException;

    protected abstract void free() throws GLException;

    public void setRealized() {
        if (this.getRenderingThread() != null && Thread.currentThread() != this.getRenderingThread()) {
            this.deferredSetRealized = true;
            return;
        }
        this.setRealized(true);
    }

    protected synchronized void setRealized(boolean bl) {
        this.realized = bl;
        if (DEBUG) {
            System.err.println("GLContext.setRealized(" + bl + ") for context " + this);
        }
    }

    public synchronized boolean getRealized() {
        return this.realized;
    }

    public synchronized void destroy() throws GLException {
        if (this.getRenderingThread() != null && Thread.currentThread() != this.getRenderingThread()) {
            this.deferredDestroy = true;
            return;
        }
        this.setRealized(false);
        GLContextShareSet.contextDestroyed(this);
        this.destroyImpl();
    }

    protected abstract void destroyImpl() throws GLException;

    public synchronized boolean isRealized() {
        return this.component == null || this.getRealized();
    }

    protected void resetProcAddressTable(Object object) {
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = fieldArray[i].getName();
            if (!string.startsWith("_addressof_")) continue;
            int n = "_addressof_".length();
            String string2 = string.substring(n);
            try {
                Field field = clazz.getDeclaredField(string);
                if (!$assertionsDisabled && field.getType() != Long.TYPE) {
                    throw new AssertionError();
                }
                long l = this.dynamicLookupFunction(string2);
                field.setLong(object, l);
                if (!DEBUG) continue;
            }
            catch (Exception exception) {
                throw new GLException("Cannot get GL proc address for method \"" + string2 + "\": Couldn't set value of field \"" + string + "\" in class " + clazz.getName(), exception);
            }
        }
    }

    protected abstract long dynamicLookupFunction(String var1);

    public abstract boolean isCreated();

    protected static GLContextStack getPerThreadContextStack() {
        return (GLContextStack)perThreadContextStack.get();
    }

    protected static GLContext getPerThreadSavedCurrentContext() {
        return ((GLContextInitActionPair)perThreadSavedCurrentContext.get()).getContext();
    }

    protected static Runnable getPerThreadSavedInitAction() {
        return ((GLContextInitActionPair)perThreadSavedCurrentContext.get()).getInitAction();
    }

    protected static void setPerThreadSavedCurrentContext(GLContext gLContext, Runnable runnable) {
        perThreadSavedCurrentContext.set(new GLContextInitActionPair(gLContext, runnable));
    }

    private void recomputeSingleThreadedWorkaround() {
        GL gL = this.getGL();
        String string = gL.glGetString(7936);
        if (string != null && string.indexOf("ATI") >= 0) {
            SingleThreadedWorkaround.shouldDoWorkaround();
            if (SingleThreadedWorkaround.doWorkaround()) {
                this.renderingThread = null;
            }
        }
    }

    static {
        $assertionsDisabled = !GLContext.class.desiredAssertionStatus();
        DEBUG = Debug.debug("GLContext");
        NativeLibLoader.load();
        gluProcAddressTable = new GLUProcAddressTable();
        perThreadRenderingContext = new ThreadLocal();
        perThreadContextStack = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new GLContextStack();
            }
        };
        perThreadSavedCurrentContext = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new GLContextInitActionPair(null, null);
            }
        };
    }
}

