/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.PreferencesWindow;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.barchart.BarChartPanel;
import edu.uoregon.tau.paraprof.barchart.GlobalBarChartModel;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.perfdmf.Function;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;

public class GlobalDataWindow
extends JFrame
implements ActionListener,
Observer,
ChangeListener,
ParaProfWindow {
    private ParaProfTrial ppTrial;
    private Function phase;
    private BarChartPanel panel;
    private GlobalBarChartModel model;
    private DataSorter dataSorter;
    private JMenu optionsMenu;
    private JCheckBoxMenuItem nameCheckBox;
    private JCheckBoxMenuItem normalizeCheckBox;
    private JCheckBoxMenuItem stackBarsCheckBox;
    private JCheckBoxMenuItem orderByMeanCheckBox;
    private JCheckBoxMenuItem orderCheckBox;
    private JCheckBoxMenuItem slidersCheckBox;
    private JCheckBoxMenuItem metaDataCheckBox;
    private JLabel barLengthLabel = new JLabel("Bar Width");
    private JSlider barLengthSlider = new JSlider(0, 2000, 600);
    private Container contentPane;
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    private boolean normalizeBars = true;
    private boolean stackBars = true;
    private boolean mShown = false;

    public GlobalDataWindow(ParaProfTrial paraProfTrial, Function function) {
        this.ppTrial = paraProfTrial;
        this.phase = function;
        paraProfTrial.addObserver(this);
        this.dataSorter = new DataSorter(paraProfTrial);
        this.dataSorter.setPhase(function);
        if (function == null) {
            this.setTitle("ParaProf: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else {
            this.setTitle("ParaProf: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()) + " Phase: " + function.getName());
        }
        int n = 750;
        int n2 = 410;
        this.setSize(ParaProfUtils.checkSize(new Dimension(n, n2)));
        this.setLocation(WindowPlacer.getGlobalDataWindowPosition(this));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GlobalDataWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.demoMode) {
            this.barLengthSlider.setValue(500);
        }
        this.contentPane = this.getContentPane();
        this.gbl = new GridBagLayout();
        this.contentPane.setLayout(this.gbl);
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(2, 2, 2, 2);
        this.model = new GlobalBarChartModel(this, this.dataSorter, paraProfTrial);
        this.panel = new BarChartPanel(this.model, null);
        this.setupMenus();
        this.panel.getBarChart().setLeftJustified(true);
        this.panel.getBarChart().setBarLength(this.barLengthSlider.getValue());
        JScrollBar jScrollBar = this.panel.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        this.setHeader();
        this.barLengthSlider.setPaintTicks(true);
        this.barLengthSlider.setMajorTickSpacing(400);
        this.barLengthSlider.setMinorTickSpacing(50);
        this.barLengthSlider.setPaintLabels(true);
        this.barLengthSlider.addChangeListener(this);
        this.gbc.fill = 1;
        this.gbc.anchor = 10;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.addCompItem(this.panel, this.gbc, 0, 0, 1, 1);
        this.sortLocalData();
        this.panel.repaint();
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        this.optionsMenu = new JMenu("Options");
        this.slidersCheckBox = new JCheckBoxMenuItem("Show Width Slider", false);
        this.slidersCheckBox.addActionListener(this);
        this.optionsMenu.add(this.slidersCheckBox);
        this.metaDataCheckBox = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
        this.metaDataCheckBox.addActionListener(this);
        this.optionsMenu.add(this.metaDataCheckBox);
        this.optionsMenu.add(new JSeparator());
        this.nameCheckBox = new JCheckBoxMenuItem("Sort By Name", false);
        this.nameCheckBox.addActionListener(this);
        this.optionsMenu.add(this.nameCheckBox);
        this.normalizeCheckBox = new JCheckBoxMenuItem("Normalize Bars", true);
        this.normalizeCheckBox.addActionListener(this);
        this.optionsMenu.add(this.normalizeCheckBox);
        this.orderByMeanCheckBox = new JCheckBoxMenuItem("Order By Mean", true);
        this.orderByMeanCheckBox.addActionListener(this);
        this.optionsMenu.add(this.orderByMeanCheckBox);
        this.orderCheckBox = new JCheckBoxMenuItem("Descending Order", true);
        this.orderCheckBox.addActionListener(this);
        this.optionsMenu.add(this.orderCheckBox);
        this.stackBarsCheckBox = new JCheckBoxMenuItem("Stack Bars Together", true);
        this.stackBarsCheckBox.addActionListener(this);
        this.optionsMenu.add(this.stackBarsCheckBox);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this.panel, this.panel));
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Sort By Name")) {
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Normalize Bars")) {
                    this.panel.getBarChart().setNormalized(this.normalizeCheckBox.isSelected());
                    this.panel.repaint();
                } else if (string.equals("Stack Bars Together")) {
                    if (this.stackBarsCheckBox.isSelected()) {
                        this.normalizeCheckBox.setEnabled(true);
                        this.orderByMeanCheckBox.setEnabled(true);
                        this.panel.getBarChart().setNormalized(this.normalizeCheckBox.isSelected());
                        this.panel.getBarChart().setStacked(true);
                        this.stackBars = true;
                    } else {
                        this.stackBars = false;
                        this.normalizeCheckBox.setSelected(false);
                        this.normalizeCheckBox.setEnabled(false);
                        this.normalizeBars = false;
                        this.orderByMeanCheckBox.setSelected(true);
                        this.orderByMeanCheckBox.setEnabled(false);
                        this.panel.getBarChart().setNormalized(this.normalizeCheckBox.isSelected());
                        this.panel.getBarChart().setStacked(false);
                    }
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Order By Mean")) {
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Descending Order")) {
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Show Width Slider")) {
                    if (this.slidersCheckBox.isSelected()) {
                        this.showWidthSlider(true);
                    } else {
                        this.showWidthSlider(false);
                    }
                } else if (string.equals("Show Meta Data in Panel")) {
                    this.setHeader();
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.panel.getBarChart().setBarLength(this.barLengthSlider.getValue());
            this.panel.repaint();
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            this.sortLocalData();
            this.setHeader();
            this.panel.repaint();
        }
    }

    public Dimension getViewportSize() {
        return this.panel.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.panel.getViewport().getViewRect();
    }

    public void setHeader() {
        if (this.metaDataCheckBox.isSelected()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            jTextArea.setMargin(new Insets(3, 3, 3, 3));
            PreferencesWindow preferencesWindow = this.ppTrial.getPreferencesWindow();
            jTextArea.setFont(ParaProf.preferencesWindow.getFont());
            jTextArea.append(this.getHeaderString());
            this.panel.setColumnHeaderView(jTextArea);
        } else {
            this.panel.setColumnHeaderView(null);
        }
    }

    public String getHeaderString() {
        if (this.phase != null) {
            return "Phase: " + this.phase + "\nMetric: " + this.ppTrial.getMetricName(this.ppTrial.getDefaultMetricID()) + "\nValue: " + "Exclusive" + "\n";
        }
        return "Metric: " + this.ppTrial.getMetricName(this.ppTrial.getDefaultMetricID()) + "\nValue: " + "Exclusive" + "\n";
    }

    private void showWidthSlider(boolean bl) {
        if (bl) {
            this.contentPane.remove(this.panel);
            this.gbc.insets = new Insets(5, 5, 5, 5);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, this.gbc, 0, 0, 1, 1);
            this.gbc.fill = 2;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.7;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, this.gbc, 1, 0, 1, 1);
            this.gbc.insets = new Insets(0, 0, 0, 0);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 0.99;
            this.addCompItem(this.panel, this.gbc, 0, 1, 2, 1);
        } else {
            this.contentPane.remove(this.barLengthLabel);
            this.contentPane.remove(this.barLengthSlider);
            this.contentPane.remove(this.panel);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 1.0;
            this.addCompItem(this.panel, this.gbc, 0, 0, 1, 1);
        }
        this.validate();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.contentPane.add(component, gridBagConstraints);
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    private void sortLocalData() {
        this.dataSorter.setSelectedMetricID(this.ppTrial.getDefaultMetricID());
        this.dataSorter.setValueType(ValueType.EXCLUSIVE);
        if (this.nameCheckBox.isSelected()) {
            this.dataSorter.setSortType(SortType.NAME);
        } else if (this.orderByMeanCheckBox.isSelected()) {
            this.dataSorter.setSortType(SortType.MEAN_VALUE);
        } else {
            this.dataSorter.setSortType(SortType.MEAN_VALUE);
        }
        this.dataSorter.setDescendingOrder(this.orderCheckBox.isSelected());
        this.model.reloadData();
    }

    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            this.setSize(dimension);
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        try {
            this.setVisible(false);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    public boolean getNormalizeBars() {
        return this.normalizeBars;
    }

    public boolean getStackBars() {
        return this.stackBars;
    }

    public void help(boolean bl) {
        ParaProf.helpWindow.show();
    }

    public Function getPhase() {
        return this.phase;
    }
}

