/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.EPSOutput;
import edu.uoregon.tau.paraprof.ParaProfImageFormatFileFilter;
import edu.uoregon.tau.paraprof.ParaProfImageOptionsPanel;
import edu.uoregon.tau.paraprof.interfaces.ImageExport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.Document;

public class JVMDependent {
    public static final String version = "1.4";

    public static void main(String[] stringArray) {
        System.out.println("I was compiled with Java 1.4");
    }

    public static void setClipboardContents(String string, ClipboardOwner clipboardOwner) {
        if (string == null || string == "") {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = toolkit.getSystemSelection();
        if (clipboard != null) {
            clipboard.setContents(stringSelection, clipboardOwner);
        }
        if ((clipboard = toolkit.getSystemClipboard()) != null) {
            clipboard.setContents(stringSelection, clipboardOwner);
        }
    }

    public static void exportVector(ImageExport imageExport) throws Exception {
        int n;
        Object object;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save Vector Graphics File");
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            jFileChooser.removeChoosableFileFilter(fileFilterArray[i]);
        }
        jFileChooser.addChoosableFileFilter(new ParaProfImageFormatFileFilter(ParaProfImageFormatFileFilter.EPS));
        jFileChooser.addChoosableFileFilter(new ParaProfImageFormatFileFilter(ParaProfImageFormatFileFilter.SVG));
        jFileChooser.setFileSelectionMode(0);
        ParaProfImageOptionsPanel paraProfImageOptionsPanel = new ParaProfImageOptionsPanel((Component)((Object)imageExport), true, true);
        jFileChooser.setAccessory(paraProfImageOptionsPanel);
        jFileChooser.addPropertyChangeListener(paraProfImageOptionsPanel);
        int n2 = jFileChooser.showSaveDialog((Component)((Object)imageExport));
        if (n2 != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        String string = file.getCanonicalPath();
        String string2 = ParaProfImageFormatFileFilter.getExtension(file);
        if (string2 == null) {
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (fileFilter instanceof ParaProfImageFormatFileFilter) {
                object = (ParaProfImageFormatFileFilter)fileFilter;
                string = string + "." + ((ParaProfImageFormatFileFilter)object).getExtension();
            }
            file = new File(string);
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog((Component)((Object)imageExport), file + " already exists\nOverwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
            return;
        }
        string2 = ParaProfImageFormatFileFilter.getExtension(file).toLowerCase();
        boolean bl = paraProfImageOptionsPanel.getTextAsShapes();
        if (string2.compareTo("svg") == 0) {
            object = GenericDOMImplementation.getDOMImplementation();
            Document document = object.createDocument(null, "svg", null);
            SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(SVGGeneratorContext.createDefault((Document)document), bl);
            imageExport.export((Graphics2D)sVGGraphics2D, false, paraProfImageOptionsPanel.isFullScreen(), paraProfImageOptionsPanel.isPrependHeader());
            boolean bl2 = true;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            sVGGraphics2D.stream((Writer)outputStreamWriter, bl2);
        } else if (string2.compareTo("eps") == 0) {
            object = imageExport.getImageSize(paraProfImageOptionsPanel.isFullScreen(), paraProfImageOptionsPanel.isPrependHeader());
            EPSOutput ePSOutput = new EPSOutput("ParaProf", file, ((Dimension)object).width, ((Dimension)object).height);
            imageExport.export((Graphics2D)ePSOutput, false, paraProfImageOptionsPanel.isFullScreen(), paraProfImageOptionsPanel.isPrependHeader());
            ePSOutput.finish();
            ePSOutput = new EPSOutput("ParaProf", file, ((Dimension)object).width, ((Dimension)object).height);
            ePSOutput.setDrawTextAsShapes(bl);
            imageExport.export((Graphics2D)ePSOutput, false, paraProfImageOptionsPanel.isFullScreen(), paraProfImageOptionsPanel.isPrependHeader());
            ePSOutput.finish();
        } else {
            JOptionPane.showMessageDialog((JComponent)((Object)imageExport), "Unknown format: '" + string2 + "'");
        }
    }
}

