/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.ThreeDeeControlPanel;
import edu.uoregon.tau.paraprof.ThreeDeeSettings;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.enums.VisType;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.UnitListener;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import edu.uoregon.tau.vis.Axes;
import edu.uoregon.tau.vis.BarPlot;
import edu.uoregon.tau.vis.ColorScale;
import edu.uoregon.tau.vis.ExceptionHandler;
import edu.uoregon.tau.vis.Plot;
import edu.uoregon.tau.vis.ScatterPlot;
import edu.uoregon.tau.vis.Shape;
import edu.uoregon.tau.vis.TriangleMeshPlot;
import edu.uoregon.tau.vis.Vec;
import edu.uoregon.tau.vis.VisCanvas;
import edu.uoregon.tau.vis.VisRenderer;
import edu.uoregon.tau.vis.VisTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.Timer;

public class ThreeDeeWindow
extends JFrame
implements ActionListener,
KeyListener,
Observer,
Printable,
ParaProfWindow,
UnitListener {
    private final int defaultToScatter = 4000;
    private VisCanvas visCanvas;
    private VisRenderer visRenderer = new VisRenderer();
    private Plot plot;
    private Axes axes;
    private ColorScale colorScale = new ColorScale();
    private ParaProfTrial ppTrial;
    private JMenu optionsMenu = null;
    private DataSorter dataSorter;
    private ThreeDeeControlPanel controlPanel;
    private ThreeDeeSettings settings = new ThreeDeeSettings();
    private ThreeDeeSettings oldSettings;
    private Timer fpsTimer;
    private JSplitPane jSplitPane;
    private TriangleMeshPlot triangleMeshPlot;
    private BarPlot barPlot;
    private ScatterPlot scatterPlot;
    private Axes fullDataPlotAxes;
    private Axes scatterPlotAxes;
    private List functionNames;
    private List threadNames;
    private List functions;
    private List threads;
    private List selectedFunctions = new ArrayList();
    private int units = ParaProf.preferences.getUnits();
    float maxHeightValue = 0.0f;
    float maxColorValue = 0.0f;
    float[] minScatterValues;
    float[] maxScatterValues;
    private long lastCall = 0L;

    public ThreeDeeWindow(ParaProfTrial paraProfTrial, Component component) {
        Object object;
        VisTools.setSwingExceptionHandler((ExceptionHandler)new ExceptionHandler(){

            public void handleException(Exception exception) {
                ParaProfUtils.handleException(exception);
            }
        });
        this.ppTrial = paraProfTrial;
        this.dataSorter = new DataSorter(paraProfTrial);
        this.dataSorter.setSortType(SortType.NAME);
        this.setTitle("ParaProf Visualizer: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ThreeDeeWindow.this.thisWindowClosing(windowEvent);
            }
        });
        this.setupMenus();
        this.validate();
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        if (string.startsWith("linux") && string2.equals("ia64")) {
            this.show();
        }
        DataSource dataSource = paraProfTrial.getDataSource();
        int n = dataSource.getNumThreads();
        DataSorter dataSorter = new DataSorter(paraProfTrial);
        dataSorter.setDescendingOrder(true);
        List list = dataSorter.getFunctionProfiles(dataSource.getStdDevData());
        Object object2 = list.iterator();
        for (int i = 0; object2.hasNext() && i < 4; ++i) {
            object = (PPFunctionProfile)object2.next();
            this.settings.setScatterFunction(((PPFunctionProfile)object).getFunction(), i);
        }
        if (n > 4000) {
            this.settings.setVisType(VisType.SCATTER_PLOT);
        }
        this.generate3dModel(true, this.settings);
        this.oldSettings = (ThreeDeeSettings)this.settings.clone();
        this.visRenderer.addShape((Shape)this.plot);
        this.visRenderer.addShape((Shape)this.colorScale);
        this.visCanvas = new VisCanvas(this.visRenderer);
        this.visCanvas.addKeyListener((KeyListener)this);
        object2 = new JPanel(){

            public Dimension getMinimumSize() {
                return new Dimension(10, 10);
            }
        };
        ((Component)object2).addKeyListener(this);
        ((Container)object2).setLayout(new GridBagLayout());
        object = new GridBagConstraints();
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((Container)object2).add((Component)this.visCanvas.getActualCanvas(), object);
        ((JComponent)object2).setPreferredSize(new Dimension(5, 5));
        this.controlPanel = new ThreeDeeControlPanel(this, this.settings, paraProfTrial, this.visRenderer);
        this.jSplitPane = new JSplitPane(1, (Component)object2, this.controlPanel);
        this.jSplitPane.setContinuousLayout(true);
        this.jSplitPane.setResizeWeight(1.0);
        this.jSplitPane.setOneTouchExpandable(true);
        this.jSplitPane.addKeyListener(this);
        this.getContentPane().add(this.jSplitPane);
        this.setSize(ParaProfUtils.checkSize(new Dimension(1000, 700)));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        if (string.startsWith("linux") && string2.equals("ia64")) {
            this.validate();
        }
        this.show();
        if (System.getProperty("vis.fps") != null) {
            this.fpsTimer = new Timer(1000, this);
            this.fpsTimer.start();
        }
        ParaProf.incrementNumWindows();
        paraProfTrial.addObserver(this);
    }

    private void generateScatterPlot(boolean bl, ThreeDeeSettings threeDeeSettings) {
        Function[] functionArray = threeDeeSettings.getScatterFunctions();
        ValueType[] valueTypeArray = threeDeeSettings.getScatterValueTypes();
        int[] nArray = threeDeeSettings.getScatterMetricIDs();
        DataSource dataSource = this.ppTrial.getDataSource();
        int n = dataSource.getNumThreads();
        float[][] fArray = new float[n][4];
        int n2 = 0;
        this.minScatterValues = new float[4];
        this.maxScatterValues = new float[4];
        for (int i = 0; i < 4; ++i) {
            this.minScatterValues[i] = Float.MAX_VALUE;
        }
        Iterator iterator = this.ppTrial.getDataSource().getAllThreads().iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            for (int i = 0; i < functionArray.length; ++i) {
                FunctionProfile functionProfile;
                if (functionArray[i] == null || (functionProfile = thread.getFunctionProfile(functionArray[i])) == null) continue;
                fArray[n2][i] = (float)valueTypeArray[i].getValue(functionProfile, nArray[i]);
                this.maxScatterValues[i] = Math.max(this.maxScatterValues[i], fArray[n2][i]);
                this.minScatterValues[i] = Math.min(this.minScatterValues[i], fArray[n2][i]);
            }
            ++n2;
        }
        if (this.scatterPlotAxes == null) {
            this.scatterPlotAxes = new Axes();
        }
        this.setAxisStrings();
        this.axes = this.scatterPlotAxes;
        if (this.scatterPlot == null) {
            this.scatterPlot = new ScatterPlot();
            if (n > 4000) {
                this.scatterPlot.setSphereSize(0.0f);
            }
        }
        this.scatterPlot.setSize(15.0f, 15.0f, 15.0f);
        this.scatterPlot.setAxes(this.axes);
        this.scatterPlot.setValues(fArray);
        this.scatterPlot.setColorScale(this.colorScale);
        this.plot = this.scatterPlot;
    }

    private void generate3dModel(boolean bl, ThreeDeeSettings threeDeeSettings) {
        int n;
        if (this.plot != null) {
            this.plot.cleanUp();
        }
        if (threeDeeSettings.getVisType() == VisType.SCATTER_PLOT) {
            this.generateScatterPlot(bl, threeDeeSettings);
            return;
        }
        if (this.triangleMeshPlot == null && this.barPlot == null) {
            bl = true;
        }
        DataSource dataSource = this.ppTrial.getDataSource();
        int n2 = dataSource.getNumThreads();
        int n3 = 0;
        List list = this.dataSorter.getFunctionProfiles(this.ppTrial.getDataSource().getMeanData());
        n3 = list.size();
        float[][] fArray = new float[n3][n2];
        float[][] fArray2 = new float[n3][n2];
        boolean bl2 = false;
        if (this.functionNames == null) {
            this.functionNames = new ArrayList();
            this.functions = new ArrayList();
            bl2 = true;
        }
        if (this.threadNames == null) {
            this.threadNames = new ArrayList();
            this.threads = new ArrayList();
            Iterator iterator = this.ppTrial.getDataSource().getAllThreads().iterator();
            while (iterator.hasNext()) {
                Thread thread = (Thread)iterator.next();
                this.threadNames.add(thread.getNodeID() + ":" + thread.getContextID() + ":" + thread.getThreadID());
                this.threads.add(thread);
            }
        }
        this.maxHeightValue = 0.0f;
        this.maxColorValue = 0.0f;
        int n4 = 0;
        for (n = 0; n < list.size(); ++n) {
            PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)list.get(n);
            Function function = pPFunctionProfile.getFunction();
            if (bl2) {
                this.functionNames.add(ParaProfUtils.getFunctionName(function));
                this.functions.add(function);
            }
            int n5 = 0;
            Iterator iterator = this.ppTrial.getDataSource().getAllThreads().iterator();
            while (iterator.hasNext()) {
                Thread thread = (Thread)iterator.next();
                FunctionProfile functionProfile = thread.getFunctionProfile(function);
                if (functionProfile != null) {
                    fArray[n4][n5] = (float)threeDeeSettings.getHeightValue().getValue(functionProfile, threeDeeSettings.getHeightMetricID());
                    fArray2[n4][n5] = (float)threeDeeSettings.getColorValue().getValue(functionProfile, threeDeeSettings.getColorMetricID());
                    this.maxHeightValue = Math.max(this.maxHeightValue, fArray[n4][n5]);
                    this.maxColorValue = Math.max(this.maxColorValue, fArray2[n4][n5]);
                }
                ++n5;
            }
            ++n4;
        }
        if (bl) {
            n = 20;
            int n6 = 20;
            int n7 = 20;
            float f = (float)this.threadNames.size() / (float)this.functionNames.size();
            if (f > 2.0f) {
                f = 2.0f;
            }
            if (f < 0.5f) {
                f = 0.5f;
            }
            if (f > 1.0f) {
                n6 = (int)(30.0f * (1.0f / f));
                n = 30;
            } else if (f < 1.0f) {
                n6 = 30;
                n = (int)(30.0f * f);
            } else {
                n = 30;
                n6 = 30;
            }
            n7 = 6;
            threeDeeSettings.setSize(n, n6, n7);
            this.visRenderer.setAim(new Vec(threeDeeSettings.getPlotWidth() / 2.0f, threeDeeSettings.getPlotDepth() / 2.0f, 0.0f));
            threeDeeSettings.setRegularAim(this.visRenderer.getAim());
        }
        if (this.fullDataPlotAxes == null) {
            this.fullDataPlotAxes = new Axes();
            this.fullDataPlotAxes.setHighlightColor(this.ppTrial.getColorChooser().getHighlightColor());
        }
        this.setAxisStrings();
        this.axes = this.fullDataPlotAxes;
        if (threeDeeSettings.getVisType() == VisType.TRIANGLE_MESH_PLOT) {
            this.axes.setOnEdge(false);
            if (this.triangleMeshPlot == null) {
                this.triangleMeshPlot = new TriangleMeshPlot();
                this.triangleMeshPlot.initialize(this.axes, threeDeeSettings.getPlotWidth(), threeDeeSettings.getPlotDepth(), threeDeeSettings.getPlotHeight(), fArray, fArray2, this.colorScale);
                this.plot = this.triangleMeshPlot;
            } else {
                this.triangleMeshPlot.setValues(threeDeeSettings.getPlotWidth(), threeDeeSettings.getPlotDepth(), threeDeeSettings.getPlotHeight(), fArray, fArray2);
                this.plot = this.triangleMeshPlot;
            }
        } else {
            this.axes.setOnEdge(true);
            if (this.barPlot == null) {
                this.barPlot = new BarPlot();
                this.barPlot.initialize(this.axes, threeDeeSettings.getPlotWidth(), threeDeeSettings.getPlotDepth(), threeDeeSettings.getPlotHeight(), fArray, fArray2, this.colorScale);
                this.plot = this.barPlot;
            } else {
                this.barPlot.setValues(threeDeeSettings.getPlotWidth(), threeDeeSettings.getPlotDepth(), threeDeeSettings.getPlotHeight(), fArray, fArray2);
                this.plot = this.barPlot;
            }
        }
    }

    private void updateSettings(ThreeDeeSettings threeDeeSettings) {
        if (this.oldSettings.getAxisOrientation() != threeDeeSettings.getAxisOrientation()) {
            this.axes.setOrientation(threeDeeSettings.getAxisOrientation());
        }
        if (this.oldSettings.getVisType() != threeDeeSettings.getVisType()) {
            this.visRenderer.removeShape((Shape)this.plot);
            this.visRenderer.removeShape((Shape)this.colorScale);
            this.generate3dModel(false, threeDeeSettings);
            this.visRenderer.addShape((Shape)this.plot);
            this.visRenderer.addShape((Shape)this.colorScale);
            this.plot.setSelectedCol(threeDeeSettings.getSelections()[1]);
            this.plot.setSelectedRow(threeDeeSettings.getSelections()[0]);
            if (threeDeeSettings.getVisType() == VisType.SCATTER_PLOT) {
                this.visRenderer.setAim(this.settings.getScatterAim());
            } else if (threeDeeSettings.getVisType() == VisType.TRIANGLE_MESH_PLOT || threeDeeSettings.getVisType() == VisType.BAR_PLOT) {
                this.visRenderer.setAim(this.settings.getRegularAim());
            }
        } else if (threeDeeSettings.getVisType() == VisType.SCATTER_PLOT) {
            this.visRenderer.removeShape((Shape)this.plot);
            this.visRenderer.removeShape((Shape)this.colorScale);
            this.generate3dModel(false, threeDeeSettings);
            this.visRenderer.addShape((Shape)this.plot);
            this.visRenderer.addShape((Shape)this.colorScale);
        } else if (threeDeeSettings.getVisType() == VisType.TRIANGLE_MESH_PLOT || threeDeeSettings.getVisType() == VisType.BAR_PLOT) {
            this.settings.setSize((int)this.plot.getWidth(), (int)this.plot.getDepth(), (int)this.plot.getHeight());
            if (this.oldSettings.getHeightMetricID() != threeDeeSettings.getHeightMetricID() || this.oldSettings.getHeightValue() != threeDeeSettings.getHeightValue() || this.oldSettings.getColorValue() != threeDeeSettings.getColorValue() || this.oldSettings.getColorMetricID() != threeDeeSettings.getColorMetricID()) {
                this.generate3dModel(false, threeDeeSettings);
            } else {
                this.plot.setSelectedCol(threeDeeSettings.getSelections()[1]);
                this.plot.setSelectedRow(threeDeeSettings.getSelections()[0]);
            }
        }
        this.oldSettings = (ThreeDeeSettings)threeDeeSettings.clone();
    }

    public void redraw() {
        this.jSplitPane.revalidate();
        this.jSplitPane.validate();
        this.jSplitPane.resetToPreferredSizes();
        this.updateSettings(this.settings);
        this.visRenderer.redraw();
    }

    private void helperAddRadioMenuItem(String string, String string2, boolean bl, ButtonGroup buttonGroup, JMenu jMenu) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string, bl);
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setActionCommand(string2);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        Object var2_2 = null;
        Object var3_3 = null;
        this.optionsMenu = new JMenu("Options");
        this.optionsMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        JMenu jMenu = ParaProfUtils.createUnitsMenu(this, this.units, true);
        jMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.optionsMenu.add(jMenu);
        JMenu jMenu2 = ParaProfUtils.createFileMenu(this, this, this);
        JMenu jMenu3 = ParaProfUtils.createWindowsMenu(this.ppTrial, this);
        JMenu jMenu4 = ParaProfUtils.createHelpMenu(this, this);
        jMenu2.getPopupMenu().setLightWeightPopupEnabled(false);
        jMenu3.getPopupMenu().setLightWeightPopupEnabled(false);
        jMenu4.getPopupMenu().setLightWeightPopupEnabled(false);
        jMenuBar.add(jMenu2);
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        this.setJMenuBar(jMenuBar);
    }

    public int getUnits() {
        return this.units;
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        } else if (!string.equals("prefEvent")) {
            if (string.equals("colorEvent")) {
                if (this.fullDataPlotAxes != null) {
                    this.fullDataPlotAxes.setHighlightColor(this.ppTrial.getColorChooser().getHighlightColor());
                    this.visRenderer.redraw();
                }
            } else if (string.equals("dataEvent")) {
                this.sortLocalData();
            }
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        this.setVisible(false);
        this.ppTrial.deleteObserver(this);
        ParaProf.decrementNumWindows();
        if (this.plot != null) {
            this.plot.cleanUp();
        }
        if (this.visRenderer != null) {
            this.visRenderer.cleanUp();
        }
        this.visRenderer = null;
        this.plot = null;
        this.dispose();
    }

    private void sortLocalData() {
        this.functionNames = null;
        if (this.settings.getVisType() == VisType.BAR_PLOT || this.settings.getVisType() == VisType.TRIANGLE_MESH_PLOT) {
            this.settings.setSize((int)this.plot.getWidth(), (int)this.plot.getDepth(), (int)this.plot.getHeight());
            this.settings.setRegularAim(this.visRenderer.getAim());
            this.settings.setRegularEye(this.visRenderer.getEye());
        } else if (this.settings.getVisType() == VisType.SCATTER_PLOT) {
            this.settings.setScatterAim(this.visRenderer.getAim());
            this.settings.setScatterEye(this.visRenderer.getEye());
        }
        this.generate3dModel(false, this.settings);
        this.visRenderer.redraw();
        this.controlPanel.dataChanged();
    }

    public void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        ParaProf.helpWindow.writeText("This is the 3D Window");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("This window displays profile data in three dimensions through the Triangle Mesh Plot, the Bar Plot, and the ScatterPlot");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Change between the plots by selecting the desired type from the radio buttons in the upper right.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Experiment with the controls at the right.");
        ParaProf.helpWindow.writeText("");
    }

    public BufferedImage getImage() {
        return this.visRenderer.createScreenShot();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.visCanvas.getWidth(), this.visCanvas.getHeight());
            BufferedImage bufferedImage = this.visRenderer.createScreenShot();
            ImageObserver imageObserver = new ImageObserver(){

                public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                    return false;
                }
            };
            graphics.drawImage(bufferedImage, 0, 0, Color.black, imageObserver);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof Timer) {
                if (this.visRenderer == null) {
                    ((Timer)object).stop();
                    return;
                }
                long l = System.currentTimeMillis();
                int n = this.visRenderer.getFramesRendered();
                if (n != 0) {
                    this.visRenderer.setFramesRendered(0);
                    float f = (float)n / ((float)(l - this.lastCall) / 1000.0f);
                    this.visRenderer.setFps(f);
                    System.out.println("FPS = " + f);
                    this.lastCall = l;
                }
                return;
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public ColorScale getColorScale() {
        return this.colorScale;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) {
        this.plot = plot;
    }

    public List getFunctionNames() {
        return this.functionNames;
    }

    public List getThreadNames() {
        return this.threadNames;
    }

    public String getFunctionName(int n) {
        if (this.functionNames == null) {
            return null;
        }
        return (String)this.functionNames.get(n);
    }

    public String getThreadName(int n) {
        if (this.threadNames == null) {
            return null;
        }
        return (String)this.threadNames.get(n);
    }

    public String getSelectedHeightValue() {
        Function function;
        if (this.threads == null || this.functionNames == null) {
            return "";
        }
        if (this.settings.getSelections()[1] < 0 || this.settings.getSelections()[0] < 0) {
            return "";
        }
        Thread thread = (Thread)this.threads.get(this.settings.getSelections()[1]);
        FunctionProfile functionProfile = thread.getFunctionProfile(function = this.ppTrial.getDataSource().getFunction((String)this.functionNames.get(this.settings.getSelections()[0])));
        if (functionProfile == null) {
            return "no value";
        }
        int n = this.units;
        ParaProfMetric paraProfMetric = this.ppTrial.getMetric(this.settings.getHeightMetricID());
        if (!paraProfMetric.isTimeMetric() || !ValueType.isTimeUnits(this.settings.getHeightValue())) {
            n = 0;
        }
        return UtilFncs.getOutputString((int)n, (double)this.settings.getHeightValue().getValue(functionProfile, this.settings.getHeightMetricID()), (int)6).trim() + this.getUnitsString(n, this.settings.getHeightValue(), paraProfMetric);
    }

    public String getSelectedColorValue() {
        Function function;
        if (this.threads == null || this.functionNames == null) {
            return "";
        }
        if (this.settings.getSelections()[1] < 0 || this.settings.getSelections()[0] < 0) {
            return "";
        }
        Thread thread = (Thread)this.threads.get(this.settings.getSelections()[1]);
        FunctionProfile functionProfile = thread.getFunctionProfile(function = this.ppTrial.getDataSource().getFunction((String)this.functionNames.get(this.settings.getSelections()[0])));
        if (functionProfile == null) {
            return "no value";
        }
        int n = this.units;
        ParaProfMetric paraProfMetric = this.ppTrial.getMetric(this.settings.getColorMetricID());
        if (!paraProfMetric.isTimeMetric() || !ValueType.isTimeUnits(this.settings.getColorValue())) {
            n = 0;
        }
        return UtilFncs.getOutputString((int)n, (double)this.settings.getColorValue().getValue(functionProfile, this.settings.getColorMetricID()), (int)6).trim() + this.getUnitsString(n, this.settings.getColorValue(), paraProfMetric);
    }

    private String getUnitsString(int n, ValueType valueType, ParaProfMetric paraProfMetric) {
        return valueType.getSuffix(n, paraProfMetric);
    }

    private void setAxisStrings() {
        if (this.settings.getVisType() == VisType.SCATTER_PLOT) {
            Function[] functionArray = this.settings.getScatterFunctions();
            ValueType[] valueTypeArray = this.settings.getScatterValueTypes();
            int[] nArray = this.settings.getScatterMetricIDs();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < functionArray.length; ++i) {
                if (functionArray[i] != null) {
                    if (valueTypeArray[i] == ValueType.NUMCALLS || valueTypeArray[i] == ValueType.NUMSUBR) {
                        arrayList.add(ParaProfUtils.getFunctionName(functionArray[i]) + "\n(" + valueTypeArray[i].toString() + ")");
                        continue;
                    }
                    arrayList.add(ParaProfUtils.getFunctionName(functionArray[i]) + "\n(" + valueTypeArray[i].toString() + ", " + this.ppTrial.getMetricName(nArray[i]) + ")");
                    continue;
                }
                arrayList.add("none");
            }
            ArrayList[] arrayListArray = new ArrayList[4];
            for (int i = 0; i < 4; ++i) {
                if (this.minScatterValues[i] == Float.MAX_VALUE) {
                    this.minScatterValues[i] = 0.0f;
                }
                ParaProfMetric paraProfMetric = this.ppTrial.getMetric(nArray[i]);
                int n = valueTypeArray[i].getUnits(this.units, paraProfMetric);
                arrayListArray[i] = new ArrayList();
                arrayListArray[i].add(UtilFncs.getOutputString((int)n, (double)this.minScatterValues[i], (int)6).trim());
                arrayListArray[i].add(UtilFncs.getOutputString((int)n, (double)((double)this.minScatterValues[i] + (double)(this.maxScatterValues[i] - this.minScatterValues[i]) * 0.25), (int)6).trim());
                arrayListArray[i].add(UtilFncs.getOutputString((int)n, (double)((double)this.minScatterValues[i] + (double)(this.maxScatterValues[i] - this.minScatterValues[i]) * 0.5), (int)6).trim());
                arrayListArray[i].add(UtilFncs.getOutputString((int)n, (double)((double)this.minScatterValues[i] + (double)(this.maxScatterValues[i] - this.minScatterValues[i]) * 0.75), (int)6).trim());
                arrayListArray[i].add(UtilFncs.getOutputString((int)n, (double)(this.minScatterValues[i] + (this.maxScatterValues[i] - this.minScatterValues[i])), (int)6).trim());
            }
            ParaProfMetric paraProfMetric = this.ppTrial.getMetric(nArray[3]);
            int n = valueTypeArray[3].getUnits(this.units, paraProfMetric);
            this.colorScale.setStrings(UtilFncs.getOutputString((int)n, (double)this.minScatterValues[3], (int)6).trim(), UtilFncs.getOutputString((int)n, (double)this.maxScatterValues[3], (int)6).trim(), (String)arrayList.get(3));
            this.scatterPlotAxes.setStrings((String)arrayList.get(0), (String)arrayList.get(1), (String)arrayList.get(2), (List)arrayListArray[0], (List)arrayListArray[1], (List)arrayListArray[2]);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("0");
            ParaProfMetric paraProfMetric = this.ppTrial.getMetric(this.settings.getHeightMetricID());
            int n = this.settings.getHeightValue().getUnits(this.units, paraProfMetric);
            arrayList.add(UtilFncs.getOutputString((int)n, (double)((double)this.maxHeightValue * 0.25), (int)6).trim());
            arrayList.add(UtilFncs.getOutputString((int)n, (double)((double)this.maxHeightValue * 0.5), (int)6).trim());
            arrayList.add(UtilFncs.getOutputString((int)n, (double)((double)this.maxHeightValue * 0.75), (int)6).trim());
            arrayList.add(UtilFncs.getOutputString((int)n, (double)this.maxHeightValue, (int)6).trim());
            String string = this.settings.getHeightValue().getSuffix(n, paraProfMetric);
            paraProfMetric = this.ppTrial.getMetric(this.settings.getColorMetricID());
            n = this.settings.getColorValue().getUnits(this.units, paraProfMetric);
            String string2 = this.settings.getColorValue().getSuffix(n, paraProfMetric);
            this.colorScale.setStrings("0", UtilFncs.getOutputString((int)n, (double)this.maxColorValue, (int)6).trim(), string2);
            this.fullDataPlotAxes.setStrings("Threads", "Functions", string, this.threadNames, this.functionNames, arrayList);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        try {
            if (keyEvent.getKeyChar() == '+') {
                this.visRenderer.zoomIn();
            } else if (keyEvent.getKeyChar() == '-') {
                this.visRenderer.zoomOut();
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void setUnits(int n) {
        this.units = n;
        this.setAxisStrings();
        this.controlPanel.dataChanged();
        this.visRenderer.redraw();
    }
}

