/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Searcher;
import edu.uoregon.tau.paraprof.barchart.BarChartModel;
import edu.uoregon.tau.paraprof.barchart.BarChartModelListener;
import edu.uoregon.tau.paraprof.barchart.BarChartPanel;
import edu.uoregon.tau.paraprof.barchart.DrawObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public class BarChart
extends JPanel
implements MouseListener,
BarChartModelListener {
    private BarChartModel model;
    private int maxRowLabelStringWidth;
    private boolean maxRowLabelStringWidthSet;
    private int maxValueLabelStringWidth;
    private boolean maxValueLabelStringWidthSet;
    private boolean preferredSizeSet;
    private boolean dataProcessed;
    double[] maxRowValues;
    double[] maxSubValues;
    double maxRowSum;
    double maxOverallValue;
    double[] rowSums;
    private FontMetrics fontMetrics;
    private boolean leftJustified;
    private int barLength = 400;
    private int leftMargin = 8;
    private int rightMargin = 5;
    private int horizSpacing = 10;
    private int barVerticalSpacing = 4;
    private int barHeight;
    private int topMargin = 0;
    private int rowStart;
    private ArrayList rowLabelDrawObjects = new ArrayList();
    private ArrayList valueDrawObjects = new ArrayList();
    private BarChartPanel panel;
    private Searcher searcher;
    private int barHorizSpacing = 5;
    private int threshold = 2;
    private boolean stacked = true;
    private boolean normalized = true;
    private boolean singleLine = true;
    private int fontHeight;

    public BarChart(BarChartModel barChartModel, BarChartPanel barChartPanel) {
        this.model = barChartModel;
        this.panel = barChartPanel;
        barChartModel.addBarChartModelListener(this);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.searcher = new Searcher(this, barChartPanel);
        this.searcher.setTopMargin(this.topMargin);
        this.addMouseListener(this.searcher);
        this.addMouseMotionListener(this.searcher);
        this.setAutoscrolls(true);
        this.barChartChanged();
        this.setToolTipText("...");
    }

    public boolean getLeftJustified() {
        return this.leftJustified;
    }

    public void setLeftJustified(boolean bl) {
        this.leftJustified = bl;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Object object;
        int n;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        int n4 = this.rowLabelDrawObjects.size();
        for (n = 0; n < n4; ++n) {
            object = (DrawObject)this.rowLabelDrawObjects.get(n);
            if (n2 < ((DrawObject)object).getXBeg() || n2 > ((DrawObject)object).getXEnd() || n3 < ((DrawObject)object).getYBeg() || n3 > ((DrawObject)object).getYEnd()) continue;
            return this.model.getRowLabelToolTipText(n + this.rowStart);
        }
        n4 = this.valueDrawObjects.size();
        for (n = 0; n < n4; ++n) {
            object = (ArrayList)this.valueDrawObjects.get(n);
            int n5 = ((ArrayList)object).size();
            for (int i = 0; i < n5; ++i) {
                DrawObject drawObject = (DrawObject)((ArrayList)object).get(i);
                if (drawObject == null || n2 < drawObject.getXBeg() || n2 > drawObject.getXEnd() || n3 < drawObject.getYBeg() || n3 > drawObject.getYEnd()) continue;
                if (i == n5 - 1) {
                    return this.model.getOtherToolTopText(n + this.rowStart);
                }
                return this.model.getValueToolTipText(n + this.rowStart, i);
            }
        }
        return null;
    }

    protected void paintComponent(Graphics graphics) {
        try {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(Color.white);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.export((Graphics2D)graphics, true, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        int n;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        int n4 = this.rowLabelDrawObjects.size();
        for (n = 0; n < n4; ++n) {
            object = (DrawObject)this.rowLabelDrawObjects.get(n);
            if (n2 < ((DrawObject)object).getXBeg() || n2 > ((DrawObject)object).getXEnd() || n3 < ((DrawObject)object).getYBeg() || n3 > ((DrawObject)object).getYEnd()) continue;
            this.model.fireRowLabelClick(n + this.rowStart, mouseEvent, this);
            return;
        }
        n4 = this.valueDrawObjects.size();
        for (n = 0; n < n4; ++n) {
            object = (ArrayList)this.valueDrawObjects.get(n);
            int n5 = ((ArrayList)object).size();
            for (int i = 0; i < n5; ++i) {
                DrawObject drawObject = (DrawObject)((ArrayList)object).get(i);
                if (drawObject == null || n2 < drawObject.getXBeg() || n2 > drawObject.getXEnd() || n3 < drawObject.getYBeg() || n3 > drawObject.getYEnd() || i == n5 - 1) continue;
                this.model.fireValueClick(n + this.rowStart, i, mouseEvent, this);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private int getMaxRowLabelStringWidth() {
        if (!this.maxRowLabelStringWidthSet) {
            this.maxRowLabelStringWidth = 0;
            for (int i = 0; i < this.model.getNumRows(); ++i) {
                String string = this.model.getRowLabel(i);
                this.maxRowLabelStringWidth = Math.max(this.maxRowLabelStringWidth, this.fontMetrics.stringWidth(string));
            }
            this.maxRowLabelStringWidthSet = true;
        }
        return this.maxRowLabelStringWidth;
    }

    private int getMaxValueLabelStringWidth() {
        if (!this.maxValueLabelStringWidthSet) {
            this.maxValueLabelStringWidth = 0;
            for (int i = 0; i < this.model.getNumRows(); ++i) {
                String string = this.model.getValueLabel(i, 0);
                this.maxValueLabelStringWidth = Math.max(this.maxValueLabelStringWidth, this.fontMetrics.stringWidth(string));
            }
            this.maxValueLabelStringWidthSet = true;
        }
        return this.maxValueLabelStringWidth;
    }

    private void checkPreferredSize() {
        int n;
        if (this.preferredSizeSet) {
            return;
        }
        int n2 = this.model.getNumRows() * this.fontHeight + this.topMargin + this.fontMetrics.getMaxDescent() + this.fontMetrics.getLeading();
        if (this.model.getSubSize() == 1) {
            n = this.barLength + this.getMaxRowLabelStringWidth() + this.getMaxValueLabelStringWidth() + this.leftMargin + 2 * this.horizSpacing + this.rightMargin;
        } else if (this.singleLine) {
            if (this.stacked) {
                n = this.leftMargin + this.getMaxRowLabelStringWidth() + this.horizSpacing + this.barLength + this.rightMargin;
            } else {
                n = this.leftMargin + this.getMaxRowLabelStringWidth() + this.horizSpacing + this.rightMargin;
                for (int i = 0; i < this.model.getSubSize(); ++i) {
                    int n3 = (int)(this.maxSubValues[i] / this.maxRowSum * (double)this.barLength);
                    n = (int)((double)n + (this.maxSubValues[i] / this.maxRowSum * (double)this.barLength + (double)this.barHorizSpacing));
                }
            }
        } else {
            int n4 = this.fontHeight * this.model.getSubSize() + 10;
            n = this.barLength + this.getMaxRowLabelStringWidth() + this.getMaxValueLabelStringWidth() + this.leftMargin + 2 * this.horizSpacing + this.rightMargin;
            n2 = this.model.getNumRows() * n4;
        }
        super.setSize(new Dimension(n, n2 + 5));
        super.setPreferredSize(new Dimension(n, n2 + 5));
        this.preferredSizeSet = true;
        this.invalidate();
    }

    private void processData() {
        if (this.dataProcessed) {
            return;
        }
        this.dataProcessed = true;
        this.maxRowValues = new double[this.model.getNumRows()];
        this.maxSubValues = new double[this.model.getSubSize()];
        this.rowSums = new double[this.model.getNumRows()];
        this.maxRowSum = 0.0;
        this.maxOverallValue = 0.0;
        for (int i = 0; i < this.model.getNumRows(); ++i) {
            double d = 0.0;
            for (int j = 0; j < this.model.getSubSize(); ++j) {
                double d2 = Math.max(0.0, this.model.getValue(i, j));
                this.maxRowValues[i] = Math.max(this.maxRowValues[i], d2);
                this.maxSubValues[j] = Math.max(this.maxSubValues[j], d2);
                d += d2;
                int n = i;
                this.rowSums[n] = this.rowSums[n] + d2;
                this.maxOverallValue = Math.max(this.maxOverallValue, d2);
            }
            this.maxRowSum = Math.max(this.maxRowSum, d);
        }
    }

    private Color lighter(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = Math.max(n, n2);
        n4 = Math.max(n4, n3);
        n4 = Math.max(n4, 255);
        n += (int)((double)(n4 - n) / 2.36);
        n2 += (int)((double)(n4 - n2) / 2.36);
        n3 += (int)((double)(n4 - n3) / 2.36);
        return new Color(n, n2, n3);
    }

    private void drawBar(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color, Color color2) {
        boolean bl = true;
        if (bl && n4 > 4) {
            graphics2D.setColor(color);
            graphics2D.fillRect(n, n2, n3, n4 - 1);
            graphics2D.setColor(this.lighter(color));
            int n5 = n4 / 4;
            graphics2D.fillRect(n, n2 + n5 / 2 + 1, n3, n5);
            int n6 = n5 / 3;
            graphics2D.setColor(this.lighter(this.lighter(color)));
            graphics2D.fillRect(n, n2 + n5 / 2 + 1 + n6, n3, n6);
            graphics2D.setColor(Color.black);
            if (color2 != null) {
                graphics2D.setColor(color2);
                graphics2D.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 3);
            }
            graphics2D.drawRect(n, n2, n3, n4 - 1);
        } else {
            n4 = Math.max(n4, 1);
            graphics2D.setColor(color);
            graphics2D.fillRect(n, n2, n3, n4);
            if (n4 > 3) {
                graphics2D.setColor(Color.black);
                if (color2 != null) {
                    graphics2D.setColor(color2);
                    graphics2D.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                }
                graphics2D.drawRect(n, n2, n3, n4);
            }
        }
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2) {
        this.rowLabelDrawObjects.clear();
        this.valueDrawObjects.clear();
        Font font = ParaProf.preferencesWindow.getFont();
        graphics2D.setFont(font);
        this.fontMetrics = graphics2D.getFontMetrics(font);
        this.barVerticalSpacing = 0;
        this.fontHeight = this.fontMetrics.getHeight();
        int n = this.fontMetrics.getMaxDescent();
        int n2 = this.fontMetrics.getMaxAscent();
        int n3 = this.fontMetrics.getLeading();
        this.barHeight = n + n2 + n3 - 2;
        this.processData();
        int n4 = this.leftJustified ? this.leftMargin + this.getMaxRowLabelStringWidth() : this.leftMargin + this.getMaxValueLabelStringWidth() + this.horizSpacing + this.barLength + this.horizSpacing;
        int n5 = (int)((float)n2 - ((float)n + (float)n2 + (float)n3 - (float)this.barHeight) / 2.0f);
        this.checkPreferredSize();
        int n6 = this.fontHeight;
        int n7 = n6 + this.topMargin;
        if (!this.singleLine) {
            n6 = n6 * this.model.getSubSize() + 10;
        }
        this.searcher.setLineHeight(n6);
        this.searcher.setMaxDescent(this.fontMetrics.getMaxDescent());
        int[] nArray = ParaProfUtils.computeClipping(this.panel.getViewport().getViewRect(), this.panel.getViewport().getViewRect(), true, bl2, this.model.getNumRows(), n6, n7);
        this.rowStart = nArray[0];
        int n8 = nArray[1];
        n7 = nArray[2];
        double d = this.maxRowSum;
        this.searcher.setVisibleLines(this.rowStart, n8);
        this.searcher.setG2d(graphics2D);
        this.searcher.setXOffset(n4);
        for (int i = this.rowStart; i <= n8; ++i) {
            int n9;
            int n10;
            String string = this.model.getRowLabel(i);
            int n11 = this.fontMetrics.stringWidth(string);
            ArrayList<DrawObject> arrayList = new ArrayList<DrawObject>();
            this.valueDrawObjects.add(arrayList);
            if (this.model.getSubSize() == 1) {
                int n12;
                int n13;
                String string2 = this.model.getValueLabel(i, 0);
                double d2 = this.model.getValue(i, 0);
                double d3 = d2 / d;
                int n14 = (int)(d3 * (double)this.barLength);
                int n15 = this.fontMetrics.stringWidth(string2);
                int n16 = n7 - n5;
                if (this.leftJustified) {
                    n13 = n4 + this.horizSpacing;
                    n10 = n4 - n11;
                    n12 = n4 + n14 + 2 * this.horizSpacing;
                } else {
                    n13 = n4 - n14 - this.horizSpacing;
                    n10 = n4;
                    n12 = n4 - n14 - n15 - 2 * this.horizSpacing;
                }
                this.drawBar(graphics2D, n13, n7 - n5, n14, this.barHeight, this.model.getValueColor(i, 0), this.model.getValueHighlightColor(i, 0));
                arrayList.add(new DrawObject(n13, n7 - n5, n13 + n14, n7 - n5 + this.barHeight));
                this.searcher.drawHighlights(graphics2D, n10, n7, i);
                graphics2D.setColor(Color.black);
                graphics2D.drawString(string, n10, n7);
                this.rowLabelDrawObjects.add(new DrawObject(n10, n7 - this.fontHeight, n10 + n11, n7));
                graphics2D.drawString(string2, n12, n7);
                n7 += n6;
                arrayList.add(null);
                continue;
            }
            if (this.singleLine) {
                int n17;
                int n18 = n7 - n5;
                d = this.normalized ? this.rowSums[i] : this.maxRowSum;
                if (this.leftJustified) {
                    n17 = n4 + this.horizSpacing;
                    n9 = n4 - n11;
                } else {
                    n17 = 0;
                    n9 = 0;
                }
                this.searcher.drawHighlights(graphics2D, n9, n7, i);
                graphics2D.setColor(Color.black);
                graphics2D.drawString(string, n9, n7);
                this.rowLabelDrawObjects.add(new DrawObject(n9, n7 - this.fontHeight, n9 + n11, n7));
                if (d > 0.0) {
                    double d4 = 0.0;
                    double d5 = 0.0;
                    for (n10 = 0; n10 < this.model.getSubSize(); ++n10) {
                        graphics2D.setColor(this.model.getValueColor(i, n10));
                        double d6 = this.model.getValue(i, n10);
                        Color color = this.model.getValueColor(i, n10);
                        double d7 = d6 / d;
                        int n19 = (int)(d7 * (double)this.barLength + d5);
                        d5 = d7 * (double)this.barLength + d5 - (double)n19;
                        if (n19 < this.threshold && this.stacked) {
                            d4 += d6;
                            arrayList.add(null);
                            continue;
                        }
                        int n20 = (int)(this.maxSubValues[n10] / d * (double)this.barLength);
                        if (n20 < this.threshold) {
                            arrayList.add(null);
                            d4 += d6;
                            continue;
                        }
                        if (d6 < 0.0) {
                            arrayList.add(null);
                        } else if (n19 < this.threshold) {
                            arrayList.add(null);
                            d4 += d6;
                        } else {
                            this.drawBar(graphics2D, n17, n7 - n5, n19, this.barHeight, color, this.model.getValueHighlightColor(i, n10));
                            arrayList.add(new DrawObject(n17, n7 - n5, n17 + n19, n7 - n5 + this.barHeight));
                        }
                        if (!this.stacked) {
                            n17 = (int)((double)n17 + (this.maxSubValues[n10] / d * (double)this.barLength + (double)this.barHorizSpacing));
                            continue;
                        }
                        n17 += n19;
                    }
                    if (this.normalized) {
                        n10 = this.barLength + n4 + this.horizSpacing - n17;
                    } else {
                        double d8 = d4 / d;
                        n10 = (int)(d8 * (double)this.barLength + d5);
                    }
                    this.drawBar(graphics2D, n17, n7 - n5, n10, this.barHeight, Color.black, null);
                    arrayList.add(new DrawObject(n17, n7 - n5, n17 + n10, n7 - n5 + this.barHeight));
                }
                n7 += n6;
                continue;
            }
            d = this.maxOverallValue;
            this.leftJustified = false;
            int n21 = this.leftJustified ? n4 - n11 : n4;
            n9 = n7 + n6 / 2 - n2;
            this.searcher.drawHighlights(graphics2D, n21, n9, i);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string, n21, n9);
            this.rowLabelDrawObjects.add(new DrawObject(n21, n9 - this.fontHeight, n21 + n11, n9));
            int n22 = n7;
            for (int j = 0; j < this.model.getSubSize(); ++j) {
                int n23;
                int n24;
                double d9 = this.model.getValue(i, j);
                if (d9 < 0.0) {
                    n22 += this.fontHeight;
                    continue;
                }
                String string3 = this.model.getValueLabel(i, j);
                int n25 = this.fontMetrics.stringWidth(string3);
                double d10 = d9 / d;
                int n26 = (int)(d10 * (double)this.barLength);
                if (this.leftJustified) {
                    n24 = n4 + this.horizSpacing;
                    n23 = n4 + n26 + 2 * this.horizSpacing;
                } else {
                    n24 = n4 - n26 - this.horizSpacing;
                    n23 = n4 - n26 - n25 - 2 * this.horizSpacing;
                }
                this.drawBar(graphics2D, n24, n22 - n5, n26, this.barHeight, this.model.getValueColor(i, j), this.model.getValueHighlightColor(i, 0));
                graphics2D.drawString(string3, n23, n22);
                n22 += this.fontHeight;
            }
            n7 += n6;
        }
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        return null;
    }

    public void barChartChanged() {
        this.preferredSizeSet = false;
        this.maxValueLabelStringWidthSet = false;
        this.maxRowLabelStringWidthSet = false;
        this.dataProcessed = false;
        this.setSearchLines();
        this.repaint();
    }

    private void setSearchLines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.model.getNumRows(); ++i) {
            arrayList.add(this.model.getRowLabel(i));
        }
        this.searcher.setSearchLines(arrayList);
    }

    public int getBarLength() {
        return this.barLength;
    }

    public void setBarLength(int n) {
        this.barLength = n;
        this.preferredSizeSet = false;
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public boolean getNormalized() {
        return this.normalized;
    }

    public void setNormalized(boolean bl) {
        this.normalized = bl;
        this.preferredSizeSet = false;
    }

    public boolean getStacked() {
        return this.stacked;
    }

    public void setStacked(boolean bl) {
        this.stacked = bl;
        this.preferredSizeSet = false;
    }

    public boolean getSingleLine() {
        return this.singleLine;
    }

    public void setSingleLine(boolean bl) {
        this.singleLine = bl;
    }
}

