/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.CallPathUtilFuncs;
import edu.uoregon.tau.perfdmf.CubeXMLHandler;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class CubeDataSource
extends DataSource {
    private File file;
    private volatile CubeXMLHandler handler = new CubeXMLHandler(this);

    public CubeDataSource(File file) {
        this.file = file;
    }

    public void load() throws FileNotFoundException, IOException, DataSourceException, SQLException {
        try {
            long l = System.currentTimeMillis();
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xMLReader.setContentHandler(this.handler);
            xMLReader.setErrorHandler(this.handler);
            xMLReader.parse(new InputSource(new FileInputStream(this.file)));
            if (CallPathUtilFuncs.checkCallPathsPresent(this.getFunctions())) {
                this.setCallPathDataPresent(true);
            }
            this.setGroupNamesPresent(true);
            this.generateDerivedData();
            l = System.currentTimeMillis() - l;
        }
        catch (SAXException sAXException) {
            throw new DataSourceException(sAXException);
        }
    }

    public int getProgress() {
        int n = 0;
        if (this.handler != null) {
            n = this.handler.getProgress();
        }
        return n;
    }

    public void cancelLoad() {
    }
}

