/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.IntervalLocationProfile;
import edu.uoregon.tau.perfdmf.database.DB;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class IntervalEvent {
    private int intervalEventID;
    private String name;
    private String group;
    private int trialID;
    private IntervalLocationProfile meanSummary = null;
    private IntervalLocationProfile totalSummary = null;
    private DatabaseAPI dataSession = null;

    public IntervalEvent(DatabaseAPI databaseAPI) {
        this.dataSession = databaseAPI;
    }

    public int getID() {
        return this.intervalEventID;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public int getTrialID() {
        return this.trialID;
    }

    public IntervalLocationProfile getMeanSummary() throws SQLException {
        if (this.meanSummary == null) {
            this.dataSession.getIntervalEventDetail(this);
        }
        return this.meanSummary;
    }

    public IntervalLocationProfile getTotalSummary() throws SQLException {
        if (this.totalSummary == null) {
            this.dataSession.getIntervalEventDetail(this);
        }
        return this.totalSummary;
    }

    public void setID(int n) {
        this.intervalEventID = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public void setTrialID(int n) {
        this.trialID = n;
    }

    public void setMeanSummary(IntervalLocationProfile intervalLocationProfile) {
        this.meanSummary = intervalLocationProfile;
    }

    public void setTotalSummary(IntervalLocationProfile intervalLocationProfile) {
        this.totalSummary = intervalLocationProfile;
    }

    public static Vector getIntervalEvents(DatabaseAPI databaseAPI, DB dB, String string) {
        Vector<IntervalEvent> vector = new Vector<IntervalEvent>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select id, name, group_name, trial ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "interval_event ");
        stringBuffer.append(string);
        if (dB.getDBType().compareTo("oracle") == 0) {
            stringBuffer.append(" order by dbms_lob.substr(name) asc");
        } else {
            stringBuffer.append(" order by name asc ");
        }
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            Object var6_7 = null;
            while (resultSet.next()) {
                IntervalEvent intervalEvent = new IntervalEvent(databaseAPI);
                intervalEvent.setID(resultSet.getInt(1));
                intervalEvent.setName(resultSet.getString(2));
                intervalEvent.setGroup(resultSet.getString(3));
                intervalEvent.setTrialID(resultSet.getInt(4));
                vector.addElement(intervalEvent);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    public int saveIntervalEvent(DB dB, int n, Hashtable hashtable, int n2) throws SQLException {
        int n3 = 0;
        PreparedStatement preparedStatement = null;
        if (n2 < 0) {
            preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_event (trial, name, group_name) VALUES (?, ?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, this.name);
            preparedStatement.setString(3, this.group);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "interval_event_id_seq.currval FROM dual" : "select currval('interval_event_id_seq');"));
            n3 = Integer.parseInt(dB.getDataItem(string));
        } else {
            preparedStatement = dB.getDBType().compareTo("oracle") == 0 ? dB.prepareStatement("SELECT id FROM " + dB.getSchemaPrefix() + "interval_event where dbms_lob.instr(name, ?) > 0") : dB.prepareStatement("SELECT id FROM " + dB.getSchemaPrefix() + "interval_event where name = ?");
            preparedStatement.setString(1, this.name);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n3 = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
        }
        if (this.meanSummary != null) {
            this.meanSummary.saveMeanSummary(dB, n3, hashtable, n2);
        }
        if (this.totalSummary != null) {
            this.totalSummary.saveTotalSummary(dB, n3, hashtable, n2);
        }
        return n3;
    }
}

