/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.CallPathUtilFuncs;
import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.LineData;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class TauDataSource
extends DataSource {
    private volatile boolean abort = false;
    private volatile int totalFiles = 0;
    private volatile int filesRead = 0;
    private LineData functionDataLine = new LineData();
    private LineData usereventDataLine = new LineData();
    private boolean profileStatsPresent = false;
    private boolean groupCheck = false;
    private List dirs;
    private File fileToMonitor;
    static /* synthetic */ Class class$java$io$FileInputStream;

    public TauDataSource(List list) {
        File[] fileArray;
        this.dirs = list;
        if (list.size() > 0 && (fileArray = (File[])list.get(0)).length > 0) {
            this.fileToMonitor = fileArray[0];
        }
    }

    public void cancelLoad() {
        this.abort = true;
    }

    public int getProgress() {
        if (this.totalFiles != 0) {
            return (int)((float)this.filesRead / (float)this.totalFiles * 100.0f);
        }
        return 0;
    }

    public List getFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(this.fileToMonitor);
        return arrayList;
    }

    public void load() throws FileNotFoundException, IOException, DataSourceException {
        int n;
        Object object;
        long l = System.currentTimeMillis();
        boolean bl = false;
        try {
            object = (class$java$io$FileInputStream == null ? (class$java$io$FileInputStream = TauDataSource.class$("java.io.FileInputStream")) : class$java$io$FileInputStream).getMethod("getChannel", null);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        object = this.dirs.iterator();
        while (object.hasNext()) {
            File[] fileArray = (File[])object.next();
            for (n = 0; n < fileArray.length; ++n) {
                ++this.totalFiles;
            }
        }
        boolean bl2 = false;
        int n2 = 0;
        n = 0;
        Function function = null;
        FunctionProfile functionProfile = null;
        UserEventProfile userEventProfile = null;
        Object object2 = -1;
        Object object3 = -1;
        Object object4 = -1;
        String string = null;
        Iterator iterator = this.dirs.iterator();
        while (iterator.hasNext()) {
            Object object5;
            Object object6;
            Object object7;
            Comparable comparable;
            File[] fileArray = (File[])iterator.next();
            n = 0;
            if (n2 != 0) {
                Iterator iterator2 = this.getNodes();
                while (iterator2.hasNext()) {
                    Node node = (Node)iterator2.next();
                    Iterator iterator3 = node.getContexts();
                    while (iterator3.hasNext()) {
                        comparable = (Context)iterator3.next();
                        object7 = ((Context)comparable).getThreads();
                        while (object7.hasNext()) {
                            object6 = (Thread)object7.next();
                            ((Thread)object6).incrementStorage();
                            object5 = ((Thread)object6).getFunctionProfiles().iterator();
                            while (object5.hasNext()) {
                                FunctionProfile functionProfile2 = (FunctionProfile)object5.next();
                                if (functionProfile2 == null) continue;
                                functionProfile2.incrementStorage();
                            }
                        }
                    }
                }
            }
            for (int i = 0; i < fileArray.length; ++i) {
                boolean bl3 = false;
                int n3 = 0;
                while (!bl3) {
                    comparable = null;
                    try {
                        Object object8;
                        int n4;
                        int n5;
                        InputStreamReader inputStreamReader;
                        BufferedReader bufferedReader;
                        ++this.filesRead;
                        if (this.abort) {
                            return;
                        }
                        object7 = this.getNCT(fileArray[i].getName());
                        if (object7 == null && this.dirs.size() == 1 && fileArray.length == 1) {
                            throw new DataSourceException(fileArray[i].getName() + ": This doesn't look like a TAU profile\nDid you mean do use the -f option to specify a file format?");
                        }
                        if (object7 == null) {
                            bl3 = true;
                            continue;
                        }
                        object2 = object7[0];
                        object3 = object7[1];
                        object4 = object7[2];
                        object6 = this.addNode((int)object2);
                        object5 = ((Node)object6).addContext((int)object3);
                        comparable = ((Context)object5).getThread((int)object4);
                        if (comparable == null) {
                            comparable = ((Context)object5).addThread((int)object4);
                        }
                        bl2 = true;
                        FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                        FileLock fileLock = null;
                        if (bl) {
                            FileChannel fileChannel = fileInputStream.getChannel();
                            fileLock = fileChannel.lock(0L, Long.MAX_VALUE, true);
                        }
                        if ((string = (bufferedReader = new BufferedReader(inputStreamReader = new InputStreamReader(fileInputStream))).readLine()) == null) {
                            throw new DataSourceException("Unexpected end of file: " + fileArray[i].getName() + "\nLooking for 'templated_functions' line");
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
                        String string2 = stringTokenizer.nextToken();
                        try {
                            n5 = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new DataSourceException(fileArray[i].getName() + ": Couldn't read number of functions, bad TAU Profile?");
                        }
                        if (n == 0) {
                            String string3 = this.getMetricName(string);
                            if (string3 == null) {
                                string3 = new String("Time");
                            }
                            this.addMetric(string3);
                            n = 1;
                        }
                        if ((string = bufferedReader.readLine()) == null) {
                            throw new DataSourceException("Unexpected end of file: " + fileArray[i].getName() + "\nLooking for '# Name Calls ...' line");
                        }
                        if (i == 0 && string.indexOf("SumExclSqr") != -1) {
                            this.setProfileStatsPresent(true);
                        }
                        for (n4 = 0; n4 < n5; ++n4) {
                            string = bufferedReader.readLine();
                            if (string == null) {
                                throw new DataSourceException("Unexpected end of file: " + fileArray[i].getName() + "\nOnly found " + (n4 - 2) + " of " + n5 + " Function Lines");
                            }
                            this.getFunctionDataLine(string);
                            String string4 = this.getGroupNames(string);
                            if (this.functionDataLine.i0 == 0) continue;
                            function = this.addFunction(this.functionDataLine.s0, 1);
                            functionProfile = ((Thread)comparable).getFunctionProfile(function);
                            if (functionProfile == null) {
                                functionProfile = new FunctionProfile(function);
                                ((Thread)comparable).addFunctionProfile(functionProfile);
                            }
                            functionProfile.setExclusive(n2, functionProfile.getExclusive(n2) + this.functionDataLine.d0);
                            functionProfile.setInclusive(n2, functionProfile.getInclusive(n2) + this.functionDataLine.d1);
                            if (n2 == 0) {
                                functionProfile.setNumCalls(functionProfile.getNumCalls() + (double)this.functionDataLine.i0);
                                functionProfile.setNumSubr(functionProfile.getNumSubr() + (double)this.functionDataLine.i1);
                            }
                            if (n2 != 0 || string4 == null) continue;
                            object8 = new StringTokenizer(string4, "|");
                            while (((StringTokenizer)object8).hasMoreTokens()) {
                                String string5 = ((StringTokenizer)object8).nextToken();
                                if (string5 == null) continue;
                                Group group = this.addGroup(string5.trim());
                                function.addGroup(group);
                            }
                        }
                        string = bufferedReader.readLine();
                        if (string == null) {
                            throw new DataSourceException("Unexpected end of file: " + fileArray[i].getName() + "\nLooking for 'aggregates' line");
                        }
                        stringTokenizer = new StringTokenizer(string, " \t\n\r");
                        string2 = stringTokenizer.nextToken();
                        n5 = Integer.parseInt(string2);
                        for (n4 = 0; n4 < n5; ++n4) {
                            string = bufferedReader.readLine();
                        }
                        if (n2 == 0 && (string = bufferedReader.readLine()) != null) {
                            stringTokenizer = new StringTokenizer(string, " \t\n\r");
                            string2 = stringTokenizer.nextToken();
                            n4 = Integer.parseInt(string2);
                            bufferedReader.readLine();
                            for (int j = 0; j < n4; ++j) {
                                if (j == 0) {
                                    this.setUserEventsPresent(true);
                                }
                                if ((string = bufferedReader.readLine()) == null) {
                                    throw new DataSourceException("Unexpected end of file: " + fileArray[i].getName() + "\nOnly found " + (j - 2) + " of " + n4 + " User Event Lines");
                                }
                                this.getUserEventData(string);
                                if (this.usereventDataLine.i0 == 0) continue;
                                object8 = this.addUserEvent(this.usereventDataLine.s0);
                                userEventProfile = ((Thread)comparable).getUserEventProfile((UserEvent)object8);
                                if (userEventProfile == null) {
                                    userEventProfile = new UserEventProfile((UserEvent)object8);
                                    ((Thread)comparable).addUserEventProfile(userEventProfile);
                                }
                                userEventProfile.setNumSamples(this.usereventDataLine.i0);
                                userEventProfile.setMaxValue(this.usereventDataLine.d0);
                                userEventProfile.setMinValue(this.usereventDataLine.d1);
                                userEventProfile.setMeanValue(this.usereventDataLine.d2);
                                userEventProfile.setSumSquared(this.usereventDataLine.d3);
                                userEventProfile.updateMax();
                            }
                        }
                        if (fileLock != null) {
                            fileLock.release();
                        }
                        bufferedReader.close();
                        inputStreamReader.close();
                        fileInputStream.close();
                        bl3 = true;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (!(exception instanceof IOException) && !(exception instanceof FileNotFoundException)) {
                            throw new RuntimeException(exception == null ? null : exception.toString());
                        }
                        try {
                            java.lang.Thread.sleep(250L);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        if (n3 > 5) {
                            System.err.println("too many exceptions caught");
                            exception.printStackTrace();
                            bl3 = true;
                        } else if (comparable != null) {
                            object6 = ((Thread)comparable).getFunctionProfileIterator();
                            while (object6.hasNext()) {
                                object5 = (FunctionProfile)object6.next();
                                if (object5 == null) continue;
                                for (int j = 0; j < this.getNumberOfMetrics(); ++j) {
                                    ((FunctionProfile)object5).setExclusive(j, 0.0);
                                    ((FunctionProfile)object5).setInclusive(j, 0.0);
                                }
                                ((FunctionProfile)object5).setNumSubr(0.0);
                                ((FunctionProfile)object5).setNumCalls(0.0);
                            }
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        if (!bl2) {
            throw new DataSourceException("Didn't find any valid files.\nAre you sure these are TAU profiles? (e.g. profile.*.*.*)");
        }
        this.generateDerivedData();
        if (CallPathUtilFuncs.checkCallPathsPresent(this.getFunctions())) {
            this.setCallPathDataPresent(true);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    private int[] getNCT(String string) {
        try {
            int[] nArray = new int[3];
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".\t\n\r");
            stringTokenizer.nextToken();
            nArray[0] = Integer.parseInt(stringTokenizer.nextToken());
            nArray[1] = Integer.parseInt(stringTokenizer.nextToken());
            nArray[2] = Integer.parseInt(stringTokenizer.nextToken());
            if (nArray[0] < 0 || nArray[1] < 0 || nArray[2] < 0) {
                return null;
            }
            return nArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getMetricName(String string) {
        String string2 = null;
        int n = string.indexOf("_MULTI_");
        if (n > 0) {
            string2 = string.substring(n + 7);
            return string2;
        }
        n = string.indexOf("hw_counters");
        if (n > 0) {
            return "Hardware Counter";
        }
        return string2;
    }

    private void getFunctionDataLine(String string) throws DataSourceException {
        StringTokenizer stringTokenizer;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\"') continue;
            ++n;
        }
        if (n == 0) {
            throw new DataSourceException("Looking for function line, found '" + string + "' instead");
        }
        if (n == 2 || n == 4) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, "\"");
            this.functionDataLine.s0 = stringTokenizer2.nextToken();
            stringTokenizer = new StringTokenizer(stringTokenizer2.nextToken(), " \t\n\r");
        } else {
            int n2;
            int n3 = 0;
            for (n2 = 0; n3 < n - 2 && n2 < string.length(); ++n2) {
                if (string.charAt(n2) != '\"') continue;
                ++n3;
            }
            this.functionDataLine.s0 = string.substring(1, n2 - 1);
            stringTokenizer = new StringTokenizer(string.substring(n2 + 1), " \t\n\r");
        }
        this.functionDataLine.i0 = Integer.parseInt(stringTokenizer.nextToken());
        this.functionDataLine.i1 = Integer.parseInt(stringTokenizer.nextToken());
        this.functionDataLine.d0 = Double.parseDouble(stringTokenizer.nextToken());
        this.functionDataLine.d1 = Double.parseDouble(stringTokenizer.nextToken());
        if (this.getProfileStatsPresent()) {
            this.functionDataLine.d2 = Double.parseDouble(stringTokenizer.nextToken());
        }
        this.functionDataLine.i2 = Integer.parseInt(stringTokenizer.nextToken());
        if (this.functionDataLine.d0 < 0.0) {
            System.err.println("Warning, negative values found in profile, ignoring!");
            System.err.println("string = " + string);
            this.functionDataLine.d0 = 0.0;
        }
    }

    private String getGroupNames(String string) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) != '\"') continue;
            ++n3;
        }
        n2 = 0;
        for (n = 0; n2 < n3 - 2 && n < string.length(); ++n) {
            if (string.charAt(n) != '\"') continue;
            ++n2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1), "\"");
        String string2 = stringTokenizer.nextToken();
        if (!this.getGroupCheck()) {
            int n4 = string2.indexOf("GROUP=");
            if (n4 > 0) {
                this.setGroupNamesPresent(true);
            }
            this.setGroupCheck(true);
        }
        if (this.getGroupNamesPresent()) {
            try {
                string2 = stringTokenizer.nextToken();
                return string2;
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
        return null;
    }

    private void getUserEventData(String string) {
        StringTokenizer stringTokenizer;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\"') continue;
            ++n;
        }
        if (n == 2) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, "\"");
            this.usereventDataLine.s0 = stringTokenizer2.nextToken();
            stringTokenizer = new StringTokenizer(stringTokenizer2.nextToken(), " \t\n\r");
        } else {
            int n2;
            int n3 = 0;
            for (n2 = 0; n3 < n && n2 < string.length(); ++n2) {
                if (string.charAt(n2) != '\"') continue;
                ++n3;
            }
            this.usereventDataLine.s0 = string.substring(1, n2 - 1);
            stringTokenizer = new StringTokenizer(string.substring(n2 + 1), " \t\n\r");
        }
        this.usereventDataLine.i0 = (int)Double.parseDouble(stringTokenizer.nextToken());
        this.usereventDataLine.d0 = Double.parseDouble(stringTokenizer.nextToken());
        this.usereventDataLine.d1 = Double.parseDouble(stringTokenizer.nextToken());
        this.usereventDataLine.d2 = Double.parseDouble(stringTokenizer.nextToken());
        this.usereventDataLine.d3 = Double.parseDouble(stringTokenizer.nextToken());
    }

    protected void setProfileStatsPresent(boolean bl) {
        this.profileStatsPresent = bl;
    }

    public boolean getProfileStatsPresent() {
        return this.profileStatsPresent;
    }

    protected void setGroupCheck(boolean bl) {
        this.groupCheck = bl;
    }

    protected boolean getGroupCheck() {
        return this.groupCheck;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

