/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.loader;

import edu.uoregon.tau.perfdmf.database.ConnectionManager;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.ParseConfig;
import edu.uoregon.tau.perfdmf.database.PasswordField;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;

public class Configure {
    private DB db = null;
    private static String Usage = "Usage: configure [{-h,--help}] [{-g,--configfile} filename] [{-t,--tauroot} path]";
    private static String Greeting = "\nWelcome to the configuration program for PerfDMF.\nThis program will prompt you for some information necessary to ensure\nthe desired behavior for the PerfDMF tools.\n";
    private static String PDBHomePrompt = "Please enter the PerfDMF home directory:";
    private String perfdmf_home = "";
    private String tau_root = "";
    private String arch = "";
    private String jdbc_db_jarfile = "postgresql.jar";
    private String jdbc_db_driver = "org.postgresql.Driver";
    private String jdbc_db_type = "postgresql";
    private String db_hostname = "localhost";
    private String db_portnum = "5432";
    private String db_dbname = "perfdmf";
    private String db_username = "";
    private String db_password = "";
    private String db_schemaprefix = "";
    private boolean store_db_password = false;
    private String db_schemafile = "dbschema.txt";
    private String xml_parser = "xerces.jar";
    private ParseConfig parser;
    private boolean configFileFound = false;
    private String configFileName;

    public Configure(String string, String string2) {
        this.tau_root = string;
        this.arch = string2;
        this.perfdmf_home = string + "/tools/src/dms";
    }

    public void errorPrint(String string) {
        System.err.println(string);
    }

    public void initialize(String string) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println(Greeting);
        try {
            this.configFileName = string;
            File file = new File(this.configFileName);
            if (file.exists()) {
                System.out.println("Configuration file found...");
                this.parseConfigFile();
                this.configFileFound = true;
            } else {
                System.out.println("Configuration file NOT found...");
                System.out.println("a new configuration file will be created.");
            }
        }
        catch (IOException iOException) {
            System.out.println("I/O Error occurred.");
        }
    }

    public void parseConfigFile() throws IOException, FileNotFoundException {
        System.out.println("Parsing config file...");
        this.parser = new ParseConfig(this.configFileName);
        this.perfdmf_home = this.parser.getPerfDMFHome();
        this.jdbc_db_jarfile = this.parser.getJDBCJarFile();
        this.jdbc_db_driver = this.parser.getJDBCDriver();
        this.jdbc_db_type = this.parser.getDBType();
        this.db_hostname = this.parser.getDBHost();
        this.db_portnum = this.parser.getDBPort();
        this.db_schemaprefix = this.parser.getDBSchemaPrefix();
        this.db_dbname = this.parser.getDBName();
        this.db_username = this.parser.getDBUserName();
        this.db_password = this.parser.getDBPasswd();
        this.db_schemafile = this.parser.getDBSchema();
        this.xml_parser = this.parser.getXMLSAXParser();
    }

    public void promptForData() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("\nYou will now be prompted for new values, if desired.  The current or default\nvalues for each prompt are shown in parenthesis.\nTo accept the current/default value, just press Enter/Return.\n");
        try {
            System.out.print("Please enter the TAU root directory.\n(" + this.tau_root + "):");
            String string = bufferedReader.readLine();
            if (string.length() > 0) {
                this.tau_root = string;
                this.perfdmf_home = this.tau_root + "/tools/src/dms";
            }
            String string2 = this.jdbc_db_type;
            boolean bl = false;
            while (!bl) {
                System.out.print("Please enter the database vendor (oracle, postgresql or mysql).\n(" + this.jdbc_db_type + "):");
                string = bufferedReader.readLine();
                if (string.compareTo("oracle") != 0 && string.compareTo("postgresql") != 0 && string.compareTo("mysql") != 0 && string.length() != 0) continue;
                if (string.length() > 0) {
                    this.jdbc_db_type = string;
                }
                bl = true;
            }
            if (this.configFileFound) {
                if (this.jdbc_db_type.compareTo("postgresql") == 0 && string2.compareTo("postgresql") != 0) {
                    this.jdbc_db_jarfile = this.tau_root + "/" + this.arch + "/lib/" + "postgresql.jar";
                    this.jdbc_db_driver = "org.postgresql.Driver";
                    this.db_schemafile = this.perfdmf_home + "/data/" + "dbschema.txt";
                    this.db_portnum = "5432";
                } else if (this.jdbc_db_type.compareTo("mysql") == 0 && string2.compareTo("mysql") != 0) {
                    this.jdbc_db_jarfile = this.tau_root + "/" + this.arch + "/lib/" + "mysql.jar";
                    this.jdbc_db_driver = "org.gjt.mm.mysql.Driver";
                    this.db_schemafile = this.perfdmf_home + "/data/" + "dbschema.mysql.txt";
                    this.db_portnum = "3306";
                } else if (this.jdbc_db_type.compareTo("oracle") == 0 && string2.compareTo("oracle") != 0) {
                    this.jdbc_db_jarfile = this.tau_root + "/" + this.arch + "/lib/" + "ojdbc14.jar";
                    this.jdbc_db_driver = "oracle.jdbc.OracleDriver";
                    this.db_schemafile = this.perfdmf_home + "/data/" + "dbschema.oracle.txt";
                    this.db_portnum = "1521";
                }
            } else if (this.jdbc_db_type.compareTo("postgresql") == 0) {
                this.jdbc_db_jarfile = "postgresql.jar";
                this.jdbc_db_driver = "org.postgresql.Driver";
                this.db_schemafile = "dbschema.txt";
                this.db_portnum = "5432";
            } else if (this.jdbc_db_type.compareTo("mysql") == 0) {
                this.jdbc_db_jarfile = "mysql.jar";
                this.jdbc_db_driver = "org.gjt.mm.mysql.Driver";
                this.db_schemafile = "dbschema.mysql.txt";
                this.db_portnum = "3306";
            } else if (this.jdbc_db_type.compareTo("oracle") == 0) {
                this.jdbc_db_jarfile = "ojdbc14.jar";
                this.jdbc_db_driver = "oracle.jdbc.OracleDriver";
                this.db_schemafile = "dbschema.oracle.txt";
                this.db_portnum = "1521";
            }
            if (this.configFileFound) {
                System.out.print("Please enter the JDBC jar file.\n(" + this.jdbc_db_jarfile + "):");
            } else {
                System.out.print("Please enter the JDBC jar file.\n(" + this.tau_root + "/" + this.arch + "/lib/" + this.jdbc_db_jarfile + "):");
            }
            string = bufferedReader.readLine();
            if (string.length() > 0) {
                this.jdbc_db_jarfile = string;
            } else if (!this.configFileFound) {
                this.jdbc_db_jarfile = this.tau_root + "/" + this.arch + "/lib/" + this.jdbc_db_jarfile;
            }
            System.out.print("Please enter the JDBC Driver name.\n(" + this.jdbc_db_driver + "):");
            string = bufferedReader.readLine();
            if (string.length() > 0) {
                this.jdbc_db_driver = string;
            }
            System.out.print("Please enter the hostname for the database server.\n(" + this.db_hostname + "):");
            string = bufferedReader.readLine();
            if (string.length() > 0) {
                this.db_hostname = string;
            }
            System.out.print("Please enter the port number for the database JDBC connection.\n(" + this.db_portnum + "):");
            string = bufferedReader.readLine();
            if (string.length() > 0) {
                this.db_portnum = string;
            }
            if (this.jdbc_db_type.compareTo("oracle") == 0) {
                System.out.print("Please enter the oracle TCP service name.\n(" + this.db_dbname + "):");
            } else {
                System.out.print("Please enter the database name.\n(" + this.db_dbname + "):");
            }
            string = bufferedReader.readLine();
            if (string.length() > 0) {
                this.db_dbname = string;
            }
            if (this.jdbc_db_type.compareTo("oracle") == 0) {
                System.out.print("Please enter the database schema name, or your username if you are creating the tables now.\n(" + this.db_schemaprefix + "):");
                string = bufferedReader.readLine();
                if (string.length() > 0) {
                    this.db_schemaprefix = string;
                }
            }
            System.out.print("Please enter the database username.\n(" + this.db_username + "):");
            string = bufferedReader.readLine();
            if (string.length() > 0) {
                this.db_username = string;
            }
            System.out.print("Would you like to store the database password in CLEAR TEXT in your configuration file?\n(no):");
            string = bufferedReader.readLine();
            if (string.compareTo("yes") == 0 || string.compareTo("y") == 0 || string.compareTo("Y") == 0) {
                PasswordField passwordField = new PasswordField();
                this.db_password = passwordField.getPassword("Please enter the database password:");
                this.store_db_password = true;
            }
            if (this.configFileFound) {
                System.out.print("Please enter the PerfDMF schema file.\n(" + this.db_schemafile + "):");
            } else {
                System.out.print("Please enter the PerfDMF schema file.\n(" + this.perfdmf_home + "/data/" + this.db_schemafile + "):");
            }
            string = bufferedReader.readLine();
            if (string.length() > 0) {
                this.db_schemafile = string;
            } else if (!this.configFileFound) {
                this.db_schemafile = this.perfdmf_home + "/data/" + this.db_schemafile;
            }
            if (this.configFileFound) {
                System.out.print("Please enter the XML Parser jar file.\n(" + this.xml_parser + "):");
            } else {
                System.out.print("Please enter the XML Parser jar file.\n(" + this.tau_root + "/" + this.arch + "/lib/" + this.xml_parser + "):");
            }
            string = bufferedReader.readLine();
            if (string.length() > 0) {
                this.xml_parser = string;
            } else if (!this.configFileFound) {
                this.xml_parser = this.perfdmf_home + "/" + this.arch + "/lib/" + this.xml_parser;
            }
        }
        catch (IOException iOException) {
            System.out.println("I/O Error occurred.");
        }
    }

    public void testDBConnection() {
    }

    public void testDBTransaction() {
    }

    public void writeConfigFile() {
        System.out.println("\nWriting configuration file: " + this.configFileName + "...");
        try {
            File file = new File(this.configFileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("# This is the configuration file for the PerfDMF tools & API\n");
            bufferedWriter.write("# Items are listed as name:value, one per line.\n");
            bufferedWriter.write("# Comment lines begin with a '#' symbol.\n");
            bufferedWriter.write("# DO NOT EDIT THIS FILE!  It is modified by the configure utility.\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# PerfDMF home directory\n");
            bufferedWriter.write("perfdmf_home:" + this.perfdmf_home + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database JDBC jar file (with path to location)\n");
            bufferedWriter.write("jdbc_db_jarfile:" + this.jdbc_db_jarfile + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database JDBC driver name\n");
            bufferedWriter.write("jdbc_db_driver:" + this.jdbc_db_driver + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database type\n");
            bufferedWriter.write("jdbc_db_type:" + this.jdbc_db_type + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database host name\n");
            bufferedWriter.write("db_hostname:" + this.db_hostname + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database port number\n");
            bufferedWriter.write("db_portnum:" + this.db_portnum + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database name\n");
            bufferedWriter.write("db_dbname:" + this.db_dbname + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database Schema name\n");
            bufferedWriter.write("db_schemaprefix:" + this.db_schemaprefix + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database username\n");
            bufferedWriter.write("db_username:" + this.db_username + "\n");
            bufferedWriter.newLine();
            if (this.store_db_password) {
                bufferedWriter.write("# Database password\n");
                bufferedWriter.write("db_password:" + this.db_password + "\n");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("# Database Schema file - note: the path is absolute\n");
            bufferedWriter.write("db_schemafile:" + this.db_schemafile + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database XML parser jar file - note: the path is absolute\n");
            bufferedWriter.write("xml_sax_parser:" + this.xml_parser + "\n");
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setPerfDMFHome(String string) {
        this.perfdmf_home = string;
    }

    public String getPerfDMFHome() {
        return this.perfdmf_home;
    }

    public void setJDBCJarfile(String string) {
        this.jdbc_db_jarfile = string;
    }

    public String getJDBCJarfile() {
        return this.jdbc_db_jarfile;
    }

    public void setJDBCDriver(String string) {
        this.jdbc_db_driver = string;
    }

    public String getJDBCDriver() {
        return this.jdbc_db_driver;
    }

    public void setJDBCType(String string) {
        this.jdbc_db_type = string;
    }

    public String getJDBCType() {
        return this.jdbc_db_type;
    }

    public void setDBHostname(String string) {
        this.db_hostname = string;
    }

    public String getDBHostname() {
        return this.db_hostname;
    }

    public void setDBPortNum(String string) {
        this.db_portnum = string;
    }

    public String getDBPortNum() {
        return this.db_portnum;
    }

    public void setDBName(String string) {
        this.db_dbname = string;
    }

    public String getDBName() {
        return this.db_dbname;
    }

    public void setDBUsername(String string) {
        this.db_username = string;
    }

    public String getDBUsername() {
        return this.db_username;
    }

    public void setDBPassword(String string) {
        this.db_password = string;
    }

    public String getDBPassword() {
        return this.db_password;
    }

    public void setDBSchemaFile(String string) {
        this.db_schemafile = string;
    }

    public String getDBSchemaFile() {
        return this.db_schemafile;
    }

    public void setXMLPaser(String string) {
        this.xml_parser = string;
    }

    public String getXMLPaser() {
        return this.xml_parser;
    }

    public void setConfigFileName(String string) {
        this.configFileName = string;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public void createDB() {
        ConnectionManager connectionManager = null;
        DB dB = null;
        try {
            connectionManager = new ConnectionManager(this.configFileName);
            connectionManager.connect();
            dB = connectionManager.getDB();
        }
        catch (Exception exception) {
            System.out.println("\nPlease make sure that your DBMS is configured correctly, and");
            System.out.println("the database " + this.db_dbname + " has been created.");
            System.exit(0);
        }
        try {
            String string = new String("select * from application;");
            ResultSet resultSet = dB.executeQuery(string);
            resultSet.close();
            connectionManager.dbclose();
        }
        catch (Exception exception) {
            System.out.println(this.configFileName);
            connectionManager.genParentSchema(this.db_schemafile);
            connectionManager.dbclose();
            System.out.println("Congratulations! PerfDMF is configured and the database has been built.");
            System.out.println("You may begin loading applications.");
        }
        System.out.println("Configuration complete.");
    }

    public static void main(String[] stringArray) {
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addStringOption('g', "configfile");
        CmdLineParser.Option option2 = cmdLineParser.addStringOption('t', "tauroot");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('a', "arch");
        CmdLineParser.Option option4 = cmdLineParser.addBooleanOption('h', "help");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            System.err.println(Usage);
            System.exit(-1);
        }
        String string = (String)cmdLineParser.getOptionValue(option);
        String string2 = (String)cmdLineParser.getOptionValue(option2);
        String string3 = (String)cmdLineParser.getOptionValue(option3);
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option4);
        if (bl != null && bl.booleanValue()) {
            System.err.println(Usage);
            System.exit(-1);
        }
        if (string == null) {
            string = new String("");
        }
        if (string2 == null) {
            string2 = new String("");
        }
        if (string3 == null) {
            string3 = new String("");
        }
        Configure configure = new Configure(string2, string3);
        configure.initialize(string);
        configure.promptForData();
        configure.writeConfigFile();
    }
}

