/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.common;

import edu.uoregon.tau.common.EPSWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.File;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public class EPSOutput
extends Graphics2D {
    private int width;
    private int height;
    private Graphics2D g2d;
    private boolean drawTextAsShapes;
    private EPSWriter writer;

    private EPSOutput(EPSOutput ePSOutput) {
        this.writer = ePSOutput.writer;
        this.g2d = (Graphics2D)ePSOutput.g2d.create();
        this.drawTextAsShapes = ePSOutput.drawTextAsShapes;
    }

    public EPSOutput(String string, File file, int n, int n2) {
        this.writer = new EPSWriter(string, file, n, n2);
        this.width = n;
        this.height = n2;
        BufferedImage bufferedImage = new BufferedImage(5, 5, 2);
        this.g2d = bufferedImage.createGraphics();
        this.g2d.setClip(0, 0, n, n2);
        this.setStroke(new BasicStroke());
    }

    private void output(String string) {
        this.writer.write(this.g2d, string);
    }

    public void finish() throws IOException {
        this.writer.finish();
    }

    public void rotate(double d) {
        this.g2d.rotate(d);
    }

    public void scale(double d, double d2) {
        this.g2d.scale(d, d2);
    }

    public void shear(double d, double d2) {
        this.g2d.shear(d, d2);
    }

    public void translate(double d, double d2) {
        this.g2d.translate(d, d2);
    }

    public void rotate(double d, double d2, double d3) {
        this.g2d.rotate(d, d2, d3);
    }

    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    public Color getBackground() {
        return this.g2d.getBackground();
    }

    public void setBackground(Color color) {
        this.g2d.setBackground(color);
    }

    public Composite getComposite() {
        return this.g2d.getComposite();
    }

    public void setComposite(Composite composite) {
        this.g2d.setComposite(composite);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.g2d.getDeviceConfiguration();
    }

    public Paint getPaint() {
        return this.g2d.getPaint();
    }

    public void setPaint(Paint paint) {
        this.g2d.setPaint(paint);
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        }
    }

    public RenderingHints getRenderingHints() {
        return this.g2d.getRenderingHints();
    }

    public void clip(Shape shape) {
        this.g2d.clip(shape);
        this.output("initclip\n");
        this.outputPath(this.g2d.getClip());
        this.output("clip\n");
    }

    private String transformedPoint(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        Point2D point2D = this.g2d.getTransform().transform(double_, null);
        return ((Point2D.Double)point2D).x + " " + -((Point2D.Double)point2D).y;
    }

    private void outputPath(Shape shape) {
        this.output("newpath\n");
        double d = 0.0;
        double d2 = 0.0;
        PathIterator pathIterator = shape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    this.output(this.transformedPoint(dArray[0], dArray[1]) + " moveto\n");
                    d = dArray[0];
                    d2 = dArray[1];
                    break;
                }
                case 1: {
                    this.output(this.transformedPoint(dArray[0], dArray[1]) + " lineto\n");
                    d = dArray[0];
                    d2 = dArray[1];
                    break;
                }
                case 2: {
                    double[] dArray2 = new double[]{(d + 2.0 * dArray[0]) / 3.0, (d2 + 2.0 * dArray[1]) / 3.0, (dArray[2] + 2.0 * dArray[0]) / 3.0, (dArray[3] + 2.0 * dArray[1]) / 3.0};
                    this.output(this.transformedPoint(dArray2[0], dArray2[1]) + " " + this.transformedPoint(dArray2[2], dArray2[3]) + " " + this.transformedPoint(dArray[2], dArray[3]) + " curveto\n");
                    d = dArray[2];
                    d2 = dArray[3];
                    break;
                }
                case 3: {
                    this.output(this.transformedPoint(dArray[0], dArray[1]) + " " + this.transformedPoint(dArray[2], dArray[3]) + " " + this.transformedPoint(dArray[4], dArray[5]) + " curveto\n");
                    d = dArray[4];
                    d2 = dArray[5];
                    break;
                }
                case 4: {
                    this.output("closepath\n");
                }
            }
            pathIterator.next();
        }
    }

    public void draw(Shape shape) {
        this.outputPath(shape);
        this.output("stroke\n");
    }

    public void fill(Shape shape) {
        this.outputPath(shape);
        if (shape.getPathIterator(null).getWindingRule() == 0) {
            this.output("eofill\n");
        } else {
            this.output("fill\n");
        }
    }

    public Stroke getStroke() {
        return this.g2d.getStroke();
    }

    public void setStroke(Stroke stroke) {
        this.g2d.setStroke(stroke);
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            this.output(basicStroke.getLineWidth() + " setlinewidth\n");
            this.output(basicStroke.getEndCap() + " setlinecap\n");
            this.output(basicStroke.getLineJoin() + " setlinejoin\n");
            this.output(Math.max(basicStroke.getMiterLimit(), 1.0f) + " setmiterlimit\n");
            this.output("[ ");
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                for (int i = 0; i < fArray.length; ++i) {
                    this.output(fArray[i] + " ");
                }
            }
            this.output("] 0 setdash\n");
        }
    }

    public FontRenderContext getFontRenderContext() {
        return this.g2d.getFontRenderContext();
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        Shape shape = glyphVector.getOutline(f, f2);
        this.fill(shape);
    }

    public AffineTransform getTransform() {
        return this.g2d.getTransform();
    }

    public void setTransform(AffineTransform affineTransform) {
        this.g2d.setTransform(affineTransform);
    }

    public void transform(AffineTransform affineTransform) {
        this.g2d.transform(affineTransform);
    }

    public void drawString(String string, float f, float f2) {
        if (!this.drawTextAsShapes) {
            this.output(this.transformedPoint(f, f2) + " moveto\n");
            this.output("(" + string.replaceAll("\\)", "\\\\)").replaceAll("\\(", "\\\\(") + ") show\n");
        } else {
            GlyphVector glyphVector = this.getFont().createGlyphVector(this.getFontRenderContext(), string);
            this.drawGlyphVector(glyphVector, f, f2);
        }
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        textLayout.draw(this, f, f2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        textLayout.draw(this, n, n2);
    }

    public void addRenderingHints(Map map) {
        this.g2d.addRenderingHints(map);
    }

    public void setRenderingHints(Map map) {
        this.g2d.setRenderingHints(map);
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return this.g2d.hit(rectangle, shape, bl);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.g2d.getRenderingHint(key);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.g2d.setRenderingHint(key, object);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return false;
    }

    public void dispose() {
    }

    public void setPaintMode() {
        this.g2d.setPaintMode();
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        Color color = this.getColor();
        this.setColor(this.getBackground());
        this.outputPath(new Rectangle(n, n2, n3, n4));
        this.output("fill\n");
        this.setColor(color);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.draw(new Line2D.Double(n, n2, n3, n4));
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n, n2, n3, n4);
        this.draw(float_);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n, n2, n3, n4);
        this.fill(float_);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.fill(new Rectangle(n, n2, n3, n4));
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.draw(new Rectangle(n, n2, n3, n4));
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Arc2D.Float float_ = new Arc2D.Float(n, n2, n3, n4, n5, n6, 0);
        this.draw(float_);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6);
        this.draw(float_);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Arc2D.Float float_ = new Arc2D.Float(n, n2, n3, n4, n5, n6, 0);
        this.fill(float_);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6);
        this.fill(float_);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon(nArray, nArray2, n);
        this.draw(polygon);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (n > 0) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(nArray[0], nArray2[0]);
            for (int i = 1; i < n; ++i) {
                generalPath.lineTo(nArray[i], nArray2[i]);
            }
            this.draw(generalPath);
        }
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon(nArray, nArray2, n);
        this.fill(polygon);
    }

    public Color getColor() {
        return this.g2d.getColor();
    }

    public void setColor(Color color) {
        this.g2d.setColor(color);
        if (color == null) {
            color = Color.BLACK;
        }
        this.output((double)color.getRed() / 255.0 + " " + (double)color.getGreen() / 255.0 + " " + (double)color.getBlue() / 255.0 + " setrgbcolor\n");
    }

    public void setXORMode(Color color) {
    }

    public Font getFont() {
        return this.g2d.getFont();
    }

    public void setFont(Font font) {
        this.g2d.setFont(font);
        this.output("/" + font.getPSName() + " findfont " + font.getSize() + " scalefont setfont\n");
    }

    public Graphics create() {
        return new EPSOutput(this);
    }

    public Rectangle getClipBounds() {
        return this.g2d.getClipBounds();
    }

    public Shape getClip() {
        return this.g2d.getClip();
    }

    public void setClip(Shape shape) {
        this.g2d.setClip(shape);
        this.output("initclip\n");
        this.outputPath(this.g2d.getClip());
        this.output("clip\n");
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.g2d.getFontMetrics(font);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return false;
    }

    public boolean getDrawTextAsShapes() {
        return this.drawTextAsShapes;
    }

    public void setDrawTextAsShapes(boolean bl) {
        this.drawTextAsShapes = bl;
    }
}

