/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.common;

import java.awt.Graphics2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class EPSWriter {
    private FileOutputStream out;
    private OutputStreamWriter outWriter;
    private BufferedWriter bw;
    private Graphics2D lastG2d;

    public EPSWriter(String string, File file, int n, int n2) {
        try {
            this.out = new FileOutputStream(file);
            this.outWriter = new OutputStreamWriter(this.out);
            this.bw = new BufferedWriter(this.outWriter);
            Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
            String string2 = "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            simpleDateFormat.setTimeZone(TimeZone.getDefault());
            this.output("%!PS-Adobe-3.0 EPSF-3.0\n");
            this.output("%%Creator: TAU\n");
            this.output("%%Title: " + string + "\n");
            this.output("%%CreationDate: " + simpleDateFormat.format(calendar.getTime()) + "\n");
            this.output("%%BoundingBox: 0 0 " + n + " " + n2 + "\n");
            this.output("%%DocumentData: Clean7Bit\n");
            this.output("%%DocumentProcessColors: Black\n");
            this.output("%%ColorUsage: Color\n");
            this.output("%%Origin: 0 0\n");
            this.output("%%Pages: 1\n");
            this.output("%%Page: 1 1\n");
            this.output("%%EndComments\n\n");
            this.output("gsave\n");
            this.output("-0.0 " + n2 + " translate\n");
            this.output("/dialog findfont 12 scalefont setfont\n");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void output(String string) {
        try {
            this.bw.write(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Graphics2D graphics2D, String string) {
        if (graphics2D != this.lastG2d) {
            if (this.lastG2d != null) {
                this.output("grestore\n");
            }
            graphics2D.setClip(graphics2D.getClip());
            graphics2D.setStroke(graphics2D.getStroke());
            graphics2D.setColor(graphics2D.getColor());
            graphics2D.setFont(graphics2D.getFont());
            this.output("gsave\n");
        }
        this.lastG2d = graphics2D;
        this.output(string);
    }

    public void finish() throws IOException {
        this.output("grestore\n");
        this.output("showpage\n");
        this.output("\n%%EOF");
        this.bw.close();
        this.outWriter.close();
        this.out.close();
    }
}

