/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PerfExplorerActionListener;
import client.PerfExplorerConnection;
import client.PerfExplorerJTabbedPane;
import client.PerfExplorerJTree;
import client.PerfExplorerMainJMenuBar;
import common.PerfExplorerOutput;
import jargs.gnu.CmdLineParser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ToolTipManager;

public class PerfExplorerClient
extends JFrame {
    private static String USAGE = "Usage: PerfExplorerClient [{-h,--help}] {-c,--configfile}=<config_file> [{-s,--standalone}] [{-e,--engine}=<analysis_engine>]\n  where analysis_engine = R or Weka";
    private ActionListener listener = null;
    private static PerfExplorerClient mainFrame = null;

    public static PerfExplorerClient getMainFrame() {
        return mainFrame;
    }

    public ActionListener getListener() {
        return this.listener;
    }

    private PerfExplorerClient(boolean bl, String string, int n, boolean bl2) {
        super("PerfExplorer Client");
        PerfExplorerOutput.initialize(bl2);
        PerfExplorerConnection.setStandalone(bl);
        PerfExplorerConnection.setConfigFile(string);
        PerfExplorerConnection.setAnalysisEngine(n);
        this.listener = new PerfExplorerActionListener(this);
        PerfExplorerJTree perfExplorerJTree = PerfExplorerJTree.getTree();
        JScrollPane jScrollPane = new JScrollPane(perfExplorerJTree);
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        jScrollPane.setPreferredSize(new Dimension(300, 400));
        PerfExplorerJTabbedPane perfExplorerJTabbedPane = PerfExplorerJTabbedPane.getPane();
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(jScrollPane);
        jSplitPane.setRightComponent(perfExplorerJTabbedPane);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.setJMenuBar(new PerfExplorerMainJMenuBar(this.listener));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        int n2 = 800;
        int n3 = 515;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n4 = dimension.height;
        int n5 = dimension.width;
        Point point = null;
        if (point == null || point.x + n2 > n5 || point.y + n3 > n4) {
            int n6 = (n5 - n2) / 2;
            int n7 = (n4 - n3) / 2;
            if (n6 > 50) {
                n6 -= 50;
            }
            if (n7 > 50) {
                n7 -= 50;
            }
            this.setLocation(n6, n7);
        } else {
            this.setLocation(point);
        }
        mainFrame = this;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem && (string = actionEvent.getActionCommand()).equals("Quit")) {
                System.exit(0);
            }
        }
        catch (Exception exception) {
            System.err.println("actionPerformed Exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option2 = cmdLineParser.addBooleanOption('s', "standalone");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('c', "configfile");
        CmdLineParser.Option option4 = cmdLineParser.addStringOption('e', "engine");
        CmdLineParser.Option option5 = cmdLineParser.addBooleanOption('q', "quiet");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            System.err.println(USAGE);
            System.exit(-1);
        }
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option);
        Boolean bl2 = (Boolean)cmdLineParser.getOptionValue(option2);
        String string = (String)cmdLineParser.getOptionValue(option3);
        String string2 = (String)cmdLineParser.getOptionValue(option4);
        Boolean bl3 = (Boolean)cmdLineParser.getOptionValue(option5);
        int n = 1;
        if (bl != null && bl.booleanValue()) {
            System.err.println(USAGE);
            System.exit(-1);
        }
        if (bl3 == null) {
            bl3 = new Boolean(false);
        }
        if (bl2 == null) {
            bl2 = new Boolean(false);
        }
        if (bl2.booleanValue()) {
            if (string == null) {
                System.err.println("Please enter a valid config file.");
                System.err.println(USAGE);
                System.exit(-1);
            }
            if (string2 == null) {
                System.err.println("Please enter a valid engine type.");
                System.err.println(USAGE);
                System.exit(-1);
            } else if (string2.equalsIgnoreCase("R")) {
                n = 0;
            } else if (string2.equalsIgnoreCase("weka")) {
                n = 1;
            } else {
                System.err.println(USAGE);
                System.exit(-1);
            }
        }
        PerfExplorerClient perfExplorerClient = new PerfExplorerClient(bl2, string, n, bl3);
        perfExplorerClient.pack();
        perfExplorerClient.setVisible(true);
    }
}

