/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PerfExplorerChartWindow;
import client.PerfExplorerConnection;
import client.PerfExplorerModel;
import common.RMIChartData;
import java.util.List;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class PerfExplorerHistogramChart
extends PerfExplorerChartWindow {
    public PerfExplorerHistogramChart(JFreeChart jFreeChart, String string) {
        super(jFreeChart, string);
    }

    public static JFrame doHistogram() {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), 8);
        IntervalXYDataset intervalXYDataset = PerfExplorerHistogramChart.createDataset(rMIChartData);
        JFreeChart jFreeChart = PerfExplorerHistogramChart.createChart(intervalXYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setDisplayToolTips(true);
        XYItemRenderer xYItemRenderer = jFreeChart.getXYPlot().getRenderer();
        xYItemRenderer.setToolTipGenerator(new XYToolTipGenerator(){

            public String generateToolTip(XYDataset xYDataset, int n, int n2) {
                return "<html>Event: " + xYDataset.getSeriesName(n) + "<BR>Count: " + xYDataset.getYValue(n, n2) + "</html>";
            }
        });
        return new PerfExplorerHistogramChart(jFreeChart, "Distributions of Significant Events");
    }

    private static IntervalXYDataset createDataset(RMIChartData rMIChartData) {
        HistogramDataset histogramDataset = new HistogramDataset();
        List list = rMIChartData.getRowLabels();
        double[] dArray = null;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            int n;
            double d;
            List list2 = rMIChartData.getRowData(i);
            dArray = new double[list2.size()];
            double d2 = d = ((double[])list2.get(0))[1];
            for (int j = 1; j < list2.size(); ++j) {
                if (d > ((double[])list2.get(j))[1]) {
                    d = ((double[])list2.get(j))[1];
                }
                if (!(d2 < ((double[])list2.get(j))[1])) continue;
                d2 = ((double[])list2.get(j))[1];
            }
            double d3 = d2 - d;
            for (n = 0; n < list2.size(); ++n) {
                dArray[n] = (((double[])list2.get(n))[1] - d) / d3;
            }
            n = 10;
            if (list2.size() >= 2098) {
                n = 200;
            } else if (list2.size() >= 256) {
                n = 50;
            } else if (list2.size() >= 16) {
                n = 20;
            }
            histogramDataset.addSeries((String)list.get(i), dArray, n);
        }
        return histogramDataset;
    }

    private static IntervalXYDataset createDataset() {
        HistogramDataset histogramDataset = new HistogramDataset();
        double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        histogramDataset.addSeries("H1", dArray, 10, 0.0, 10.0);
        return histogramDataset;
    }

    private static JFreeChart createChart(IntervalXYDataset intervalXYDataset) {
        JFreeChart jFreeChart = ChartFactory.createHistogram((String)"Significant (>2.0% of runtime) Event Histograms", null, null, (IntervalXYDataset)intervalXYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        jFreeChart.getXYPlot().setForegroundAlpha(0.75f);
        return jFreeChart;
    }
}

