/*
 * Decompiled with CFR 0.152.
 */
package client;

import common.RMIView;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import javax.swing.table.AbstractTableModel;

public class PerfExplorerTableModel
extends AbstractTableModel {
    private Application application = null;
    private Experiment experiment = null;
    private Trial trial = null;
    private Metric metric = null;
    private RMIView view = null;
    private int type = -1;
    private String[] columnNames = new String[]{"Field", "Value"};

    public PerfExplorerTableModel(Object object) {
        if (object != null) {
            this.updateObject(object);
        }
    }

    public void updateObject(Object object) {
        if (object instanceof Application) {
            this.application = (Application)object;
            this.type = 0;
        } else if (object instanceof Experiment) {
            this.experiment = (Experiment)object;
            this.type = 1;
        } else if (object instanceof Trial) {
            this.trial = (Trial)object;
            this.type = 2;
        } else if (object instanceof Metric) {
            this.metric = (Metric)object;
            this.type = 3;
        } else if (object instanceof RMIView) {
            this.view = (RMIView)object;
            this.type = 4;
        }
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        switch (this.type) {
            case 0: {
                return this.application.getNumFields() + 2;
            }
            case 1: {
                return this.experiment.getNumFields() + 2;
            }
            case 2: {
                return this.trial.getNumFields() + 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return RMIView.getFieldCount();
            }
        }
        return 0;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        switch (this.type) {
            case 0: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Application ID";
                        }
                    }
                    if (this.application.getFieldName(n - 2) != null) {
                        return this.application.getFieldName(n - 2);
                    }
                    return "";
                }
                switch (n) {
                    case 0: {
                        return this.application.getName();
                    }
                    case 1: {
                        return new Integer(this.application.getID());
                    }
                }
                if (this.application.getField(n - 2) != null) {
                    return this.application.getField(n - 2);
                }
                return "";
            }
            case 1: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Experiment ID";
                        }
                    }
                    if (this.experiment.getFieldName(n - 2) != null) {
                        return this.experiment.getFieldName(n - 2);
                    }
                    return "";
                }
                switch (n) {
                    case 0: {
                        return this.experiment.getName();
                    }
                    case 1: {
                        return new Integer(this.experiment.getID());
                    }
                }
                if (this.experiment.getField(n - 2) != null) {
                    return this.experiment.getField(n - 2);
                }
                return "";
            }
            case 2: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Trial ID";
                        }
                    }
                    if (this.trial.getFieldName(n - 2) != null) {
                        return this.trial.getFieldName(n - 2);
                    }
                    return "";
                }
                switch (n) {
                    case 0: {
                        return this.trial.getName();
                    }
                    case 1: {
                        return new Integer(this.trial.getID());
                    }
                }
                if (this.trial.getField(n - 2) != null) {
                    return this.trial.getField(n - 2);
                }
                return "";
            }
            case 3: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Metric ID";
                        }
                        case 2: {
                            return "Trial ID";
                        }
                    }
                    return "";
                }
                switch (n) {
                    case 0: {
                        return this.metric.getName();
                    }
                    case 1: {
                        return new Integer(this.metric.getID());
                    }
                    case 2: {
                        return new Integer(this.metric.getTrialID());
                    }
                }
                return "";
            }
            case 4: {
                if (n2 == 0) {
                    if (RMIView.getFieldName(n) != null) {
                        return RMIView.getFieldName(n);
                    }
                    return "";
                }
                if (this.view.getField(n) != null) {
                    return this.view.getField(n);
                }
                return "";
            }
        }
        return "";
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }
}

