/*
 * Decompiled with CFR 0.152.
 */
package common;

import edu.uoregon.tau.perfdmf.database.ConnectionManager;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.ParseConfig;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Configure {
    private static String Greeting = "\nNow testing your database connection.\n";
    private String tau_root = "";
    private String db_dbname = "perfdmf";
    private String db_password = "";
    private ParseConfig parser;
    private String configFileName;
    private static String Usage = "Usage: configure [{-h,--help}] [{-g,--configfile} filename] [{-t,--tauroot} path]";

    public Configure(String string, String string2) {
        this.tau_root = string;
    }

    public void initialize(String string) {
        System.out.println(Greeting);
        try {
            this.configFileName = string;
            File file = new File(this.configFileName);
            if (file.exists()) {
                this.parseConfigFile();
            } else {
                System.out.println("Configuration file NOT found...");
                System.out.println("a new configuration file will be created.");
            }
        }
        catch (IOException iOException) {
            System.out.println("I/O Error occurred.");
        }
    }

    public void parseConfigFile() throws IOException, FileNotFoundException {
        this.parser = new ParseConfig(this.configFileName);
        this.db_dbname = this.parser.getDBName();
        this.db_password = this.parser.getDBPasswd();
    }

    public void createDB() {
        DB dB;
        ConnectionManager connectionManager;
        block16: {
            connectionManager = null;
            dB = null;
            try {
                connectionManager = this.db_password != null ? new ConnectionManager(this.configFileName, this.db_password) : new ConnectionManager(this.configFileName);
                connectionManager.connect();
                System.out.println();
                dB = connectionManager.getDB();
            }
            catch (Exception exception) {
                System.out.println("\nPlease make sure that your DBMS is configured correctly, and");
                System.out.println("the database " + this.db_dbname + " has been created.");
                System.exit(0);
            }
            try {
                String string = new String("SELECT * FROM " + dB.getSchemaPrefix() + "analysis_settings");
                ResultSet resultSet = dB.executeQuery(string);
                resultSet.close();
            }
            catch (SQLException sQLException) {
                System.out.print("Perfexplorer tables not found.  Would you like to upload the schema? [y/n]: ");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                String string = "";
                try {
                    string = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    System.exit(-1);
                }
                if (!string.equals("y") && !string.equals("Y")) break block16;
                String string2 = "";
                if (dB.getDBType().compareTo("oracle") == 0) {
                    string2 = this.tau_root + "/tools/src/perfexplorer/etc/dbschema.oracle";
                } else if (dB.getDBType().compareTo("mysql") == 0) {
                    string2 = this.tau_root + "/tools/src/perfexplorer/etc/dbschema.mysql";
                } else if (dB.getDBType().compareTo("postgresql") == 0) {
                    string2 = this.tau_root + "/tools/src/perfexplorer/etc/dbschema.postgresql";
                } else {
                    System.out.println("Unknown database type: " + dB.getDBType());
                    System.exit(-1);
                }
                System.out.println("Uploading Schema: " + string2);
                if (connectionManager.genParentSchema(string2) == 0) {
                    System.out.println("Successfully uploaded schema\n");
                }
                System.out.println("Error uploading schema\n");
                System.exit(-1);
            }
        }
        try {
            if (dB.checkSchema() != 0) {
                System.out.println("\nIncompatible schema found.  Please contact us at tau-team@cs.uoregon.edu\nfor a conversion script.");
                System.exit(0);
            }
        }
        catch (SQLException sQLException) {
            System.out.println("\nError trying to confirm schema:");
            sQLException.printStackTrace();
            System.exit(0);
        }
        connectionManager.dbclose();
        System.out.println("Database connection successful.");
        System.out.println("Configuration complete.");
    }

    public static void main(String[] stringArray) {
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addStringOption('g', "configfile");
        CmdLineParser.Option option2 = cmdLineParser.addStringOption('t', "tauroot");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('a', "arch");
        CmdLineParser.Option option4 = cmdLineParser.addBooleanOption('h', "help");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            System.err.println(Usage);
            System.exit(-1);
        }
        String string = (String)cmdLineParser.getOptionValue(option);
        String string2 = (String)cmdLineParser.getOptionValue(option2);
        String string3 = (String)cmdLineParser.getOptionValue(option3);
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option4);
        if (bl != null && bl.booleanValue()) {
            System.err.println(Usage);
            System.exit(-1);
        }
        if (string == null) {
            string = new String("");
        }
        if (string2 == null) {
            string2 = new String("");
        }
        if (string3 == null) {
            string3 = new String("");
        }
        Configure configure = new Configure(string2, string3);
        configure.tau_root = string2;
        configure.initialize(string);
        configure.createDB();
    }
}

