/*
 * Decompiled with CFR 0.152.
 */
package server;

import common.RMIChartData;
import common.RMIPerfExplorerModel;
import common.RMIView;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.database.DB;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import server.PerfExplorerServer;

public class ChartData
extends RMIChartData {
    private RMIPerfExplorerModel model;
    private String metricName = null;
    private String groupName = null;
    private String eventName = null;
    private String groupByColumn = null;
    private boolean preQuery = false;
    private List columnValues = null;

    public ChartData(RMIPerfExplorerModel rMIPerfExplorerModel, int n) {
        super(n);
        this.model = rMIPerfExplorerModel;
        this.metricName = rMIPerfExplorerModel.getMetricName();
        this.groupName = rMIPerfExplorerModel.getGroupName();
        this.eventName = rMIPerfExplorerModel.getEventName();
    }

    public static ChartData getChartData(RMIPerfExplorerModel rMIPerfExplorerModel, int n) {
        System.out.println("getChartData(" + rMIPerfExplorerModel.toString() + ")...");
        ChartData chartData = new ChartData(rMIPerfExplorerModel, n);
        chartData.doQuery();
        return chartData;
    }

    private void doQuery() {
        PerfExplorerServer.getServer().getControl().WAIT("doQuery");
        Object object = null;
        try {
            Object object2;
            ResultSet resultSet;
            String string = null;
            String string2 = null;
            double d = 0.0;
            double d2 = 0.0;
            String string3 = "";
            int n = -1;
            if (this.dataType == 9) {
                this.columnValues = new ArrayList();
                this.preQuery = true;
                object = this.buildStatement();
                resultSet = object.executeQuery();
                while (resultSet.next()) {
                    string = resultSet.getString(1);
                    string2 = resultSet.getString(2);
                    d2 = resultSet.getDouble(2);
                    d = resultSet.getDouble(3);
                    if (this.metricName.toLowerCase().indexOf("time") != -1) {
                        d /= 1000000.0;
                    }
                    if (!string3.equals(string)) {
                        ++n;
                        string3 = string;
                        this.addRow(string);
                    }
                    this.addColumn(n, d2, d);
                    this.columnValues.add(new Double(d2));
                }
                resultSet.close();
                object.close();
                this.preQuery = false;
            }
            object = this.buildStatement();
            resultSet = object.executeQuery();
            int n2 = 0;
            while (resultSet.next()) {
                string = resultSet.getString(1);
                string2 = resultSet.getString(2);
                d2 = resultSet.getDouble(2);
                d = resultSet.getDouble(3);
                if (this.metricName.toLowerCase().indexOf("time") != -1 && this.dataType != 0) {
                    d /= 1000000.0;
                }
                if (!string3.equals(string)) {
                    ++n;
                    string3 = string;
                    this.addRow(string);
                    n2 = 0;
                }
                if (this.dataType == 9) {
                    object2 = (Double)this.columnValues.get(n2);
                    while ((Double)object2 < d2) {
                        this.addColumn(n, (Double)object2, 0.0);
                        object2 = (Double)this.columnValues.get(++n2);
                    }
                    ++n2;
                }
                this.addColumn(n, d2, d);
            }
            resultSet.close();
            object.close();
            object = this.buildOtherStatement();
            if (object != null) {
                resultSet = object.executeQuery();
                while (resultSet.next()) {
                    string = "other";
                    string2 = resultSet.getString(1);
                    d2 = resultSet.getDouble(1);
                    d = resultSet.getDouble(2);
                    if (this.metricName.toLowerCase().indexOf("time") != -1 && this.dataType != 0) {
                        d /= 1000000.0;
                    }
                    if (!string3.equals(string)) {
                        ++n;
                        string3 = string;
                        this.addRow(string);
                    }
                    this.addColumn(n, d2, d);
                }
                resultSet.close();
                object.close();
            }
            try {
                if (this.dataType == 4 || this.dataType == 9) {
                    object2 = PerfExplorerServer.getServer().getDB();
                    if (object2.getDBType().compareTo("oracle") == 0) {
                        object = object2.prepareStatement("truncate table working_table");
                        object.execute();
                        object.close();
                    }
                    object = object2.prepareStatement("drop table working_table");
                    object.execute();
                    object.close();
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            System.out.println(object.toString());
            String string = "ERROR: Couldn't select the analysis settings from the database!";
            System.out.println(string);
            exception.printStackTrace();
            PerfExplorerServer.getServer().getControl().SIGNAL("doQuery");
        }
        PerfExplorerServer.getServer().getControl().SIGNAL("doQuery");
    }

    private PreparedStatement buildStatement() throws SQLException {
        DB dB = PerfExplorerServer.getServer().getDB();
        PreparedStatement preparedStatement = null;
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.model.getCurrentSelection();
        if (this.dataType == 0 || this.dataType == 9 && this.preQuery) {
            stringBuffer.append("select ie.name, ");
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            if (this.preQuery) {
                stringBuffer.append("ims.inclusive ");
            } else {
                stringBuffer.append("ims.exclusive_percentage ");
            }
            stringBuffer.append("from interval_mean_summary ims ");
            stringBuffer.append("inner join interval_event ie ");
            stringBuffer.append("on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, true));
            } else {
                stringBuffer.append("where t.experiment = ");
                stringBuffer.append(this.model.getExperiment().getID() + " ");
            }
            stringBuffer.append(" and m.name = ? ");
            if (this.preQuery) {
                stringBuffer.append("and ims.inclusive_percentage = 100.0");
            } else {
                stringBuffer.append("and ims.exclusive_percentage > ");
                stringBuffer.append(this.model.getXPercent());
            }
            stringBuffer.append(" and (ie.group_name is null or (");
            stringBuffer.append("ie.group_name not like '%TAU_CALLPATH%' ");
            stringBuffer.append("and ie.group_name not like '%TAU_PHASE%')) ");
            stringBuffer.append("order by 1, 2");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
        } else if (this.dataType == 1) {
            List list = this.model.getMultiSelection();
            stringBuffer.append("select ");
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    stringBuffer.append(" " + this.model.getViewSelectionString() + ", ");
                } else {
                    stringBuffer.append(" " + this.groupByColumn + ", ");
                }
            } else {
                stringBuffer.append(" e.name, ");
            }
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            stringBuffer.append("ims.inclusive from interval_mean_summary ims ");
            stringBuffer.append("inner join interval_event ie on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, true));
            } else {
                stringBuffer.append("inner join experiment e on t.experiment = e.id ");
                stringBuffer.append("where t.experiment in (");
                if (list == null) {
                    stringBuffer.append(this.model.getExperiment().getID());
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        Experiment experiment = (Experiment)list.get(i);
                        if (i > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(experiment.getID());
                    }
                }
                stringBuffer.append(")");
            }
            stringBuffer.append(" and m.name = ? and ims.inclusive_percentage = 100.0 ");
            stringBuffer.append(" and (ie.group_name is null or (");
            stringBuffer.append("ie.group_name not like '%TAU_CALLPATH%' ");
            stringBuffer.append("and ie.group_name not like '%TAU_PHASE%')) ");
            stringBuffer.append(" order by 1, 2");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
        } else if (this.dataType == 3) {
            stringBuffer.append("select ");
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    stringBuffer.append(" " + this.model.getViewSelectionString() + ", ");
                } else {
                    stringBuffer.append(" " + this.groupByColumn + ", ");
                }
            } else {
                stringBuffer.append(" e.name, ");
            }
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append("sum(ims.excl) from interval_mean_summary ims ");
            } else {
                stringBuffer.append("sum(ims.exclusive) from interval_mean_summary ims ");
            }
            stringBuffer.append("inner join interval_event ie on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            stringBuffer.append("inner join experiment e on t.experiment = e.id ");
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, false));
            } else {
                stringBuffer.append("where t.experiment in (");
                List list = this.model.getMultiSelection();
                if (list == null) {
                    stringBuffer.append(this.model.getExperiment().getID());
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        Experiment experiment = (Experiment)list.get(i);
                        if (i > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(experiment.getID());
                    }
                }
                stringBuffer.append(") ");
            }
            stringBuffer.append(" and m.name = ? ");
            stringBuffer.append(" and ie.group_name = ? group by ");
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    stringBuffer.append(" " + this.model.getViewSelectionString() + ", ");
                } else {
                    stringBuffer.append(" " + this.groupByColumn + ", ");
                }
            } else {
                stringBuffer.append(" e.name, ");
            }
            stringBuffer.append("(t.node_count * t.contexts_per_node * ");
            stringBuffer.append("t.threads_per_context), ie.group_name order by 1, 2");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
            preparedStatement.setString(2, this.groupName);
        } else if (this.dataType == 4 || this.dataType == 9 && !this.preQuery) {
            String string;
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append("create global temporary table working_table (name varchar2(4000)) ");
            } else {
                stringBuffer.append("create temporary table working_table (name text) ");
            }
            try {
                preparedStatement = dB.prepareStatement(stringBuffer.toString());
                preparedStatement.execute();
                preparedStatement.close();
            }
            catch (Exception exception) {
                System.out.println(preparedStatement.toString());
                string = "ERROR: Couldn't select the analysis settings from the database!";
                System.out.println(string);
                exception.printStackTrace();
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("insert into working_table (select distinct ");
            stringBuffer.append("ie.name from interval_mean_summary ims ");
            stringBuffer.append("inner join interval_event ie on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, true));
            } else {
                stringBuffer.append("where t.experiment = ");
                stringBuffer.append(this.model.getExperiment().getID() + " ");
            }
            stringBuffer.append(" and m.name = ? ");
            stringBuffer.append("and ims.exclusive_percentage > ");
            stringBuffer.append(this.model.getXPercent());
            stringBuffer.append(" and (ie.group_name is null or (");
            stringBuffer.append("ie.group_name not like '%TAU_CALLPATH%' ");
            stringBuffer.append("and ie.group_name not like '%TAU_PHASE%')) ");
            stringBuffer.append("and ims.inclusive_percentage < 100.0) ");
            try {
                preparedStatement = dB.prepareStatement(stringBuffer.toString());
                preparedStatement.setString(1, this.metricName);
                preparedStatement.execute();
                preparedStatement.close();
            }
            catch (Exception exception) {
                System.out.println(preparedStatement.toString());
                string = "ERROR: Couldn't select the analysis settings from the database!";
                System.out.println(string);
                exception.printStackTrace();
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("select distinct ");
            stringBuffer.append("ie.name, ");
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            if (this.dataType == 9) {
                if (dB.getDBType().compareTo("oracle") == 0) {
                    stringBuffer.append("ims.excl from interval_mean_summary ims ");
                } else {
                    stringBuffer.append("ims.exclusive from interval_mean_summary ims ");
                }
            } else if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append("ims.excl from interval_mean_summary ims ");
            } else {
                stringBuffer.append("ims.exclusive from interval_mean_summary ims ");
            }
            stringBuffer.append("inner join interval_event ie on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            stringBuffer.append("inner join working_table w on w.name = ie.name ");
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, true));
            } else {
                stringBuffer.append("where t.experiment = ");
                stringBuffer.append(this.model.getExperiment().getID() + " ");
            }
            stringBuffer.append(" and m.name = ? order by 1, 2 ");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
        } else if (this.dataType == 5) {
            stringBuffer.append("select ");
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    stringBuffer.append(" " + this.model.getViewSelectionString() + ", ");
                } else {
                    stringBuffer.append(" " + this.groupByColumn + ", ");
                }
            } else {
                stringBuffer.append(" e.name, ");
            }
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            stringBuffer.append("exclusive from interval_mean_summary ims ");
            stringBuffer.append("inner join interval_event ie on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, true));
            } else {
                stringBuffer.append("inner join experiment e on t.experiment = e.id ");
                stringBuffer.append("where t.experiment in (");
                List list = this.model.getMultiSelection();
                if (list == null) {
                    stringBuffer.append(this.model.getExperiment().getID());
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        Experiment experiment = (Experiment)list.get(i);
                        if (i > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(experiment.getID());
                    }
                }
                stringBuffer.append(") ");
            }
            stringBuffer.append(" and m.name = ? ");
            stringBuffer.append("and ie.name = ? order by 1, 2");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
            preparedStatement.setString(2, this.eventName);
        } else if (this.dataType == 6) {
            stringBuffer.append("select ");
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    stringBuffer.append(" " + this.model.getViewSelectionString() + ", ");
                } else {
                    stringBuffer.append(" " + this.groupByColumn + ", ");
                }
            } else {
                stringBuffer.append(" ie.name, ");
            }
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            stringBuffer.append("ims.inclusive from interval_mean_summary ims ");
            stringBuffer.append("inner join interval_event ie on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            stringBuffer.append("where t.experiment = ? and m.name = ? ");
            stringBuffer.append("and ie.group_name like '%TAU_PHASE%' order by 1, 2");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.model.getExperiment().getID());
            preparedStatement.setString(2, this.metricName);
        } else if (this.dataType == 7 || this.dataType == 9) {
            stringBuffer.append("select ");
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    stringBuffer.append(" " + this.model.getViewSelectionString() + ", ");
                } else {
                    stringBuffer.append(" " + this.groupByColumn + ", ");
                }
            } else {
                stringBuffer.append(" ie.name, ");
            }
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            stringBuffer.append("ims.inclusive_percentage from interval_mean_summary ims ");
            stringBuffer.append("inner join interval_event ie on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            preparedStatement = null;
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, true));
            } else {
                stringBuffer.append("where t.experiment = ");
                stringBuffer.append(this.model.getExperiment().getID() + " ");
            }
            stringBuffer.append(" and m.name = ? ");
            stringBuffer.append("and ie.group_name like '%TAU_PHASE%' order by 1, 2");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
        } else if (this.dataType == 8) {
            int n = 1;
            int n2 = 16;
            stringBuffer.append("select ie.name, (p.node*");
            stringBuffer.append(n * n2);
            stringBuffer.append(") + (p.context*");
            stringBuffer.append(n2);
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append(") + p.thread as thread, p.excl ");
            } else {
                stringBuffer.append(") + p.thread as thread, p.exclusive_percentage ");
            }
            stringBuffer.append("from interval_event ie ");
            stringBuffer.append("inner join interval_mean_summary s ");
            stringBuffer.append("on ie.id = s.interval_event and s.exclusive_percentage > ");
            stringBuffer.append(this.model.getXPercent());
            stringBuffer.append(" left outer join interval_location_profile p ");
            stringBuffer.append("on ie.id = p.interval_event ");
            stringBuffer.append("and p.metric = s.metric where ie.trial = ? ");
            stringBuffer.append(" and p.metric = ? ");
            stringBuffer.append(" and (ie.group_name is null or (");
            stringBuffer.append("ie.group_name not like '%TAU_CALLPATH%' ");
            stringBuffer.append("and ie.group_name not like '%TAU_PHASE%')) ");
            stringBuffer.append(" order by 1,2 ");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.model.getTrial().getID());
            preparedStatement.setInt(2, ((Metric)this.model.getCurrentSelection()).getID());
        }
        return preparedStatement;
    }

    private PreparedStatement buildOtherStatement() throws SQLException {
        DB dB = PerfExplorerServer.getServer().getDB();
        PreparedStatement preparedStatement = null;
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.model.getCurrentSelection();
        if (this.dataType == 0) {
            stringBuffer.append("select ");
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            stringBuffer.append("sum(ims.exclusive_percentage) from interval_mean_summary ims ");
            stringBuffer.append("inner join interval_event ie ");
            stringBuffer.append("on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, true));
            } else {
                stringBuffer.append("where t.experiment = ");
                stringBuffer.append(this.model.getExperiment().getID() + " ");
            }
            stringBuffer.append(" and m.name = ? ");
            stringBuffer.append("and ims.inclusive_percentage < 100.0 ");
            stringBuffer.append("and ims.exclusive_percentage < ");
            stringBuffer.append(this.model.getXPercent());
            stringBuffer.append(" and (ie.group_name is null or (");
            stringBuffer.append("ie.group_name not like '%TAU_CALLPATH%' ");
            stringBuffer.append("and ie.group_name not like '%TAU_PHASE%')) group by (t.node_count * t.contexts_per_node * t.threads_per_context) order by 1");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
        } else if (this.dataType == 4) {
            stringBuffer.append("select ");
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append("sum(ims.excl) from interval_mean_summary ims ");
            } else {
                stringBuffer.append("sum(ims.exclusive) from interval_mean_summary ims ");
            }
            stringBuffer.append("inner join interval_event ie on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            stringBuffer.append("left outer join working_table w on w.name = ie.name ");
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, true));
            } else {
                stringBuffer.append("where t.experiment = ");
                stringBuffer.append(this.model.getExperiment().getID() + " ");
            }
            stringBuffer.append(" and m.name = ? ");
            stringBuffer.append("and w.name is null ");
            stringBuffer.append("group by (t.node_count * t.contexts_per_node ");
            stringBuffer.append("* t.threads_per_context) order by 1 ");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
        }
        return preparedStatement;
    }

    private boolean isLeafView() {
        DB dB = PerfExplorerServer.getServer().getDB();
        PreparedStatement preparedStatement = null;
        boolean bl = true;
        try {
            preparedStatement = dB.prepareStatement("select table_name, column_name from trial_view where parent = ?");
            preparedStatement.setString(1, this.model.getViewID());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString(1);
                this.groupByColumn = string.equalsIgnoreCase("Application") ? new String("a.") : (string.equalsIgnoreCase("Experiment") ? new String("e.") : new String("t."));
                this.groupByColumn = this.groupByColumn + resultSet.getString(2);
                bl = false;
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select the analysis settings from the database!";
            System.out.println(string);
            exception.printStackTrace();
        }
        return bl;
    }
}

