package client;
import edu.uoregon.tau.perfdmf.*;

import javax.swing.table.*;
import common.RMIView;

public class PerfExplorerTableModel extends AbstractTableModel{

	private Application application = null;
	private Experiment experiment = null;
	private Trial trial = null;
	private Metric metric = null;
	private RMIView view = null;
	private int type = -1;
	private String[] columnNames = { "Field", "Value" };

	public PerfExplorerTableModel(Object object){
		super();
		if (object != null)
			updateObject(object);
	}
  
  	public void updateObject(Object object) {
		if(object instanceof Application){
			this.application = (Application)object;
			type = 0;
		}
		else if(object instanceof Experiment){
			this.experiment = (Experiment)object;
			type = 1;
		}
		else if(object instanceof Trial){
			this.trial = (Trial)object;
			type = 2;
		}
		else if(object instanceof Metric){
			this.metric = (Metric) object;
			type = 3;
		}
		else if(object instanceof RMIView){
			this.view = (RMIView) object;
			type = 4;
		}
		fireTableDataChanged();
	}
  
	public int getColumnCount(){ return 2;}
  
	public int getRowCount(){
		switch(type){
		case 0:
			return application.getNumFields()+2;
		case 1:
			return experiment.getNumFields()+2;
		case 2:
			return trial.getNumFields()+2;
		case 3:
			return 3;
		case 4:
			return RMIView.getFieldCount();
		default:
			return 0;
		}
	}
  
	public String getColumnName(int c){ return columnNames[c];}
  
	public Object getValueAt(int r, int c){
	switch(type) {
		case 0:
			if(c==0) {
				switch(r) {
					case(0):
						return "Name";
					case(1):
						return "Application ID";
					default:
						if (application.getFieldName(r-2) != null)
							return application.getFieldName(r-2);
						else
							return "";
				}
			} else {
				switch(r){
					case(0):
						return application.getName();
					case(1):
						return new Integer(application.getID());
					default:
						if (application.getField(r-2) != null)
							return application.getField(r-2);
						else
							return "";
				}
			}
		case 1:
			if(c==0) {
				switch(r) {
					case(0):
						return "Name";
					case(1):
						return "Experiment ID";
					default:
						if (experiment.getFieldName(r-2) != null)
							return experiment.getFieldName(r-2);
						else
							return "";
				}
			} else {
				switch(r) {
					case(0):
						return experiment.getName();
					case(1):
						return new Integer(experiment.getID());
					default:
						if (experiment.getField(r-2) != null)
							return experiment.getField(r-2);
						else
							return "";
				}
			}
		case 2:
			if(c==0) {
				switch(r) {
					case(0):
						return "Name";
					case(1):
						return "Trial ID";
					default:
						if (trial.getFieldName(r-2) != null)
							return trial.getFieldName(r-2);
						else
							return "";
				}
			} else {
				switch(r){
					case(0):
						return trial.getName();
					case(1):
						return new Integer(trial.getID());
					default:
						if (trial.getField(r-2) != null)
							return trial.getField(r-2);
						else
							return "";
				}
			}
		case 3:
			if(c==0) {
				switch(r){
					case(0):
						return "Name";
					case(1):
						return "Metric ID";
					case(2):
						return "Trial ID";
					default:
						return "";
				}
			} else {
				switch(r) {
					case(0):
						return metric.getName();
					case(1):
						return new Integer(metric.getID());
					case(2):
						return new Integer(metric.getTrialID());
					default:
						return "";
				}
			}
		case 4:
			if(c==0) {
				if (RMIView.getFieldName(r) != null)
					return RMIView.getFieldName(r);
				else
					return "";
			} else {
				if (view.getField(r) != null)
					return view.getField(r);
				else
					return "";
			}
		default:
			return "";
	}
	}
  
	public boolean isCellEditable(int r, int c){ return false; }
}
