/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Snapshot;
import edu.uoregon.tau.perfdmf.SnapshotDataSource;
import edu.uoregon.tau.perfdmf.Thread;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SnapshotXMLHandler
extends DefaultHandler {
    private SnapshotDataSource dataSource;
    private Map threadMap = new HashMap();
    private ThreadData currentThread;
    private Snapshot currentSnapshot;
    private Date currentDate;
    private int[] currentMetrics;
    private StringBuffer accumulator = new StringBuffer();
    private int currentId;
    private String currentName;
    private String currentGroup;
    private long currentTimestamp;

    public SnapshotXMLHandler(SnapshotDataSource snapshotDataSource) {
        this.dataSource = snapshotDataSource;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    private void handleMetric(String string) {
        Metric metric = this.dataSource.addMetric(string);
        this.currentThread.metricMap.put(new Integer(this.currentId), metric);
    }

    private void handleEvent(String string, String string2) {
        int n = this.currentId;
        Function function = this.dataSource.addFunction(string);
        this.dataSource.addGroups(string2, function);
        this.currentThread.eventMap.put(new Integer(n), function);
    }

    private void handleThread(Attributes attributes) {
        String string = attributes.getValue("id");
        int n = Integer.parseInt(attributes.getValue("node"));
        int n2 = Integer.parseInt(attributes.getValue("context"));
        int n3 = Integer.parseInt(attributes.getValue("thread"));
        ThreadData threadData = new ThreadData();
        threadData.thread = this.dataSource.addThread(n, n2, n3);
        this.threadMap.put(string, threadData);
    }

    private void handleDefinitions(Attributes attributes) {
        String string = attributes.getValue("thread");
        this.currentThread = (ThreadData)this.threadMap.get(string);
    }

    private void handleProfile(Attributes attributes) {
        String string = attributes.getValue("thread");
        this.currentThread = (ThreadData)this.threadMap.get(string);
        this.currentSnapshot = this.currentThread.thread.addSnapshot("");
    }

    private void handleIntervalData(Attributes attributes) {
        String string = attributes.getValue("metrics");
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
        this.currentMetrics = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            this.currentMetrics[n++] = n2;
        }
    }

    private void handleIntervalDataEnd() {
        String string = this.accumulator.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            Function function = (Function)this.currentThread.eventMap.get(new Integer(n));
            FunctionProfile functionProfile = this.currentThread.thread.getFunctionProfile(function);
            if (functionProfile == null) {
                functionProfile = new FunctionProfile(function, this.dataSource.getNumberOfMetrics(), this.currentThread.thread.getSnapshots().size());
                this.currentThread.thread.addFunctionProfile(functionProfile);
            }
            double d = Double.parseDouble(stringTokenizer.nextToken());
            double d2 = Double.parseDouble(stringTokenizer.nextToken());
            for (int i = 0; i < this.currentMetrics.length; ++i) {
                int n2 = this.currentMetrics[i];
                Metric metric = (Metric)this.currentThread.metricMap.get(new Integer(n2));
                double d3 = Double.parseDouble(stringTokenizer.nextToken());
                double d4 = Double.parseDouble(stringTokenizer.nextToken());
                functionProfile.setExclusive(metric.getID(), d3);
                functionProfile.setInclusive(metric.getID(), d4);
            }
            functionProfile.setNumCalls(d);
            functionProfile.setNumSubr(d2);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals("thread")) {
            this.handleThread(attributes);
        } else if (string2.equals("name")) {
            this.accumulator = new StringBuffer();
        } else if (string2.equals("group")) {
            this.accumulator = new StringBuffer();
        } else if (string2.equals("utc_date")) {
            this.accumulator = new StringBuffer();
        } else if (string2.equals("timestamp")) {
            this.accumulator = new StringBuffer();
        } else if (string2.equals("definitions")) {
            this.handleDefinitions(attributes);
        } else if (string2.equals("metric")) {
            this.currentId = Integer.parseInt(attributes.getValue("id"));
        } else if (string2.equals("event")) {
            this.currentId = Integer.parseInt(attributes.getValue("id"));
        } else if (string2.equals("profile")) {
            this.handleProfile(attributes);
        } else if (string2.equals("interval_data")) {
            this.handleIntervalData(attributes);
            this.accumulator = new StringBuffer();
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equals("thread_definition")) {
            this.currentThread = null;
        } else if (string2.equals("name")) {
            this.currentName = this.accumulator.toString();
        } else if (string2.equals("utc_date")) {
            try {
                this.currentDate = DataSource.dateTime.parse(this.accumulator.toString());
            }
            catch (ParseException parseException) {}
        } else if (string2.equals("timestamp")) {
            this.currentTimestamp = Long.parseLong(this.accumulator.toString());
        } else if (string2.equals("group")) {
            this.currentGroup = this.accumulator.toString();
        } else if (string2.equals("profile")) {
            this.currentSnapshot.setName(this.currentName);
            this.currentSnapshot.setTimestamp(this.currentTimestamp);
        } else if (string2.equals("metric")) {
            this.handleMetric(this.currentName);
        } else if (string2.equals("event")) {
            this.handleEvent(this.currentName, this.currentGroup);
        } else if (string2.equals("interval_data")) {
            this.handleIntervalDataEnd();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.accumulator.append(cArray, n, n2);
    }

    private static class ThreadData {
        public Thread thread;
        public Map metricMap = new HashMap();
        public Map eventMap = new HashMap();

        private ThreadData() {
        }
    }
}

