/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.MetaDataParser;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class TauDataSource
extends DataSource {
    private volatile boolean abort = false;
    private volatile int totalFiles = 0;
    private volatile int filesRead = 0;
    private boolean profileStatsPresent = false;
    private boolean groupCheck = false;
    private List dirs;
    private File fileToMonitor;
    static /* synthetic */ Class class$java$io$FileInputStream;

    public TauDataSource(List list) {
        File[] fileArray;
        this.dirs = list;
        if (list.size() > 0 && (fileArray = (File[])list.get(0)).length > 0) {
            this.fileToMonitor = fileArray[0];
        }
    }

    public void cancelLoad() {
        this.abort = true;
    }

    public int getProgress() {
        if (this.totalFiles != 0) {
            return (int)((float)this.filesRead / (float)this.totalFiles * 100.0f);
        }
        return 0;
    }

    public List getFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(this.fileToMonitor);
        return arrayList;
    }

    public void load() throws FileNotFoundException, IOException, DataSourceException {
        int n;
        Object object;
        long l = System.currentTimeMillis();
        boolean bl = false;
        try {
            object = (class$java$io$FileInputStream == null ? (class$java$io$FileInputStream = TauDataSource.class$("java.io.FileInputStream")) : class$java$io$FileInputStream).getMethod("getChannel", null);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        object = this.dirs.iterator();
        while (object.hasNext()) {
            File[] fileArray = (File[])object.next();
            for (n = 0; n < fileArray.length; ++n) {
                ++this.totalFiles;
            }
        }
        boolean bl2 = false;
        int n2 = 0;
        n = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        String string = null;
        Iterator iterator = this.dirs.iterator();
        while (iterator.hasNext()) {
            File[] fileArray = (File[])iterator.next();
            n = 0;
            for (int i = 0; i < fileArray.length; ++i) {
                boolean bl3 = false;
                int n6 = 0;
                while (!bl3) {
                    Object object2;
                    Object object3;
                    Thread thread = null;
                    try {
                        int n7;
                        int n8;
                        int n9;
                        InputStreamReader inputStreamReader;
                        BufferedReader bufferedReader;
                        ++this.filesRead;
                        if (this.abort) {
                            return;
                        }
                        int[] nArray = TauDataSource.getNCT(fileArray[i].getName());
                        if (nArray == null && this.dirs.size() == 1 && fileArray.length == 1) {
                            throw new DataSourceException(fileArray[i].getName() + ": This doesn't look like a TAU profile\nDid you mean do use the -f option to specify a file format?");
                        }
                        if (nArray == null) {
                            bl3 = true;
                            continue;
                        }
                        n3 = nArray[0];
                        n4 = nArray[1];
                        n5 = nArray[2];
                        thread = this.addThread(n3, n4, n5);
                        bl2 = true;
                        object3 = new FileInputStream(fileArray[i]);
                        FileLock fileLock = null;
                        if (bl) {
                            object2 = ((FileInputStream)object3).getChannel();
                            try {
                                fileLock = ((FileChannel)object2).lock(0L, Long.MAX_VALUE, true);
                            }
                            catch (IOException iOException) {
                                bl = false;
                                fileLock = null;
                            }
                        }
                        if ((string = (bufferedReader = new BufferedReader(inputStreamReader = new InputStreamReader((InputStream)object3))).readLine()) == null) {
                            throw new DataSourceException("Unexpected end of file: " + fileArray[i].getName() + "\nLooking for 'templated_functions' line");
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
                        String string2 = stringTokenizer.nextToken();
                        try {
                            n9 = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new DataSourceException(fileArray[i].getName() + ": Couldn't read number of functions, bad TAU Profile?");
                        }
                        if (n == 0) {
                            String string3 = this.getMetricName(string);
                            if (string3 == null) {
                                string3 = new String("Time");
                            }
                            this.addMetric(string3);
                            n = 1;
                        }
                        if ((string = bufferedReader.readLine()) == null) {
                            throw new DataSourceException("Unexpected end of file: " + fileArray[i].getName() + "\nLooking for '# Name Calls ...' line");
                        }
                        if (string.indexOf("<metadata>") != -1) {
                            int n10 = string.indexOf("<metadata>");
                            n8 = string.indexOf("</metadata>") + 11;
                            String string4 = string.substring(n10, n8);
                            MetaDataParser.parse(thread.getMetaData(), string4);
                        }
                        if (i == 0 && string.indexOf("SumExclSqr") != -1) {
                            this.setProfileStatsPresent(true);
                        }
                        for (n7 = 0; n7 < n9; ++n7) {
                            string = bufferedReader.readLine();
                            if (string == null) {
                                throw new DataSourceException("Unexpected end of file: " + fileArray[i].getName() + "\nOnly found " + (n7 - 2) + " of " + n9 + " Function Lines");
                            }
                            this.processFunctionLine(string, thread, n2);
                        }
                        string = bufferedReader.readLine();
                        if (string == null) {
                            throw new DataSourceException("Unexpected end of file: " + fileArray[i].getName() + "\nLooking for 'aggregates' line");
                        }
                        stringTokenizer = new StringTokenizer(string, " \t\n\r");
                        string2 = stringTokenizer.nextToken();
                        n9 = Integer.parseInt(string2);
                        for (n7 = 0; n7 < n9; ++n7) {
                            string = bufferedReader.readLine();
                        }
                        if (n2 == 0 && (string = bufferedReader.readLine()) != null) {
                            stringTokenizer = new StringTokenizer(string, " \t\n\r");
                            string2 = stringTokenizer.nextToken();
                            n7 = Integer.parseInt(string2);
                            bufferedReader.readLine();
                            for (n8 = 0; n8 < n7; ++n8) {
                                if (n8 == 0) {
                                    this.setUserEventsPresent(true);
                                }
                                if ((string = bufferedReader.readLine()) == null) {
                                    throw new DataSourceException("Unexpected end of file: " + fileArray[i].getName() + "\nOnly found " + (n8 - 2) + " of " + n7 + " User Event Lines");
                                }
                                this.processUserEventLine(string, thread);
                            }
                        }
                        if (fileLock != null) {
                            fileLock.release();
                        }
                        bufferedReader.close();
                        inputStreamReader.close();
                        ((FileInputStream)object3).close();
                        bl3 = true;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (!(exception instanceof IOException) && !(exception instanceof FileNotFoundException)) {
                            throw new RuntimeException(exception == null ? null : exception.toString());
                        }
                        try {
                            java.lang.Thread.sleep(250L);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        if (n6 > 5) {
                            System.err.println("too many exceptions caught");
                            exception.printStackTrace();
                            bl3 = true;
                        } else if (thread != null) {
                            object3 = thread.getFunctionProfileIterator();
                            while (object3.hasNext()) {
                                object2 = (FunctionProfile)object3.next();
                                if (object2 == null) continue;
                                for (int j = 0; j < this.getNumberOfMetrics(); ++j) {
                                    ((FunctionProfile)object2).setExclusive(j, 0.0);
                                    ((FunctionProfile)object2).setInclusive(j, 0.0);
                                }
                                ((FunctionProfile)object2).setNumSubr(0.0);
                                ((FunctionProfile)object2).setNumCalls(0.0);
                            }
                        }
                        ++n6;
                    }
                }
            }
            ++n2;
        }
        if (!bl2) {
            throw new DataSourceException("Didn't find any valid files.\nAre you sure these are TAU profiles? (e.g. profile.*.*.*)");
        }
        this.generateDerivedData();
        this.aggregateMetaData();
    }

    public String toString() {
        return this.getClass().getName();
    }

    public static int[] getNCT(String string) {
        try {
            int[] nArray = new int[3];
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".\t\n\r");
            stringTokenizer.nextToken();
            nArray[0] = Integer.parseInt(stringTokenizer.nextToken());
            nArray[1] = Integer.parseInt(stringTokenizer.nextToken());
            nArray[2] = Integer.parseInt(stringTokenizer.nextToken());
            if (nArray[0] < 0 || nArray[1] < 0 || nArray[2] < 0) {
                return null;
            }
            return nArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getMetricName(String string) {
        String string2 = null;
        int n = string.indexOf("_MULTI_");
        if (n > 0) {
            string2 = string.substring(n + 7);
            return string2;
        }
        n = string.indexOf("hw_counters");
        if (n > 0) {
            return "Hardware Counter";
        }
        return string2;
    }

    private void processFunctionLine(String string, Thread thread, int n) throws DataSourceException {
        StringTokenizer stringTokenizer;
        String string2;
        Object object;
        String string3 = this.getGroupNames(string);
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\"') continue;
            ++n2;
        }
        if (n2 == 0) {
            throw new DataSourceException("Looking for function line, found '" + string + "' instead");
        }
        if (n2 == 2 || n2 == 4) {
            object = new StringTokenizer(string, "\"");
            string2 = ((StringTokenizer)object).nextToken();
            stringTokenizer = new StringTokenizer(((StringTokenizer)object).nextToken(), " \t\n\r");
        } else {
            int n3;
            int n4 = 0;
            for (n3 = 0; n4 < n2 - 2 && n3 < string.length(); ++n3) {
                if (string.charAt(n3) != '\"') continue;
                ++n4;
            }
            string2 = string.substring(1, n3 - 1);
            stringTokenizer = new StringTokenizer(string.substring(n3 + 1), " \t\n\r");
        }
        double d = Double.parseDouble(stringTokenizer.nextToken());
        double d2 = Double.parseDouble(stringTokenizer.nextToken());
        double d3 = Double.parseDouble(stringTokenizer.nextToken());
        double d4 = Double.parseDouble(stringTokenizer.nextToken());
        if (this.getProfileStatsPresent()) {
            double d5 = Double.parseDouble(stringTokenizer.nextToken());
        }
        double d6 = Integer.parseInt(stringTokenizer.nextToken());
        if (d4 < 0.0) {
            System.err.println("Warning, negative values found in profile, ignoring!");
            d4 = 0.0;
        }
        if (d3 < 0.0) {
            System.err.println("Warning, negative values found in profile, ignoring!");
            d3 = 0.0;
        }
        if (d != 0.0) {
            object = this.addFunction(string2, 1);
            FunctionProfile functionProfile = thread.getFunctionProfile((Function)object);
            if (functionProfile == null) {
                functionProfile = new FunctionProfile((Function)object);
                thread.addFunctionProfile(functionProfile);
            }
            functionProfile.setExclusive(n, functionProfile.getExclusive(n) + d3);
            functionProfile.setInclusive(n, functionProfile.getInclusive(n) + d4);
            if (n == 0) {
                functionProfile.setNumCalls(functionProfile.getNumCalls() + d);
                functionProfile.setNumSubr(functionProfile.getNumSubr() + d2);
            }
            if (n == 0) {
                this.addGroups(string3, (Function)object);
            }
        }
    }

    private String getGroupNames(String string) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) != '\"') continue;
            ++n3;
        }
        n2 = 0;
        for (n = 0; n2 < n3 - 2 && n < string.length(); ++n) {
            if (string.charAt(n) != '\"') continue;
            ++n2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1), "\"");
        String string2 = stringTokenizer.nextToken();
        if (!this.getGroupCheck()) {
            int n4 = string2.indexOf("GROUP=");
            if (n4 > 0) {
                this.setGroupNamesPresent(true);
            }
            this.setGroupCheck(true);
        }
        if (this.getGroupNamesPresent()) {
            try {
                string2 = stringTokenizer.nextToken();
                return string2;
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
        return null;
    }

    private void processUserEventLine(String string, Thread thread) {
        StringTokenizer stringTokenizer;
        String string2;
        Object object;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\"') continue;
            ++n;
        }
        if (n == 2) {
            object = new StringTokenizer(string, "\"");
            string2 = ((StringTokenizer)object).nextToken();
            stringTokenizer = new StringTokenizer(((StringTokenizer)object).nextToken(), " \t\n\r");
        } else {
            int n2;
            int n3 = 0;
            for (n2 = 0; n3 < n && n2 < string.length(); ++n2) {
                if (string.charAt(n2) != '\"') continue;
                ++n3;
            }
            string2 = string.substring(1, n2 - 1);
            stringTokenizer = new StringTokenizer(string.substring(n2 + 1), " \t\n\r");
        }
        double d = Double.parseDouble(stringTokenizer.nextToken());
        double d2 = Double.parseDouble(stringTokenizer.nextToken());
        double d3 = Double.parseDouble(stringTokenizer.nextToken());
        double d4 = Double.parseDouble(stringTokenizer.nextToken());
        double d5 = Double.parseDouble(stringTokenizer.nextToken());
        if (d != 0.0) {
            object = this.addUserEvent(string2);
            UserEventProfile userEventProfile = thread.getUserEventProfile((UserEvent)object);
            if (userEventProfile == null) {
                userEventProfile = new UserEventProfile((UserEvent)object);
                thread.addUserEventProfile(userEventProfile);
            }
            userEventProfile.setNumSamples(d);
            userEventProfile.setMaxValue(d2);
            userEventProfile.setMinValue(d3);
            userEventProfile.setMeanValue(d4);
            userEventProfile.setSumSquared(d5);
            userEventProfile.updateMax();
        }
    }

    protected void setProfileStatsPresent(boolean bl) {
        this.profileStatsPresent = bl;
    }

    public boolean getProfileStatsPresent() {
        return this.profileStatsPresent;
    }

    protected void setGroupCheck(boolean bl) {
        this.groupCheck = bl;
    }

    protected boolean getGroupCheck() {
        return this.groupCheck;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

