/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Snapshot;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Thread
implements Comparable {
    private int nodeID;
    private int contextID;
    private int threadID;
    private List functionProfiles = new ArrayList();
    private List userEventProfiles = new ArrayList();
    private double[] maxData;
    private double maxNumCalls = 0.0;
    private double maxNumSubr = 0.0;
    private boolean trimmed = false;
    private boolean relationsBuilt = false;
    private int numMetrics = 1;
    private static final int METRIC_SIZE = 7;
    public static final int MEAN = -1;
    public static final int TOTAL = -2;
    public static final int STDDEV = -3;
    private List snapshots = new ArrayList();
    private Map metaData = new TreeMap();

    public Thread(int n, int n2, int n3, int n4) {
        n4 = Math.max(n4, 1);
        this.nodeID = n;
        this.contextID = n2;
        this.threadID = n3;
        this.maxData = new double[n4 * 7];
        this.numMetrics = n4;
    }

    public String toString() {
        if (this.nodeID == -1) {
            return "Mean";
        }
        if (this.nodeID == -3) {
            return "Standard Deviation";
        }
        return "n,c,t " + this.nodeID + "," + this.contextID + "," + this.threadID;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public int getContextID() {
        return this.contextID;
    }

    public int getThreadID() {
        return this.threadID;
    }

    public int getNumMetrics() {
        return this.numMetrics;
    }

    public void addMetric() {
        int n = this.maxData.length;
        double[] dArray = new double[n + 7];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.maxData[i];
        }
        this.maxData = dArray;
        ++this.numMetrics;
        Iterator iterator = this.getFunctionProfiles().iterator();
        while (iterator.hasNext()) {
            FunctionProfile functionProfile = (FunctionProfile)iterator.next();
            if (functionProfile == null) continue;
            functionProfile.addMetric();
        }
    }

    public Snapshot addSnapshot(String string) {
        Snapshot snapshot = new Snapshot(string, this.snapshots.size());
        this.snapshots.add(snapshot);
        if (this.snapshots.size() > 1) {
            Iterator iterator = this.functionProfiles.iterator();
            while (iterator.hasNext()) {
                FunctionProfile functionProfile = (FunctionProfile)iterator.next();
                if (functionProfile == null) continue;
                functionProfile.addSnapshot();
            }
        }
        return snapshot;
    }

    public List getSnapshots() {
        return this.snapshots;
    }

    public int getNumSnapshots() {
        return Math.max(1, this.snapshots.size());
    }

    public void addFunctionProfile(FunctionProfile functionProfile) {
        int n = functionProfile.getFunction().getID();
        while (n >= this.functionProfiles.size()) {
            this.functionProfiles.add(null);
        }
        this.functionProfiles.set(n, functionProfile);
        functionProfile.setThread(this);
    }

    public void addUserEventProfile(UserEventProfile userEventProfile) {
        int n = userEventProfile.getUserEvent().getID();
        while (n >= this.userEventProfiles.size()) {
            this.userEventProfiles.add(null);
        }
        this.userEventProfiles.set(n, userEventProfile);
    }

    public FunctionProfile getFunctionProfile(Function function) {
        if (this.functionProfiles != null && function.getID() < this.functionProfiles.size()) {
            return (FunctionProfile)this.functionProfiles.get(function.getID());
        }
        return null;
    }

    public List getFunctionProfiles() {
        return this.functionProfiles;
    }

    public Iterator getFunctionProfileIterator() {
        return this.functionProfiles.iterator();
    }

    public UserEventProfile getUserEventProfile(UserEvent userEvent) {
        if (this.userEventProfiles != null && userEvent.getID() < this.userEventProfiles.size()) {
            return (UserEventProfile)this.userEventProfiles.get(userEvent.getID());
        }
        return null;
    }

    public List getUserEventProfiles() {
        return this.userEventProfiles;
    }

    private void setMaxInclusive(int n, double d) {
        this.insertDouble(n, 0, d);
    }

    public double getMaxInclusive(int n) {
        return this.getDouble(n, 0);
    }

    private void setMaxExclusive(int n, double d) {
        this.insertDouble(n, 1, d);
    }

    public double getMaxExclusive(int n) {
        return this.getDouble(n, 1);
    }

    private void setMaxInclusivePercent(int n, double d) {
        this.insertDouble(n, 2, d);
    }

    public double getMaxInclusivePercent(int n) {
        return this.getDouble(n, 2);
    }

    private void setMaxExclusivePercent(int n, double d) {
        this.insertDouble(n, 3, d);
    }

    public double getMaxExclusivePercent(int n) {
        return this.getDouble(n, 3);
    }

    private void setMaxInclusivePerCall(int n, double d) {
        this.insertDouble(n, 4, d);
    }

    public double getMaxInclusivePerCall(int n) {
        return this.getDouble(n, 4);
    }

    private void setMaxExclusivePerCall(int n, double d) {
        this.insertDouble(n, 5, d);
    }

    public double getMaxExclusivePerCall(int n) {
        return this.getDouble(n, 5);
    }

    public void setPercentDivider(int n, double d) {
        this.insertDouble(n, 6, d);
    }

    public double getPercentDivider(int n) {
        return this.getDouble(n, 6);
    }

    private void setMaxNumCalls(double d) {
        this.maxNumCalls = d;
    }

    public double getMaxNumCalls() {
        return this.maxNumCalls;
    }

    private void setMaxNumSubr(double d) {
        this.maxNumSubr = d;
    }

    public double getMaxNumSubr() {
        return this.maxNumSubr;
    }

    public void setTrimmed(boolean bl) {
        this.trimmed = bl;
    }

    public boolean trimmed() {
        return this.trimmed;
    }

    public void setRelationsBuilt(boolean bl) {
        this.relationsBuilt = bl;
    }

    public boolean relationsBuilt() {
        return this.relationsBuilt;
    }

    public int compareTo(Object object) {
        return this.threadID - ((Thread)object).getThreadID();
    }

    public void setThreadData(int n) {
        this.setThreadValues(n, n);
    }

    public void setThreadDataAllMetrics() {
        this.setThreadValues(0, this.getNumMetrics() - 1);
    }

    private void insertDouble(int n, int n2, double d) {
        int n3 = n * 7 + n2;
        this.maxData[n3] = d;
    }

    private double getDouble(int n, int n2) {
        int n3 = n * 7 + n2;
        return this.maxData[n3];
    }

    private void setThreadValues(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            Iterator iterator = this.getFunctionProfileIterator();
            while (iterator.hasNext()) {
                FunctionProfile functionProfile = (FunctionProfile)iterator.next();
                if (functionProfile == null) continue;
                if (functionProfile.getFunction().isPhase()) {
                    d2 = Math.max(d2, functionProfile.getInclusive(i));
                    d4 = Math.max(d4, functionProfile.getInclusivePerCall(i));
                } else {
                    d2 = Math.max(d2, functionProfile.getExclusive(i));
                    d4 = Math.max(d4, functionProfile.getExclusivePerCall(i));
                }
                d = Math.max(d, functionProfile.getInclusive(i));
                d3 = Math.max(d3, functionProfile.getInclusivePerCall(i));
                d5 = Math.max(d5, functionProfile.getNumCalls());
                d6 = Math.max(d6, functionProfile.getNumSubr());
            }
            this.setMaxInclusive(i, d);
            this.setMaxExclusive(i, d2);
            this.setMaxInclusivePerCall(i, d3);
            this.setMaxExclusivePerCall(i, d4);
            this.setMaxNumCalls(d5);
            this.setMaxNumSubr(d6);
            double d7 = 0.0;
            double d8 = 0.0;
            Iterator iterator2 = this.getFunctionProfileIterator();
            while (iterator2.hasNext()) {
                FunctionProfile functionProfile = (FunctionProfile)iterator2.next();
                if (functionProfile == null) continue;
                Function function = functionProfile.getFunction();
                if (this.getNodeID() > -1) {
                    double d9 = this.getMaxInclusive(i);
                    this.setPercentDivider(i, d9 / 100.0);
                    if (d9 != 0.0) {
                        double d10 = functionProfile.getExclusive(i) / d9 * 100.0;
                        double d11 = functionProfile.getInclusive(i) / d9 * 100.0;
                        functionProfile.setExclusivePercent(i, d10);
                        functionProfile.setInclusivePercent(i, d11);
                    }
                }
                d8 = Math.max(d8, functionProfile.getExclusivePercent(i));
                d7 = Math.max(d7, functionProfile.getInclusivePercent(i));
            }
            this.setMaxInclusivePercent(i, d7);
            this.setMaxExclusivePercent(i, d8);
        }
    }

    public Map getMetaData() {
        return this.metaData;
    }
}

