/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.database;

import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.DBConnector;
import edu.uoregon.tau.perfdmf.database.ParseConfig;
import edu.uoregon.tau.perfdmf.database.PasswordField;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;

public class ConnectionManager {
    private String perfdmfUser;
    private String perfdmfPass;
    private String parserClass = "org.apache.xerces.parsers.SAXParser";
    private String dbschema;
    private ParseConfig parser = null;
    private DB db = null;

    public ConnectionManager(ParseConfig parseConfig, boolean bl) {
        this.parser = parseConfig;
        this.initialize(this.getPassword(bl));
    }

    public ConnectionManager(ParseConfig parseConfig, String string) {
        this.parser = parseConfig;
        this.initialize(string);
    }

    public ConnectionManager(String string) {
        this.parser = new ParseConfig(string);
        this.initialize(this.getPassword());
    }

    public ConnectionManager(String string, String string2) {
        this.parser = new ParseConfig(string);
        this.initialize(string2);
    }

    public ConnectionManager(String string, boolean bl) {
        this.parser = new ParseConfig(string);
        this.initialize(this.getPassword(bl));
    }

    public void initialize(String string) {
        this.perfdmfUser = this.parser.getDBUserName();
        this.perfdmfPass = string;
        this.dbschema = this.parser.getDBSchema();
    }

    public ParseConfig getParseConfig() {
        return this.parser;
    }

    public void connect() throws SQLException {
        this.setDB(new DBConnector(this.perfdmfUser, this.perfdmfPass, this.parser));
    }

    public void connectAndCreate() throws SQLException {
        this.setDB(new DBConnector(this.perfdmfUser, this.perfdmfPass, this.parser, true));
    }

    public String getParserClass() {
        return this.parserClass;
    }

    public String getSchemafile() {
        return this.dbschema;
    }

    public void dbclose() {
        try {
            if (this.db != null) {
                this.db.close();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setParserClass(String string) {
        this.parserClass = string;
    }

    public void setDB(DB dB) {
        this.db = dB;
    }

    public DB getDB() {
        return this.db;
    }

    public void setSchemafile(String string) {
        this.dbschema = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int genParentSchema(String string) {
        File file = new File(string);
        StringBuffer stringBuffer = new StringBuffer();
        if (file.exists()) {
            System.out.println("Found " + string + "  ... Loading");
        } else {
            System.out.println("Did not find " + string);
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                string2 = string2.replaceAll("@DATABASE_NAME@", this.parser.getDBName());
                string2 = string2.replaceAll("@DATABASE_PREFIX@", this.parser.getDBSchemaPrefix() + ".");
                stringBuffer.append(string2);
                if (!ConnectionManager.isEnd(this.db, string2)) continue;
                try {
                    if (this.db.getDBType().compareTo("oracle") == 0 || this.db.getDBType().compareTo("derby") == 0 || this.db.getDBType().compareTo("db2") == 0) {
                        stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                    }
                    this.getDB().executeUpdate(stringBuffer.toString());
                    stringBuffer = stringBuffer.delete(0, stringBuffer.length());
                }
                catch (SQLException sQLException) {
                    System.out.println(stringBuffer.toString());
                    sQLException.printStackTrace();
                    return -1;
                }
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public int genParentSchema() {
        return this.genParentSchema(this.parser.getDBSchema());
    }

    public static boolean isEnd(DB dB, String string) {
        if (dB.getDBType().compareTo("oracle") == 0) {
            return string.trim().endsWith("/");
        }
        return string.trim().endsWith(";");
    }

    public String getPassword() {
        return this.getPassword(true);
    }

    public String getPassword(boolean bl) {
        String string = this.parser.getDBPasswd();
        if (bl && string == null) {
            try {
                PasswordField passwordField = new PasswordField();
                string = passwordField.getPassword(this.parser.getDBUserName() + "'s database password:");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(0);
            }
        }
        return string;
    }
}

