/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import com.sun.opengl.util.BufferUtil;
import edu.uoregon.tau.vis.Matrix;
import edu.uoregon.tau.vis.Shape;
import edu.uoregon.tau.vis.Vec;
import edu.uoregon.tau.vis.VisTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VisRenderer
implements GLEventListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private int prevMouseX;
    private int prevMouseY;
    private boolean mouseRButtonDown = false;
    private GL gl;
    private GLU glu;
    private GLAutoDrawable glDrawable;
    private Vec eye;
    private Vec aim = new Vec(0.0f, 0.0f, 0.0f);
    private Vec vup;
    private Vec viewDirection;
    private static final float rad = 0.017444445f;
    private static final float lateralSense = 0.017444445f;
    private static final float verticalSense = 0.017444445f;
    private double viewAltitude = -0.5233333706855774;
    private double viewAzimuth = -2.355f;
    private double viewDistance = 50.0;
    private boolean reverseVideo = false;
    private Color backColor = Color.white;
    private Color foreColor = Color.black;
    private List shapes = new ArrayList();
    private float fps;
    private int framesRendered;
    private int width;
    private int height;
    private boolean makeScreenShot;
    private BufferedImage screenShot;
    private VisAnimator visAnimator;
    private volatile float rotateSpeed = 0.5f;
    private boolean antiAliasedLines = false;
    private String glInfo_Vendor;
    private String glInfo_Renderer;
    private String glInfo_Version;
    private boolean stereo_available;
    private boolean stereo;
    private JCheckBox stereoCheckBox;
    private float camera_aperture = 45.0f;
    private float camera_near = 1.0f;
    private float camera_far = 500.0f;
    private float camera_focallength = 50.0f;
    private float DTOR = (float)Math.PI / 180;
    private float RTOD = 57.29578f;

    public void addShape(Shape shape) {
        this.shapes.add(shape);
    }

    public void removeShape(Shape shape) {
        this.shapes.remove(shape);
    }

    private void setLighting() {
        float[] fArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        float[] fArray2 = new float[]{0.75f, 0.75f, 0.75f, 1.0f};
        float[] fArray3 = new float[]{0.15f, 0.15f, 0.15f, 1.0f};
        this.gl.glLightfv(16384, 4611, fArray, 0);
        this.gl.glLightfv(16384, 4609, fArray2, 0);
        this.gl.glLightfv(16384, 4608, fArray3, 0);
        this.gl.glLightModelfv(2899, fArray3, 0);
        this.gl.glEnable(2903);
        this.gl.glShadeModel(7424);
        this.gl.glEnable(2896);
        this.gl.glEnable(16384);
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.gl = gLAutoDrawable.getGL();
        this.glu = new GLU();
        this.glDrawable = gLAutoDrawable;
        VisTools.verr(this, "Initializing OpenGL (JOGL)");
        VisTools.verr(this, "JOGL Class: " + this.gl.getClass().getName());
        VisTools.verr(this, "GL_VENDOR: " + this.gl.glGetString(7936));
        VisTools.verr(this, "GL_RENDERER: " + this.gl.glGetString(7937));
        VisTools.verr(this, "GL_VERSION: " + this.gl.glGetString(7938));
        this.glInfo_Vendor = this.gl.glGetString(7936);
        this.glInfo_Renderer = this.gl.glGetString(7937);
        this.glInfo_Version = this.gl.glGetString(7938);
        byte[] byArray = new byte[1];
        this.gl.glGetBooleanv(3123, byArray, 0);
        if (byArray[0] != 0) {
            this.stereo_available = true;
            VisTools.verr(this, "OpenGL Stereo is available");
        } else {
            this.stereo_available = false;
            VisTools.verr(this, "OpenGL Stereo is not available");
        }
        if (this.stereoCheckBox != null) {
            this.stereoCheckBox.setEnabled(this.stereo_available);
        }
        this.gl.glEnable(2884);
        this.gl.glEnable(2929);
        this.setLighting();
        this.computeEye();
        if (System.getProperty("vis.polyline") != null) {
            this.gl.glPolygonMode(1032, 6913);
        }
        if (System.getProperty("vis.polyfill") != null) {
            this.gl.glPolygonMode(1032, 6914);
        }
        if (System.getProperty("vis.polypoint") != null) {
            this.gl.glPolygonMode(1032, 6912);
        }
        gLAutoDrawable.addMouseListener((MouseListener)this);
        gLAutoDrawable.addMouseMotionListener((MouseMotionListener)this);
        gLAutoDrawable.addMouseWheelListener((MouseWheelListener)this);
    }

    private void computeEye() {
        if (this.aim == null) {
            return;
        }
        Matrix matrix = Matrix.createRotateY(-this.viewAltitude);
        Matrix matrix2 = Matrix.createRotateZ(this.viewAzimuth);
        this.eye = matrix2.transform(matrix.transform(new Vec(1.0f, 0.0f, 0.0f)));
        this.eye.normalize();
        this.vup = matrix2.transform(matrix.transform(new Vec(0.0f, 0.0f, 1.0f)));
        this.eye.setx((double)this.eye.x() * this.viewDistance);
        this.eye.sety((double)this.eye.y() * this.viewDistance);
        this.eye.setz((double)this.eye.z() * this.viewDistance);
        this.eye = this.eye.add(this.aim);
    }

    public void cleanUp() {
        if (this.visAnimator != null) {
            this.visAnimator.end();
        }
    }

    private void rotate(float f, float f2) {
        this.viewAltitude += (double)(0.017444445f * f2);
        if (this.viewAltitude < (double)-1.57f) {
            this.viewAltitude = -1.57f;
        }
        if (this.viewAltitude > (double)1.57f) {
            this.viewAltitude = 1.57f;
        }
        this.viewAzimuth += (double)(0.017444445f * f);
        if (this.viewAzimuth >= (double)6.28f) {
            this.viewAzimuth -= (double)6.28f;
        }
        if (this.viewAzimuth >= (double)6.28f) {
            this.viewAzimuth -= (double)6.28f;
        }
        this.computeEye();
        this.redraw();
    }

    private void translate(float f, float f2) {
        double d = this.viewAltitude;
        float f3 = this.aim.z();
        this.viewAltitude = 45.0;
        this.computeEye();
        Vec vec = this.aim.subtract(this.eye);
        Vec vec2 = new Vec(vec);
        vec2.normalize();
        Vec vec3 = this.vup.cross(vec2);
        vec3.normalize();
        Vec vec4 = vec2.cross(vec3);
        vec4.normalize();
        Matrix matrix = new Matrix();
        matrix.setToTranslate(-this.eye.x(), -this.eye.y(), -this.eye.z());
        Matrix matrix2 = new Matrix();
        matrix2.setOrthRotate(vec3, vec4, vec2);
        Matrix matrix3 = matrix2.multiply(matrix);
        Vec vec5 = matrix3.transform(this.aim);
        Vec vec6 = this.eye.subtract(this.aim);
        double d2 = Math.sqrt(vec6.length()) / 50.0;
        matrix.setToTranslate(d2 * (double)f, 0.0, d2 * (double)f2);
        matrix3 = matrix.multiply(matrix3);
        matrix2.transpose();
        matrix3 = matrix2.multiply(matrix3);
        matrix.setToTranslate(this.eye.x(), this.eye.y(), this.eye.z());
        matrix3 = matrix.multiply(matrix3);
        this.aim = matrix3.transform(this.aim);
        this.aim.setz(f3);
        this.viewAltitude = d;
        this.computeEye();
        this.redraw();
    }

    public void redraw() {
        this.glDrawable.display();
    }

    public BufferedImage createScreenShot() {
        this.makeScreenShot = true;
        this.glDrawable.display();
        return this.screenShot;
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.width = n3;
        this.height = n4;
        this.camera_near = 1.0f;
        this.camera_far = 500.0f;
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.glu.gluPerspective((double)this.camera_aperture, (double)((float)n3 / (float)n4), (double)this.camera_near, (double)this.camera_far);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.reshape(gLAutoDrawable, 0, 0, this.getWidth(), this.getHeight());
        int n = 1;
        if (this.stereo) {
            n = 2;
        }
        for (int i = 0; i < n; ++i) {
            if (this.stereo) {
                if (i == 0) {
                    this.gl.glDrawBuffer(1026);
                } else {
                    this.gl.glDrawBuffer(1027);
                }
            } else {
                this.gl.glDrawBuffer(1029);
            }
            if (this.reverseVideo) {
                this.gl.glClearColor(0.93333334f, 0.93333334f, 0.93333334f, 1.0f);
            } else {
                this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            }
            this.gl.glClear(16640);
            this.gl.glPushMatrix();
            this.gl.glTranslated(0.0, 0.0, -this.viewDistance);
            this.setLighting();
            if (this.aim == null) {
                this.aim = new Vec(0.0f, 0.0f, 0.0f);
            }
            if (this.stereo) {
                this.camera_near = 1.0f;
                this.camera_far = 500.0f;
                float f = this.camera_focallength / 20.0f;
                float f2 = (float)this.width / (float)this.height;
                float f3 = this.DTOR * this.camera_aperture / 2.0f;
                float f4 = (float)((double)this.camera_near * Math.tan(f3));
                Vec vec = this.eye.subtract(this.aim);
                Vec vec2 = vec.cross(this.vup);
                vec2.normalize();
                vec2.scale((float)((double)f / 2.0));
                float f5 = i == 0 ? 0.5f : -0.5f;
                this.gl.glMatrixMode(5889);
                this.gl.glLoadIdentity();
                float f6 = this.camera_near / this.camera_focallength;
                float f7 = -f2 * f4 + f5 * f * f6;
                float f8 = f2 * f4 + f5 * f * f6;
                float f9 = f4;
                float f10 = -f4;
                this.gl.glFrustum((double)f7, (double)f8, (double)f10, (double)f9, (double)this.camera_near, (double)this.camera_far);
                this.gl.glMatrixMode(5888);
                if (i == 0) {
                    this.glu.gluLookAt((double)(this.aim.x() - vec2.x()), (double)(this.aim.y() - vec2.y()), (double)(this.aim.z() - vec2.z()), (double)(this.eye.x() - vec2.x()), (double)(this.eye.y() - vec2.y()), (double)(this.eye.z() - vec2.z()), (double)this.vup.x(), (double)this.vup.y(), (double)this.vup.z());
                } else {
                    this.glu.gluLookAt((double)(this.aim.x() + vec2.x()), (double)(this.aim.y() + vec2.y()), (double)(this.aim.z() + vec2.z()), (double)(this.eye.x() + vec2.x()), (double)(this.eye.y() + vec2.y()), (double)(this.eye.z() + vec2.z()), (double)this.vup.x(), (double)this.vup.y(), (double)this.vup.z());
                }
            } else {
                this.glu.gluLookAt((double)this.aim.x(), (double)this.aim.y(), (double)this.aim.z(), (double)this.eye.x(), (double)this.eye.y(), (double)this.eye.z(), (double)this.vup.x(), (double)this.vup.y(), (double)this.vup.z());
            }
            this.viewDirection = this.eye.subtract(this.aim);
            for (int j = 0; j < this.shapes.size(); ++j) {
                Shape shape = (Shape)this.shapes.get(j);
                shape.render(this);
            }
            this.gl.glPopMatrix();
            ++this.framesRendered;
        }
        if (this.makeScreenShot) {
            this.makeScreenShot = false;
            this.makeScreenShot(gLAutoDrawable);
        }
    }

    private void makeScreenShot(GLAutoDrawable gLAutoDrawable) {
        int n = gLAutoDrawable.getWidth();
        int n2 = gLAutoDrawable.getHeight();
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer((int)(n * n2 * 3));
        GL gL = gLAutoDrawable.getGL();
        gL.glReadBuffer(1029);
        gL.glPixelStorei(3333, 1);
        gL.glReadPixels(0, 0, n, n2, 6407, 5121, (Buffer)byteBuffer);
        int[] nArray = new int[n * n2];
        int n3 = n * n2 * 3;
        int n4 = 0;
        int n5 = n * 3;
        for (int i = 0; i < n2; ++i) {
            int n6 = n3 -= n5;
            for (int j = 0; j < n; ++j) {
                byte by = byteBuffer.get(n6++);
                byte by2 = byteBuffer.get(n6++);
                byte by3 = byteBuffer.get(n6++);
                nArray[n4++] = 0xFF000000 | (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
            }
        }
        this.screenShot = new BufferedImage(n, n2, 1);
        this.screenShot.setRGB(0, 0, n, n2, nArray, 0, n);
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.prevMouseX = mouseEvent.getX();
        this.prevMouseY = mouseEvent.getY();
        if ((mouseEvent.getModifiers() & 4) != 0) {
            this.mouseRButtonDown = true;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            this.mouseRButtonDown = false;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Dimension dimension = mouseEvent.getComponent().getSize();
        float f = 360.0f * ((float)(n - this.prevMouseX) / (float)dimension.width);
        float f2 = 360.0f * ((float)(this.prevMouseY - n2) / (float)dimension.height);
        float f3 = n - this.prevMouseX;
        float f4 = n2 - this.prevMouseY;
        if (this.mouseRButtonDown) {
            this.translate(-f3, -f4);
        } else {
            this.rotate(-f3, f4);
        }
        this.prevMouseX = n;
        this.prevMouseY = n2;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (n > 0) {
            this.zoomOut();
        } else {
            this.zoomIn();
        }
    }

    public void zoomIn() {
        this.viewDistance /= 1.1;
        this.computeEye();
        this.glDrawable.display();
    }

    public void zoomOut() {
        this.viewDistance *= 1.1;
        this.computeEye();
        this.glDrawable.display();
    }

    public float getFps() {
        return this.fps;
    }

    public void setFps(float f) {
        this.fps = f;
    }

    public int getFramesRendered() {
        return this.framesRendered;
    }

    public void setFramesRendered(int n) {
        this.framesRendered = n;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Vec getEye() {
        return this.eye;
    }

    public Vec getAim() {
        return this.aim;
    }

    public void setAim(Vec vec) {
        this.aim = vec;
        this.computeEye();
    }

    public JPanel getControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.setLayout(new GridBagLayout());
        final JCheckBox jCheckBox = new JCheckBox("Auto-Rotate", this.visAnimator != null);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (jCheckBox.isSelected()) {
                        VisRenderer.this.visAnimator = new VisAnimator();
                        VisRenderer.this.visAnimator.start();
                    } else {
                        VisRenderer.this.visAnimator.end();
                        VisRenderer.this.visAnimator = null;
                    }
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        final JCheckBox jCheckBox2 = new JCheckBox("Reverse Video", this.reverseVideo);
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    VisRenderer.this.setReverseVideo(jCheckBox2.isSelected());
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        final JCheckBox jCheckBox3 = new JCheckBox("Anti-Aliased Lines", this.antiAliasedLines);
        jCheckBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    VisRenderer.this.setAntiAliasedLines(jCheckBox3.isSelected());
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        this.stereoCheckBox = new JCheckBox("Stereo", this.stereo);
        this.stereoCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    VisRenderer.this.setStereo(VisRenderer.this.stereoCheckBox.isSelected());
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        this.stereoCheckBox.setEnabled(this.stereo_available);
        final JSlider jSlider = new JSlider(0, 200, (int)this.camera_focallength);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                VisRenderer.this.setCamera_focallength(jSlider.getValue());
            }
        });
        final JSlider jSlider2 = new JSlider(0, 90, (int)this.camera_aperture);
        jSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                VisRenderer.this.setCamera_aperture(jSlider2.getValue());
            }
        });
        final JSlider jSlider3 = new JSlider(0, 200, (int)(Math.sqrt(this.rotateSpeed) * 100.0));
        jSlider3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    VisRenderer.this.rotateSpeed = (float)jSlider3.getValue() / 100.0f;
                    VisRenderer.this.rotateSpeed *= VisRenderer.this.rotateSpeed;
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        final JButton jButton = new JButton("GL Info");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "JOGL Class: " + VisRenderer.this.gl.getClass().getName() + "\n" + "GL_VENDOR: " + VisRenderer.this.glInfo_Vendor + "\n" + "GL_RENDERER: " + VisRenderer.this.glInfo_Renderer + "\n" + "GL_VERSION: " + VisRenderer.this.glInfo_Version;
                JOptionPane.showMessageDialog(jButton, string);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        VisTools.addCompItem(jPanel, jCheckBox, gridBagConstraints, 0, 0, 2, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 0;
        VisTools.addCompItem(jPanel, new JLabel("Speed"), gridBagConstraints, 2, 0, 1, 1);
        gridBagConstraints.fill = 2;
        VisTools.addCompItem(jPanel, jSlider3, gridBagConstraints, 2, 1, 1, 1);
        VisTools.addCompItem(jPanel, jCheckBox2, gridBagConstraints, 0, 2, 3, 1);
        VisTools.addCompItem(jPanel, jCheckBox3, gridBagConstraints, 0, 3, 3, 1);
        VisTools.addCompItem(jPanel, this.stereoCheckBox, gridBagConstraints, 0, 4, 3, 1);
        gridBagConstraints.weightx = 0.1;
        VisTools.addCompItem(jPanel, new JLabel("Separation"), gridBagConstraints, 0, 5, 1, 1);
        VisTools.addCompItem(jPanel, new JLabel("Aperture"), gridBagConstraints, 0, 6, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.anchor = 10;
        VisTools.addCompItem(jPanel, jSlider, gridBagConstraints, 1, 5, 2, 1);
        VisTools.addCompItem(jPanel, jSlider2, gridBagConstraints, 1, 6, 2, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        VisTools.addCompItem(jPanel, jButton, gridBagConstraints, 0, 7, 3, 1);
        return jPanel;
    }

    public boolean getReverseVideo() {
        return this.reverseVideo;
    }

    public void setReverseVideo(boolean bl) {
        this.reverseVideo = bl;
        this.redraw();
    }

    public GLAutoDrawable getGLAutoDrawable() {
        return this.glDrawable;
    }

    public Vec getViewDirection() {
        return this.viewDirection;
    }

    public boolean getAntiAliasedLines() {
        return this.antiAliasedLines;
    }

    public void setAntiAliasedLines(boolean bl) {
        this.antiAliasedLines = bl;
        this.redraw();
    }

    public boolean getStereo() {
        return this.stereo;
    }

    public void setStereo(boolean bl) {
        this.stereo = bl;
        this.redraw();
    }

    public float getCamera_focallength() {
        return this.camera_focallength;
    }

    public void setCamera_focallength(float f) {
        this.camera_focallength = Math.max(1.0f, f);
        this.redraw();
    }

    public float getCamera_aperture() {
        return this.camera_aperture;
    }

    public void setCamera_aperture(float f) {
        this.camera_aperture = f;
        this.redraw();
    }

    private class VisAnimator
    extends Thread {
        private volatile boolean stop = false;

        private VisAnimator() {
        }

        public void run() {
            this.stop = false;
            while (!this.stop) {
                try {
                    if (VisRenderer.this.rotateSpeed == 0.0f) {
                        Thread.sleep(250L);
                        continue;
                    }
                    VisRenderer.this.rotate(VisRenderer.this.rotateSpeed, 0.0f);
                }
                catch (Exception exception) {}
            }
        }

        public void end() {
            this.stop = true;
        }
    }
}

