/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Thread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class PPThread {
    private ParaProfTrial ppTrial;
    private Thread thread = null;
    private List functions = new ArrayList();
    private List userevents = new ArrayList();

    public PPThread(Thread thread, ParaProfTrial paraProfTrial) {
        if (thread == null) {
            throw new ParaProfException("PPThread constructor called with null thread");
        }
        this.ppTrial = paraProfTrial;
        this.thread = thread;
    }

    public Thread getThread() {
        return this.thread;
    }

    public int getNodeID() {
        return this.thread.getNodeID();
    }

    public int getContextID() {
        return this.thread.getContextID();
    }

    public int getThreadID() {
        return this.thread.getThreadID();
    }

    public String getName() {
        if (this.getNodeID() == -1) {
            return "mean";
        }
        if (this.getNodeID() == -2) {
            return "total";
        }
        if (this.getNodeID() == -3) {
            return "std. dev.";
        }
        return "n,c,t " + this.getNodeID() + "," + this.getContextID() + "," + this.getThreadID();
    }

    public String getFullName() {
        if (this.thread.getNodeID() == -1) {
            return "Mean Data";
        }
        if (this.thread.getNodeID() == -2) {
            return "Total Data";
        }
        if (this.thread.getNodeID() == -3) {
            return "Standard Deviation Data";
        }
        return this.getName();
    }

    public void addFunction(PPFunctionProfile pPFunctionProfile) {
        this.functions.add(pPFunctionProfile);
    }

    public void addUserevent(PPFunctionProfile pPFunctionProfile) {
        this.userevents.add(pPFunctionProfile);
    }

    public List getFunctionList() {
        return this.functions;
    }

    public ListIterator getFunctionListIterator() {
        return this.functions.listIterator();
    }

    public List getUsereventList() {
        return this.userevents;
    }

    public ListIterator getUsereventListIterator() {
        return this.userevents.listIterator();
    }

    public List getSortedFunctionProfiles(DataSorter dataSorter, boolean bl) {
        ArrayList<PPFunctionProfile> arrayList = null;
        List list = this.thread.getFunctionProfiles();
        arrayList = new ArrayList<PPFunctionProfile>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FunctionProfile functionProfile = (FunctionProfile)iterator.next();
            if (functionProfile == null || !bl && (!this.ppTrial.displayFunction(functionProfile.getFunction()) || !functionProfile.getFunction().isPhaseMember(dataSorter.getPhase()))) continue;
            PPFunctionProfile pPFunctionProfile = new PPFunctionProfile(dataSorter, this.thread, functionProfile);
            arrayList.add(pPFunctionProfile);
        }
        Collections.sort(arrayList);
        return arrayList;
    }
}

