/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.TauScripter;
import edu.uoregon.tau.paraprof.ApplicationManager;
import edu.uoregon.tau.paraprof.ColorChooser;
import edu.uoregon.tau.paraprof.ColorMap;
import edu.uoregon.tau.paraprof.FunctionBarChartWindow;
import edu.uoregon.tau.paraprof.HelpWindow;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Preferences;
import edu.uoregon.tau.paraprof.PreferencesWindow;
import edu.uoregon.tau.paraprof.interfaces.EclipseHandler;
import edu.uoregon.tau.paraprof.script.ParaProfScript;
import edu.uoregon.tau.paraprof.sourceview.SourceManager;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceExport;
import edu.uoregon.tau.perfdmf.FileList;
import edu.uoregon.tau.perfdmf.UtilFncs;
import jargs.gnu.CmdLineParser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class ParaProf
implements ActionListener {
    private static final String VERSION = "Mon Feb 12 16:53:20 PST 2007";
    public static int defaultNumberPrecision = 6;
    public static File paraProfHomeDirectory;
    public static Preferences preferences;
    public static ColorChooser colorChooser;
    public static ColorMap colorMap;
    public static ParaProfManagerWindow paraProfManagerWindow;
    public static ApplicationManager applicationManager;
    private static HelpWindow helpWindow;
    public static PreferencesWindow preferencesWindow;
    public static Runtime runtime;
    private static int numWindowsOpen;
    private static int fileType;
    private static File[] sourceFiles;
    private static boolean fixNames;
    private static boolean monitorProfiles;
    private static String[] args;
    public static boolean demoMode;
    public static boolean usePathNameInTrial;
    public static FunctionBarChartWindow theComparisonWindow;
    public static boolean JNLP;
    public static List scripts;
    public static String scriptFile;
    public static boolean insideEclipse;
    public static EclipseHandler eclipseHandler;
    public static SourceManager directoryManager;
    static /* synthetic */ Class class$edu$uoregon$tau$paraprof$ParaProf;
    static /* synthetic */ Class class$edu$uoregon$tau$paraprof$ParaProf$XThrowableHandler;

    public static HelpWindow getHelpWindow() {
        if (helpWindow == null) {
            helpWindow = new HelpWindow();
        }
        return helpWindow;
    }

    public static SourceManager getDirectoryManager() {
        if (directoryManager == null) {
            directoryManager = new SourceManager(preferences.getSourceLocations());
        }
        return directoryManager;
    }

    public static void registerScript(ParaProfScript paraProfScript) {
        scripts.add(paraProfScript);
    }

    private static void usage() {
        System.err.println("Usage: paraprof [--pack <file>] [--dump] [-p] [-m] [-i] [-f <filetype>] <files/directory>\n\ntry `paraprof --help` for more information");
    }

    private static void outputHelp() {
        System.err.println("Usage: paraprof [options] <files/directory> \n\nOptions:\n\n  -f, --filetype <filetype>       Specify type of performance data, options are:\n                                    profiles (default), pprof, dynaprof, mpip,\n                                    gprof, psrun, hpm, packed, cube, hpc\n\n  -h, --help                      Display this help message\n  -p                              Use `pprof` to compute derived data\n  -i, --fixnames                  Use the fixnames option for gprof\n\n  --pack <file>                   Pack the data into packed (.ppk) format\n                                    (does not launch ParaProf GUI)\n  --dump                          Dump profile data to TAU profile format\n                                    (does not launch ParaProf GUI)\n\nNotes:\n  -m, --monitor                   Perform runtime monitoring of profile data\n\n  For the TAU profiles type, you can specify either a specific set of profile\nfiles on the commandline, or you can specify a directory (by default the current\ndirectory).  The specified directory will be searched for profile.*.*.* files,\nor, in the case of multiple counters, directories named MULTI_* containing\nprofile data.\n\n");
    }

    public static void incrementNumWindows() {
        ++numWindowsOpen;
    }

    public static void decrementNumWindows() {
        if (--numWindowsOpen <= 0) {
            ParaProf.exitParaProf(0);
        }
    }

    public static void loadDefaultTrial() {
        ParaProfApplication paraProfApplication = applicationManager.addApplication();
        paraProfApplication.setName("Default App");
        ParaProfExperiment paraProfExperiment = paraProfApplication.addExperiment();
        paraProfExperiment.setName("Default Exp");
        paraProfManagerWindow.setVisible(true);
        try {
            if (fileType == 7) {
                for (int i = 0; i < sourceFiles.length; ++i) {
                    File[] fileArray = new File[]{sourceFiles[i]};
                    paraProfManagerWindow.addTrial(paraProfApplication, paraProfExperiment, fileArray, fileType, fixNames, monitorProfiles);
                }
            } else {
                paraProfManagerWindow.addTrial(paraProfApplication, paraProfExperiment, sourceFiles, fileType, fixNames, monitorProfiles);
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public static void initialize() {
        try {
            if (System.getProperty("jnlp.running") != null) {
                JNLP = true;
            }
        }
        catch (AccessControlException accessControlException) {
            JNLP = true;
        }
        if (!JNLP) {
            paraProfHomeDirectory = new File(System.getProperty("user.home") + "/.ParaProf");
            if (paraProfHomeDirectory.exists()) {
                Object object;
                block14: {
                    try {
                        object = new FileInputStream(paraProfHomeDirectory.getPath() + "/ParaProf.conf");
                        ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
                        preferences = (Preferences)objectInputStream.readObject();
                        preferences.setLoaded(true);
                        colorChooser = new ColorChooser(preferences);
                    }
                    catch (Exception exception) {
                        if (exception instanceof FileNotFoundException) break block14;
                        System.out.println("Error while trying to read the ParaProf preferences file, using defaults");
                    }
                }
                colorMap.setMap(preferences.getAssignedColors());
                preferences.setDatabasePassword(null);
                object = new File(paraProfHomeDirectory.getPath() + "/perfdmf.cfg");
                if (((File)object).exists()) {
                    preferences.setDatabaseConfigurationFile(paraProfHomeDirectory.getPath() + "/perfdmf.cfg");
                } else {
                    System.out.println("Did not find db configuration file ... load manually");
                }
            } else {
                System.out.println("Did not find ParaProf home directory ... creating ...");
                paraProfHomeDirectory.mkdir();
                System.out.println("Done creating ParaProf home directory!");
            }
        } else {
            URL uRL = (class$edu$uoregon$tau$paraprof$ParaProf == null ? (class$edu$uoregon$tau$paraprof$ParaProf = ParaProf.class$("edu.uoregon.tau.paraprof.ParaProf")) : class$edu$uoregon$tau$paraprof$ParaProf).getResource("/perfdmf.cfg");
            String string = URLDecoder.decode(uRL.getPath());
            preferences.setDatabaseConfigurationFile(string);
        }
        if (colorChooser == null) {
            colorChooser = new ColorChooser(null);
        }
        preferencesWindow = new PreferencesWindow(preferences);
        DataSource.setMeanIncludeNulls((!preferences.getComputeMeanWithoutNulls() ? 1 : 0) != 0);
        try {
            System.setProperty("sun.awt.exception.handler", (class$edu$uoregon$tau$paraprof$ParaProf$XThrowableHandler == null ? (class$edu$uoregon$tau$paraprof$ParaProf$XThrowableHandler = ParaProf.class$("edu.uoregon.tau.paraprof.ParaProf$XThrowableHandler")) : class$edu$uoregon$tau$paraprof$ParaProf$XThrowableHandler).getName());
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        paraProfManagerWindow = new ParaProfManagerWindow();
    }

    public static void loadScripts() {
        scripts.clear();
        scriptFile = System.getProperty("user.home") + "/.ParaProf/ParaProf.py";
        if (new File(scriptFile).exists()) {
            try {
                TauScripter.execfile((String)(System.getProperty("user.home") + "/.ParaProf/ParaProf.py"));
            }
            catch (Exception exception) {
                new ParaProfErrorDialog("Exception while executing script: ", exception);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Timer) {
            System.out.println("------------------------");
            System.out.println("The amount of memory used by the system is: " + runtime.totalMemory());
            System.out.println("The amount of memory free to the system is: " + runtime.freeMemory());
        }
    }

    public static String getInfoString() {
        long l = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
        return new String("ParaProf\n" + ParaProf.getVersionString() + "\nJVM Heap Size: " + l + "kb\n" + "http://www.cs.uoregon.edu/research/tau\n");
    }

    public static String getVersionString() {
        return new String(VERSION);
    }

    public static void loadPreferences(File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        preferences = (Preferences)objectInputStream.readObject();
        preferences.setLoaded(true);
        colorChooser = new ColorChooser(preferences);
        colorMap.setMap(preferences.getAssignedColors());
        Vector vector = paraProfManagerWindow.getLoadedTrials();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ParaProfTrial paraProfTrial = (ParaProfTrial)iterator.next();
            colorChooser.setColors(paraProfTrial, -1);
            paraProfTrial.updateRegisteredObjects("colorEvent");
            paraProfTrial.updateRegisteredObjects("prefEvent");
        }
    }

    public static void exitParaProf(int n) {
        try {
            ParaProf.savePreferences(new File(paraProfHomeDirectory.getPath() + "/ParaProf.conf"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!insideEclipse) {
            System.exit(n);
        }
    }

    public static boolean savePreferences(File file) {
        colorChooser.setSavedColors();
        preferences.setAssignedColors(colorMap.getMap());
        preferences.setManagerWindowPosition(paraProfManagerWindow.getLocation());
        preferences.setSourceLocations(ParaProf.getDirectoryManager().getCurrentElements());
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(preferences);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("An error occured while trying to save ParaProf preferences.");
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        args = stringArray;
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option2 = cmdLineParser.addStringOption('g', "configfile");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('f', "filetype");
        CmdLineParser.Option option4 = cmdLineParser.addBooleanOption('i', "fixnames");
        CmdLineParser.Option option5 = cmdLineParser.addStringOption('a', "pack");
        CmdLineParser.Option option6 = cmdLineParser.addBooleanOption('u', "dump");
        CmdLineParser.Option option7 = cmdLineParser.addBooleanOption('m', "monitor");
        CmdLineParser.Option option8 = cmdLineParser.addBooleanOption('z', "demo");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println("paraprof: " + optionException.getMessage());
            ParaProf.usage();
            System.exit(-1);
        }
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option);
        String string = (String)cmdLineParser.getOptionValue(option3);
        Boolean bl2 = (Boolean)cmdLineParser.getOptionValue(option4);
        String string2 = (String)cmdLineParser.getOptionValue(option5);
        Boolean bl3 = (Boolean)cmdLineParser.getOptionValue(option6);
        Boolean bl4 = (Boolean)cmdLineParser.getOptionValue(option7);
        Boolean bl5 = (Boolean)cmdLineParser.getOptionValue(option8);
        boolean bl6 = demoMode = bl5 != null && bl5 != false;
        if (bl4 != null) {
            monitorProfiles = bl4;
        }
        if (string2 != null && bl3 != null) {
            System.err.println("--pack and --dump are mutually exclusive");
            System.exit(-1);
        }
        if (bl != null && bl.booleanValue()) {
            ParaProf.outputHelp();
            System.exit(-1);
        }
        String[] stringArray2 = cmdLineParser.getRemainingArgs();
        sourceFiles = new File[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            ParaProf.sourceFiles[i] = new File(stringArray2[i]);
        }
        if (bl2 != null) {
            fixNames = bl2;
        }
        if (string != null) {
            if (string.equals("profiles")) {
                fileType = 0;
            } else if (string.equals("pprof")) {
                fileType = 1;
            } else if (string.equals("dynaprof")) {
                fileType = 2;
            } else if (string.equals("mpip")) {
                fileType = 3;
            } else if (string.equals("hpm")) {
                fileType = 4;
            } else if (string.equals("gprof")) {
                fileType = 5;
            } else if (string.equals("psrun")) {
                fileType = 6;
            } else if (string.equals("packed")) {
                fileType = 7;
            } else if (string.equals("cube")) {
                fileType = 8;
            } else if (string.equals("hpc")) {
                fileType = 9;
            } else if (string.equals("snap")) {
                fileType = 10;
            } else {
                System.err.println("Please enter a valid file type.");
                ParaProf.usage();
                System.exit(-1);
            }
        } else if (stringArray2.length >= 1) {
            String string3 = sourceFiles[0].getName();
            if (string3.toLowerCase().endsWith(".ppk")) {
                fileType = 7;
            }
            if (string3.toLowerCase().endsWith(".cube")) {
                fileType = 8;
            }
            if (string3.toLowerCase().endsWith(".mpip")) {
                fileType = 3;
            }
        }
        if (string2 != null) {
            try {
                DataSource dataSource = UtilFncs.initializeDataSource((File[])sourceFiles, (int)fileType, (boolean)fixNames);
                System.out.println("Loading data...");
                dataSource.load();
                System.out.println("Packing data...");
                DataSourceExport.writePacked((DataSource)dataSource, (File)new File(string2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
        if (bl3 != null && bl3.booleanValue()) {
            try {
                FileList fileList = new FileList();
                List list = fileList.helperFindProfiles(".");
                if (list.size() != 0) {
                    System.err.println("Error: profiles found in current directory, please remove first");
                    return;
                }
                DataSource dataSource = UtilFncs.initializeDataSource((File[])sourceFiles, (int)fileType, (boolean)fixNames);
                System.out.println("Loading data...");
                dataSource.load();
                System.out.println("Creating TAU Profile data...");
                DataSourceExport.writeProfiles((DataSource)dataSource, (File)new File("."));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ParaProf.initialize();
                    ParaProf.loadScripts();
                    ParaProf.loadDefaultTrial();
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        preferences = new Preferences();
        colorMap = new ColorMap();
        applicationManager = new ApplicationManager();
        numWindowsOpen = 0;
        fileType = 0;
        sourceFiles = new File[0];
        fixNames = false;
        usePathNameInTrial = false;
        JNLP = false;
        scripts = new ArrayList();
        runtime = Runtime.getRuntime();
    }

    public static class XThrowableHandler {
        public void handle(Throwable throwable) throws Throwable {
            if (throwable instanceof Exception) {
                ParaProfUtils.handleException((Exception)throwable);
            } else {
                System.err.println("Uncaught Throwable: " + throwable.fillInStackTrace());
            }
        }
    }
}

