/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ColorChooser;
import edu.uoregon.tau.paraprof.GlobalDataWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfTreeNodeUserObject;
import edu.uoregon.tau.paraprof.PreferencesWindow;
import edu.uoregon.tau.paraprof.script.ParaProfScript;
import edu.uoregon.tau.paraprof.script.ParaProfTrialScript;
import edu.uoregon.tau.paraprof.util.FileMonitor;
import edu.uoregon.tau.paraprof.util.FileMonitorListener;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.FileList;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UserEvent;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ParaProfTrial
extends Observable
implements ParaProfTreeNodeUserObject {
    private Function highlightedFunction = null;
    private Group highlightedGroup = null;
    private UserEvent highlightedUserEvent = null;
    private DatabaseAPI dbAPI;
    private ParaProfExperiment experiment = null;
    private DefaultMutableTreeNode defaultMutableTreeNode = null;
    private TreePath treePath = null;
    private boolean dBTrial = false;
    private boolean upload = false;
    private boolean loading = false;
    private GlobalDataWindow fullDataWindow = null;
    private ColorChooser clrChooser = ParaProf.colorChooser;
    private PreferencesWindow preferencesWindow = ParaProf.preferencesWindow;
    private String path = null;
    private String pathReverse = null;
    private int defaultMetricID = 0;
    private Group selectedGroup;
    private Group groupInclude;
    private Group groupExclude;
    private Trial trial;
    private boolean[] functionMask;
    private boolean monitored;
    private List obs = new ArrayList();
    private FileMonitorListener fileMonitorListener;

    public ParaProfTrial() {
        this.trial = new Trial();
        this.trial.setID(-1);
        this.trial.setExperimentID(-1);
        this.trial.setApplicationID(-1);
        this.trial.setName("");
    }

    public ParaProfTrial(Trial trial) {
        this.trial = new Trial(trial);
    }

    public Iterator getFunctions() {
        return this.getDataSource().getFunctions();
    }

    public Thread getMeanThread() {
        return this.getDataSource().getMeanData();
    }

    public Trial getTrial() {
        return this.trial;
    }

    public int getApplicationID() {
        return this.trial.getApplicationID();
    }

    public int getExperimentID() {
        return this.trial.getExperimentID();
    }

    public int getID() {
        return this.trial.getID();
    }

    public void setApplicationID(int n) {
        this.trial.setApplicationID(n);
    }

    public void setExperimentID(int n) {
        this.trial.setExperimentID(n);
    }

    public void setID(int n) {
        this.trial.setID(n);
    }

    public String getName() {
        return this.trial.getName();
    }

    public DataSource getDataSource() {
        return this.trial.getDataSource();
    }

    public void setExperiment(ParaProfExperiment paraProfExperiment) {
        this.experiment = paraProfExperiment;
    }

    public ParaProfExperiment getExperiment() {
        return this.experiment;
    }

    public void setDMTN(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.defaultMutableTreeNode = defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDMTN() {
        return this.defaultMutableTreeNode;
    }

    public void setTreePath(TreePath treePath) {
        this.treePath = treePath;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public void setDBTrial(boolean bl) {
        this.dBTrial = bl;
    }

    public boolean dBTrial() {
        return this.dBTrial;
    }

    public void setUpload(boolean bl) {
        this.upload = bl;
    }

    public boolean upload() {
        return this.upload;
    }

    public void setLoading(boolean bl) {
        this.loading = bl;
    }

    public boolean loading() {
        return this.loading;
    }

    public String getIDString() {
        if (this.experiment != null) {
            return this.experiment.getIDString() + ":" + this.trial.getID();
        }
        return ":" + this.trial.getID();
    }

    public ColorChooser getColorChooser() {
        return this.clrChooser;
    }

    public PreferencesWindow getPreferencesWindow() {
        return this.preferencesWindow;
    }

    public String getTrialIdentifier(boolean bl) {
        if (this.path != null) {
            if (bl) {
                return this.pathReverse;
            }
            return this.path;
        }
        return "Application " + this.trial.getApplicationID() + ", Experiment " + this.trial.getExperimentID() + ", Trial " + this.trial.getID() + ".";
    }

    public void setPaths(String string) {
        this.path = string;
        this.pathReverse = FileList.getPathReverse((String)string);
    }

    public String getPath() {
        return this.path;
    }

    public String getPathReverse() {
        return this.pathReverse;
    }

    public String toString() {
        if (this.loading()) {
            return this.trial.getName() + " (Loading...)";
        }
        return this.trial.getName();
    }

    public void clearDefaultMutableTreeNode() {
        this.setDMTN(null);
    }

    public GlobalDataWindow getFullDataWindow() {
        return this.fullDataWindow;
    }

    public void showMainWindow() {
        if (this.fullDataWindow == null) {
            this.fullDataWindow = new GlobalDataWindow(this, this.trial.getDataSource().getTopLevelPhase());
            this.fullDataWindow.setVisible(true);
        } else {
            ParaProf.incrementNumWindows();
            this.fullDataWindow.setVisible(true);
        }
    }

    public void setDefaultMetricID(int n) {
        this.defaultMetricID = n;
    }

    public int getDefaultMetricID() {
        return this.defaultMetricID;
    }

    public boolean isTimeMetric() {
        String string = this.getMetricName(this.getDefaultMetricID());
        return (string = string.toUpperCase()).indexOf("TIME") != -1;
    }

    public boolean isDerivedMetric() {
        return this.getMetric(this.getDefaultMetricID()).getDerivedMetric();
    }

    public List getMetrics() {
        return this.trial.getDataSource().getMetrics();
    }

    public int getMetricID(String string) {
        Metric metric = this.getDataSource().getMetric(string);
        if (metric == null) {
            return -1;
        }
        return metric.getID();
    }

    public int getNumberOfMetrics() {
        return this.trial.getDataSource().getNumberOfMetrics();
    }

    public ParaProfMetric getMetric(int n) {
        return (ParaProfMetric)this.trial.getDataSource().getMetric(n);
    }

    public String getMetricName(int n) {
        return this.trial.getDataSource().getMetricName(n);
    }

    public ParaProfMetric addMetric() {
        ParaProfMetric paraProfMetric = new ParaProfMetric();
        this.trial.getDataSource().addMetric((Metric)paraProfMetric);
        return paraProfMetric;
    }

    public boolean groupNamesPresent() {
        return this.trial.getDataSource().getGroupNamesPresent();
    }

    public boolean userEventsPresent() {
        return this.trial.getDataSource().getUserEventsPresent();
    }

    public boolean callPathDataPresent() {
        return this.trial.getDataSource().getCallPathDataPresent();
    }

    public int[] getMaxNCTNumbers() {
        return this.trial.getDataSource().getMaxNCTNumbers();
    }

    public void setMeanData(int n) {
        this.trial.getDataSource().generateStatistics(n, n);
    }

    public List getDisplayedFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        Iterator iterator = this.getDataSource().getFunctions();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            if (!this.displayFunction(function)) continue;
            arrayList.add(function);
        }
        return arrayList;
    }

    public boolean displayFunction(Function function) {
        return this.functionMask[function.getID()];
    }

    public void showGroup(Group group) {
        Iterator iterator = this.getDataSource().getFunctions();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            if (!function.isGroupMember(group)) continue;
            this.functionMask[function.getID()] = true;
        }
        this.groupInclude = null;
        this.groupExclude = null;
        this.updateRegisteredObjects("dataEvent");
    }

    public void hideGroup(Group group) {
        Iterator iterator = this.getDataSource().getFunctions();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            if (!function.isGroupMember(group)) continue;
            this.functionMask[function.getID()] = false;
        }
        this.groupInclude = null;
        this.groupExclude = null;
        this.updateRegisteredObjects("dataEvent");
    }

    public void showGroupOnly(Group group) {
        Iterator iterator = this.getDataSource().getFunctions();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            if (function.isGroupMember(group)) {
                this.functionMask[function.getID()] = true;
                continue;
            }
            this.functionMask[function.getID()] = false;
        }
        this.groupInclude = group;
        this.groupExclude = null;
        this.updateRegisteredObjects("dataEvent");
    }

    public void showAllExcept(Group group) {
        Iterator iterator = this.getDataSource().getFunctions();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            if (function.isGroupMember(group)) {
                this.functionMask[function.getID()] = false;
                continue;
            }
            this.functionMask[function.getID()] = true;
        }
        this.groupInclude = null;
        this.groupExclude = group;
        this.updateRegisteredObjects("dataEvent");
    }

    public void setFunctionMask(boolean[] blArray) {
        this.functionMask = blArray;
        this.groupInclude = null;
        this.groupExclude = null;
        this.updateRegisteredObjects("dataEvent");
    }

    public void showFunction(Function function) {
        this.functionMask[function.getID()] = true;
        this.updateRegisteredObjects("dataEvent");
    }

    public void hideFunction(Function function) {
        this.functionMask[function.getID()] = false;
        this.updateRegisteredObjects("dataEvent");
    }

    public void hideMatching(String string, boolean bl, boolean bl2) {
        this.maskMatching(string, false, bl, bl2);
    }

    public void showMatching(String string, boolean bl, boolean bl2) {
        this.maskMatching(string, true, bl, bl2);
    }

    public void maskMatching(String string, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            string = string.toUpperCase();
        }
        if (bl3) {
            bl = !bl;
            for (int i = 0; i < this.functionMask.length; ++i) {
                this.functionMask[i] = !bl;
            }
        }
        Iterator iterator = this.getDataSource().getFunctions();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            String string2 = function.getName();
            if (bl2) {
                string2 = string2.toUpperCase();
            }
            if (string2.indexOf(string) == -1) continue;
            this.functionMask[function.getID()] = bl;
        }
        this.updateRegisteredObjects("dataEvent");
    }

    public void setSelectedGroup(Group group) {
        this.selectedGroup = group;
    }

    public void closeTrialWindows() {
        this.updateRegisteredObjects("subWindowCloseEvent");
    }

    public Group getSelectedGroup() {
        return this.selectedGroup;
    }

    public void finishLoad() {
        ParaProfMetric paraProfMetric;
        int n;
        this.trial.setMetaData(this.trial.getDataSource().getMetaData());
        int n2 = this.trial.getDataSource().getNumberOfMetrics();
        Vector<ParaProfMetric> vector = new Vector<ParaProfMetric>();
        for (n = 0; n < n2; ++n) {
            paraProfMetric = new ParaProfMetric();
            paraProfMetric.setName(this.trial.getDataSource().getMetricName(n));
            paraProfMetric.setID(n);
            paraProfMetric.setPpTrial(this);
            vector.add(paraProfMetric);
        }
        this.trial.getDataSource().setMetrics(vector);
        for (n = 0; n < n2; ++n) {
            paraProfMetric = (ParaProfMetric)this.trial.getDataSource().getMetric(n);
            if (!paraProfMetric.isTimeMetric()) continue;
            this.setDefaultMetricID(n);
            break;
        }
        for (n = 0; n < n2; ++n) {
            paraProfMetric = (ParaProfMetric)this.trial.getDataSource().getMetric(n);
            if (!paraProfMetric.getName().equalsIgnoreCase("Time")) continue;
            this.setDefaultMetricID(n);
            break;
        }
        this.functionMask = new boolean[this.getDataSource().getNumFunctions()];
        for (n = 0; n < this.functionMask.length; ++n) {
            this.functionMask[n] = true;
        }
        this.clrChooser.setColors(this, -1);
        this.setLoading(false);
        Group group = this.getGroup("TAU_CALLPATH_DERIVED");
        if (group != null) {
            this.showAllExcept(group);
        }
        for (int i = 0; i < ParaProf.scripts.size(); ++i) {
            ParaProfScript paraProfScript = (ParaProfScript)ParaProf.scripts.get(i);
            if (!(paraProfScript instanceof ParaProfTrialScript)) continue;
            try {
                ((ParaProfTrialScript)paraProfScript).trialLoaded(this);
                continue;
            }
            catch (Exception exception) {
                new ParaProfErrorDialog("Exception while executing script: ", exception);
            }
        }
    }

    public DatabaseAPI getDatabaseAPI() {
        return this.dbAPI;
    }

    public void setDatabaseAPI(DatabaseAPI databaseAPI) {
        this.dbAPI = databaseAPI;
    }

    public void setHighlightedFunction(Function function) {
        this.highlightedFunction = function;
        this.updateRegisteredObjects("colorEvent");
    }

    public Function getHighlightedFunction() {
        return this.highlightedFunction;
    }

    public void toggleHighlightedFunction(Function function) {
        this.highlightedFunction = this.highlightedFunction == function ? null : function;
        this.updateRegisteredObjects("colorEvent");
    }

    public void setHighlightedGroup(Group group) {
        this.highlightedGroup = group;
        this.updateRegisteredObjects("colorEvent");
    }

    public Group getHighlightedGroup() {
        return this.highlightedGroup;
    }

    public void toggleHighlightedGroup(Group group) {
        this.highlightedGroup = this.highlightedGroup == group ? null : group;
        this.updateRegisteredObjects("colorEvent");
    }

    public void setHighlightedUserEvent(UserEvent userEvent) {
        this.highlightedUserEvent = userEvent;
        this.updateRegisteredObjects("colorEvent");
    }

    public UserEvent getHighlightedUserEvent() {
        return this.highlightedUserEvent;
    }

    public void toggleHighlightedUserEvent(UserEvent userEvent) {
        this.highlightedUserEvent = this.highlightedUserEvent == userEvent ? null : userEvent;
        this.updateRegisteredObjects("colorEvent");
    }

    public boolean getMonitored() {
        return this.monitored;
    }

    public void setMonitored(boolean bl) {
        this.monitored = bl;
        if (bl) {
            FileMonitor fileMonitor = new FileMonitor(1000L);
            List list = this.trial.getDataSource().getFiles();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                fileMonitor.addFile(file);
            }
            this.fileMonitorListener = new FileMonitorListener(){

                public void fileChanged(File file) {
                    try {
                        while (ParaProfTrial.this.loading) {
                            java.lang.Thread.sleep(1000L);
                        }
                        EventQueue.invokeAndWait(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                try {
                                    if (1.access$100(this.this$1).getDataSource().reloadData()) {
                                        ParaProfTrial.access$200(1.access$100(this.this$1)).setColors(1.access$100(this.this$1), -1);
                                        1.access$100(this.this$1).updateRegisteredObjects("dataEvent");
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                static /* synthetic */ ParaProfTrial access$100(1 var0) {
                    return var0.ParaProfTrial.this;
                }
            };
            fileMonitor.addListener(this.fileMonitorListener);
        }
    }

    public Function getFunction(String string) {
        return this.getDataSource().getFunction(string);
    }

    public Thread getThread(int n, int n2, int n3) {
        return this.getDataSource().getThread(n, n2, n3);
    }

    public void updateRegisteredObjects(String string) {
        this.setChanged();
        this.notifyObservers(string);
    }

    public void addObserver(Observer observer) {
        super.addObserver(observer);
        this.obs.add(observer);
    }

    public void deleteObserver(Observer observer) {
        super.deleteObserver(observer);
        this.obs.remove(observer);
    }

    public List getObservers() {
        return this.obs;
    }

    public Group getGroup(String string) {
        return this.getDataSource().getGroup(string);
    }

    public Group getGroupInclude() {
        return this.groupInclude;
    }

    public Group getGroupExclude() {
        return this.groupExclude;
    }

    static /* synthetic */ ColorChooser access$200(ParaProfTrial paraProfTrial) {
        return paraProfTrial.clrChooser;
    }
}

