/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Thread;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class SnapshotBreakdownWindow
extends JFrame
implements ActionListener,
Observer,
ChangeListener,
ParaProfWindow {
    private ParaProfTrial ppTrial;
    private Thread thread;
    private ChartPanel panel;
    private DataSorter dataSorter;
    private static int defaultWidth = 750;
    private static int defaultHeight = 610;
    private JMenu optionsMenu;
    private JCheckBoxMenuItem nameCheckBox = new JCheckBoxMenuItem("Sort By Name", false);
    private JCheckBoxMenuItem normalizeCheckBox = new JCheckBoxMenuItem("Normalize Bars", true);
    private JCheckBoxMenuItem orderByMeanCheckBox = new JCheckBoxMenuItem("Order By Mean", true);
    private JCheckBoxMenuItem orderCheckBox = new JCheckBoxMenuItem("Descending Order", true);
    private JCheckBoxMenuItem stackBarsCheckBox = new JCheckBoxMenuItem("Stack Bars Together", true);
    private JCheckBoxMenuItem metaDataCheckBox;
    private DefaultTableXYDataset dataSet = new DefaultTableXYDataset();

    public SnapshotBreakdownWindow(ParaProfTrial paraProfTrial, Thread thread, Component component) {
        this.ppTrial = paraProfTrial;
        this.thread = thread;
        PPThread pPThread = new PPThread(thread, paraProfTrial);
        this.setTitle("TAU: ParaProf: Snapshots for " + pPThread.getFullName() + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        this.dataSorter = new DataSorter(paraProfTrial);
        JFreeChart jFreeChart = this.createChart();
        this.panel = new ChartPanel(jFreeChart);
        this.getContentPane().add((Component)this.panel);
        this.setSize(ParaProfUtils.checkSize(new Dimension(defaultWidth, defaultHeight)));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        this.setupMenus();
        ParaProfUtils.setFrameIcon(this);
    }

    private JFreeChart createChart() {
        this.dataSet.removeAllSeries();
        this.dataSorter.setDescendingOrder(true);
        List list = this.thread.getSnapshots();
        List list2 = this.dataSorter.getBasicFunctionProfiles(this.thread);
        for (int i = 0; i < list2.size(); ++i) {
            FunctionProfile functionProfile = (FunctionProfile)list2.get(i);
            XYSeries xYSeries = new XYSeries(functionProfile.getName(), true, false);
            for (int j = 1; j < list.size() - 1; ++j) {
                int n = j;
                boolean bl = true;
                double d = bl && n != 0 ? functionProfile.getExclusive(n, this.ppTrial.getDefaultMetricID()) - functionProfile.getExclusive(n - 1, this.ppTrial.getDefaultMetricID()) : functionProfile.getExclusive(n, this.ppTrial.getDefaultMetricID());
                xYSeries.add((double)j, d);
            }
            this.dataSet.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createXYAreaChart((String)"Snapshot Breakdown", (String)"Snapshots", (String)"Exclusive value (microseconds)", (XYDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        jFreeChart.getPlot().setForegroundAlpha(0.4f);
        return jFreeChart;
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        this.optionsMenu = new JMenu("Options");
        this.metaDataCheckBox = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
        this.metaDataCheckBox.addActionListener(this);
        this.optionsMenu.add(this.metaDataCheckBox);
        this.optionsMenu.add(new JSeparator());
        this.nameCheckBox.addActionListener(this);
        this.optionsMenu.add(this.nameCheckBox);
        this.normalizeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotBreakdownWindow.this.setNormalized(SnapshotBreakdownWindow.this.normalizeCheckBox.isSelected());
            }
        });
        this.optionsMenu.add(this.normalizeCheckBox);
        this.orderByMeanCheckBox.addActionListener(this);
        this.optionsMenu.add(this.orderByMeanCheckBox);
        this.orderCheckBox.addActionListener(this);
        this.optionsMenu.add(this.orderCheckBox);
        this.stackBarsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotBreakdownWindow.this.setStackBars(SnapshotBreakdownWindow.this.stackBarsCheckBox.isSelected());
            }
        });
        this.optionsMenu.add(this.stackBarsCheckBox);
        this.optionsMenu.add(new JSeparator());
        jMenuBar.add(ParaProfUtils.createFileMenu(this, (Printable)this.panel, this.panel));
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        if (ParaProf.scripts.size() > 0) {
            jMenuBar.add(ParaProfUtils.createScriptMenu(this.ppTrial, this));
        }
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void update(Observable observable, Object object) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void closeThisWindow() {
    }

    public void help(boolean bl) {
    }

    public boolean getNormalized() {
        return this.normalizeCheckBox.isSelected();
    }

    public void setNormalized(boolean bl) {
    }

    public void setStackBars(boolean bl) {
    }
}

