/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.sourceview;

import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.sourceview.SourceViewer;
import edu.uoregon.tau.perfdmf.SourceRegion;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class SourceManager
extends JFrame {
    private DefaultListModel listModel;
    private JList dirList;
    private SourceRegion toFind;
    private Map sourceViewers = new TreeMap();

    public ArrayList getCurrentElements() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            arrayList.add(this.listModel.getElementAt(i));
        }
        return arrayList;
    }

    private boolean match(String string, String string2) {
        return string.equals(string2);
    }

    private boolean searchLocations(SourceRegion sourceRegion, File[] fileArray, boolean bl) {
        int n;
        for (n = 0; n < fileArray.length; ++n) {
            if (!this.match(sourceRegion.getFilename(), fileArray[n].getName())) continue;
            SourceViewer sourceViewer = (SourceViewer)this.sourceViewers.get(fileArray[n]);
            if (sourceViewer == null) {
                sourceViewer = new SourceViewer(fileArray[n]);
                this.sourceViewers.put(fileArray[n], sourceViewer);
            }
            sourceViewer.highlightRegion(sourceRegion);
            sourceViewer.setVisible(true);
            return true;
        }
        if (bl) {
            for (n = 0; n < fileArray.length; ++n) {
                if (!fileArray[n].isDirectory() || !this.searchLocations(sourceRegion, fileArray[n].listFiles(), bl)) continue;
                return true;
            }
        }
        return false;
    }

    public void showSourceCode(SourceRegion sourceRegion) {
        int n;
        String string = sourceRegion.getFilename();
        File file = new File(".");
        if (this.searchLocations(sourceRegion, file.listFiles(), false)) {
            return;
        }
        for (n = 0; n < this.listModel.getSize(); ++n) {
            String string2 = (String)this.listModel.getElementAt(n);
            File file2 = new File(string2);
            File[] fileArray = file2.listFiles();
            if (!this.searchLocations(sourceRegion, fileArray, true)) continue;
            return;
        }
        n = JOptionPane.showOptionDialog(this, "ParaProf could not find \"" + string + "\", would you like to add the containing directory to the search list?", "Looking for \"" + string + "\"", 0, 3, null, null, null);
        this.toFind = null;
        if (n == 0) {
            this.toFind = sourceRegion;
            this.display(null);
        }
    }

    public SourceManager(List list) {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel("Current Source Directories (directories are search recursively)");
        jLabel.setFont(new Font("SansSerif", 0, 14));
        this.addCompItem(jLabel, gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.listModel = new DefaultListModel();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.listModel.addElement(list.get(i));
            }
        }
        this.dirList = new JList(this.listModel);
        this.dirList.setSelectionMode(0);
        this.dirList.setSize(500, 300);
        JScrollPane jScrollPane = new JScrollPane(this.dirList);
        this.addCompItem(jScrollPane, gridBagConstraints, 0, 1, 1, 3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JButton jButton = new JButton("Add");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setDialogTitle("Select Directory");
                jFileChooser.setApproveButtonText("Select");
                if (jFileChooser.showOpenDialog(SourceManager.this) != 0) {
                    return;
                }
                try {
                    SourceManager.this.listModel.addElement(jFileChooser.getSelectedFile().getCanonicalPath());
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        this.addCompItem(jButton, gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jButton = new JButton("Remove");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SourceManager.this.dirList.getSelectedIndex();
                SourceManager.this.listModel.removeElementAt(n);
            }
        });
        this.addCompItem(jButton, gridBagConstraints, 1, 2, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceManager.this.setVisible(false);
                if (SourceManager.this.toFind != null) {
                    SourceManager.this.showSourceCode(SourceManager.this.toFind);
                }
            }
        });
        this.addCompItem(jButton, gridBagConstraints, 1, 3, 1, 1);
    }

    public void display(Component component) {
        this.setSize(new Dimension(855, 450));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        this.setTitle("TAU: ParaProf: Source Directory Manager");
        ParaProfUtils.setFrameIcon(this);
        this.setVisible(true);
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }
}

