/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PerfExplorerBoxChart;
import client.PerfExplorerChart;
import client.PerfExplorerClient;
import client.PerfExplorerConnection;
import client.PerfExplorerCube;
import client.PerfExplorerHistogramChart;
import client.PerfExplorerModel;
import client.PerfExplorerProbabilityPlot;
import client.PerfExplorerVariation;
import client.PerfExplorerViews;
import common.AnalysisType;
import common.PerfExplorerOutput;
import common.RMIPerfExplorerModel;
import common.RMISortableIntervalEvent;
import common.RMIView;
import common.TransformationType;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class PerfExplorerActionListener
implements ActionListener {
    public static final String QUIT = "Quit PerfExplorer";
    public static final String QUIT_SERVER = "Quit PerfExplorer (Shutdown Server)";
    public static final String LOOK_AND_FEEL = "Set Look and Feel: ";
    public static final String ABOUT = "About PerfExplorer";
    public static final String SEARCH = "Search for help on...";
    public static final String CLUSTERING_METHOD = "Select Clustering Method";
    public static final String DIMENSION_REDUCTION = "Select Dimension Reduction";
    public static final String NORMALIZATION = "Select Normalization Method";
    public static final String NUM_CLUSTERS = "Set Maximum Number of Clusters";
    public static final String DO_CLUSTERING = "Do Clustering";
    public static final String DO_CORRELATION_ANALYSIS = "Do Correlation Analysis";
    public static final String DO_CORRELATION_CUBE = "Do 3D Correlation Cube";
    public static final String DO_VARIATION_ANALYSIS = "Show Data Summary";
    public static final String SET_GROUPNAME = "Set Group Name";
    public static final String SET_PROBLEM_SIZE = "Set Problem Size (Scaling)";
    public static final String SET_METRICNAME = "Set Metric of Interest";
    public static final String SET_TIMESTEPS = "Set Total Number of Timesteps";
    public static final String SET_EVENTNAME = "Set Event of Interest";
    public static final String TIMESTEPS_CHART = "Timesteps Per Second";
    public static final String TOTAL_TIME_CHART = "Total Execution Time";
    public static final String EFFICIENCY_CHART = "Relative Efficiency";
    public static final String EFFICIENCY_EVENTS_CHART = "Relative Efficiency by Event";
    public static final String EFFICIENCY_ONE_EVENT_CHART = "Relative Efficiency for One Event";
    public static final String SPEEDUP_CHART = "Relative Speedup";
    public static final String SPEEDUP_EVENTS_CHART = "Relative Speedup by Event";
    public static final String SPEEDUP_ONE_EVENT_CHART = "Relative Speedup for One Event";
    public static final String COMMUNICATION_CHART = "Group % of Total Runtime";
    public static final String FRACTION_CHART = "Runtime Breakdown";
    public static final String CORRELATION_CHART = "Correlate Events with Total Runtime";
    public static final String EFFICIENCY_PHASE_CHART = "Relative Efficiency per Phase";
    public static final String SPEEDUP_PHASE_CHART = "Relative Speedup per Phase";
    public static final String FRACTION_PHASE_CHART = "Phase Fraction of Total Runtime";
    public static final String CREATE_NEW_VIEW = "Create New View";
    public static final String CREATE_NEW_SUB_VIEW = "Create New Sub-view";
    public static final String DO_IQR_BOXCHART = "Create BoxChart";
    public static final String DO_HISTOGRAM = "Create Histograms";
    public static final String DO_PROBABILITY_PLOT = "Create Normal Probability Plot";
    private PerfExplorerClient mainFrame;

    public PerfExplorerActionListener(PerfExplorerClient perfExplorerClient) {
        this.mainFrame = perfExplorerClient;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals(QUIT)) {
                    System.exit(0);
                } else if (string.equals(QUIT_SERVER)) {
                    System.exit(0);
                } else if (string.startsWith(LOOK_AND_FEEL)) {
                    UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
                    for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
                        if (!string.endsWith(lookAndFeelInfoArray[i].getName())) continue;
                        try {
                            PerfExplorerClient perfExplorerClient = PerfExplorerClient.getMainFrame();
                            UIManager.setLookAndFeel(lookAndFeelInfoArray[i].getClassName());
                            Frame[] frameArray = perfExplorerClient.getFrames();
                            for (int j = 0; j < frameArray.length; ++j) {
                                Component[] componentArray = perfExplorerClient.getComponents();
                                for (int k = 0; k < componentArray.length; ++k) {
                                    this.updateAll((Container)componentArray[k]);
                                }
                                frameArray[j].repaint();
                            }
                            continue;
                        }
                        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                            PerfExplorerOutput.println(unsupportedLookAndFeelException.getMessage());
                        }
                    }
                } else if (string.equals(ABOUT)) {
                    this.createAboutWindow();
                } else if (string.equals(SEARCH)) {
                    this.createHelpWindow();
                } else if (string.equals(CLUSTERING_METHOD)) {
                    this.createMethodWindow();
                } else if (string.equals(DIMENSION_REDUCTION)) {
                    this.createDimensionWindow();
                } else if (string.equals(NORMALIZATION)) {
                    this.createNormalizationWindow();
                } else if (string.equals(NUM_CLUSTERS)) {
                    this.createClusterSizeWindow();
                } else if (string.equals(DO_CLUSTERING)) {
                    if (this.validAnalysisSelection()) {
                        this.createDoClusteringWindow();
                    }
                } else if (string.equals(DO_CORRELATION_ANALYSIS)) {
                    if (this.validCorrelationSelection()) {
                        this.createDoCorrelationWindow();
                    }
                } else if (string.equals(DO_CORRELATION_CUBE)) {
                    if (this.valid3DSelection()) {
                        PerfExplorerCube.doCorrelationCube();
                    }
                } else if (string.equals(DO_IQR_BOXCHART)) {
                    if (this.valid3DSelection()) {
                        PerfExplorerBoxChart.doIQRBoxChart();
                    }
                } else if (string.equals(DO_HISTOGRAM)) {
                    if (this.validDistributionSelection()) {
                        PerfExplorerHistogramChart.doHistogram();
                    }
                } else if (string.equals(DO_VARIATION_ANALYSIS)) {
                    if (this.valid3DSelection()) {
                        PerfExplorerVariation.doVariationAnalysis();
                    }
                } else if (string.equals(DO_PROBABILITY_PLOT)) {
                    if (this.validDistributionSelection()) {
                        PerfExplorerProbabilityPlot.doProbabilityPlot();
                    }
                } else if (string.equals(SET_PROBLEM_SIZE)) {
                    this.checkAndSetProblemSize(true);
                } else if (string.equals(SET_GROUPNAME)) {
                    this.checkAndSetGroupName(true);
                } else if (string.equals(SET_METRICNAME)) {
                    this.checkAndSetMetricName(true);
                } else if (string.equals(SET_EVENTNAME)) {
                    this.checkAndSetEventName(true);
                } else if (string.equals(SET_TIMESTEPS)) {
                    this.checkAndSetTimesteps(true);
                } else if (string.equals(TIMESTEPS_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetTimesteps(false)) {
                        PerfExplorerChart.doTimestepsChart();
                    }
                } else if (string.equals(TOTAL_TIME_CHART)) {
                    if (this.checkAndSetMetricName(false)) {
                        PerfExplorerChart.doTotalTimeChart();
                    }
                } else if (string.equals(EFFICIENCY_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetProblemSize(false)) {
                        PerfExplorerChart.doEfficiencyChart();
                    }
                } else if (string.equals(EFFICIENCY_EVENTS_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetProblemSize(false)) {
                        PerfExplorerChart.doEfficiencyEventsChart();
                    }
                } else if (string.equals(EFFICIENCY_ONE_EVENT_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetEventName(false) && this.checkAndSetProblemSize(false)) {
                        PerfExplorerChart.doEfficiencyOneEventChart();
                    }
                } else if (string.equals(SPEEDUP_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetProblemSize(false)) {
                        PerfExplorerChart.doSpeedupChart();
                    }
                } else if (string.equals(SPEEDUP_EVENTS_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetProblemSize(false)) {
                        PerfExplorerChart.doSpeedupEventsChart();
                    }
                } else if (string.equals(SPEEDUP_ONE_EVENT_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetEventName(false) && this.checkAndSetProblemSize(false)) {
                        PerfExplorerChart.doSpeedupOneEventChart();
                    }
                } else if (string.equals(COMMUNICATION_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetGroupName(false)) {
                        PerfExplorerChart.doCommunicationChart();
                    }
                } else if (string.equals(FRACTION_CHART)) {
                    if (this.checkAndSetMetricName(false)) {
                        PerfExplorerChart.doFractionChart();
                    }
                } else if (string.equals(CORRELATION_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetProblemSize(false)) {
                        PerfExplorerChart.doCorrelationChart();
                    }
                } else if (string.equals(EFFICIENCY_PHASE_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetProblemSize(false)) {
                        PerfExplorerChart.doEfficiencyPhasesChart();
                    }
                } else if (string.equals(SPEEDUP_PHASE_CHART)) {
                    if (this.checkAndSetMetricName(false) && this.checkAndSetProblemSize(false)) {
                        PerfExplorerChart.doSpeedupPhasesChart();
                    }
                } else if (string.equals(FRACTION_PHASE_CHART)) {
                    if (this.checkAndSetMetricName(false)) {
                        PerfExplorerChart.doFractionPhasesChart();
                    }
                } else if (string.equals(CREATE_NEW_VIEW)) {
                    int n = 0;
                    PerfExplorerViews.createNewView(this.mainFrame, n);
                } else if (string.equals(CREATE_NEW_SUB_VIEW)) {
                    PerfExplorerViews.createNewSubView(this.mainFrame);
                } else {
                    System.out.println("unknown event! " + string);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("actionPerformed Exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void updateAll(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JComponent jComponent;
            if (componentArray[i] instanceof Container) {
                this.updateAll((Container)componentArray[i]);
            }
            if (componentArray[i] instanceof JComponent) {
                jComponent = (JComponent)componentArray[i];
                jComponent.updateUI();
            }
            if (!(componentArray[i] instanceof JTree)) continue;
            jComponent = (JTree)componentArray[i];
            ((JTree)jComponent).updateUI();
        }
        container.repaint();
    }

    public static String getVersionString() {
        return new String("Thu Feb  8 13:20:07 PST 2007");
    }

    public void createAboutWindow() {
        long l = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
        String string = new String("PerfExplorer 1.0\n" + PerfExplorerActionListener.getVersionString() + "\nJVM Heap Size: " + l + "kb\n");
        ImageIcon imageIcon = PerfExplorerActionListener.createImageIcon(Utility.getResource((String)"tau-large.png"));
        JOptionPane.showMessageDialog(this.mainFrame, string, ABOUT, 1, imageIcon);
    }

    protected static ImageIcon createImageIcon(URL uRL) {
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + uRL);
        return null;
    }

    public void createHelpWindow() {
        ImageIcon imageIcon = PerfExplorerActionListener.createImageIcon(Utility.getResource((String)"tau-large.png"));
        JOptionPane.showMessageDialog(this.mainFrame, "Internal help not implemented.\nFor the most up-to-date documentation, please see\n<html><a href='http://www.cs.uoregon.edu/research/tau/'>http://www.cs.uoregon.edu/research/tau/</a></html>", "PerfExplorer Help", 1, imageIcon);
    }

    public void createMethodWindow() {
        Object[] objectArray = AnalysisType.getClusterMethods();
        String string = (String)JOptionPane.showInputDialog(this.mainFrame, "Select a cluster method:", "Cluster Method", -1, null, objectArray, AnalysisType.K_MEANS);
        PerfExplorerModel.getModel().setClusterMethod(string);
    }

    public void createDimensionWindow() {
        Object[] objectArray = TransformationType.getDimensionReductions();
        Object object = JOptionPane.showInputDialog(this.mainFrame, "Select a dimension reduction method:", "Dimension Reduction", -1, null, objectArray, TransformationType.NONE);
        TransformationType transformationType = (TransformationType)object;
        PerfExplorerModel.getModel().setDimensionReduction(transformationType);
        if (PerfExplorerModel.getModel().getDimensionReduction().equals(transformationType)) {
            String string = JOptionPane.showInputDialog(this.mainFrame, "Only select events with exclusive time % greater than X:\n(where 0 <= X < 100)", "Minimum Percentage", -1);
            if (transformationType != null && !transformationType.equals("")) {
                PerfExplorerModel.getModel().setXPercent(string);
            }
        }
    }

    public void createNormalizationWindow() {
        Object[] objectArray = TransformationType.getNormalizations();
        TransformationType transformationType = (TransformationType)JOptionPane.showInputDialog(this.mainFrame, "Select a normalization method:", "Normalization", -1, null, objectArray, TransformationType.NONE);
        PerfExplorerModel.getModel().setNormalization(transformationType);
    }

    public void createClusterSizeWindow() {
        String string = new Integer(PerfExplorerModel.getModel().getNumberOfClusters()).toString();
        String string2 = JOptionPane.showInputDialog(this.mainFrame, "Enter the max number of clusters (<= " + string + "):", "Max Clusters", -1);
        if (string2 != null && !string2.equals("")) {
            PerfExplorerModel.getModel().setNumberOfClusters(string2);
        }
    }

    public void createDoClusteringWindow() {
        int n;
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        String string = null;
        if (object instanceof Application) {
            int n2 = this.getConfirmation(perfExplorerModel);
            if (n2 == 1) {
                Application application = (Application)object;
                PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
                ListIterator listIterator = perfExplorerConnection.getExperimentList(application.getID());
                Experiment experiment = null;
                boolean bl = false;
                while (listIterator.hasNext() && !bl) {
                    experiment = (Experiment)listIterator.next();
                    perfExplorerModel.setCurrentSelection(experiment);
                    ListIterator listIterator2 = perfExplorerConnection.getTrialList(experiment.getID());
                    Trial trial = null;
                    block1: while (listIterator2.hasNext() && !bl) {
                        trial = (Trial)listIterator2.next();
                        perfExplorerModel.setCurrentSelection(trial);
                        Vector vector = trial.getMetrics();
                        for (int i = 0; i < vector.size(); ++i) {
                            Object e = vector.get(i);
                            perfExplorerModel.setCurrentSelection(e);
                            RMIPerfExplorerModel rMIPerfExplorerModel = perfExplorerModel.copy();
                            string = perfExplorerConnection.requestAnalysis(rMIPerfExplorerModel, true);
                            if (string.endsWith("Request accepted.")) continue;
                            JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", 0);
                            bl = true;
                            continue block1;
                        }
                    }
                    perfExplorerModel.setCurrentSelection(experiment);
                }
                perfExplorerModel.setCurrentSelection(application);
                if (string.endsWith("Request accepted.")) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", -1);
                }
            }
        } else if (object instanceof Experiment) {
            int n3 = this.getConfirmation(perfExplorerModel);
            if (n3 == 1) {
                Experiment experiment = (Experiment)object;
                PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
                ListIterator listIterator = perfExplorerConnection.getTrialList(experiment.getID());
                Trial trial = null;
                boolean bl = false;
                block3: while (listIterator.hasNext() && !bl) {
                    trial = (Trial)listIterator.next();
                    perfExplorerModel.setCurrentSelection(trial);
                    Vector vector = trial.getMetrics();
                    for (int i = 0; i < vector.size(); ++i) {
                        Object e = vector.get(i);
                        perfExplorerModel.setCurrentSelection(e);
                        RMIPerfExplorerModel rMIPerfExplorerModel = perfExplorerModel.copy();
                        string = perfExplorerConnection.requestAnalysis(rMIPerfExplorerModel, true);
                        if (string.endsWith("Request accepted.")) continue;
                        JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", 0);
                        bl = true;
                        continue block3;
                    }
                }
                if (string.endsWith("Request accepted.")) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", -1);
                }
                perfExplorerModel.setCurrentSelection(experiment);
            }
        } else if (object instanceof Trial) {
            int n4 = this.getConfirmation(perfExplorerModel);
            if (n4 == 1) {
                PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
                RMIPerfExplorerModel rMIPerfExplorerModel = perfExplorerModel.copy();
                string = perfExplorerConnection.requestAnalysis(rMIPerfExplorerModel, true);
                Trial trial = (Trial)object;
                Vector vector = trial.getMetrics();
                for (int i = 0; i < vector.size(); ++i) {
                    rMIPerfExplorerModel = perfExplorerModel.copy();
                    Object e = vector.get(i);
                    rMIPerfExplorerModel.setCurrentSelection(e);
                    string = perfExplorerConnection.requestAnalysis(rMIPerfExplorerModel, true);
                    if (string.endsWith("Request accepted.")) continue;
                    JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", 0);
                    break;
                }
                if (string.endsWith("Request accepted.")) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", -1);
                }
            }
        } else if (object instanceof Metric && (n = this.getConfirmation(perfExplorerModel)) == 1) {
            PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
            string = perfExplorerConnection.requestAnalysis(PerfExplorerModel.getModel(), true);
            if (string.endsWith("Request accepted.")) {
                JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", -1);
            } else {
                JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", 0);
            }
        }
    }

    public void createDoCorrelationWindow() {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        String string = null;
        if (object instanceof Trial || object instanceof Metric) {
            RMIPerfExplorerModel rMIPerfExplorerModel = perfExplorerModel.copy();
            rMIPerfExplorerModel.setClusterMethod(AnalysisType.CORRELATION_ANALYSIS);
            int n = this.getConfirmation(rMIPerfExplorerModel);
            if (n == 1) {
                PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
                string = perfExplorerConnection.requestAnalysis(rMIPerfExplorerModel, true);
                if (string.endsWith("Request accepted.")) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", -1);
                } else {
                    JOptionPane.showMessageDialog(this.mainFrame, "Request Status: \n" + string, "Request Status", 0);
                }
            }
        }
    }

    private int getConfirmation(RMIPerfExplorerModel rMIPerfExplorerModel) {
        Object[] objectArray = new Object[]{"No, not yet", "Yes, do analysis"};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Analysis method: " + rMIPerfExplorerModel.getClusterMethod());
        stringBuffer.append("\nDimension Reduction: " + rMIPerfExplorerModel.getDimensionReduction());
        if (rMIPerfExplorerModel.getDimensionReduction().equals(TransformationType.OVER_X_PERCENT)) {
            stringBuffer.append("\n\t\t Minimum percentage: " + rMIPerfExplorerModel.getXPercent());
        }
        stringBuffer.append("\nNormalization: " + rMIPerfExplorerModel.getNormalization());
        if (!rMIPerfExplorerModel.getClusterMethod().equals(AnalysisType.CORRELATION_ANALYSIS)) {
            stringBuffer.append("\nMax Clusters: " + rMIPerfExplorerModel.getNumberOfClusters());
        }
        stringBuffer.append("\nTrial: " + rMIPerfExplorerModel.toString());
        stringBuffer.append("\n\nPerform clustering with the these options?");
        int n = JOptionPane.showOptionDialog(this.mainFrame, stringBuffer.toString(), "Confirm Analysis", 0, -1, null, objectArray, objectArray[1]);
        return n;
    }

    private boolean validCorrelationSelection() {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        if (!(object instanceof Trial) && !(object instanceof Metric)) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please select a Trial or Metric.", "Selection Error", 0);
            return false;
        }
        return true;
    }

    private boolean validAnalysisSelection() {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        if (!(object instanceof Experiment || object instanceof Trial || object instanceof Application || object instanceof Metric)) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please select an Application, Experiment, Trial or Metric.", "Selection Error", 0);
            return false;
        }
        return true;
    }

    private boolean validSelection(PerfExplorerModel perfExplorerModel) {
        Object object = perfExplorerModel.getCurrentSelection();
        if (!(object instanceof Experiment) && !(object instanceof RMIView)) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please select one or more Experiments or one View.", "Selection Error", 0);
            return false;
        }
        return true;
    }

    private boolean valid3DSelection() {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        if (object == null || !(object instanceof Metric)) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please select a Metric.", "Selection Error", 0);
            return false;
        }
        return true;
    }

    private boolean validDistributionSelection() {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        if (object == null || !(object instanceof Metric) && !(object instanceof RMISortableIntervalEvent)) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please select an Metrics or one or more Events.", "Selection Error", 0);
            return false;
        }
        return true;
    }

    private boolean checkAndSetMetricName(boolean bl) {
        PerfExplorerConnection perfExplorerConnection;
        List list;
        Object[] objectArray;
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        if (!this.validSelection(perfExplorerModel)) {
            return false;
        }
        String string = perfExplorerModel.getMetricName();
        if ((bl || string == null) && (objectArray = (list = (perfExplorerConnection = PerfExplorerConnection.getConnection()).getPotentialMetrics(perfExplorerModel)).toArray()).length > 0) {
            string = objectArray.length == 1 ? (String)objectArray[0] : (String)JOptionPane.showInputDialog(this.mainFrame, "Please enter the metric of interest", "Metric of interest", -1, null, objectArray, objectArray[0]);
            perfExplorerModel.setMetricName(string);
        }
        return bl || string != null;
    }

    private boolean checkAndSetGroupName(boolean bl) {
        PerfExplorerConnection perfExplorerConnection;
        List list;
        Object[] objectArray;
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        String string = perfExplorerModel.getGroupName();
        if ((bl || string == null) && (objectArray = (list = (perfExplorerConnection = PerfExplorerConnection.getConnection()).getPotentialGroups(perfExplorerModel)).toArray()).length > 0) {
            string = objectArray.length == 1 ? (String)objectArray[0] : (String)JOptionPane.showInputDialog(this.mainFrame, "Please enter the group of interest", "Group of interest", -1, null, objectArray, objectArray[0]);
            perfExplorerModel.setGroupName(string);
        }
        return bl || string != null;
    }

    private boolean checkAndSetEventName(boolean bl) {
        PerfExplorerConnection perfExplorerConnection;
        List list;
        Object[] objectArray;
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        String string = perfExplorerModel.getEventName();
        if ((bl || string == null) && (objectArray = (list = (perfExplorerConnection = PerfExplorerConnection.getConnection()).getPotentialEvents(perfExplorerModel)).toArray()).length > 0) {
            string = objectArray.length == 1 ? (String)objectArray[0] : (String)JOptionPane.showInputDialog(this.mainFrame, "Please enter the event of interest", "Event of interest", -1, null, objectArray, objectArray[0]);
            perfExplorerModel.setEventName(string);
        }
        return bl || string != null;
    }

    private boolean checkAndSetTimesteps(boolean bl) {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        String string = perfExplorerModel.getTotalTimesteps();
        if (bl || string == null) {
            string = JOptionPane.showInputDialog(this.mainFrame, "Please enter the total number of timesteps for the experiment", "Total Timesteps", -1);
            perfExplorerModel.setTotalTimesteps(string);
        }
        return bl || string != null;
    }

    private boolean checkAndSetProblemSize(boolean bl) {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Boolean bl2 = perfExplorerModel.getConstantProblem();
        if (bl || bl2 == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("The problem size remains constant. (strong scaling)");
            arrayList.add("The problem size increases as the processor count increases. (weak scaling)");
            Object[] objectArray = arrayList.toArray();
            String string = (String)JOptionPane.showInputDialog(this.mainFrame, "Please select the problem scaling:", "Problem Scaling", -1, null, objectArray, objectArray[0]);
            perfExplorerModel.setConstantProblem(string.startsWith("The problem size remains"));
            bl2 = perfExplorerModel.getConstantProblem();
        }
        return bl || bl2 != null;
    }
}

