/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PerfExplorerChartWindow;
import client.PerfExplorerConnection;
import client.PerfExplorerModel;
import common.ChartDataType;
import common.RMIChartData;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;

public class PerfExplorerBoxChart
extends PerfExplorerChartWindow {
    public PerfExplorerBoxChart(JFreeChart jFreeChart, String string) {
        super(jFreeChart, string);
    }

    public static void doIQRBoxChart() {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.IQR_DATA);
        BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset = PerfExplorerBoxChart.createDataset(rMIChartData);
        JFreeChart jFreeChart = PerfExplorerBoxChart.createChart(boxAndWhiskerCategoryDataset);
        PerfExplorerBoxChart perfExplorerBoxChart = new PerfExplorerBoxChart(jFreeChart, "Distributions of Significant Events");
    }

    private static BoxAndWhiskerCategoryDataset createDataset(RMIChartData rMIChartData) {
        int n = rMIChartData.getRows();
        int n2 = 1;
        DefaultBoxAndWhiskerCategoryDataset defaultBoxAndWhiskerCategoryDataset = new DefaultBoxAndWhiskerCategoryDataset();
        List list = rMIChartData.getRowLabels();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                List list2 = PerfExplorerBoxChart.createValueList(rMIChartData.getRowData(i));
                defaultBoxAndWhiskerCategoryDataset.add(list2, (Comparable)((Object)((String)list.get(i))), (Comparable)((Object)""));
            }
        }
        return defaultBoxAndWhiskerCategoryDataset;
    }

    private static List createValueList(List list) {
        double d;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d2 = d = ((double[])list.get(0))[1];
        for (int i = 1; i < list.size(); ++i) {
            if (d > ((double[])list.get(i))[1]) {
                d = ((double[])list.get(i))[1];
            }
            if (!(d2 < ((double[])list.get(i))[1])) continue;
            d2 = ((double[])list.get(i))[1];
        }
        double d3 = d2 - d;
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new Double((((double[])list.get(i))[1] - d) / d3));
        }
        return arrayList;
    }

    private static List createValueList(double d, double d2, int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            double d3 = d + Math.random() * (d2 - d);
            arrayList.add(new Double(d3));
        }
        return arrayList;
    }

    private static JFreeChart createChart(BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset) {
        CategoryAxis categoryAxis = new CategoryAxis(null);
        NumberAxis numberAxis = new NumberAxis("Value");
        BoxAndWhiskerRenderer boxAndWhiskerRenderer = new BoxAndWhiskerRenderer();
        boxAndWhiskerRenderer.setToolTipGenerator(new CategoryToolTipGenerator(){

            public String generateToolTip(CategoryDataset categoryDataset, int n, int n2) {
                BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset = (BoxAndWhiskerCategoryDataset)categoryDataset;
                return "<html>Min Outlier: " + boxAndWhiskerCategoryDataset.getMinOutlier(n, n2) + "<BR>Min Regular Value: " + boxAndWhiskerCategoryDataset.getMinRegularValue(n, n2) + "<BR>Q1 Value: " + boxAndWhiskerCategoryDataset.getQ1Value(n, n2) + "<BR>Mean Value: " + boxAndWhiskerCategoryDataset.getMeanValue(n, n2) + "<BR>Q3 Value: " + boxAndWhiskerCategoryDataset.getQ3Value(n, n2) + "<BR>Max Regular Value: " + boxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2) + "<BR>Max Outlier: " + boxAndWhiskerCategoryDataset.getMaxOutlier(n, n2) + "</html>";
            }
        });
        CategoryPlot categoryPlot = new CategoryPlot((CategoryDataset)boxAndWhiskerCategoryDataset, categoryAxis, (ValueAxis)numberAxis, (CategoryItemRenderer)boxAndWhiskerRenderer);
        JFreeChart jFreeChart = new JFreeChart("Significant (>2.0% of runtime) Event IQR Boxplot with Outliers", (Plot)categoryPlot);
        jFreeChart.setBackgroundPaint((Paint)Color.white);
        categoryPlot.setBackgroundPaint((Paint)Color.white);
        categoryPlot.setDomainGridlinePaint((Paint)Color.white);
        categoryPlot.setDomainGridlinesVisible(true);
        categoryPlot.setRangeGridlinePaint((Paint)Color.white);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }
}

