/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PerfExplorerClient;
import client.PerfExplorerModel;
import common.ChartDataType;
import common.EngineType;
import common.RMIChartData;
import common.RMICubeData;
import common.RMIGeneralChartData;
import common.RMIPerfExplorer;
import common.RMIPerfExplorerModel;
import common.RMIPerformanceResults;
import common.RMIVarianceData;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import server.PerfExplorerServer;

public class PerfExplorerConnection {
    private static PerfExplorerConnection theConnection = null;
    private RMIPerfExplorer server = null;
    private static boolean standalone = false;
    private static String configFile = null;
    private static EngineType analysisEngine = EngineType.WEKA;

    private PerfExplorerConnection() {
        this.makeConnection();
    }

    private void makeConnection() {
        if (standalone) {
            this.server = PerfExplorerServer.getServer(configFile, analysisEngine);
        } else {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            try {
                String string = System.getProperty("java.rmi.server.hostname");
                String string2 = "PerfExplorerServer";
                System.out.println("Connecting to rmi://" + string + "/" + string2);
                this.server = (RMIPerfExplorer)Naming.lookup("//" + string + "/" + string2);
                System.out.println("Bound to " + string2);
            }
            catch (Exception exception) {
                System.err.println("createServer Exception: " + exception.getMessage());
                exception.printStackTrace();
                this.server = null;
            }
        }
    }

    public static void setStandalone(boolean bl) {
        standalone = bl;
    }

    public static void setConfigFile(String string) {
        configFile = string;
    }

    public static void setAnalysisEngine(EngineType engineType) {
        analysisEngine = engineType;
    }

    public static PerfExplorerConnection getConnection() {
        if (theConnection == null) {
            theConnection = new PerfExplorerConnection();
        }
        if (PerfExplorerConnection.theConnection.server == null) {
            return null;
        }
        return theConnection;
    }

    private void handleError(RemoteException remoteException, String string) {
        System.out.println("PerfExplorerConnection." + string + " Exception: ");
        System.out.println(remoteException.getMessage());
        remoteException.printStackTrace();
        JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), "An error occurred communicating with the server.", "Server Error", 0);
        this.server = null;
        this.makeConnection();
        if (this.server == null) {
            JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), "The connection could not be restored.\nPlease check to make sure the server is running.", "Server Error", 0);
        } else {
            JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), "Connection restored - please try your request again.", "Connection Restored", 1);
        }
    }

    public String sayHello() {
        String string = null;
        try {
            string = this.server.sayHello();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "sayHello()");
        }
        return string;
    }

    public ListIterator getApplicationList() {
        ListIterator listIterator = null;
        try {
            listIterator = this.server.getApplicationList().listIterator();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getApplicationList()");
        }
        return listIterator;
    }

    public ListIterator getExperimentList(int n) {
        ListIterator listIterator = null;
        try {
            listIterator = this.server.getExperimentList(n).listIterator();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getExperimentList(" + n + ")");
        }
        return listIterator;
    }

    public ListIterator getTrialList(int n) {
        ListIterator listIterator = null;
        try {
            listIterator = this.server.getTrialList(n).listIterator();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getTrialList(" + n + ")");
        }
        return listIterator;
    }

    public String requestAnalysis(RMIPerfExplorerModel rMIPerfExplorerModel, boolean bl) {
        String string = null;
        try {
            string = this.server.requestAnalysis(rMIPerfExplorerModel, bl);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "requestAnalysis(" + rMIPerfExplorerModel.toString() + ")");
        }
        return string;
    }

    public RMIPerformanceResults getPerformanceResults(PerfExplorerModel perfExplorerModel) {
        RMIPerformanceResults rMIPerformanceResults = null;
        try {
            rMIPerformanceResults = this.server.getPerformanceResults(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getPerformanceResults(" + perfExplorerModel.toString() + ")");
        }
        return rMIPerformanceResults;
    }

    public RMIPerformanceResults getCorrelationResults(PerfExplorerModel perfExplorerModel) {
        RMIPerformanceResults rMIPerformanceResults = null;
        try {
            rMIPerformanceResults = this.server.getCorrelationResults(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getCorrelationResults(" + perfExplorerModel.toString() + ")");
        }
        return rMIPerformanceResults;
    }

    public void stopServer() {
        try {
            this.server.stopServer();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "stopServer()");
        }
    }

    public RMIChartData requestChartData(PerfExplorerModel perfExplorerModel, ChartDataType chartDataType) {
        RMIChartData rMIChartData = null;
        try {
            rMIChartData = this.server.requestChartData(perfExplorerModel, chartDataType);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "requestChartData(" + perfExplorerModel.toString() + ")");
        }
        return rMIChartData;
    }

    public RMIGeneralChartData requestGeneralChartData(PerfExplorerModel perfExplorerModel, ChartDataType chartDataType) {
        RMIGeneralChartData rMIGeneralChartData = null;
        try {
            rMIGeneralChartData = this.server.requestGeneralChartData(perfExplorerModel, chartDataType);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "requestGeneralChartData(" + perfExplorerModel.toString() + ")");
        }
        return rMIGeneralChartData;
    }

    public List getPotentialGroups(PerfExplorerModel perfExplorerModel) {
        List list = null;
        try {
            list = this.server.getPotentialGroups(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getPotentialGroups(" + perfExplorerModel.toString() + ")");
        }
        return list;
    }

    public List getPotentialMetrics(PerfExplorerModel perfExplorerModel) {
        List list = null;
        try {
            list = this.server.getPotentialMetrics(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getPotentialGroups(" + perfExplorerModel.toString() + ")");
        }
        return list;
    }

    public List getPotentialEvents(PerfExplorerModel perfExplorerModel) {
        List list = null;
        try {
            list = this.server.getPotentialEvents(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getPotentialEvents(" + perfExplorerModel.toString() + ")");
        }
        return list;
    }

    public String[] getMetaData(String string) {
        String[] stringArray = null;
        try {
            stringArray = this.server.getMetaData(string);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getMetaData(" + string + ")");
        }
        return stringArray;
    }

    public List getPossibleValues(String string, String string2) {
        List list = null;
        try {
            list = this.server.getPossibleValues(string, string2);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getPossibleValues(" + string + ", " + string2 + ")");
        }
        return list;
    }

    public int createNewView(String string, int n, String string2, String string3, String string4, String string5) {
        int n2 = 0;
        try {
            n2 = this.server.createNewView(string, n, string2, string3, string4, string5);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "createNewView(" + string2 + ", " + string3 + ", " + string5 + ")");
        }
        return n2;
    }

    public List getViews(int n) {
        List list = null;
        try {
            list = this.server.getViews(n);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getViews(" + n + ")");
        }
        return list;
    }

    public ListIterator getTrialsForView(List list) {
        ListIterator listIterator = null;
        try {
            listIterator = this.server.getTrialsForView(list).listIterator();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getTrialsForView(" + list + ")");
        }
        return listIterator;
    }

    public RMIVarianceData requestVariationAnalysis(PerfExplorerModel perfExplorerModel) {
        RMIVarianceData rMIVarianceData = null;
        try {
            rMIVarianceData = this.server.getVariationAnalysis(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getVariationAnalysis(" + perfExplorerModel.toString() + ")");
        }
        return rMIVarianceData;
    }

    public RMICubeData requestCubeData(PerfExplorerModel perfExplorerModel) {
        RMICubeData rMICubeData = null;
        try {
            rMICubeData = this.server.getCubeData(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getCubeData(" + perfExplorerModel.toString() + ")");
        }
        return rMICubeData;
    }

    public String getConnectionString() {
        String string = null;
        try {
            string = this.server.getConnectionString();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getConnectionString()");
        }
        return string;
    }

    public ListIterator getEventList(int n, int n2) {
        ListIterator listIterator = null;
        try {
            listIterator = this.server.getEventList(n, n2).listIterator();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getEventList(" + n + ")");
        }
        return listIterator;
    }

    public List getTrialList(String string) {
        List list = null;
        try {
            list = this.server.getTrialList(string);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getTrialList(" + string + ")");
        }
        return list;
    }
}

