/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PerfExplorerClient;
import client.PerfExplorerConnection;
import client.PerfExplorerModel;
import common.RMICubeData;
import edu.uoregon.tau.vis.ColorScale;
import edu.uoregon.tau.vis.PlotFactory;
import edu.uoregon.tau.vis.ScatterPlot;
import edu.uoregon.tau.vis.Shape;
import edu.uoregon.tau.vis.Vec;
import edu.uoregon.tau.vis.VisCanvas;
import edu.uoregon.tau.vis.VisRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PerfExplorerCube {
    public static void doCorrelationCube() {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMICubeData rMICubeData = perfExplorerConnection.requestCubeData(PerfExplorerModel.getModel());
        PerfExplorerCube.createAndShowGUI(rMICubeData);
    }

    private static void createAndShowGUI(RMICubeData rMICubeData) {
        JFrame jFrame = new JFrame("TAU/PerfExplorer: Correlation of top 4 variant events");
        float[][] fArray = rMICubeData.getValues();
        VisRenderer visRenderer = new VisRenderer();
        VisCanvas visCanvas = new VisCanvas(visRenderer);
        visCanvas.getActualCanvas().setSize(600, 600);
        ColorScale colorScale = new ColorScale();
        ScatterPlot scatterPlot = PlotFactory.createScatterPlot((String)rMICubeData.getNames(0), (String)rMICubeData.getNames(1), (String)rMICubeData.getNames(2), (String)rMICubeData.getNames(3), (float[][])fArray, (boolean)true, (ColorScale)colorScale);
        scatterPlot.setSize(10.0f, 10.0f, 10.0f);
        visRenderer.setAim(new Vec(5.0f, 5.0f, 5.0f));
        visRenderer.addShape((Shape)scatterPlot);
        visRenderer.addShape((Shape)colorScale);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setTabLayoutPolicy(1);
        jTabbedPane.addTab("ScatterPlot", scatterPlot.getControlPanel(visRenderer));
        jTabbedPane.addTab("Axes", scatterPlot.getAxes().getControlPanel(visRenderer));
        jTabbedPane.addTab("ColorScale", colorScale.getControlPanel(visRenderer));
        jTabbedPane.addTab("Render", visRenderer.getControlPanel());
        jTabbedPane.setMinimumSize(new Dimension(300, 300));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)visCanvas.getActualCanvas(), new GridBagConstraints(0, 0, 1, 1, 0.9, 1.0, 17, 1, new Insets(5, 5, 5, 5), 1, 1));
        jPanel.add((Component)jTabbedPane, new GridBagConstraints(1, 0, 1, 1, 0.1, 1.0, 13, 2, new Insets(5, 5, 5, 5), 1, 1));
        int n = 760;
        int n2 = 600;
        Point point = PerfExplorerClient.getMainFrame().getLocationOnScreen();
        Dimension dimension = PerfExplorerClient.getMainFrame().getSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = (n3 - n) / 2;
        int n6 = (n4 - n2) / 2;
        n5 = (int)point.getX() + n5;
        n6 = (int)point.getY() + n6;
        jFrame.setLocation(n5, n6);
        jFrame.setSize(new Dimension(n, n2));
        jFrame.getContentPane().add(jPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

