/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PerfExplorerChartWindow;
import client.PerfExplorerConnection;
import client.PerfExplorerModel;
import client.ProbabilityPlotDataset;
import client.SpeedupXYLineAndShapeRenderer;
import common.ChartDataType;
import common.RMIChartData;
import common.RMISortableIntervalEvent;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;

public class PerfExplorerProbabilityPlot
extends PerfExplorerChartWindow {
    public PerfExplorerProbabilityPlot(JFreeChart jFreeChart, String string) {
        super(jFreeChart, string);
    }

    public static JFrame doProbabilityPlot() {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        RMIChartData rMIChartData = null;
        rMIChartData = object instanceof RMISortableIntervalEvent ? perfExplorerConnection.requestChartData(perfExplorerModel, ChartDataType.DISTRIBUTION_DATA) : perfExplorerConnection.requestChartData(perfExplorerModel, ChartDataType.IQR_DATA);
        ProbabilityPlotDataset probabilityPlotDataset = new ProbabilityPlotDataset(rMIChartData);
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)"Normal Probability Plot", (String)"Normal N(0,1) Ordered Statistic Medians", (String)"Ordered Measurements", (XYDataset)probabilityPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        SpeedupXYLineAndShapeRenderer speedupXYLineAndShapeRenderer = new SpeedupXYLineAndShapeRenderer(probabilityPlotDataset.getSeriesCount() - 1);
        for (int i = 0; i < probabilityPlotDataset.getSeriesCount(); ++i) {
            if (i == probabilityPlotDataset.getSeriesCount() - 1) {
                speedupXYLineAndShapeRenderer.setSeriesShapesVisible(i, false);
                continue;
            }
            speedupXYLineAndShapeRenderer.setSeriesLinesVisible(i, false);
        }
        speedupXYLineAndShapeRenderer.setToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator(){

            public String generateToolTip(XYDataset xYDataset, int n, int n2) {
                ProbabilityPlotDataset probabilityPlotDataset = (ProbabilityPlotDataset)xYDataset;
                return probabilityPlotDataset.getTooltip(n, n2);
            }
        });
        xYPlot.setRenderer((XYItemRenderer)speedupXYLineAndShapeRenderer);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return new PerfExplorerProbabilityPlot(jFreeChart, "Normal Probability Plot");
    }

    private static double SND(double d) {
        double d2 = Math.sqrt(Math.PI * 2);
        double d3 = 0.0 - d * d / 2.0;
        double d4 = Math.pow(Math.E, d3) / d2;
        return d4;
    }

    static class Point
    implements Comparable {
        public double x = 0.0;
        public double y = 0.0;
        public double n = 0.0;
        public double r = 0.0;
        public double z = 0.0;

        public Point(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public int compareTo(Object object) {
            Point point = (Point)object;
            if (this.y < point.y) {
                return -1;
            }
            if (this.y > point.y) {
                return 1;
            }
            return 0;
        }
    }
}

