/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PerfExplorerChart;
import client.PerfExplorerConnection;
import client.PerfExplorerModel;
import common.AnalysisType;
import common.EngineType;
import common.PerfExplorerOutput;
import common.RMIVarianceData;
import common.TransformationType;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ScriptFacade {
    private final PerfExplorerConnection connection;
    private final PerfExplorerModel model;

    public ScriptFacade() {
        this.connection = PerfExplorerConnection.getConnection();
        this.model = PerfExplorerModel.getModel();
    }

    public ScriptFacade(String string, EngineType engineType) {
        PerfExplorerOutput.setQuiet(false);
        PerfExplorerConnection.setStandalone(true);
        PerfExplorerConnection.setConfigFile(string);
        PerfExplorerConnection.setAnalysisEngine(engineType);
        this.connection = PerfExplorerConnection.getConnection();
        this.model = PerfExplorerModel.getModel();
    }

    public void doSomething() {
        PerfExplorerOutput.println("Testing Script Facade");
    }

    public void exit() {
        System.exit(0);
    }

    public void setApplication(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Application name cannot be null.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("Application name cannot be an empty string.");
        }
        boolean bl = false;
        ListIterator listIterator = this.connection.getApplicationList();
        while (listIterator.hasNext() && !bl) {
            Application application = (Application)listIterator.next();
            if (!application.getName().equals(string)) continue;
            this.model.setCurrentSelection(application);
            bl = true;
        }
        if (!bl) {
            throw new NoSuchElementException("Application '" + string + "' not found.");
        }
    }

    public void setExperiment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Experiment name cannot be null.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("Experiment name cannot be an empty string.");
        }
        Application application = this.model.getApplication();
        if (application == null) {
            throw new NullPointerException("Application selection is null. Please select an Application before setting the Experiment.");
        }
        boolean bl = false;
        ListIterator listIterator = this.connection.getExperimentList(application.getID());
        while (listIterator.hasNext() && !bl) {
            Experiment experiment = (Experiment)listIterator.next();
            if (!experiment.getName().equals(string)) continue;
            this.model.setCurrentSelection(experiment);
            bl = true;
        }
        if (!bl) {
            throw new NoSuchElementException("Experiment '" + string + "' not found.");
        }
    }

    public void setTrial(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Trial name cannot be null.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("Trial name cannot be an empty string.");
        }
        Experiment experiment = this.model.getExperiment();
        if (experiment == null) {
            throw new NullPointerException("Experiment selection is null.  Please select an Experiment before setting the Trial.");
        }
        boolean bl = false;
        ListIterator listIterator = this.connection.getTrialList(experiment.getID());
        while (listIterator.hasNext() && !bl) {
            Trial trial = (Trial)listIterator.next();
            if (!trial.getName().equals(string)) continue;
            this.model.setCurrentSelection(trial);
            bl = true;
        }
        if (!bl) {
            throw new NoSuchElementException("Trial '" + string + "' not found.");
        }
    }

    public void setMetric(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Metric name cannot be null.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("Metric name cannot be an empty string.");
        }
        Trial trial = this.model.getTrial();
        if (trial == null) {
            throw new NullPointerException("Trial selection is null.  Please select a Trial before setting the Metric.");
        }
        boolean bl = false;
        Vector vector = trial.getMetrics();
        int n = vector.size();
        for (int i = 0; i < n && !bl; ++i) {
            Metric metric = (Metric)vector.elementAt(i);
            if (!metric.getName().equals(string)) continue;
            this.model.setCurrentSelection(metric);
            bl = true;
        }
        if (!bl) {
            throw new NoSuchElementException("Metric '" + string + "' not found.");
        }
    }

    public void setDimensionReduction(TransformationType transformationType, String string) {
        if (transformationType == null) {
            throw new IllegalArgumentException("TransformationType type cannot be null.");
        }
        this.model.setDimensionReduction(transformationType);
        if (transformationType == TransformationType.OVER_X_PERCENT) {
            if (string == null) {
                throw new IllegalArgumentException("Object parameter cannot be null.");
            }
            this.model.setXPercent(string);
        }
    }

    public void setAnalysisType(AnalysisType analysisType) {
        this.model.setClusterMethod(analysisType);
    }

    public String requestAnalysis() {
        return this.connection.requestAnalysis(this.model, true);
    }

    public void doANOVA() {
        PerfExplorerOutput.println("Doing ANOVA");
    }

    public void do3DCorrelationCube() {
    }

    public void setMaximumNumberOfClusters(int n) {
    }

    public void createBoxChart() {
    }

    public void createHistograms() {
    }

    public void createNormalProbabilityChart() {
    }

    public void showDataSummary() {
        RMIVarianceData rMIVarianceData = this.connection.requestVariationAnalysis(this.model);
        PerfExplorerOutput.print(UtilFncs.pad((String)rMIVarianceData.getValueName(0), (int)25).toUpperCase() + " ");
        for (int i = 1; i < rMIVarianceData.getValueCount(); ++i) {
            PerfExplorerOutput.print(UtilFncs.lpad((String)rMIVarianceData.getValueName(i), (int)11).toUpperCase() + " ");
        }
        PerfExplorerOutput.println("\n--------------------------------------------------------------------------------------------------------------------------------");
        Object[][] objectArray = rMIVarianceData.getDataMatrix();
        int n = 25;
        for (int i = 0; i < rMIVarianceData.getEventCount(); ++i) {
            Double d;
            if (this.model.getDimensionReduction() == TransformationType.OVER_X_PERCENT && (d = (Double)objectArray[i][2]) < this.model.getXPercent()) continue;
            for (int j = 0; j < rMIVarianceData.getValueCount(); ++j) {
                Object object;
                if (objectArray[i][j] instanceof String) {
                    object = (String)objectArray[i][j];
                    object = ((String)object).length() > n ? ((String)object).substring(0, n) : object;
                    PerfExplorerOutput.print(UtilFncs.pad((String)object, (int)n).toUpperCase() + " ");
                    continue;
                }
                if (!(objectArray[i][j] instanceof Double)) continue;
                object = (Double)objectArray[i][j];
                PerfExplorerOutput.print(UtilFncs.lpad((String)UtilFncs.formatDouble((double)((Double)object), (int)10, (boolean)true), (int)11) + " ");
            }
            PerfExplorerOutput.print("\n");
        }
        PerfExplorerOutput.print("\n");
    }

    public Object[] getTrialList(String string) {
        return this.connection.getTrialList(string).toArray();
    }

    public void doGeneralChart() {
        PerfExplorerChart.doGeneralChart();
    }

    public void addExperiment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Experiment name cannot be null.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("Experiment name cannot be an empty string.");
        }
        Application application = this.model.getApplication();
        if (application == null) {
            throw new NullPointerException("Application selection is null. Please select an Application before setting the Experiment.");
        }
        boolean bl = false;
        ListIterator listIterator = this.connection.getExperimentList(application.getID());
        while (listIterator.hasNext() && !bl) {
            Experiment experiment = (Experiment)listIterator.next();
            if (!experiment.getName().equals(string)) continue;
            this.model.addSelection(experiment);
            bl = true;
        }
        if (!bl) {
            throw new NoSuchElementException("Experiment '" + string + "' not found.");
        }
    }

    public void setEventName(String string) {
        this.model.setEventName(string);
    }

    public void addEventName(String string) {
        this.model.addEventName(string);
    }

    public void setMetricName(String string) {
        this.model.setMetricName(string);
    }

    public void setChartSeriesName(String string) {
        this.model.setChartSeriesName(string);
    }

    public void setChartXAxisName(String string, String string2) {
        this.model.setChartXAxisName(string, string2);
    }

    public void setChartYAxisName(String string, String string2) {
        this.model.setChartYAxisName(string, string2);
    }

    public void setChartTitle(String string) {
        this.model.setChartTitle(string);
    }

    public void setChartMainEventOnly(int n) {
        if (n == 0) {
            this.model.setMainEventOnly(false);
        } else {
            this.model.setMainEventOnly(true);
        }
    }

    public void setChartEventNoCallPath(int n) {
        if (n == 0) {
            this.model.setEventNoCallpath(false);
        } else {
            this.model.setEventNoCallpath(true);
        }
    }

    public void setChartEventExclusive100(int n) {
        if (n == 0) {
            this.model.setEventExclusive100(false);
        } else {
            this.model.setEventExclusive100(true);
        }
    }

    public void setChartLogYAxis(int n) {
        if (n == 0) {
            this.model.setChartLogYAxis(false);
        } else {
            this.model.setChartLogYAxis(true);
        }
    }

    public void setChartScalability(int n) {
        if (n == 0) {
            this.model.setChartScalability(false);
        } else {
            this.model.setChartScalability(true);
        }
    }

    public void setChartEfficiency(int n) {
        if (n == 0) {
            this.model.setChartEfficiency(false);
        } else {
            this.model.setChartEfficiency(true);
        }
    }

    public void setChartConstantProblem(int n) {
        if (n == 0) {
            this.model.setConstantProblem(false);
        } else {
            this.model.setConstantProblem(true);
        }
    }
}

