/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PerfExplorerBoxChart;
import client.PerfExplorerChart;
import client.PerfExplorerClient;
import client.PerfExplorerConnection;
import client.PerfExplorerHistogramChart;
import client.PerfExplorerModel;
import client.PerfExplorerProbabilityPlot;
import client.PerfExplorerVariation;
import client.TestType;
import common.AnalysisType;
import common.EngineType;
import common.PerfExplorerOutput;
import common.RMIPerfExplorerModel;
import common.RMIView;
import common.TransformationType;
import edu.uoregon.tau.common.TauScripter;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import jargs.gnu.CmdLineParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.ToolTipManager;

public class TestHarness {
    private static String USAGE = "Usage: TestHarness [{-h,--help}] {-c,--configfile}=<config_file> [{-s,--standalone}] [{-e,--engine}=<analysis_engine>] [{-t,--test}=<test_type>]\n  where analysis_engine = R or Weka and test_type = charts, cluster, correlation, viz, script or all ";
    private PerfExplorerConnection connection = null;
    private RMIPerfExplorerModel model = null;
    private Object[] viewList = null;
    private boolean foundView = false;

    private TestHarness(boolean bl, String string, EngineType engineType, boolean bl2, TestType testType) {
        PerfExplorerClient perfExplorerClient = new PerfExplorerClient(bl, string, engineType, bl2);
        perfExplorerClient.pack();
        perfExplorerClient.setVisible(true);
        this.connection = PerfExplorerConnection.getConnection();
        this.model = PerfExplorerModel.getModel();
        try {
            System.out.println(this.connection.sayHello());
        }
        catch (Exception exception) {
            System.err.println("TestHarness exception: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            if (testType == TestType.CHART || testType == TestType.ALL) {
                this.setSelection("gyro.B1-std", "B1-std.tg", null, null);
                this.model.setMetricName("WALL_CLOCK_TIME");
                this.model.setEventName("field");
                this.model.setGroupName("TRANSPOSE");
                this.model.setTotalTimesteps("100");
                this.model.setConstantProblem(true);
                System.out.println("Testing charts...");
                this.testCharts();
            }
        }
        catch (Exception exception) {
            System.err.println("TestHarness exception: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            if (testType == TestType.VIZ || testType == TestType.ALL) {
                System.out.println("Testing visualization...");
                this.setSelection("sweep3d", "150.1 Strong Scaling 2", "128", "time");
                this.testVisualization();
            }
        }
        catch (Exception exception) {
            System.err.println("TestHarness exception: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            if (testType == TestType.VIEWS || testType == TestType.ALL) {
                System.out.println("Testing views...");
                this.viewList = null;
                this.foundView = false;
                this.getViews("0", new ArrayList());
                System.out.print("Selecting: ");
                for (int i = 0; i < this.viewList.length; ++i) {
                    System.out.print(this.viewList[i] + ": ");
                }
                System.out.println("");
                this.model.setCurrentSelection(this.viewList);
                this.model.setMetricName("Time");
                this.model.setEventName("field");
                this.model.setGroupName("TRANSPOSE");
                this.model.setTotalTimesteps("100");
                this.model.setConstantProblem(true);
                this.testViews();
            }
        }
        catch (Exception exception) {
            System.err.println("TestHarness exception: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            if (testType == TestType.CLUSTER || testType == TestType.ALL) {
                System.out.println("Testing clustering...");
                this.setSelection("FLASH", "hydro radiation scaling on BG/L", "tau64p.ppk/64p/scaling/hydro-radiation-scaling/flash/flash/taudata/packages/disk2/", "Time");
                this.testCluster();
            }
        }
        catch (Exception exception) {
            System.err.println("TestHarness exception: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            if (testType == TestType.CORRELATION || testType == TestType.ALL) {
                System.out.println("Testing correlation...");
                this.setSelection("FLASH", "hydro radiation scaling on BG/L", "tau64p.ppk/64p/scaling/hydro-radiation-scaling/flash/flash/taudata/packages/disk2/", "Time");
                this.testCorrelation();
            }
        }
        catch (Exception exception) {
            System.err.println("TestHarness exception: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            if (testType == TestType.SCRIPT || testType == TestType.ALL) {
                System.out.println("Testing scripting...");
                this.testScripting();
            }
        }
        catch (Exception exception) {
            System.err.println("TestHarness exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private Application setApplication(String string) {
        Application application = null;
        System.out.println("******** Applications *********");
        ListIterator listIterator = this.connection.getApplicationList();
        while (listIterator.hasNext()) {
            application = (Application)listIterator.next();
            System.out.println("\t" + application.getName());
            if (!application.getName().equalsIgnoreCase(string)) continue;
            break;
        }
        return application;
    }

    private Experiment setExperiment(Application application, String string) {
        Experiment experiment = null;
        System.out.println("******** Experiments *********");
        ListIterator listIterator = this.connection.getExperimentList(application.getID());
        while (listIterator.hasNext()) {
            experiment = (Experiment)listIterator.next();
            System.out.println("\t" + experiment.getName());
            if (!experiment.getName().equalsIgnoreCase(string)) continue;
            break;
        }
        return experiment;
    }

    private Trial setTrial(Experiment experiment, String string) {
        Trial trial = null;
        System.out.println("******** Trials *********");
        ListIterator listIterator = this.connection.getTrialList(experiment.getID());
        while (listIterator.hasNext()) {
            trial = (Trial)listIterator.next();
            System.out.println("\t" + trial.getName());
            if (!trial.getName().trim().equalsIgnoreCase(string)) continue;
            break;
        }
        return trial;
    }

    private Metric setMetric(Trial trial, String string) {
        Metric metric = null;
        System.out.println("******** Metrics *********");
        Vector vector = trial.getMetrics();
        for (int i = 0; i < vector.size(); ++i) {
            metric = (Metric)vector.elementAt(i);
            System.out.println("\t" + metric.getName());
            if (metric.getName().equalsIgnoreCase(string)) break;
        }
        return metric;
    }

    public void setSelection(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[4];
        Application application = this.setApplication(string);
        objectArray[0] = application;
        if (string2 != null) {
            Experiment experiment = this.setExperiment(application, string2);
            objectArray[1] = experiment;
            if (string3 != null) {
                Trial trial = this.setTrial(experiment, string3);
                objectArray[2] = trial;
                if (string4 != null) {
                    Metric metric = this.setMetric(trial, string4);
                    objectArray[3] = metric;
                }
            }
        }
        this.model.setCurrentSelection(objectArray);
    }

    public void testCharts() throws Exception {
        PerfExplorerChart.doTotalTimeChart();
        PerfExplorerChart.doTimestepsChart();
        PerfExplorerChart.doEfficiencyChart();
        PerfExplorerChart.doSpeedupChart();
        PerfExplorerChart.doEfficiencyOneEventChart();
        PerfExplorerChart.doSpeedupOneEventChart();
        PerfExplorerChart.doEfficiencyEventsChart();
        PerfExplorerChart.doSpeedupEventsChart();
        PerfExplorerChart.doCommunicationChart();
        PerfExplorerChart.doFractionChart();
        PerfExplorerChart.doCorrelationChart();
        PerfExplorerChart.doEfficiencyPhasesChart();
        PerfExplorerChart.doSpeedupPhasesChart();
        PerfExplorerChart.doFractionPhasesChart();
    }

    public void testVisualization() throws Exception {
        PerfExplorerVariation.doVariationAnalysis();
        PerfExplorerBoxChart.doIQRBoxChart();
        PerfExplorerHistogramChart.doHistogram();
        PerfExplorerProbabilityPlot.doProbabilityPlot();
    }

    public void testViews() throws Exception {
        PerfExplorerOutput.print("total time:   ");
        PerfExplorerChart.doTotalTimeChart();
        PerfExplorerOutput.print("timesteps:   ");
        PerfExplorerChart.doTimestepsChart();
        PerfExplorerOutput.print("efficiency:   ");
        PerfExplorerChart.doEfficiencyChart();
        PerfExplorerOutput.print("speedup:   ");
        PerfExplorerChart.doSpeedupChart();
        PerfExplorerOutput.print("efficiency one:   ");
        PerfExplorerChart.doEfficiencyOneEventChart();
        PerfExplorerOutput.print("speedup one:   ");
        PerfExplorerChart.doSpeedupOneEventChart();
        PerfExplorerOutput.print("efficiency all:   ");
        PerfExplorerChart.doEfficiencyEventsChart();
        PerfExplorerOutput.print("speedup all:   ");
        PerfExplorerChart.doSpeedupEventsChart();
        PerfExplorerOutput.print("group:   ");
        PerfExplorerChart.doCommunicationChart();
        PerfExplorerOutput.print("fraction:   ");
        PerfExplorerChart.doFractionChart();
        PerfExplorerOutput.print("correlation:   ");
        PerfExplorerChart.doCorrelationChart();
        PerfExplorerOutput.print("efficiency phases:   ");
        PerfExplorerChart.doEfficiencyPhasesChart();
        PerfExplorerOutput.print("speedup phases:   ");
        PerfExplorerChart.doSpeedupPhasesChart();
        PerfExplorerOutput.print("fraction phases:   ");
        PerfExplorerChart.doFractionPhasesChart();
    }

    public void getViews(String string, ArrayList arrayList) throws Exception {
        Object object;
        Object object2;
        List list = this.connection.getViews(Integer.parseInt(string));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (RMIView)iterator.next();
            System.out.println("VIEW: " + ((RMIView)object2).getField("NAME"));
            if (((RMIView)object2).getField("VALUE").equals("gyro.B1-std.HPM")) {
                this.foundView = true;
            }
            object = new ArrayList(arrayList);
            ((ArrayList)object).add(object2);
            this.getViews(((RMIView)object2).getField("ID"), (ArrayList)object);
        }
        if (list.size() == 0) {
            if (this.viewList == null && this.foundView) {
                this.viewList = arrayList.toArray();
            }
            object2 = this.connection.getTrialsForView(arrayList);
            object = null;
            while (object2.hasNext()) {
                object = (Trial)object2.next();
                System.out.println("TRIAL: " + object.getName());
            }
        }
    }

    public void testCluster() throws Exception {
        this.model.setDimensionReduction(TransformationType.OVER_X_PERCENT);
        this.model.setNumberOfClusters("10");
        this.model.setXPercent("2");
        String string = this.connection.requestAnalysis(this.model, true);
        System.out.println(string);
        if (string.equalsIgnoreCase("Request already exists")) {
            System.out.println(this.connection.requestAnalysis(this.model, true));
        }
        Thread.sleep(5000L);
    }

    public void testCorrelation() throws Exception {
        this.model.setClusterMethod(AnalysisType.CORRELATION_ANALYSIS);
        this.model.setDimensionReduction(TransformationType.OVER_X_PERCENT);
        this.model.setXPercent("2");
        String string = this.connection.requestAnalysis(this.model, true);
        System.out.println(string);
        if (string.equalsIgnoreCase("Request already exists")) {
            System.out.println(this.connection.requestAnalysis(this.model, true));
        }
        Thread.sleep(5000L);
    }

    public void testScripting() throws Exception {
        TauScripter.execfile((String)"etc/milc.py");
    }

    public static void main(String[] stringArray) {
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option2 = cmdLineParser.addBooleanOption('s', "standalone");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('c', "configfile");
        CmdLineParser.Option option4 = cmdLineParser.addStringOption('e', "engine");
        CmdLineParser.Option option5 = cmdLineParser.addBooleanOption('q', "quiet");
        CmdLineParser.Option option6 = cmdLineParser.addStringOption('t', "test");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            System.err.println(USAGE);
            System.exit(-1);
        }
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option);
        Boolean bl2 = (Boolean)cmdLineParser.getOptionValue(option2);
        String string = (String)cmdLineParser.getOptionValue(option3);
        String string2 = (String)cmdLineParser.getOptionValue(option4);
        Boolean bl3 = (Boolean)cmdLineParser.getOptionValue(option5);
        String string3 = (String)cmdLineParser.getOptionValue(option6);
        EngineType engineType = EngineType.WEKA;
        if (bl != null && bl.booleanValue()) {
            System.err.println(USAGE);
            System.exit(-1);
        }
        if (bl3 == null) {
            bl3 = new Boolean(false);
        }
        if (bl2 == null) {
            bl2 = new Boolean(false);
        }
        string3 = string3 == null ? new String("all") : string3.toLowerCase();
        if (bl2.booleanValue()) {
            if (string == null) {
                System.err.println("Please enter a valid config file.");
                System.err.println(USAGE);
                System.exit(-1);
            }
            try {
                engineType = EngineType.getType(string2);
            }
            catch (Exception exception) {
                System.err.println("Please enter a valid engine type.");
                System.err.println(USAGE);
                System.exit(-1);
            }
        }
        TestType testType = null;
        try {
            testType = TestType.getType(string3);
        }
        catch (Exception exception) {
            System.err.println("Please enter a valid test.");
            System.err.println(USAGE);
            System.exit(-1);
        }
        TestHarness testHarness = new TestHarness(bl2, string, engineType, bl3, testType);
    }
}

