/*
 * Decompiled with CFR 0.152.
 */
package server;

import clustering.AnalysisFactory;
import clustering.ClusterException;
import clustering.KMeansClusterInterface;
import clustering.RawDataInterface;
import common.AnalysisType;
import common.ChartType;
import common.PerfExplorerException;
import common.PerfExplorerOutput;
import common.RMIPerfExplorerModel;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.database.DB;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.util.Hashtable;
import java.util.List;
import java.util.TimerTask;
import server.DataUtils;
import server.DendrogramTree;
import server.ImageUtils;
import server.PerfExplorerServer;
import server.Thumbnail;
import server.VirtualTopology;

public class AnalysisTask
extends TimerTask {
    private ChartType chartType = ChartType.DENDROGRAM;
    private AnalysisFactory factory = null;
    private RMIPerfExplorerModel modelData = null;
    private PerfExplorerServer server = null;
    private DatabaseAPI session = null;
    private int analysisID = 0;
    private int numTotalThreads = 0;
    private RawDataInterface rawData = null;
    private List eventIDs = null;
    private double rCorrelation = 0.0;
    private boolean correlateToMain = false;

    public AnalysisTask(PerfExplorerServer perfExplorerServer, DatabaseAPI databaseAPI) {
        this.server = perfExplorerServer;
        this.session = databaseAPI;
        this.factory = perfExplorerServer.getAnalysisFactory();
    }

    public void saveAnalysisResult(String string, String string2, String string3, boolean bl) throws PerfExplorerException {
        Thumbnail.createThumbnail(string2, string3, bl);
        try {
            DB dB = this.session.db();
            PreparedStatement preparedStatement = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("insert into analysis_result (analysis_settings, ");
            stringBuffer.append("description, thumbnail_size, image_size, thumbnail, ");
            stringBuffer.append("image, result_type) values ");
            stringBuffer.append("(?, ?, ?, ?, ?, ?, ?) ");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.analysisID);
            preparedStatement.setString(2, string2);
            File file = new File(string2);
            FileInputStream fileInputStream = new FileInputStream(file);
            File file2 = new File(string3);
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            preparedStatement.setInt(3, (int)file2.length());
            preparedStatement.setInt(4, (int)file.length());
            preparedStatement.setBinaryStream(5, (InputStream)fileInputStream2, (int)file2.length());
            preparedStatement.setBinaryStream(6, (InputStream)fileInputStream, (int)file.length());
            preparedStatement.setString(7, this.chartType.toString());
            preparedStatement.executeUpdate();
            fileInputStream.close();
            preparedStatement.close();
            file.delete();
            file2.delete();
        }
        catch (Exception exception) {
            String string4 = "ERROR: Couldn't insert the analysis results into the database!";
            System.err.println(string4);
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            throw new PerfExplorerException(string4, exception);
        }
    }

    public void saveAnalysisResult(RawDataInterface rawDataInterface, RawDataInterface rawDataInterface2, File file, File file2) throws PerfExplorerException {
        try {
            DB dB = this.session.db();
            dB.setAutoCommit(false);
            PreparedStatement preparedStatement = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("insert into analysis_result ");
            stringBuffer.append(" (analysis_settings, description, thumbnail_size, thumbnail, image_size, image, result_type) values (?, ?, ?, ?, ?, ?, ?)");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.analysisID);
            preparedStatement.setString(2, new String("analysis_result"));
            FileInputStream fileInputStream = new FileInputStream(file);
            preparedStatement.setInt(3, (int)file2.length());
            preparedStatement.setBinaryStream(4, (InputStream)fileInputStream, (int)file.length());
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            preparedStatement.setInt(5, (int)file2.length());
            preparedStatement.setBinaryStream(6, (InputStream)fileInputStream2, (int)file2.length());
            preparedStatement.setString(7, this.chartType.toString());
            preparedStatement.executeUpdate();
            preparedStatement.close();
            dB.commit();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't insert the analysis results into the database!";
            System.err.println(string);
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            throw new PerfExplorerException(string, exception);
        }
    }

    public DendrogramTree createDendrogramTree(int[] nArray, double[] dArray) {
        DendrogramTree dendrogramTree = null;
        DendrogramTree dendrogramTree2 = null;
        DendrogramTree dendrogramTree3 = null;
        Hashtable<Integer, DendrogramTree> hashtable = new Hashtable<Integer, DendrogramTree>(nArray.length);
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            dendrogramTree = nArray[n] < 0 ? new DendrogramTree(nArray[n], 0.0) : (DendrogramTree)hashtable.get(new Integer(nArray[n]));
            dendrogramTree2 = nArray[++n] < 0 ? new DendrogramTree(nArray[n], 0.0) : (DendrogramTree)hashtable.get(new Integer(nArray[n]));
            ++n;
            dendrogramTree3 = new DendrogramTree(i + 1, dArray[i]);
            dendrogramTree3.setLeftAndRight(dendrogramTree, dendrogramTree2);
            hashtable.put(new Integer(i + 1), dendrogramTree3);
        }
        return dendrogramTree3;
    }

    public RawDataInterface doDimensionReduction() {
        return this.rawData;
    }

    public void run() {
        this.modelData = this.server.getNextRequest();
        if (this.modelData != null) {
            this.analysisID = this.modelData.getAnalysisID();
            try {
                PerfExplorerOutput.println("Processing " + this.modelData.toString());
                this.rawData = DataUtils.getRawData(this.session, this.modelData);
                this.eventIDs = this.rawData.getEventNames();
                this.numTotalThreads = this.rawData.numVectors();
                RawDataInterface rawDataInterface = this.doDimensionReduction();
                if (this.modelData.getClusterMethod().equals(AnalysisType.K_MEANS)) {
                    int n = this.numTotalThreads <= this.modelData.getNumberOfClusters() ? this.numTotalThreads - 1 : this.modelData.getNumberOfClusters();
                    for (int i = 2; i <= n; ++i) {
                        RawDataInterface[] rawDataInterfaceArray;
                        Object object;
                        Object object2;
                        PerfExplorerOutput.println("Doing " + i + " clusters:" + this.modelData.toString());
                        KMeansClusterInterface kMeansClusterInterface = this.factory.createKMeansEngine();
                        kMeansClusterInterface.setInputData(rawDataInterface);
                        kMeansClusterInterface.setK(i);
                        kMeansClusterInterface.findClusters();
                        RawDataInterface rawDataInterface2 = kMeansClusterInterface.getClusterCentroids();
                        RawDataInterface rawDataInterface3 = kMeansClusterInterface.getClusterStandardDeviations();
                        int[] nArray = kMeansClusterInterface.getClusterSizes();
                        File file = ImageUtils.generateClusterSizeThumbnail(this.modelData, nArray, this.eventIDs);
                        File file2 = ImageUtils.generateClusterSizeImage(this.modelData, nArray, this.eventIDs);
                        this.chartType = ChartType.HISTOGRAM;
                        this.saveAnalysisResult(rawDataInterface2, rawDataInterface3, file, file2);
                        if (this.modelData.getCurrentSelection() instanceof Metric) {
                            object2 = this.factory.createPCAEngine(this.server.getCubeData(this.modelData));
                            object2.setInputData(rawDataInterface);
                            object2.doPCA();
                            object = object2.getResults();
                            object2.setClusterer(kMeansClusterInterface);
                            rawDataInterfaceArray = object2.getClusters();
                            this.rCorrelation = 0.0;
                            file = ImageUtils.generateClusterScatterplotThumbnail(ChartType.PCA_SCATTERPLOT, this.modelData, rawDataInterfaceArray);
                            file2 = ImageUtils.generateClusterScatterplotImage(ChartType.PCA_SCATTERPLOT, this.modelData, (RawDataInterface)object, rawDataInterfaceArray);
                            this.saveAnalysisResult((RawDataInterface)object, (RawDataInterface)object, file, file2);
                        }
                        object2 = new VirtualTopology(this.modelData, kMeansClusterInterface);
                        object = ((VirtualTopology)object2).getImage();
                        rawDataInterfaceArray = ((VirtualTopology)object2).getThumbnail();
                        this.saveAnalysisResult("Virtual Topology", (String)object, (String)rawDataInterfaceArray, false);
                        this.chartType = ChartType.CLUSTER_MINIMUMS;
                        file = ImageUtils.generateBreakdownThumbnail(this.modelData, kMeansClusterInterface.getClusterMinimums(), rawDataInterface3, this.eventIDs);
                        file2 = ImageUtils.generateBreakdownImage(this.chartType, this.modelData, kMeansClusterInterface.getClusterMinimums(), rawDataInterface3, this.eventIDs);
                        this.saveAnalysisResult(kMeansClusterInterface.getClusterMinimums(), rawDataInterface3, file, file2);
                        this.chartType = ChartType.CLUSTER_AVERAGES;
                        file = ImageUtils.generateBreakdownThumbnail(this.modelData, rawDataInterface2, rawDataInterface3, this.eventIDs);
                        file2 = ImageUtils.generateBreakdownImage(this.chartType, this.modelData, rawDataInterface2, rawDataInterface3, this.eventIDs);
                        this.saveAnalysisResult(rawDataInterface2, rawDataInterface3, file, file2);
                        this.chartType = ChartType.CLUSTER_MAXIMUMS;
                        file = ImageUtils.generateBreakdownThumbnail(this.modelData, kMeansClusterInterface.getClusterMaximums(), rawDataInterface3, this.eventIDs);
                        file2 = ImageUtils.generateBreakdownImage(this.chartType, this.modelData, kMeansClusterInterface.getClusterMaximums(), rawDataInterface3, this.eventIDs);
                        this.saveAnalysisResult(kMeansClusterInterface.getClusterMaximums(), rawDataInterface3, file, file2);
                    }
                } else {
                    PerfExplorerOutput.println("Doing Correlation Analysis...");
                    this.chartType = ChartType.CORRELATION_SCATTERPLOT;
                    for (int i = 0; i < rawDataInterface.numDimensions(); ++i) {
                        for (int j = 0; j < rawDataInterface.numDimensions(); ++j) {
                            this.rCorrelation = rawDataInterface.getCorrelation(i, j);
                            File file = ImageUtils.generateCorrelationScatterplotThumbnail(this.chartType, this.modelData, rawDataInterface, i, j, this.correlateToMain);
                            File file3 = ImageUtils.generateCorrelationScatterplotImage(this.chartType, this.modelData, rawDataInterface, i, j, this.correlateToMain, this.rCorrelation);
                            this.saveAnalysisResult(rawDataInterface, rawDataInterface, file, file3);
                        }
                    }
                }
            }
            catch (PerfExplorerException perfExplorerException) {
                System.err.println(perfExplorerException.getMessage());
                perfExplorerException.printStackTrace();
            }
            catch (ClusterException clusterException) {
                System.err.println(clusterException.getMessage());
                clusterException.printStackTrace();
            }
            this.server.taskFinished();
            this.modelData = null;
        }
    }
}

