/*
 * Decompiled with CFR 0.152.
 */
package server;

import common.ChartDataType;
import common.PerfExplorerOutput;
import common.RMIGeneralChartData;
import common.RMIPerfExplorerModel;
import common.TransformationType;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DB;
import java.sql.ResultSet;
import java.util.List;
import server.PerfExplorerServer;

public class GeneralChartData
extends RMIGeneralChartData {
    private RMIPerfExplorerModel model;
    private String metricName = null;
    private String groupName = null;
    private String eventName = null;
    private String groupByColumn = null;
    private List columnValues = null;
    private StringBuffer buf = null;

    public GeneralChartData(RMIPerfExplorerModel rMIPerfExplorerModel, ChartDataType chartDataType) {
        super(chartDataType);
        this.model = rMIPerfExplorerModel;
        this.metricName = rMIPerfExplorerModel.getMetricName();
        this.groupName = rMIPerfExplorerModel.getGroupName();
        this.eventName = rMIPerfExplorerModel.getEventName();
    }

    public static GeneralChartData getChartData(RMIPerfExplorerModel rMIPerfExplorerModel, ChartDataType chartDataType) {
        PerfExplorerOutput.println("getChartData(" + rMIPerfExplorerModel.toString() + ")...");
        GeneralChartData generalChartData = new GeneralChartData(rMIPerfExplorerModel, chartDataType);
        generalChartData.doQuery();
        return generalChartData;
    }

    private void doQuery() {
        Object object = null;
        try {
            String string;
            int n;
            List list;
            List list2;
            int n2;
            int n3;
            Object object2;
            DB dB = PerfExplorerServer.getServer().getDB();
            Object object3 = this.model.getCurrentSelection();
            this.buf = this.buildCreateTableStatement("temp_trial", dB);
            this.buf.append("(select trial.* from trial ");
            this.buf.append("inner join experiment ");
            this.buf.append("on trial.experiment = experiment.id ");
            this.buf.append("inner join application ");
            this.buf.append("on experiment.application = application.id ");
            this.buf.append("where ");
            List list3 = this.model.getMultiSelection();
            if (list3 == null) {
                object2 = this.model.getCurrentSelection();
                if (object2 instanceof Application) {
                    this.buf.append("application.id = " + this.model.getApplication().getID());
                } else if (object2 instanceof Experiment) {
                    this.buf.append("experiment.id = " + this.model.getExperiment().getID());
                } else if (object2 instanceof Trial) {
                    this.buf.append("trial.id = " + this.model.getTrial().getID());
                }
            } else {
                int n4;
                boolean bl = false;
                for (n3 = 0; n3 < list3.size(); ++n3) {
                    if (!(list3.get(n3) instanceof Application)) continue;
                    Application application = (Application)list3.get(n3);
                    if (!bl) {
                        this.buf.append("application.id in (");
                        bl = true;
                    } else {
                        this.buf.append(",");
                    }
                    this.buf.append(application.getID());
                }
                if (bl) {
                    this.buf.append(") ");
                }
                n3 = 0;
                for (n4 = 0; n4 < list3.size(); ++n4) {
                    if (!(list3.get(n4) instanceof Experiment)) continue;
                    Experiment experiment = (Experiment)list3.get(n4);
                    if (n3 == 0) {
                        if (bl) {
                            this.buf.append(" and ");
                        }
                        this.buf.append("experiment.id in (");
                        n3 = 1;
                    } else {
                        this.buf.append(",");
                    }
                    this.buf.append(experiment.getID());
                }
                if (n3 != 0) {
                    this.buf.append(") ");
                }
                n4 = 0;
                for (n2 = 0; n2 < list3.size(); ++n2) {
                    if (!(list3.get(n2) instanceof Trial)) continue;
                    Trial trial = (Trial)list3.get(n2);
                    if (n4 == 0) {
                        if (bl || n3 != 0) {
                            this.buf.append(" and ");
                        }
                        this.buf.append("trial.id in (");
                        n4 = 1;
                    } else {
                        this.buf.append(",");
                    }
                    this.buf.append(trial.getID());
                }
                if (n4 != 0) {
                    this.buf.append(") ");
                }
            }
            this.buf.append(") ");
            object = dB.prepareStatement(this.buf.toString());
            object.execute();
            object.close();
            this.buf = this.buildCreateTableStatement("temp_metric", dB);
            this.buf.append("(select metric.* from metric ");
            this.buf.append("inner join temp_trial ");
            this.buf.append("on metric.trial = temp_trial.id ");
            object2 = this.model.getMetricNames();
            if (object2 != null) {
                if (dB.getDBType().compareTo("db2") == 0) {
                    this.buf.append("where metric.name like ? ");
                } else {
                    this.buf.append("where metric.name = ? ");
                }
                for (n3 = 1; n3 < object2.size(); ++n3) {
                    if (dB.getDBType().compareTo("db2") == 0) {
                        this.buf.append("or metric.name like ? ");
                        continue;
                    }
                    this.buf.append("or metric.name = ? ");
                }
            }
            this.buf.append(") ");
            object = dB.prepareStatement(this.buf.toString());
            if (object2 != null) {
                for (n3 = 1; n3 <= object2.size(); ++n3) {
                    String string2 = (String)object2.get(n3 - 1);
                    object.setString(n3, string2);
                }
            }
            object.execute();
            object.close();
            this.buf = this.buildCreateTableStatement("temp_event", dB);
            this.buf.append("(select interval_event.* from interval_event ");
            this.buf.append("inner join temp_trial ");
            this.buf.append("on interval_event.trial = temp_trial.id ");
            this.buf.append("inner join interval_mean_summary ");
            this.buf.append("on interval_mean_summary.interval_event = interval_event.id ");
            this.buf.append("inner join temp_metric ");
            this.buf.append("on interval_mean_summary.metric = temp_metric.id ");
            n3 = 0;
            if (this.model.getMainEventOnly()) {
                this.buf.append("where interval_mean_summary.inclusive_percentage = 100 ");
                n3 = 1;
            }
            if (this.model.getEventNoCallpath()) {
                if (n3 != 0) {
                    this.buf.append("and ");
                } else {
                    this.buf.append("where ");
                    n3 = 1;
                }
                this.buf.append("(interval_event.group_name is null ");
                this.buf.append("or (interval_event.group_name not like '%TAU_CALLPATH%' ");
                this.buf.append("and interval_event.group_name not like '%TAU_PHASE%')) ");
            }
            if (this.model.getDimensionReduction() == TransformationType.OVER_X_PERCENT) {
                if (n3 != 0) {
                    this.buf.append("and ");
                } else {
                    this.buf.append("where ");
                    n3 = 1;
                }
                this.buf.append("interval_mean_summary.exclusive_percentage > ");
                this.buf.append(this.model.getXPercent());
                this.buf.append(" ");
            }
            if (this.model.getEventExclusive100()) {
                if (n3 != 0) {
                    this.buf.append("and ");
                } else {
                    this.buf.append("where ");
                    n3 = 1;
                }
                this.buf.append("interval_mean_summary.exclusive_percentage = 100 ");
            }
            if ((list2 = this.model.getGroupNames()) != null) {
                n2 = 0;
                for (int i = 0; i < list2.size(); ++i) {
                    if (n3 != 0) {
                        if (n2 != 0) {
                            this.buf.append("or ");
                        } else {
                            this.buf.append("and ");
                            n2 = 1;
                        }
                    } else {
                        this.buf.append("where ");
                        n3 = 1;
                    }
                    if (dB.getDBType().compareTo("db2") == 0) {
                        this.buf.append("interval_event.group_name like ? ");
                        continue;
                    }
                    this.buf.append("interval_event.group_name = ? ");
                }
            }
            if ((list = this.model.getEventNames()) != null) {
                boolean bl = false;
                for (n = 0; n < list.size(); ++n) {
                    if (n3 != 0) {
                        if (bl) {
                            this.buf.append("or ");
                        } else {
                            this.buf.append("and ");
                            bl = true;
                        }
                    } else {
                        this.buf.append("where ");
                        n3 = 1;
                    }
                    if (dB.getDBType().compareTo("db2") == 0) {
                        this.buf.append("interval_event.name like ? ");
                        continue;
                    }
                    this.buf.append("interval_event.name = ? ");
                }
            }
            this.buf.append(")");
            object = dB.prepareStatement(this.buf.toString());
            int n5 = 1;
            if (list2 != null) {
                for (n = 0; n < list2.size(); ++n) {
                    string = (String)list2.get(n);
                    object.setString(n5, string);
                    ++n5;
                }
            }
            if (list != null) {
                for (n = 0; n < list.size(); ++n) {
                    string = (String)list.get(n);
                    object.setString(n5, string);
                    ++n5;
                }
            }
            object.execute();
            object.close();
            String string3 = this.model.getChartSeriesName();
            string = this.model.getChartXAxisName();
            String string4 = this.model.getChartYAxisName();
            this.buf = new StringBuffer();
            this.buf.append("select ");
            this.buf.append(this.fixClause(string3, dB) + " as series_name, ");
            this.buf.append(this.fixClause(string, dB) + " as xaxis_value, ");
            this.buf.append(this.fixClause(string4, dB) + " as yaxis_value ");
            this.buf.append("from interval_mean_summary ");
            this.buf.append("inner join temp_metric ");
            this.buf.append("on interval_mean_summary.metric = temp_metric.id ");
            this.buf.append("inner join temp_event ");
            this.buf.append("on interval_mean_summary.interval_event = temp_event.id ");
            this.buf.append("inner join temp_trial ");
            this.buf.append("on temp_event.trial = temp_trial.id ");
            this.buf.append("inner join experiment ");
            this.buf.append("on temp_trial.experiment = experiment.id ");
            this.buf.append("inner join application ");
            this.buf.append("on experiment.application = application.id ");
            this.buf.append("group by " + this.fixClause(string3, dB));
            this.buf.append(", " + this.fixClause(string, dB) + " ");
            this.buf.append("order by 1, 2 ");
            object = dB.prepareStatement(this.buf.toString());
            ResultSet resultSet = object.executeQuery();
            boolean bl = false;
            while (resultSet.next()) {
                this.addRow(resultSet.getString(1), resultSet.getString(2), resultSet.getDouble(3));
            }
            resultSet.close();
            object.close();
            object = dB.prepareStatement("truncate table temp_event");
            object.execute();
            object.close();
            object = dB.prepareStatement("drop table temp_event");
            object.execute();
            object.close();
            object = dB.prepareStatement("truncate table temp_metric");
            object.execute();
            object.close();
            object = dB.prepareStatement("drop table temp_metric");
            object.execute();
            object.close();
            object = dB.prepareStatement("truncate table temp_trial");
            object.execute();
            object.close();
            object = dB.prepareStatement("drop table temp_trial");
            object.execute();
            object.close();
        }
        catch (Exception exception) {
            if (object != null) {
                PerfExplorerOutput.println(object.toString());
            }
            PerfExplorerOutput.println(this.buf.toString());
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private StringBuffer buildCreateTableStatement(String string, DB dB) {
        StringBuffer stringBuffer = new StringBuffer();
        if (dB.getDBType().equalsIgnoreCase("oracle")) {
            stringBuffer.append("create global ");
        } else if (dB.getDBType().equalsIgnoreCase("derby") || dB.getDBType().equalsIgnoreCase("db2")) {
            stringBuffer.append("declare global ");
        } else {
            stringBuffer.append("create ");
        }
        stringBuffer.append("temporary table ");
        stringBuffer.append(string);
        stringBuffer.append(" as ");
        return stringBuffer;
    }

    private String fixClause(String string, DB dB) {
        String string2 = string.replaceAll("trial.", "temp_trial.").replaceAll("metric.", "temp_metric.").replaceAll("interval_event.", "temp_event.");
        if (dB.getDBType().equalsIgnoreCase("oracle")) {
            string2 = string2.replaceAll("exclusive", "exec");
        }
        if (dB.getDBType().equalsIgnoreCase("derby")) {
            string2 = string2.replaceAll("call", "num_calls");
        }
        return string2;
    }
}

