/****************************************************************************
 *			Tuning and Analysis Utilities
 *			http://www.cs.uoregon.edu/research/paracomp/tau
 ****************************************************************************
 * Copyright (c) 1997-2006
 *    Department of Computer and Information Science, University of Oregon
 *    Advanced Computing Laboratory, Los Alamos National Laboratory
 *    Research Center Juelich, ZAM Germany	
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Wyatt Spear - initial API and implementation
 ****************************************************************************/
package org.eclipse.ptp.tau.core.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.Window;
//import org.eclipse.ptp.internal.core.CoreMessages;
//import org.eclipse.ptp.launch.ui.PLaunchConfigurationTab;
import org.eclipse.ptp.tau.core.internal.LaunchImages;
import org.eclipse.ptp.tau.options.TAUOptionsPlugin;
import org.eclipse.ptp.tau.papiselect.PapiListSelectionDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/**
 * 
 */
public class AnalysisTab extends AbstractLaunchConfigurationTab {
	
	protected Button mpiCheck;
	//protected Button pdtCheck;
	
	protected Button callpathCheck;
	protected Button memoryCheck;
	
	protected Button openmpCheck;
	protected Button opariCheck;
	protected Button epilogCheck;
	protected Button vtraceCheck;
	
	protected Button papiCheck;
	protected Button papiSelect;
	protected Button papiCountRadios[];
	protected Composite papiComp;
	
	protected Button perfCheck;
	protected Button traceCheck;
	protected Button phaseCheck;
	//protected Button icpcCheck;
	protected Composite selComp;
	protected Label selectLabel;
	protected Button selectRadios[];
	protected Text compiler;
	
	protected Button buildonlyCheck;
	protected Button nocleanCheck;
	protected Button keepprofsCheck;
	
	protected Text tauArch = null;
	protected Button browseSelfileButton = null;
	
	protected LinkedHashSet allmakefiles=null;
	protected LinkedHashSet selmakefiles=null;
	protected LinkedHashSet allopts=null;
	protected LinkedHashSet selopts=null;
	protected Combo makecombo =null;
	protected String selmakefile=null;
	private String tlpath=null;
	
	protected Map archvarmap = null;//PAPI Map entries
	protected Map varmap = null;
	//protected Map environ = null;//Current environment
	//protected int numvars=0;

	protected class WidgetListener extends SelectionAdapter implements ModifyListener,IPropertyChangeListener {
		public void widgetSelected(SelectionEvent e) {
			
			Object source = e.getSource();
			
			if(source==makecombo){
				selmakefile=makecombo.getItem(makecombo.getSelectionIndex());
				if(selmakefile.indexOf("-papi")>0&&selmakefile.indexOf("-multiplecounters")>0)
					papiSelect.setEnabled(true);
				else
					papiSelect.setEnabled(false);
			}
			
			if(source == browseSelfileButton) {
				handleSelfileBrowseButtonSelected();
			}
			else
			if(source==papiSelect){
				handlePapiSelect();
			}
			else
			if(source.equals(selectRadios[2]))
			{
				if(!selectRadios[2].getSelection()){
					selComp.setEnabled(false);
					tauArch.setEnabled(false);
					tauArch.setEnabled(false);
				}
				else
				{
					selComp.setEnabled(true);
					tauArch.setEnabled(true);
					tauArch.setEnabled(true);
				}
			}
			else
				if(source==callpathCheck)
				{
					String cmd = "callpath";
					if(((Button)source).getSelection())
					{
						selopts.add(cmd);
					}
					else
					{
						selopts.remove(cmd);
					}
					initMakeCombo();
					reinitMakeChecks();
				}
				else
					if(source==memoryCheck)
					{
						String cmd="memory";
						if(((Button)source).getSelection())
						{
							selopts.add(cmd);
						}
						else
						{
							selopts.remove(cmd);
						}
						initMakeCombo();
						reinitMakeChecks();
					}
					else
						if(source==openmpCheck)
						{
							String cmd="openmp";
							if(((Button)source).getSelection())
							{
								selopts.add(cmd);
							}
							else
							{
								selopts.remove(cmd);
							}
							initMakeCombo();
							reinitMakeChecks();
						}
						else
							if(source==opariCheck)
							{
								String cmd="opari";
								if(((Button)source).getSelection())
								{
									selopts.add(cmd);
								}
								else
								{
									selopts.remove(cmd);
								}
								initMakeCombo();
								reinitMakeChecks();
							}
							else
								if(source==epilogCheck)
								{
									String cmd="epilog";
									if(((Button)source).getSelection())
									{
										selopts.add(cmd);
									}
									else
									{
										selopts.remove(cmd);
									}
									initMakeCombo();
									reinitMakeChecks();
								}
								else
									if(source==vtraceCheck)
									{
										String cmd="vampirtrace";
										if(((Button)source).getSelection())
										{
											selopts.add(cmd);
										}
										else
										{
											selopts.remove(cmd);
										}
										initMakeCombo();
										reinitMakeChecks();
									}
					else
						if(source==papiCheck)
						{
							String cmd="papi";
							if(((Button)source).getSelection())
							{
								selopts.add(cmd);
								selopts.add("multiplecounters");
								papiSelect.setEnabled(true);
							}
							else
							{
								selopts.remove(cmd);
								selopts.remove("multiplecounters");
								papiSelect.setEnabled(false);
							}
							initMakeCombo();
							reinitMakeChecks();
						}
						else
							if(source==perfCheck)
							{
								String cmd="perf";
								if(((Button)source).getSelection())
								{
									selopts.add(cmd);
								}
								else
								{
									selopts.remove(cmd);
								}
								initMakeCombo();
								reinitMakeChecks();
							}
							else
								if(source==traceCheck)
								{
									String cmd="trace";
									if(((Button)source).getSelection())
									{
										selopts.add(cmd);
										selopts.add("profile");
									}
									else
									{
										selopts.remove(cmd);
										selopts.remove("profile");
									}
									initMakeCombo();
									reinitMakeChecks();
								}
								else
									if(source==phaseCheck)
									{
										String cmd="phase";
										if(((Button)source).getSelection())
										{
											selopts.add(cmd);
										}
										else
										{
											selopts.remove(cmd);
										}
										initMakeCombo();
										reinitMakeChecks();
									}
									else
										if(source==mpiCheck)
										{
											String cmd="mpi";
											if(((Button)source).getSelection())
											{
												selopts.add(cmd);
											}
											else
											{
												selopts.remove(cmd);
											}
											initMakeCombo();
											reinitMakeChecks();
										}
			
			updateLaunchConfigurationDialog();
		}

		public void propertyChange(PropertyChangeEvent event) {
			updateLaunchConfigurationDialog();
		}
		
		public void modifyText(ModifyEvent evt) {
			Object source = evt.getSource();
			if(source==tauArch){
				//setupMakefiles();
				//tcombo.select(0);
			}
			//System.out.println("ChangeText");
			updateLaunchConfigurationDialog();
		}
	}

	protected WidgetListener listener = new WidgetListener();

	private void reinitMakeChecks(){
		
		LinkedHashSet goodopts = new LinkedHashSet(allopts.size());
		String holdmake=null;
		String check=null;
		
		if(selopts==null||selopts.size()==0){
			goodopts.addAll(allopts);
		}
		else{
			
				Iterator makes = allmakefiles.iterator();
				boolean allgood=true;
				while(makes.hasNext())
				{
					holdmake=(String)makes.next();
					
					Iterator opts = selopts.iterator();
					
					while(opts.hasNext())
					{
						check=(String)opts.next();
					
						if(holdmake.indexOf("-"+check)<=0)
						{
							allgood=false;break;
						}
					}
					if(allgood==true)
						goodopts.addAll(Arrays.asList(holdmake.split("-")));
					else
						allgood=true;
			}
		}
		//Iterator testit = goodopts.iterator();
		//while(testit.hasNext())System.out.println(testit.next());
		
		if(!goodopts.contains("papi")&&!goodopts.contains("multiplecounters"))
		{
			papiSelect.setEnabled(false);
			papiCheck.setEnabled(false);
		}
		else
		{
			//papiSelect.setEnabled(true);
			papiCheck.setEnabled(true);
		}
		
		if(!goodopts.contains("memory"))
			memoryCheck.setEnabled(false);
		else
			memoryCheck.setEnabled(true);
		
		if(!goodopts.contains("callpath"))
			callpathCheck.setEnabled(false);
		else
			callpathCheck.setEnabled(true);
		
		if(!goodopts.contains("openmp"))
			openmpCheck.setEnabled(false);
		else
			openmpCheck.setEnabled(true);
		
		if(!goodopts.contains("opari"))
			opariCheck.setEnabled(false);
		else
			opariCheck.setEnabled(true);
		
		if(!goodopts.contains("epilog"))
			epilogCheck.setEnabled(false);
		else
			epilogCheck.setEnabled(true);
		
		
		if(!goodopts.contains("vampirtrace"))
			vtraceCheck.setEnabled(false);
		else
			vtraceCheck.setEnabled(true);
		
		if(!goodopts.contains("phase"))
			phaseCheck.setEnabled(false);
		else
			phaseCheck.setEnabled(true);
		
		if(!goodopts.contains("trace")&&!goodopts.contains("profile"))
			traceCheck.setEnabled(false);
		else
			traceCheck.setEnabled(true);
		
		if(!goodopts.contains("perf"))
			perfCheck.setEnabled(false);
		else
			perfCheck.setEnabled(true);
		
		//System.out.println(goodopts.contains("mpi"));
		
		if(!goodopts.contains("mpi"))
			mpiCheck.setEnabled(false);
		else
			mpiCheck.setEnabled(true);
	}
	
	private void initMakeChecks(){
		if(allmakefiles==null||allmakefiles.size()==0||allopts==null||allopts.size()==0)
		{
			papiCheck.setEnabled(false);
			papiSelect.setEnabled(false);
			memoryCheck.setEnabled(false);
			callpathCheck.setEnabled(false);
			phaseCheck.setEnabled(false);
			traceCheck.setEnabled(false);
			perfCheck.setEnabled(false);
			mpiCheck.setEnabled(false);
			openmpCheck.setEnabled(false);
			opariCheck.setEnabled(false);
			epilogCheck.setEnabled(false);
			vtraceCheck.setEnabled(false);
			return;
		}
		
		if(!allopts.contains("papi")&&!allopts.contains("multiplecounters"))
		{
			papiSelect.setEnabled(false);
			papiCheck.setEnabled(false);
		}
		if(!allopts.contains("memory"))
			memoryCheck.setEnabled(false);
		if(!allopts.contains("callpath"))
			callpathCheck.setEnabled(false);
		if(!allopts.contains("phase"))
			phaseCheck.setEnabled(false);
		if(!allopts.contains("trace")&&!allopts.contains("profile"))
			traceCheck.setEnabled(false);
		if(!allopts.contains("perf"))
			perfCheck.setEnabled(false);
		if(!allopts.contains("mpi"))
			mpiCheck.setEnabled(false);
		
		if(!allopts.contains("openmp"))
			openmpCheck.setEnabled(false);
		if(!allopts.contains("opari"))
			opariCheck.setEnabled(false);
		if(!allopts.contains("epilog"))
			epilogCheck.setEnabled(false);
		if(!allopts.contains("vampirtrace"))
			vtraceCheck.setEnabled(false);
	}
	
	private void initMakefiles(){
		IPreferenceStore pstore = TAUOptionsPlugin.getDefault().getPreferenceStore();
		String archpath=pstore.getString("TAUCDTArchPath");
		tlpath = archpath+File.separator+"lib";
		File taulib = new File(tlpath);
		
		class makefilter implements FilenameFilter{
			public boolean accept(File dir, String name) {
				if(name.indexOf("Makefile.tau")!=0 || name.indexOf("-pdt")<=0)//|| name.indexOf("-pdt")<=0 || name.indexOf("-mpi")<=0 
					return false;
				return true;
			}
		}
		File[] mfiles=null;
		makefilter mfilter = new makefilter();
		if(taulib.exists()){
			mfiles = taulib.listFiles(mfilter);
		}
		if(mfiles==null||mfiles.length==0)
		{
//			/mnt/netapp/home/users/wspear/tau2/x86_64
			File test = new File(tlpath);
			//System.out.println(tlpath);
			
				//System.out.println("Error: Please specify a valid TAU arch directory");
				DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
				dialog.setText("Select TAU Arch Directory");
				dialog.setMessage("You must select a valid TAU architecture directory.  Such a directory should be created when you configure and install TAU.  It must contain least one valid stub makefile configured with the Program Database Toolkit (pdt)");
				if (archpath != null) 
				{
					File path = new File(archpath);
					if (path.exists())
						dialog.setFilterPath(path.isFile() ? archpath : path.getParent());
				
					/*
					String correctPath = getFieldContent(tauArch.getText());
				
					}*/
					String selectedPath=null;
					while(true)
					{
						selectedPath = dialog.open();
						if(selectedPath==null)
							break;
							//throw new FileNotFoundException("Invalid TAU Arch Directory");
					
						tlpath=selectedPath+File.separator+"lib";
						test = new File(tlpath);
						if(test.exists()){
							mfiles = test.listFiles(mfilter);
						}
						if (mfiles!=null&&mfiles.length>0)
						{
							pstore.setValue("TAUCDTArchPath", selectedPath);
							break;
						}
					}
				}
			}
		//LinkedHashSet filenames = new LinkedHashSet(Arrays.asList(makefiles));
		allmakefiles = new LinkedHashSet();
		allopts=new LinkedHashSet();
		String name = null;
		for(int i=0;i<mfiles.length;i++)
		{
			name=mfiles[i].getName();
			allmakefiles.add(name);
			allopts.addAll(Arrays.asList(name.split("-")));
			
		}
		allopts.remove("Makefile.tau");
		//Iterator testall = allopts.iterator();
		//while(testall.hasNext())System.out.println(testall.next());
	}
	
	/*(re)populates the makefile combo box with those makefiles that match the selected options*/
	private void initMakeCombo(){try{
		//String oldsel="";
		//if(makecombo.getSelectionIndex()>=0)
		//	oldsel=makecombo.getItem(makecombo.getSelectionIndex());
		String adding="";
		
		makecombo.removeAll();
		//Put the list of valid makefiles in selmakefiles
		selectMakefiles();
		String select="";
		
		//If there are valid makefiles, put each one in the fresh combobox
		if(selmakefiles!=null&&selmakefiles.size()>0)
		{
			Iterator i = selmakefiles.iterator();
			while(i.hasNext())
			{
				adding=(String)i.next();
				//We want to select the minimal (shortest) makefile by default
				if(select.length()>adding.length()||select.equals(""))
				{
					select=adding;
				}
				makecombo.add(adding);
			}
			//If the currently selected makefile is still present, keep it.  Otherwise use the shortest
			if(selmakefile!=null&&makecombo.indexOf(selmakefile)>=0)
				makecombo.select(makecombo.indexOf(selmakefile));
			else
				makecombo.select(makecombo.indexOf(select));
		}
		//If there are no valid makefiles, make it known
		else
		{
			makecombo.add("No Valid Makefiles!");
			makecombo.select(0);
		}
		String checkforpapi=makecombo.getItem(makecombo.getSelectionIndex());
		//If the new makefile has the right options, activate the papi selector
		if(checkforpapi.indexOf("-papi")>0&&checkforpapi.indexOf("-multiplecounters")>0)//makecombo.getItem(makecombo.getSelectionIndex()).indexOf("-papi")>0
			papiSelect.setEnabled(true);
		else
			papiSelect.setEnabled(false);
		makecombo.pack();
	}catch(Exception e){e.printStackTrace();}
	}
	
	/*Populates the set selmakefiles with those makefiles in allmakefiles that contain every option in selopts*/
	private void selectMakefiles(){
		selmakefiles = new LinkedHashSet();
		Iterator allit = allmakefiles.iterator();
		String curmake="";
		String curopt="";
		//Look at each makefile individually
		while(allit.hasNext())
		{
			Iterator nameit = selopts.iterator();
			//Assume the makefile meets the desired criteria
			boolean hasall = true;
			curmake=(String)allit.next();
			//Look at each option in the selected options
			while(nameit.hasNext())
			{
				curopt=(String)nameit.next();
				//If the makefile is missing a required option, mark it a failure and keep checking
				if(curmake.indexOf("-"+curopt)<=0)
				{
					hasall=false;
					break;
				}
			}
			//If the makefile wasn't rejected, add it to the list of selectable makefiles
			if(hasall)
				selmakefiles.add(curmake);
			else
				hasall=true;
		}
	}
	
	/**
	 * @see ILaunchConfigurationTab#createControl(Composite)
	 */
	public void createControl(Composite parent) {
		Composite comp = new Composite(parent, SWT.NONE);
		setControl(comp);

		GridLayout topLayout = new GridLayout();
		comp.setLayout(topLayout);

		Composite parallelComp = new Composite(comp, SWT.NONE);
		parallelComp.setLayout(createGridLayout(1, false, 0, 0));
		parallelComp.setLayoutData(spanGridData(GridData.FILL_HORIZONTAL, 5));

		createVerticalSpacer(parallelComp, 2);

		mpiCheck = createCheckButton(parallelComp, "MPI");
		mpiCheck.setToolTipText("Collect data on MPI based programs.  This option is required for instrumentation of programs that use MPI!  (configure TAU with -mpilib=<dir> and -mpiinc=<dir>)");
		mpiCheck.addSelectionListener(listener);
		
		callpathCheck = createCheckButton(parallelComp, "Callpath Profiling");
		callpathCheck.setToolTipText("Collect callpath data in profile output (configure TAU with -PROFILECALLPATH)");
		callpathCheck.addSelectionListener(listener);
		
		phaseCheck = createCheckButton(parallelComp, "Phase Based Profiling");
		phaseCheck.addSelectionListener(listener);
		
		//createVerticalSpacer(parallelComp, 2);
		memoryCheck = createCheckButton(parallelComp, "Memory Profiling");
		memoryCheck.addSelectionListener(listener);
		
		opariCheck = createCheckButton(parallelComp, "OPARI");
		opariCheck.addSelectionListener(listener);
		
		openmpCheck = createCheckButton(parallelComp, "OpenMP");
		openmpCheck.addSelectionListener(listener);
		
		epilogCheck = createCheckButton(parallelComp, "Epilog");
		epilogCheck.addSelectionListener(listener);
		
		vtraceCheck = createCheckButton(parallelComp, "VampirTrace");
		vtraceCheck.addSelectionListener(listener);
		
		papiComp=new Composite(parallelComp,SWT.NONE);
		papiComp.setLayout(createGridLayout(4, false, 0, 0));
		papiComp.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		papiCheck = createCheckButton(papiComp, "PAPI");
		papiCheck.setToolTipText("Use the PAPI event counter library (configure TAU with -papi=<dir> and -MULTIPLECOUNTERS)");
		papiCheck.addSelectionListener(listener);
		papiSelect=createPushButton(papiComp,"Select PAPI Counters",null);
		papiSelect.setToolTipText("Set PAPI COUNTER environment variables");
		papiSelect.addSelectionListener(listener);
		
		papiCountRadios=new Button[2];
		papiCountRadios[0]=createRadioButton(papiComp,"Preset Counters");
		papiCountRadios[1]=createRadioButton(papiComp,"Native Counters");
		
		perfCheck = createCheckButton(parallelComp, "Perflib");
		perfCheck.addSelectionListener(listener);
		
		traceCheck = createCheckButton(parallelComp, "Trace");
		traceCheck.setToolTipText("Create TAU trace files in addition to profile output.  (configure TAU with -TRACE and -PROFILE)");
		traceCheck.addSelectionListener(listener);
		
		
		//createVerticalSpacer(parallelComp, 2);
		/*
		Composite comComp=new Composite(parallelComp,SWT.NONE);
		comComp.setLayout(createGridLayout(2, false, 0, 0));
		comComp.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		Label compLab = new Label(comComp, 0);
		compLab.setText("Using Compiler:");
		compiler = new Text(comComp, SWT.BORDER | SWT.SINGLE);
		compiler.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		compiler.addModifyListener(listener);*/
		
		Composite makeComp=new Composite(parallelComp,SWT.NONE);
		makeComp.setLayout(createGridLayout(2, false, 0, 0));
		makeComp.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		Label makeLab = new Label(makeComp, 0);
		makeLab.setText("Select Makefile:");
		makecombo = new Combo(makeComp,SWT.DROP_DOWN|SWT.READ_ONLY| SWT.BORDER);
		makecombo.addSelectionListener(listener);

		createVerticalSpacer(parallelComp, 2);
		selectLabel = new Label(parallelComp, SWT.SHADOW_NONE);
		selectLabel.setText("Selective Instrumentation");
		selectRadios = new Button[4];

		selectRadios[0]=createRadioButton(parallelComp, "None");
		selectRadios[0].setToolTipText("Do not use selective instrumentation.");
		selectRadios[1]=createRadioButton(parallelComp, "Internal");
		selectRadios[1].setToolTipText("Use the selective instrumentation file generated by selective instrumentation commands in the workspace.");
		selectRadios[2]=createRadioButton(parallelComp, "User Defined");
		selectRadios[2].setToolTipText("Specify a pre-existing selective instrumentation file.");
		
		selComp = new Composite(parallelComp, SWT.NONE);		
		selComp.setLayout(createGridLayout(2, false, 0, 0));
		selComp.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		tauArch = new Text(selComp, SWT.BORDER | SWT.SINGLE);
		tauArch.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		tauArch.addModifyListener(listener);
		browseSelfileButton = createPushButton(selComp, "Browse", null);
		browseSelfileButton.addSelectionListener(listener);
		
		selectRadios[3]=createRadioButton(parallelComp, "Automatic");
		selectRadios[3].setEnabled(false);
		for(int i=0; i<selectRadios.length;i++)
			selectRadios[i].addSelectionListener(listener);
		
		createVerticalSpacer(parallelComp, 2);
		
		buildonlyCheck = createCheckButton(parallelComp, "Build the instrumented executable but do not launch it");
		buildonlyCheck.addSelectionListener(listener);
		nocleanCheck = createCheckButton(parallelComp, "Keep instrumented executable");
		nocleanCheck.addSelectionListener(listener);
		keepprofsCheck = createCheckButton(parallelComp, "Keep profiles");
		keepprofsCheck.addSelectionListener(listener);
		
	}

	public void updateComboFromSelection() {
		System.out.println("change startup");
	}

	/**
	 * Defaults are empty.
	 * 
	 * @see ILaunchConfigurationTab#setDefaults(ILaunchConfigurationWorkingCopy)
	 */
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute(ITAULaunchConfigurationConstants.MPI, ITAULaunchConfigurationConstants.MPI_DEF);
		configuration.setAttribute(ITAULaunchConfigurationConstants.CALLPATH, ITAULaunchConfigurationConstants.CALLPATH_DEF);
		configuration.setAttribute(ITAULaunchConfigurationConstants.MEMORY, ITAULaunchConfigurationConstants.MEMORY_DEF);
		configuration.setAttribute(ITAULaunchConfigurationConstants.PAPI, ITAULaunchConfigurationConstants.PAPI_DEF);
		configuration.setAttribute(ITAULaunchConfigurationConstants.PERF, ITAULaunchConfigurationConstants.PERF_DEF);
		configuration.setAttribute(ITAULaunchConfigurationConstants.TRACE, ITAULaunchConfigurationConstants.TRACE_DEF);
		configuration.setAttribute(ITAULaunchConfigurationConstants.PHASE, ITAULaunchConfigurationConstants.PHASE_DEF);
		configuration.setAttribute(ITAULaunchConfigurationConstants.COMPILER, ITAULaunchConfigurationConstants.COMPILER_DEF);
		
		configuration.setAttribute(ITAULaunchConfigurationConstants.EPILOG, ITAULaunchConfigurationConstants.EPILOG_DEF);
		configuration.setAttribute(ITAULaunchConfigurationConstants.VAMPIRTRACE, ITAULaunchConfigurationConstants.VAMPIRTRACE_DEF);
		
		configuration.setAttribute(ITAULaunchConfigurationConstants.NOCLEAN, ITAULaunchConfigurationConstants.NOCLEAN_DEF);
		configuration.setAttribute(ITAULaunchConfigurationConstants.KEEPPROFS, ITAULaunchConfigurationConstants.KEEPPROFS_DEF);
		
		configuration.setAttribute(ITAULaunchConfigurationConstants.SELECT, 0);
		configuration.setAttribute(ITAULaunchConfigurationConstants.SELECT_FILE, "");
		
		configuration.setAttribute(ITAULaunchConfigurationConstants.ENVVARS, (Map)null);
		
		configuration.setAttribute(ITAULaunchConfigurationConstants.MAKEFILE, "");
		
	}

	/**
	 * @see ILaunchConfigurationTab#initializeFrom(ILaunchConfiguration)
	 */
	public void initializeFrom(ILaunchConfiguration configuration) {
		try {
			
			selopts=new LinkedHashSet();


			initMakefiles();
			initMakeChecks();
			
			mpiCheck.setSelection(configuration.getAttribute(ITAULaunchConfigurationConstants.MPI, true));

			if(mpiCheck.getSelection()&&mpiCheck.getEnabled())
				selopts.add("mpi");
			
			callpathCheck.setSelection(configuration.getAttribute(ITAULaunchConfigurationConstants.CALLPATH, false));

			if(callpathCheck.getSelection()&&callpathCheck.getEnabled())
				selopts.add("callpath");
			
			memoryCheck.setSelection(configuration.getAttribute(ITAULaunchConfigurationConstants.MEMORY, false));
			
			if(memoryCheck.getSelection()&&memoryCheck.getEnabled())
				selopts.add("memory");
			
			papiCheck.setSelection(configuration.getAttribute(ITAULaunchConfigurationConstants.PAPI, false));
			
			
			if(papiCheck.getSelection()&&papiCheck.getEnabled())
			{
				selopts.add("papi");
				selopts.add("multiplecounters");
			}
			
			int papiSelected = configuration.getAttribute(ITAULaunchConfigurationConstants.PAPISELECT, 0);
			papiCountRadios[papiSelected].setSelection(true);
			
			perfCheck.setSelection(configuration.getAttribute(ITAULaunchConfigurationConstants.PERF, false));
			
			if(perfCheck.getSelection()&&perfCheck.getEnabled())
				selopts.add("perf");
			
			traceCheck.setSelection(configuration.getAttribute(ITAULaunchConfigurationConstants.TRACE, false));
			
			if(traceCheck.getSelection()&&traceCheck.getEnabled())
			{
				selopts.add("trace");
				selopts.add("profile");
			}
			
			phaseCheck.setSelection(configuration.getAttribute(ITAULaunchConfigurationConstants.PHASE, false));
			
			if(phaseCheck.getSelection()&&phaseCheck.getEnabled())
				selopts.add("phase");
			
			
			openmpCheck.setSelection(configuration.getAttribute(ITAULaunchConfigurationConstants.OPENMP, false));
			
			if(openmpCheck.getSelection()&&openmpCheck.getEnabled())
				selopts.add("openmp");
			
			opariCheck.setSelection(configuration.getAttribute(ITAULaunchConfigurationConstants.OPARI, false));
			
			if(opariCheck.getSelection()&&opariCheck.getEnabled())
				selopts.add("opari");
			
			epilogCheck.setSelection(configuration.getAttribute(ITAULaunchConfigurationConstants.EPILOG, false));
			
			if(epilogCheck.getSelection()&&epilogCheck.getEnabled())
				selopts.add("epilog");
			
			vtraceCheck.setSelection(configuration.getAttribute(ITAULaunchConfigurationConstants.VAMPIRTRACE, false));
			
			if(vtraceCheck.getSelection()&&vtraceCheck.getEnabled())
				selopts.add("vampirtrace");



			
			/*
			compiler.setText(configuration.getAttribute(ITAULaunchConfigurationConstants.COMPILER, ""));
			
			if(compiler.getText().length()>2)
			{
				selopts.add(compiler.getText().trim());
			}*/
			
			selmakefile=configuration.getAttribute(ITAULaunchConfigurationConstants.MAKEFILE, (String)null);
			
			initMakeCombo();
			reinitMakeChecks();
			int selected = configuration.getAttribute(ITAULaunchConfigurationConstants.SELECT, 0);
			
			selectRadios[selected].setSelection(true);
			
			tauArch.setText(configuration.getAttribute(ITAULaunchConfigurationConstants.SELECT_FILE, ""));
			
			if(!selectRadios[2].getSelection()){
				selComp.setEnabled(false);
				tauArch.setEnabled(false);
				tauArch.setEnabled(false);
			}
			
			buildonlyCheck.setSelection(configuration.getAttribute(ITAULaunchConfigurationConstants.BUILDONLY, false));
			nocleanCheck.setSelection(configuration.getAttribute(ITAULaunchConfigurationConstants.NOCLEAN, false));
			keepprofsCheck.setSelection(configuration.getAttribute(ITAULaunchConfigurationConstants.KEEPPROFS, false));
			
			
			varmap=archvarmap=configuration.getAttribute(ITAULaunchConfigurationConstants.ENVVARS, (Map)null);

			//if(varmap!=null)numvars=varmap.size();
			
		} catch (CoreException e) {
			setErrorMessage("Core Exception while initializing Analysis tab: "+e.getMessage());
		}
		
	}

	/**
	 * @see ILaunchConfigurationTab#performApply(ILaunchConfigurationWorkingCopy)
	 */
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		
		configuration.setAttribute(ITAULaunchConfigurationConstants.MPI, mpiCheck.getSelection());
		configuration.setAttribute(ITAULaunchConfigurationConstants.CALLPATH, callpathCheck.getSelection());
		configuration.setAttribute(ITAULaunchConfigurationConstants.MEMORY, memoryCheck.getSelection());
		configuration.setAttribute(ITAULaunchConfigurationConstants.PAPI, papiCheck.getSelection());
		configuration.setAttribute(ITAULaunchConfigurationConstants.PERF, perfCheck.getSelection());
		configuration.setAttribute(ITAULaunchConfigurationConstants.TRACE, traceCheck.getSelection());
		configuration.setAttribute(ITAULaunchConfigurationConstants.PHASE, phaseCheck.getSelection());
		
		configuration.setAttribute(ITAULaunchConfigurationConstants.OPENMP, openmpCheck.getSelection());
		configuration.setAttribute(ITAULaunchConfigurationConstants.OPARI, opariCheck.getSelection());
		configuration.setAttribute(ITAULaunchConfigurationConstants.EPILOG, epilogCheck.getSelection());
		configuration.setAttribute(ITAULaunchConfigurationConstants.VAMPIRTRACE, vtraceCheck.getSelection());
		//configuration.setAttribute(ITAULaunchConfigurationConstants.COMPILER, compiler.getText());
		
		configuration.setAttribute(ITAULaunchConfigurationConstants.BUILDONLY, buildonlyCheck.getSelection());
		configuration.setAttribute(ITAULaunchConfigurationConstants.NOCLEAN, nocleanCheck.getSelection());
		configuration.setAttribute(ITAULaunchConfigurationConstants.KEEPPROFS, keepprofsCheck.getSelection());
		
		if((varmap==null&&archvarmap!=null) || (varmap!=null&&archvarmap==null) || (varmap!=null&&archvarmap!=null&&!varmap.equals(archvarmap)))
		{
			Map envvars=null;
			
			try {
				envvars = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, (Map)null);
			} catch (CoreException e) {
				e.printStackTrace();
			}
			
			if(envvars!=null && envvars.size()>0 && archvarmap!=null && archvarmap.size()>0)
			{
				Iterator archit = archvarmap.keySet().iterator();
				while(archit.hasNext())
					envvars.remove(archit.next());
			}
			
			if(varmap!=null&&varmap.size()>0){
				if(envvars==null)envvars=new HashMap();
				envvars.putAll(varmap);
			}
			
			configuration.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, envvars);
				//updateLaunchConfigurationDialog();
			configuration.setAttribute(ITAULaunchConfigurationConstants.ENVVARS, varmap);
		}
		
		//int papiSelected=0;
		if(papiCountRadios[0].getSelection())
			configuration.setAttribute(ITAULaunchConfigurationConstants.SELECT, 0);
		else
			configuration.setAttribute(ITAULaunchConfigurationConstants.SELECT, 1);
		
		int selected = 0;
		for(int i=0; i<selectRadios.length;i++)
		{
			if(selectRadios[i].getSelection())
			{
				selected = i;
				break;
			}
		}
		configuration.setAttribute(ITAULaunchConfigurationConstants.SELECT, selected);
		
		configuration.setAttribute(ITAULaunchConfigurationConstants.SELECT_FILE, tauArch.getText());
		
		configuration.setAttribute(ITAULaunchConfigurationConstants.MAKEFILE, makecombo.getItem(makecombo.getSelectionIndex()));
		
	}


	protected String getFieldContent(IntegerFieldEditor editorField) {
		return getFieldContent(editorField.getStringValue());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#isValid(org.eclipse.debug.core.ILaunchConfiguration)
	 */
	public boolean isValid(ILaunchConfiguration configuration) {
		setErrorMessage(null);
		setMessage(null);

		//if (!numberOfProcessField.isValid()) {
		//	setErrorMessage(numberOfProcessField.getErrorMessage());
		//	return false;
		//}

		/*
		 * if (getFieldContent(numberOfProcessStartField) != null &&
		 * !numberOfProcessStartField.isValid()) {
		 * setErrorMessage(numberOfProcessStartField.getErrorMessage()); return
		 * false; }
		 * 
		 * if (getFieldContent(firstNodeNumberField) != null &&
		 * !firstNodeNumberField.isValid()) {
		 * setErrorMessage(firstNodeNumberField.getErrorMessage()); return
		 * false; }
		 */

		return true;
	}

	protected void handleSelfileBrowseButtonSelected() 
	{
		FileDialog dialog = new FileDialog(getShell());
		dialog.setText("Select TAU Selective Instrumentation File");
		
		String correctPath = getFieldContent(tauArch.getText());
		if (correctPath != null) {
			File path = new File(correctPath);
			if (path.exists())
				dialog.setFilterPath(path.isFile() ? correctPath : path
						.getParent());
		}

		String selectedPath = dialog.open();
		if (selectedPath != null)
			tauArch.setText(selectedPath);
	}
	
	/* public class ListDialog extends Dialog { 
		 Object result; 
		 public ListDialog (Shell parent, int style){ 
			 super (parent, style); } 
		 	public ListDialog (Shell parent)
		 	{ 
		 		this (parent, 0); // your default style bits go here (not the Shell's style bits) 
		 	} 
		 	public Object open(){ 
		 		Shell parent = getParent(); 
		 		Shell shell = new Shell(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL); 
		 		shell.setText(getText()); 
		 		// Your code goes here (widget creation, set result, etc). 
		 		//shell.setSize(100, 400);
		 		shell.setLayout(new FillLayout(SWT.VERTICAL));
		 		shell.setSize(250,400);
		 		//shell.setLayout(createGridLayout(1, false, 0, 0));
				//shell.setLayoutData(spanGridData(GridData.FILL_HORIZONTAL, 5));
		 		List papilist = new List(shell, SWT.MULTI |SWT.BORDER | SWT.V_SCROLL);
		 		//papilist.setSize(50, 50);
		 		
		 		LinkedHashSet counters = PapiSelect.getAvail("/usr/local/packages/papi/bin/", null);
		 		
		 		//Iterator papit = counters.iterator();
		 		//while(papit.hasNext())
		 	//	{
		 		//	papilist.add((String)papit.next());
		 		//}
		 		String[] init = new  String[counters.size()];
		 		counters.toArray(init);
		 		papilist.setItems(init);
		 		//papilist.setSize(100, 400);
		 		//papilist.add("yesy");
		 		//papilist.add("nowu");
		 		//papilist.add("mayb");
		 		//papilist.pack();
		 		//okay.pack();
		 		//cancel.pack();
		 		//shell.pack();
		 		
		 		//Composite endcomp=new Composite(shell,SWT.NONE);
		 		//endcomp.setLayout(createGridLayout(2, false, 0, 0));
		 		//endcomp.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		 		
		 		Button okay = createPushButton(shell, "Okay", null);
		 		Button cancel = createPushButton(shell, "Cancel", null);
		 		okay.setBounds(100, 100, 40, 40);
		 		//FormData button1Data = new FormData ();
		 		//button1Data.right = new FormAttachment (cancel, -4);
		 	    //button1Data.bottom = new FormAttachment (100, 0);
		 	    //okay.setLayoutData (button1Data);
		 		
		 		shell.open(); 
		 		Display display = parent.getDisplay(); 
		 		while (!shell.isDisposed()){ 
		 			if (!display.readAndDispatch()) display.sleep(); 
		 		} 
		 		return result; } }*/
	
	
	private String getPapiLoc() throws FileNotFoundException{
		
		String papimake=tlpath+File.separator+makecombo.getItem(makecombo.getSelectionIndex());
		
		File papimakefile = new File(papimake);
		if(!papimakefile.canRead())
			System.out.println("INVALID MAKEFILE FOR PAPI");
		
		String papiline="";
		boolean found=false;
	    try {
			BufferedReader readmake = new BufferedReader(new FileReader(papimakefile));
			papiline = readmake.readLine();
			while(papiline!=null){
				if(papiline.indexOf("PAPIDIR=")==0)
				{
					found=true;
					break;
				}
				papiline = readmake.readLine();
			}
			readmake.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		
		if(found)
		{
			papiline=papiline.substring(papiline.indexOf("=")+1);
			File papibin = new File(papiline+File.separator+"bin"+File.separator+"papi_event_chooser");
			if(!papibin.canRead())
				papibin = new File(papiline+File.separator+"share"+File.separator+"papi"+File.separator+"utils"+File.separator+"papi_event_chooser");
				
			if(!papibin.canRead())
				throw new FileNotFoundException("Could not locate papi utilities");
			
			papiline=papibin.getParentFile().toString();
		}
		else
			System.out.println("No PAPIDIR in Makefile!");
		
		System.out.println(papimake);
		
		System.out.println(papiline);
		
		return papiline;//"/usr/local/packages/papi/bin/";
	}
	
	protected void handlePapiSelect() 
	{try{
		LabelProvider papilab = new LabelProvider();
		ArrayContentProvider paprov = new ArrayContentProvider();
		
		int papiCountType=0;
		if(papiCountRadios[1].getSelection())
			papiCountType=1;
		PapiListSelectionDialog papidialog= new PapiListSelectionDialog(getShell(), getPapiLoc(), paprov, papilab, "Select the PAPI counters to use with TAU",papiCountType);
		papidialog.setTitle("PAPI Counters");
		papidialog.setHelpAvailable(false);
		if(varmap!=null && varmap.size()>0)
		{
			Iterator checkin = varmap.values().iterator();
			while(checkin.hasNext()){System.out.println("Init: "+checkin.next());}
			papidialog.setInitialSelections(varmap.values().toArray());
		}
		
		if(papidialog.open()==Window.OK)
		{
			Object[] selected = papidialog.getResult();
			//for(int i=0;i<selected.length;i++)
			//System.out.println(selected[i]);
		
			if(selected !=null&&selected.length>0){
				LinkedHashSet selset = new LinkedHashSet(Arrays.asList(selected));
		
				varmap = new HashMap(selset.size());
				varmap.put("COUNTER1", "GET_TIME_OF_DAY");
				Iterator varit = selset.iterator();
				int counter=2;
				while(varit.hasNext()){
					varmap.put("COUNTER"+counter,varit.next());
					counter++;
				}
				
				//System.out.println("Arr "+varmap.entrySet().toArray().toString());
				//updateLaunchConfigurationDialog();
			}else varmap=null;
		}
		//this.getLaunchManager().
		//getWorkingCopy();
		}catch(Exception e){e.printStackTrace();}
	}
	
	/**
	 * @see ILaunchConfigurationTab#getName()
	 */
	public String getName() {
		return "Analysis";//CoreMessages.getResourceString("ParallelTab.Parallel");
	}

	/**
	 * @see ILaunchConfigurationTab#setLaunchConfigurationDialog(ILaunchConfigurationDialog)
	 */
	public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
		super.setLaunchConfigurationDialog(dialog);
	}

	/**
	 * @see ILaunchConfigurationTab#getImage()
	 */
	public Image getImage() {
		return LaunchImages.getImage("org.eclipse.ptp.tau.core.tauLogo.gif");//LaunchImages.IMG_ANALYSIS_TAB
	}
	
    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }
    
    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        if (style == -1)
            gd = new GridData();
        else
            gd = new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }    
    
    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(""))
            return null;
        
        return text;
    }
	
}