/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.paraprof.ColorBar;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.enums.CallGraphOption;
import edu.uoregon.tau.paraprof.graph.Layout;
import edu.uoregon.tau.paraprof.graph.Vertex;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.perfdmf.CallPathUtilFuncs;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Thread;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultGraphSelectionModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;

public class CallGraphWindow
extends JFrame
implements ActionListener,
KeyListener,
ChangeListener,
Observer,
ImageExport,
Printable,
ParaProfWindow {
    private static final int MARGIN = 20;
    private static final int HORIZONTAL_SPACING = 10;
    private static final int VERTICAL_SPACING = 120;
    private ParaProfTrial ppTrial;
    private Thread thread;
    private JMenu optionsMenu;
    private JCheckBoxMenuItem slidersCheckBox;
    private Graph graph;
    private JScrollPane jGraphPane;
    private CallGraphOption widthOption = CallGraphOption.INCLUSIVE;
    private CallGraphOption colorOption = CallGraphOption.EXCLUSIVE;
    private int boxWidth = 120;
    private JLabel boxWidthLabel = new JLabel("Box width");
    private JSlider boxWidthSlider = new JSlider(0, 500, this.boxWidth);
    private List functionProfileList;
    private DefaultGraphModel model;
    private List graphCellList;
    private Object[] cells;
    private List levels;
    private List backEdges;
    private Map vertexMap;
    private int widthMetricID;
    private int colorMetricID;
    private Font font;
    private int boxHeight;
    private double scale = 1.0;

    public CallGraphWindow(ParaProfTrial paraProfTrial, Thread thread, Component component) {
        this.ppTrial = paraProfTrial;
        paraProfTrial.addObserver(this);
        this.colorMetricID = paraProfTrial.getDefaultMetricID();
        this.widthMetricID = paraProfTrial.getDefaultMetricID();
        this.thread = thread;
        if (paraProfTrial.callPathDataPresent()) {
            CallPathUtilFuncs.buildThreadRelations((DataSource)paraProfTrial.getDataSource(), (Thread)thread);
        }
        this.functionProfileList = thread.getFunctionProfiles();
        if (thread.getNodeID() == -1) {
            this.setTitle("TAU: ParaProf: Mean Call Graph - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else if (thread.getNodeID() == -3) {
            this.setTitle("TAU: ParaProf: Standard Deviation Call Graph - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else {
            this.setTitle("TAU: ParaProf: Call Graph for n,c,t, " + thread.getNodeID() + "," + thread.getContextID() + "," + thread.getThreadID() + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        }
        ParaProfUtils.setFrameIcon(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CallGraphWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.getHelpWindow().isVisible()) {
            this.help(false);
        }
        this.setupMenus();
        this.boxWidthSlider.setPaintTicks(true);
        this.boxWidthSlider.setMajorTickSpacing(50);
        this.boxWidthSlider.setMinorTickSpacing(10);
        this.boxWidthSlider.setPaintLabels(true);
        this.boxWidthSlider.setSnapToTicks(false);
        this.boxWidthSlider.addChangeListener(this);
        this.boxWidthSlider.addKeyListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.font = ParaProf.preferencesWindow.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.boxHeight = fontMetrics.getHeight() + 5;
        ColorBar colorBar = new ColorBar();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(colorBar, gridBagConstraints, 0, 0, 2, 1);
        this.createGraph();
        Dimension dimension = this.jGraphPane.getPreferredSize();
        dimension.width += 25;
        dimension.height += 95;
        if (dimension.width > 1000) {
            dimension.width = 1000;
        }
        if (dimension.height > 1000) {
            dimension.height = 1000;
        }
        ((Component)this).setSize(ParaProfUtils.checkSize(dimension));
        ((Component)this).setLocation(WindowPlacer.getNewLocation(this, component));
        ((Component)this).setVisible(true);
        ParaProf.incrementNumWindows();
    }

    private Component createWidthMetricMenu(final CallGraphOption callGraphOption, boolean bl, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        if (this.ppTrial.getNumberOfMetrics() == 1) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(callGraphOption.toString(), bl);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.widthOption = callGraphOption;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            return jRadioButtonMenuItem;
        }
        JMenu jMenu = new JMenu(callGraphOption.toString() + "...");
        int n = 0;
        while (n < this.ppTrial.getNumberOfMetrics()) {
            jRadioButtonMenuItem = n == this.widthMetricID && bl ? new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName(), true) : new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName());
            final int n2 = n++;
            jRadioButtonMenuItem.addActionListener(new ActionListener(){
                final int metric;
                {
                    this.metric = n2;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.widthOption = callGraphOption;
                    CallGraphWindow.this.widthMetricID = this.metric;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    private Component createColorMetricMenu(final CallGraphOption callGraphOption, boolean bl, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        if (this.ppTrial.getNumberOfMetrics() == 1) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(callGraphOption.toString(), bl);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.colorOption = callGraphOption;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            return jRadioButtonMenuItem;
        }
        JMenu jMenu = new JMenu(callGraphOption.toString() + "...");
        int n = 0;
        while (n < this.ppTrial.getNumberOfMetrics()) {
            jRadioButtonMenuItem = n == this.widthMetricID && bl ? new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName(), true) : new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName());
            final int n2 = n++;
            jRadioButtonMenuItem.addActionListener(new ActionListener(){
                final int metric;
                {
                    this.metric = n2;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.colorOption = callGraphOption;
                    CallGraphWindow.this.colorMetricID = this.metric;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        this.optionsMenu = new JMenu("Options");
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        this.slidersCheckBox = new JCheckBoxMenuItem("Show Width Slider", false);
        this.slidersCheckBox.addActionListener(this);
        this.optionsMenu.add(this.slidersCheckBox);
        jMenu = new JMenu("Box width by...");
        buttonGroup = new ButtonGroup();
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.EXCLUSIVE, CallGraphOption.EXCLUSIVE == this.widthOption, buttonGroup));
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.INCLUSIVE, CallGraphOption.INCLUSIVE == this.widthOption, buttonGroup));
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.EXCLUSIVE_PER_CALL, CallGraphOption.EXCLUSIVE_PER_CALL == this.widthOption, buttonGroup));
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.INCLUSIVE_PER_CALL, CallGraphOption.INCLUSIVE_PER_CALL == this.widthOption, buttonGroup));
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", CallGraphOption.NUMCALLS == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.NUMCALLS;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", CallGraphOption.NUMSUBR == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.NUMSUBR;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Static", CallGraphOption.STATIC == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.STATIC;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Name Length", CallGraphOption.NAME_LENGTH == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.NAME_LENGTH;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        jMenu = new JMenu("Box color by...");
        buttonGroup = new ButtonGroup();
        jMenu.add(this.createColorMetricMenu(CallGraphOption.EXCLUSIVE, CallGraphOption.EXCLUSIVE == this.colorOption, buttonGroup));
        jMenu.add(this.createColorMetricMenu(CallGraphOption.INCLUSIVE, CallGraphOption.INCLUSIVE == this.colorOption, buttonGroup));
        jMenu.add(this.createColorMetricMenu(CallGraphOption.EXCLUSIVE_PER_CALL, CallGraphOption.EXCLUSIVE_PER_CALL == this.colorOption, buttonGroup));
        jMenu.add(this.createColorMetricMenu(CallGraphOption.INCLUSIVE_PER_CALL, CallGraphOption.INCLUSIVE_PER_CALL == this.colorOption, buttonGroup));
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", CallGraphOption.NUMCALLS == this.colorOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.colorOption = CallGraphOption.NUMCALLS;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", CallGraphOption.NUMSUBR == this.colorOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.colorOption = CallGraphOption.NUMSUBR;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Static", CallGraphOption.STATIC == this.colorOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.colorOption = CallGraphOption.STATIC;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this, this));
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    private double getMaxValue(CallGraphOption callGraphOption, int n) {
        double d = 1.0;
        int n2 = this.ppTrial.getSelectedSnapshot();
        if (n2 == -1) {
            n2 = this.thread.getNumSnapshots() - 1;
        }
        if (callGraphOption == CallGraphOption.EXCLUSIVE) {
            d = this.thread.getMaxExclusive(n, n2);
        } else if (callGraphOption == CallGraphOption.INCLUSIVE) {
            d = this.thread.getMaxInclusive(n, n2);
        } else if (callGraphOption == CallGraphOption.NUMCALLS) {
            d = this.thread.getMaxNumCalls(n2);
        } else if (callGraphOption == CallGraphOption.NUMSUBR) {
            d = this.thread.getMaxNumSubr(n2);
        } else if (callGraphOption == CallGraphOption.INCLUSIVE_PER_CALL) {
            d = this.thread.getMaxInclusivePerCall(n, n2);
        } else if (callGraphOption == CallGraphOption.EXCLUSIVE_PER_CALL) {
            d = this.thread.getMaxExclusivePerCall(n, n2);
        } else if (callGraphOption == CallGraphOption.STATIC) {
            d = 1.0;
        } else if (this.widthOption == CallGraphOption.NAME_LENGTH) {
            d = 1.0;
        } else {
            throw new ParaProfException("Unexpected CallGraphOption : " + callGraphOption);
        }
        return d;
    }

    private double getValue(FunctionProfile functionProfile, CallGraphOption callGraphOption, double d, int n) {
        int n2 = this.ppTrial.getSelectedSnapshot();
        double d2 = 1.0;
        if (callGraphOption == CallGraphOption.STATIC) {
            d2 = 1.0;
        } else if (callGraphOption == CallGraphOption.EXCLUSIVE) {
            d2 = functionProfile.getExclusive(n2, n) / d;
        } else if (callGraphOption == CallGraphOption.INCLUSIVE) {
            d2 = functionProfile.getInclusive(n2, n) / d;
        } else if (callGraphOption == CallGraphOption.NUMCALLS) {
            d2 = functionProfile.getNumCalls(n2) / d;
        } else if (callGraphOption == CallGraphOption.NUMSUBR) {
            d2 = functionProfile.getNumSubr(n2) / d;
        } else if (callGraphOption == CallGraphOption.INCLUSIVE_PER_CALL) {
            d2 = functionProfile.getInclusivePerCall(n2, n) / d;
        } else if (callGraphOption == CallGraphOption.EXCLUSIVE_PER_CALL) {
            d2 = functionProfile.getExclusivePerCall(n2, n) / d;
        } else if (callGraphOption == CallGraphOption.STATIC) {
            d2 = 1.0;
        } else {
            throw new ParaProfException("Unexpected CallGraphOption : " + callGraphOption);
        }
        return d2;
    }

    private int getWidth(FunctionProfile functionProfile, double d) {
        int n = 0;
        if (this.widthOption == CallGraphOption.NAME_LENGTH) {
            FontMetrics fontMetrics = this.getFontMetrics(this.font);
            n = fontMetrics.stringWidth(functionProfile.getName()) + 5;
        } else {
            n = (int)((double)this.boxWidth * this.getValue(functionProfile, this.widthOption, d, this.widthMetricID));
        }
        return n;
    }

    private List constructGraph() {
        Vertex vertex;
        Vertex vertex2;
        Object object;
        Object object2;
        Object object3;
        List list;
        Object object4;
        FunctionProfile functionProfile;
        this.vertexMap = new HashMap();
        this.backEdges = new ArrayList();
        double d = this.getMaxValue(this.widthOption, this.widthMetricID);
        double d2 = this.getMaxValue(this.colorOption, this.colorMetricID);
        int n = 0;
        while (n < this.functionProfileList.size()) {
            functionProfile = (FunctionProfile)this.functionProfileList.get(n);
            if (functionProfile != null && !functionProfile.isCallPathFunction()) {
                object4 = new Vertex(functionProfile, this.getWidth(functionProfile, d), this.boxHeight);
                ((Vertex)object4).setColorRatio((float)this.getValue(functionProfile, this.colorOption, d2, this.colorMetricID));
                this.vertexMap.put(functionProfile, object4);
            }
            ++n;
        }
        functionProfile = new Stack();
        object4 = new Stack();
        int n2 = 0;
        while (n2 < this.functionProfileList.size()) {
            Vertex vertex3;
            list = (FunctionProfile)this.functionProfileList.get(n2);
            if (list != null && !list.isCallPathFunction() && !(vertex3 = (Vertex)this.vertexMap.get(list)).getVisited()) {
                ((Vector)object4).add(list);
                functionProfile.add(null);
                object3 = list.getChildProfiles();
                while (object3.hasNext()) {
                    object2 = (FunctionProfile)object3.next();
                    functionProfile.add(object2);
                }
                while (!functionProfile.empty()) {
                    object2 = (FunctionProfile)functionProfile.pop();
                    if (object2 == null) {
                        ((Stack)object4).pop();
                        continue;
                    }
                    object = (Vertex)this.vertexMap.get(object2);
                    vertex2 = (FunctionProfile)((Stack)object4).peek();
                    vertex = (Vertex)this.vertexMap.get(vertex2);
                    boolean bl = false;
                    Iterator iterator = ((AbstractList)object4).iterator();
                    while (iterator.hasNext()) {
                        if ((FunctionProfile)iterator.next() != object2) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        this.backEdges.add(new Vertex.BackEdge(vertex, (Vertex)object));
                        continue;
                    }
                    boolean bl2 = false;
                    int n3 = 0;
                    while (n3 < vertex.getChildren().size()) {
                        if (vertex.getChildren().get(n3) == object) {
                            bl2 = true;
                        }
                        ++n3;
                    }
                    if (!bl2) {
                        vertex.getChildren().add(object);
                    }
                    bl2 = false;
                    int n4 = 0;
                    while (n4 < ((Vertex)object).getParents().size()) {
                        if (((Vertex)object).getParents().get(n4) == vertex) {
                            bl2 = true;
                        }
                        ++n4;
                    }
                    if (!bl2) {
                        ((Vertex)object).getParents().add(vertex);
                    }
                    if (((Vertex)object).getVisited()) continue;
                    ((Vertex)object).setVisited(true);
                    ((Vector)object4).add(object2);
                    functionProfile.add(null);
                    Iterator iterator2 = object2.getChildProfiles();
                    while (iterator2.hasNext()) {
                        FunctionProfile functionProfile2 = (FunctionProfile)iterator2.next();
                        functionProfile.add(functionProfile2);
                    }
                }
            }
            ++n2;
        }
        list = Layout.findRoots(this.vertexMap);
        int n5 = 0;
        while (n5 < this.functionProfileList.size()) {
            object3 = (FunctionProfile)this.functionProfileList.get(n5);
            if (object3 != null && !object3.isCallPathFunction() && ((Vertex)(object2 = (Vertex)this.vertexMap.get(object3))).getLevel() == -1) {
                Layout.assignLevel((Vertex)object2);
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.functionProfileList.size()) {
            object2 = (FunctionProfile)this.functionProfileList.get(n6);
            if (object2 != null && !object2.isCallPathFunction()) {
                object = (Vertex)this.vertexMap.get(object2);
                Layout.insertDummies((Vertex)object);
            }
            ++n6;
        }
        int n7 = 0;
        while (n7 < this.functionProfileList.size()) {
            object = (FunctionProfile)this.functionProfileList.get(n7);
            if (object != null && !object.isCallPathFunction()) {
                vertex2 = (Vertex)this.vertexMap.get(object);
                vertex2.setVisited(false);
            }
            ++n7;
        }
        object = new ArrayList();
        int n8 = 0;
        while (n8 < list.size()) {
            vertex = (Vertex)list.get(n8);
            Layout.fillLevels(vertex, (List)object, 0);
            ++n8;
        }
        Layout.runSugiyama((List)object);
        Layout.assignPositions((List)object);
        return object;
    }

    private void createGraph() {
        this.levels = this.constructGraph();
        this.model = new DefaultGraphModel();
        this.graph = new Graph((GraphModel)this.model, this);
        ((Component)((Object)this.graph)).addMouseListener(this.graph);
        ((Component)((Object)this.graph)).addKeyListener(this);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.graph));
        this.createCustomGraph(this.levels, this.backEdges);
        this.jGraphPane = new JScrollPane((Component)((Object)this.graph));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.jGraphPane, gridBagConstraints, 0, 1, 0, 0);
    }

    void recreateGraph() {
        int n = 0;
        while (n < this.graphCellList.size()) {
            DefaultGraphCell defaultGraphCell = (DefaultGraphCell)this.graphCellList.get(n);
            defaultGraphCell.removeAllChildren();
            ++n;
        }
        this.model.remove(this.cells);
        this.reassignWidths(this.levels);
        Layout.assignPositions(this.levels);
        this.createCustomGraph(this.levels, this.backEdges);
    }

    void reassignWidths(List list) {
        double d = this.getMaxValue(this.widthOption, this.widthMetricID);
        double d2 = this.getMaxValue(this.colorOption, this.colorMetricID);
        int n = 0;
        while (n < list.size()) {
            List list2 = (List)list.get(n);
            int n2 = 0;
            while (n2 < list2.size()) {
                Vertex vertex = (Vertex)list2.get(n2);
                if (vertex.getUserObject() != null) {
                    FunctionProfile functionProfile = (FunctionProfile)vertex.getUserObject();
                    vertex.setWidth(this.getWidth(functionProfile, d));
                    if (vertex.getWidth() < 5) {
                        vertex.setWidth(5);
                    }
                    vertex.setColorRatio((float)this.getValue(functionProfile, this.colorOption, d2, this.colorMetricID));
                    vertex.setHeight(this.boxHeight);
                }
                ++n2;
            }
            ++n;
        }
    }

    void createCustomGraph(List list, List list2) {
        GraphCell graphCell;
        Object object;
        Object object2;
        Object object3;
        HashMap hashMap = new HashMap();
        this.graphCellList = new ArrayList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < list.size()) {
            object3 = (List)list.get(n);
            int n2 = 0;
            while (n2 < object3.size()) {
                Vertex vertex = (Vertex)object3.get(n2);
                object2 = null;
                if (vertex.getUserObject() != null) {
                    object2 = this.createGraphCell(vertex, vertex.getPosition() - vertex.getWidth() / 2, 20 + n * 120, vertex.getHeight(), vertex.getWidth(), vertex.getColorRatio(), hashMap);
                    vertex.setGraphCell((GraphCell)((Object)object2));
                    arrayList.add(object2);
                    this.graphCellList.add(object2);
                }
                ++n2;
            }
            ++n;
        }
        object3 = new ConnectionSet();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n3 = 0;
        while (n3 < list.size()) {
            object2 = (List)list.get(n3);
            int n4 = 0;
            while (n4 < object2.size()) {
                object = (Vertex)object2.get(n4);
                if (((Vertex)object).getUserObject() != null) {
                    graphCell = ((Vertex)object).getGraphCell();
                    Iterator iterator = ((Vertex)object).getChildren().iterator();
                    while (iterator.hasNext()) {
                        Object object4;
                        Vertex vertex = (Vertex)iterator.next();
                        if (vertex.getUserObject() != null) {
                            object4 = vertex.getGraphCell();
                            DefaultEdge defaultEdge = this.createEdge(graphCell, (DefaultGraphCell)object4, hashMap, (ConnectionSet)object3, null);
                            arrayList.add(defaultEdge);
                            arrayList2.add(defaultEdge);
                            continue;
                        }
                        object4 = new ArrayList();
                        int n5 = 1;
                        ((ArrayList)object4).add(new Point(3000, 3000));
                        while (vertex.getUserObject() == null) {
                            ((ArrayList)object4).add(new Point(vertex.getPosition(), 20 + (n3 + n5) * 120 + this.boxHeight / 2));
                            vertex = (Vertex)vertex.getChildren().get(0);
                            ++n5;
                        }
                        ((ArrayList)object4).add(new Point(3000, 3000));
                        DefaultEdge defaultEdge = this.createEdge(graphCell, vertex.getGraphCell(), hashMap, (ConnectionSet)object3, (ArrayList)object4);
                        arrayList.add(defaultEdge);
                        arrayList2.add(defaultEdge);
                    }
                }
                ++n4;
            }
            ++n3;
        }
        int n6 = 0;
        while (n6 < list2.size()) {
            Vertex.BackEdge backEdge = (Vertex.BackEdge)list2.get(n6);
            object = new ArrayList<Point>();
            ((ArrayList)object).add(new Point(3000, 3000));
            ((ArrayList)object).add(new Point(backEdge.a.getPosition() + backEdge.a.getWidth() / 2 + 50, backEdge.a.getLevel() * 120 + 20 + this.boxHeight / 2));
            ((ArrayList)object).add(new Point(backEdge.b.getPosition() + 25, backEdge.b.getLevel() * 120 - 25 + 20));
            ((ArrayList)object).add(new Point(3000, 3000));
            graphCell = this.createEdge(backEdge.a.getGraphCell(), backEdge.b.getGraphCell(), hashMap, (ConnectionSet)object3, (ArrayList)object);
            arrayList.add((Object)graphCell);
            arrayList2.add((Object)graphCell);
            ++n6;
        }
        this.cells = arrayList.toArray();
        this.model.insert(this.cells, hashMap, (ConnectionSet)object3, null, null);
        this.moveDownToVisible(arrayList, arrayList2);
    }

    private void moveDownToVisible(List list, List list2) {
        CellView cellView;
        int n = 0;
        int n2 = 0;
        while (n2 < list2.size()) {
            cellView = this.graph.getGraphLayoutCache().getMapping(list2.get(n2), false);
            Rectangle2D rectangle2D = cellView.getBounds();
            if (rectangle2D.getY() < (double)n) {
                n = (int)rectangle2D.getY();
            }
            ++n2;
        }
        if (n != 0) {
            n -= 5;
            cellView = new HashMap();
            int n3 = 0;
            while (n3 < list.size()) {
                DefaultGraphCell defaultGraphCell = (DefaultGraphCell)list.get(n3);
                AttributeMap attributeMap = defaultGraphCell.getAttributes();
                CallGraphWindow.translate((Map)attributeMap, 0.0, -n);
                cellView.put(defaultGraphCell, attributeMap);
                ++n3;
            }
            this.graph.getGraphLayoutCache().edit((Map)cellView, null, null, null);
        }
    }

    public static void translate(Map map, double d, double d2) {
        if (GraphConstants.isMoveable((Map)map)) {
            List list;
            Rectangle2D rectangle2D = GraphConstants.getBounds((Map)map);
            if (rectangle2D != null) {
                int n = GraphConstants.getMoveableAxis((Map)map);
                if (n == 1) {
                    d2 = 0.0;
                } else if (n == 2) {
                    d = 0.0;
                }
                rectangle2D.setFrame(Math.max(0.0, rectangle2D.getX() + d), Math.max(0.0, rectangle2D.getY() + d2), rectangle2D.getWidth(), rectangle2D.getHeight());
                GraphConstants.setBounds((Map)map, (Rectangle2D)rectangle2D);
            }
            if ((list = GraphConstants.getPoints((Map)map)) != null) {
                int n = 0;
                while (n < list.size()) {
                    Object e = list.get(n);
                    if (e instanceof Point2D) {
                        Point2D point2D = (Point2D)e;
                        point2D.setLocation(Math.max(0.0, point2D.getX() + d), Math.max(0.0, point2D.getY() + d2));
                    }
                    ++n;
                }
                GraphConstants.setPoints((Map)map, (List)list);
            }
        }
    }

    public GraphCell createGraphCell(Vertex vertex, int n, int n2, int n3, int n4, float f, Map map) {
        GraphCell graphCell = new GraphCell(vertex);
        Hashtable hashtable = new Hashtable();
        map.put(graphCell, hashtable);
        Rectangle rectangle = new Rectangle(n, n2, n4, n3);
        GraphConstants.setBounds(hashtable, (Rectangle2D)rectangle);
        GraphConstants.setBorderColor(hashtable, (Color)Color.black);
        if (this.colorOption == CallGraphOption.STATIC) {
            GraphConstants.setBackground(hashtable, (Color)Color.orange);
            GraphConstants.setForeground(hashtable, (Color)Color.black);
        } else {
            GraphConstants.setBackground(hashtable, (Color)ColorBar.getColor(f));
            GraphConstants.setForeground(hashtable, (Color)ColorBar.getContrast(ColorBar.getColor(f)));
        }
        GraphConstants.setOpaque(hashtable, (boolean)true);
        GraphConstants.setEditable(hashtable, (boolean)false);
        GraphConstants.setFont(hashtable, (Font)this.font);
        GraphConstants.setBorder(hashtable, (Border)BorderFactory.createRaisedBevelBorder());
        DefaultPort defaultPort = new DefaultPort();
        ((DefaultMutableTreeNode)((Object)graphCell)).add((MutableTreeNode)defaultPort);
        return graphCell;
    }

    public DefaultEdge createEdge(DefaultGraphCell defaultGraphCell, DefaultGraphCell defaultGraphCell2, Map map, ConnectionSet connectionSet, ArrayList arrayList) {
        DefaultEdge defaultEdge = new DefaultEdge();
        Hashtable hashtable = new Hashtable();
        map.put(defaultEdge, hashtable);
        if (arrayList != null) {
            GraphConstants.setPoints(hashtable, (List)arrayList);
            GraphConstants.setLineStyle(hashtable, (int)13);
        }
        GraphConstants.setLineEnd(hashtable, (int)1);
        GraphConstants.setEndFill(hashtable, (boolean)true);
        GraphConstants.setDisconnectable(hashtable, (boolean)false);
        if (defaultGraphCell == defaultGraphCell2) {
            DefaultPort defaultPort = new DefaultPort();
            defaultGraphCell.add((MutableTreeNode)defaultPort);
            connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), (Object)defaultGraphCell.getChildAt(1));
        } else {
            connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), (Object)defaultGraphCell2.getChildAt(0));
        }
        return defaultEdge;
    }

    private void displaySliders(boolean bl) {
        Container container = this.getContentPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (bl) {
            container.remove(this.jGraphPane);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.boxWidthLabel, gridBagConstraints, 0, 1, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.7;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.boxWidthSlider, gridBagConstraints, 1, 1, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.99;
            this.addCompItem(this.jGraphPane, gridBagConstraints, 0, 2, 2, 1);
        } else {
            container.remove(this.boxWidthLabel);
            container.remove(this.boxWidthSlider);
            container.remove(this.jGraphPane);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.addCompItem(this.jGraphPane, gridBagConstraints, 0, 1, 1, 1);
        }
        this.validate();
    }

    public Edge getEdge(FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        Vertex vertex = (Vertex)this.vertexMap.get(functionProfile);
        Vertex vertex2 = (Vertex)this.vertexMap.get(functionProfile2);
        int n = ((DefaultMutableTreeNode)((Object)vertex2.getGraphCell())).getChildCount();
        int n2 = 0;
        while (n2 < n) {
            Port port = (Port)((DefaultMutableTreeNode)((Object)vertex2.getGraphCell())).getChildAt(n2);
            Iterator iterator = port.edges();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                if (edge.getTarget() != port) continue;
                Port port2 = (Port)edge.getSource();
                Object object = this.model.getParent((Object)port2);
                CellView cellView = this.graph.getGraphLayoutCache().getMapping(object, false);
                GraphCell graphCell = (GraphCell)((Object)cellView.getCell());
                if (graphCell.getVertex() != vertex) continue;
                return edge;
            }
            ++n2;
        }
        return null;
    }

    private void handlePrefEvent() {
        this.font = new Font(this.ppTrial.getPreferencesWindow().getFontName(), this.ppTrial.getPreferencesWindow().getFontStyle(), this.ppTrial.getPreferencesWindow().getFontSize());
        this.setFont(this.font);
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.boxHeight = fontMetrics.getHeight() + 5;
        this.recreateGraph();
    }

    public void handleColorEvent() {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        Hashtable hashtable = new Hashtable();
        int n2 = 0;
        while (n2 < this.graphCellList.size()) {
            GraphCell graphCell = (GraphCell)((Object)this.graphCellList.get(n2));
            object4 = graphCell.getVertex();
            object4.setPathHighlight(false);
            n = this.model.getChildCount((Object)graphCell);
            int n3 = 0;
            while (n3 < n) {
                object3 = this.model.getChild((Object)graphCell, n3);
                object2 = this.model.edges(object3);
                while (object2.hasNext()) {
                    Object e = object2.next();
                    object = new HashMap();
                    GraphConstants.setLineColor(object, (Color)Color.black);
                    hashtable.put(e, object);
                }
                ++n3;
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < this.graphCellList.size()) {
            object4 = (GraphCell)((Object)this.graphCellList.get(n4));
            if (((GraphCell)((Object)object4)).function == this.ppTrial.getHighlightedFunction()) {
                n = 0;
                while (n < this.functionProfileList.size()) {
                    FunctionProfile functionProfile = (FunctionProfile)this.functionProfileList.get(n);
                    if (functionProfile != null && (object3 = functionProfile.getFunction()).isCallPathFunction() && ((String)(object2 = object3.getName())).indexOf(((GraphCell)((Object)object4)).getFunction().getName()) != -1) {
                        int n5 = ((String)object2).indexOf("=>");
                        while (n5 != -1) {
                            object = ((String)object2).substring(0, n5);
                            int n6 = ((String)object2).indexOf("=>", n5 + 1);
                            if (n6 == -1) {
                                n6 = ((String)object2).length();
                            }
                            String string = ((String)object2).substring(n5 + 2, n6);
                            FunctionProfile functionProfile2 = this.thread.getFunctionProfile(this.ppTrial.getDataSource().getFunction((String)object));
                            FunctionProfile functionProfile3 = this.thread.getFunctionProfile(this.ppTrial.getDataSource().getFunction(string));
                            Vertex vertex = (Vertex)this.vertexMap.get(functionProfile2);
                            vertex.setPathHighlight(true);
                            vertex = (Vertex)this.vertexMap.get(functionProfile3);
                            vertex.setPathHighlight(true);
                            Edge edge = this.getEdge(functionProfile2, functionProfile3);
                            HashMap hashMap = new HashMap();
                            GraphConstants.setLineColor(hashMap, (Color)Color.blue);
                            if (edge != null) {
                                hashtable.put(edge, hashMap);
                            }
                            object2 = ((String)object2).substring(n5 + 3);
                            n5 = ((String)object2).indexOf("=>");
                        }
                    }
                    ++n;
                }
            }
            ++n4;
        }
        int n7 = 0;
        while (n7 < this.graphCellList.size()) {
            GraphCell graphCell = (GraphCell)((Object)this.graphCellList.get(n7));
            HashMap hashMap = new HashMap();
            if (graphCell.function == this.ppTrial.getHighlightedFunction()) {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createBevelBorder(0, this.ppTrial.getColorChooser().getHighlightColor(), this.ppTrial.getColorChooser().getHighlightColor()));
            } else if (graphCell.getVertex().getPathHighlight()) {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createBevelBorder(0, Color.blue, Color.blue));
            } else if (graphCell.function.isGroupMember(this.ppTrial.getHighlightedGroup())) {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createBevelBorder(0, this.ppTrial.getColorChooser().getGroupHighlightColor(), this.ppTrial.getColorChooser().getGroupHighlightColor()));
            } else {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createRaisedBevelBorder());
            }
            hashtable.put((Object)((Object)graphCell), hashMap);
            ++n7;
        }
        this.graph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        } else if (string.equals("prefEvent")) {
            this.handlePrefEvent();
        } else if (string.equals("colorEvent")) {
            this.handleColorEvent();
        } else if (string.equals("dataEvent")) {
            this.setupMenus();
            this.validate();
            this.recreateGraph();
        }
    }

    public void help(boolean bl) {
        ParaProf.getHelpWindow().clearText();
        if (bl) {
            ((Component)ParaProf.getHelpWindow()).setVisible(true);
        }
        ParaProf.getHelpWindow().writeText("This is the Call Graph Window");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("This window shows you a graph of call paths present in the profile data.");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("Click on a box to highlight paths that go through that function.");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("Right-click on a box to access the Function Data Window for that function.");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("Experiment with the \"Box Width by...\" and \"Box Color by...\" menus (under Options) to display different types of data.");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("If you only see a single line of boxes (no edges connecting them), it probably means that your profile data does not contain call path data.  If you believe this to be incorrect please contact us with the data at tau-bugs@cs.uoregon.edu");
        ParaProf.getHelpWindow().writeText("");
    }

    public Dimension getViewportSize() {
        return this.jGraphPane.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.jGraphPane.getViewport().getViewRect();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        ((Component)this).setVisible(false);
        this.ppTrial.deleteObserver(this);
        ParaProf.decrementNumWindows();
        this.dispose();
    }

    public GraphCell getGraphCellForLocation(int n, int n2) {
        int n3 = 0;
        while (n3 < this.graphCellList.size()) {
            GraphCell graphCell = (GraphCell)((Object)this.graphCellList.get(n3));
            AttributeMap attributeMap = graphCell.getAttributes();
            Rectangle2D rectangle2D = GraphConstants.getBounds((Map)attributeMap);
            if (rectangle2D.contains(n, n2)) {
                return graphCell;
            }
            ++n3;
        }
        return null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.boxWidth = this.boxWidthSlider.getValue();
            this.recreateGraph();
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        try {
            char c = keyEvent.getKeyChar();
            if (c == '+' || c == '=') {
                this.scale += 0.1;
                if (this.scale > 5.0) {
                    this.scale = 5.0;
                }
                this.graph.setScale(this.scale);
            } else if (c == '-' || c == '_') {
                this.scale -= 0.1;
                if (this.scale < 0.1) {
                    this.scale = 0.1;
                }
                this.graph.setScale(this.scale);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        if (bl) {
            return this.getPreferredSize();
        }
        return this.getSize();
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        if (!bl) {
            ((JComponent)((Object)this.graph)).setDoubleBuffered(false);
        }
        if (bl2) {
            ((Component)((Object)this.graph)).paintAll(graphics2D);
        } else {
            ((JComponent)((Object)this.graph)).paint(graphics2D);
        }
        if (!bl) {
            ((JComponent)((Object)this.graph)).setDoubleBuffered(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        double d;
        block4: {
            int n2;
            block3: {
                d = this.graph.getScale();
                try {
                    ((JComponent)((Object)this.graph)).setDoubleBuffered(false);
                    if (n >= 1) {
                        n2 = 1;
                        Object var8_6 = null;
                        ((JComponent)((Object)this.graph)).setDoubleBuffered(true);
                        break block3;
                    }
                    ParaProfUtils.scaleForPrint(graphics, pageFormat, ((JComponent)((Object)this.graph)).getWidth(), ((JComponent)((Object)this.graph)).getHeight());
                    ((JComponent)((Object)this.graph)).paint(graphics);
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    ((JComponent)((Object)this.graph)).setDoubleBuffered(true);
                    this.graph.setScale(d);
                    throw throwable;
                }
            }
            this.graph.setScale(d);
            return n2;
        }
        Object var8_7 = null;
        ((JComponent)((Object)this.graph)).setDoubleBuffered(true);
        this.graph.setScale(d);
        return 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem && (string = actionEvent.getActionCommand()).equals("Show Width Slider")) {
                if (this.slidersCheckBox.isSelected()) {
                    this.displaySliders(true);
                } else {
                    this.displaySliders(false);
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private class Graph
    extends JGraph
    implements MouseListener {
        private CallGraphWindow callGraphWindow;

        public String getToolTipText(MouseEvent mouseEvent) {
            double d;
            double d2 = (double)mouseEvent.getX() / this.getScale();
            GraphCell graphCell = this.callGraphWindow.getGraphCellForLocation((int)d2, (int)(d = (double)mouseEvent.getY() / this.getScale()));
            if (graphCell != null) {
                return graphCell.getToolTipString();
            }
            return null;
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                double d = (double)mouseEvent.getX() / this.getScale();
                double d2 = (double)mouseEvent.getY() / this.getScale();
                GraphCell graphCell = this.callGraphWindow.getGraphCellForLocation((int)d, (int)d2);
                if (graphCell != null) {
                    Function function = graphCell.getFunction();
                    if (ParaProfUtils.rightClick(mouseEvent)) {
                        JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(CallGraphWindow.this.ppTrial, function, CallGraphWindow.this.thread, (Component)((Object)this));
                        jPopupMenu.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        CallGraphWindow.this.ppTrial.toggleHighlightedFunction(function);
                    }
                }
            }
            catch (Exception exception) {
                ParaProfUtils.handleException(exception);
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.setSize(dimension.width + 10, dimension.height + 10);
            return dimension;
        }

        public Graph(GraphModel graphModel, CallGraphWindow callGraphWindow2) {
            super(graphModel);
            this.callGraphWindow = callGraphWindow2;
            this.setSelectionModel((org.jgraph.graph.GraphSelectionModel)new GraphSelectionModel(this));
        }
    }

    public class GraphCell
    extends DefaultGraphCell {
        private final Function function;
        private final FunctionProfile functionProfile;
        private final Vertex vertex;

        public GraphCell(Vertex vertex) {
            super((Object)((FunctionProfile)vertex.getUserObject()).getFunction());
            this.functionProfile = (FunctionProfile)vertex.getUserObject();
            this.function = this.functionProfile.getFunction();
            this.vertex = vertex;
        }

        public String getToolTipString() {
            float f;
            String string = "<html>" + this.function;
            if (CallGraphWindow.this.widthOption != CallGraphOption.STATIC && CallGraphWindow.this.widthOption != CallGraphOption.NAME_LENGTH) {
                f = (float)CallGraphWindow.this.getValue(this.functionProfile, CallGraphWindow.this.widthOption, 1.0, CallGraphWindow.this.widthMetricID);
                string = string + "<br>Width Value (" + CallGraphWindow.this.widthOption;
                if (CallGraphWindow.this.widthOption != CallGraphOption.NUMCALLS && CallGraphWindow.this.widthOption != CallGraphOption.NUMSUBR) {
                    string = string + ", " + CallGraphWindow.this.ppTrial.getMetricName(CallGraphWindow.this.widthMetricID);
                }
                string = string + ") : " + f;
            }
            if (CallGraphWindow.this.colorOption != CallGraphOption.STATIC) {
                f = (float)CallGraphWindow.this.getValue(this.functionProfile, CallGraphWindow.this.colorOption, 1.0, CallGraphWindow.this.colorMetricID);
                string = string + "<br>Color Value (" + CallGraphWindow.this.colorOption;
                if (CallGraphWindow.this.colorOption != CallGraphOption.NUMCALLS && CallGraphWindow.this.colorOption != CallGraphOption.NUMSUBR) {
                    string = string + ", " + CallGraphWindow.this.ppTrial.getMetricName(CallGraphWindow.this.colorMetricID);
                }
                string = string + ") : " + f;
            }
            return string;
        }

        public Function getFunction() {
            return this.function;
        }

        public Vertex getVertex() {
            return this.vertex;
        }
    }

    private static class GraphSelectionModel
    extends DefaultGraphSelectionModel {
        GraphSelectionModel(JGraph jGraph) {
            super(jGraph);
        }

        public Object[] getSelectables() {
            if (this.isChildrenSelectable()) {
                ArrayList arrayList = new ArrayList();
                Stack<Object> stack = new Stack<Object>();
                GraphModel graphModel = this.graph.getModel();
                int n = 0;
                while (n < graphModel.getRootCount()) {
                    stack.add(graphModel.getRootAt(n));
                    ++n;
                }
                while (!stack.isEmpty()) {
                    Object e = stack.pop();
                    if (!graphModel.isPort(e) && !graphModel.isEdge(e)) {
                        arrayList.add(e);
                    }
                    if (!this.isChildrenSelectable(e)) continue;
                    int n2 = 0;
                    while (n2 < graphModel.getChildCount(e)) {
                        stack.add(graphModel.getChild(e, n2));
                        ++n2;
                    }
                }
                return arrayList.toArray();
            }
            return this.graph.getRoots();
        }
    }
}

