/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.UnitListener;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class HistogramWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
ChangeListener,
ParaProfWindow,
UnitListener,
Printable,
ImageExport {
    private ParaProfTrial ppTrial;
    private DataSorter dataSorter;
    private Function function;
    private ChartPanel chartPanel;
    private JMenu unitsSubMenu = null;
    private List data = null;
    private int units = ParaProf.preferences.getUnits();
    private JCheckBoxMenuItem slidersCheckBox = null;
    private JLabel numBinsLabel = new JLabel("Number of Bins");
    private JSlider numBinsSlider = new JSlider(0, 100, 10);
    private int numBins = 10;

    public HistogramWindow(ParaProfTrial paraProfTrial, Function function, Component component) {
        this.ppTrial = paraProfTrial;
        paraProfTrial.addObserver(this);
        this.dataSorter = new DataSorter(paraProfTrial);
        this.function = function;
        this.setTitle("TAU: ParaProf: Histogram: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        ParaProfUtils.setFrameIcon(this);
        ((Component)this).setSize(ParaProfUtils.checkSize(new Dimension(670, 630)));
        ((Component)this).setLocation(WindowPlacer.getNewLocation(this, component));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HistogramWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.getHelpWindow().isVisible()) {
            this.help(false);
        }
        this.sortLocalData();
        this.numBinsSlider.setPaintTicks(true);
        this.numBinsSlider.setMajorTickSpacing(50);
        this.numBinsSlider.setMinorTickSpacing(10);
        this.numBinsSlider.setPaintLabels(true);
        this.numBinsSlider.setSnapToTicks(false);
        this.numBinsSlider.addChangeListener(this);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JFreeChart jFreeChart = this.createChart();
        this.chartPanel = new ChartPanel(jFreeChart);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.95;
        gridBagConstraints.weighty = 0.98;
        this.addCompItem((Component)this.chartPanel, gridBagConstraints, 0, 0, 1, 1);
        this.setupMenus();
        ParaProf.incrementNumWindows();
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        JMenu jMenu2 = new JMenu("Options");
        this.slidersCheckBox = new JCheckBoxMenuItem("Show Number of Bins Slider", false);
        this.slidersCheckBox.addActionListener(this);
        jMenu2.add(this.slidersCheckBox);
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        this.unitsSubMenu = ParaProfUtils.createUnitsMenu(this, this.units, true);
        jMenu2.add(this.unitsSubMenu);
        jMenu = new JMenu("Select Value Type");
        buttonGroup = new ButtonGroup();
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Exclusive", true);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Inclusive", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Inclusive per Call", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Exclusive per Call", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jMenu2.add(jMenu);
        jMenu2.addMenuListener(this);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this, this));
        jMenuBar.add(jMenu2);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block11: {
            try {
                Object object = actionEvent.getSource();
                if (!(object instanceof JMenuItem)) break block11;
                String string = actionEvent.getActionCommand();
                if (string.equals("Exclusive")) {
                    this.dataSorter.setValueType(ValueType.EXCLUSIVE);
                    this.sortLocalData();
                    break block11;
                }
                if (string.equals("Inclusive")) {
                    this.dataSorter.setValueType(ValueType.INCLUSIVE);
                    this.sortLocalData();
                    break block11;
                }
                if (string.equals("Number of Calls")) {
                    this.dataSorter.setValueType(ValueType.NUMCALLS);
                    this.sortLocalData();
                    break block11;
                }
                if (string.equals("Number of Child Calls")) {
                    this.dataSorter.setValueType(ValueType.NUMSUBR);
                    this.sortLocalData();
                    break block11;
                }
                if (string.equals("Inclusive per Call")) {
                    this.dataSorter.setValueType(ValueType.INCLUSIVE_PER_CALL);
                    this.sortLocalData();
                    break block11;
                }
                if (string.equals("Exclusive per Call")) {
                    this.dataSorter.setValueType(ValueType.EXCLUSIVE_PER_CALL);
                    this.sortLocalData();
                    break block11;
                }
                if (string.equals("Show Number of Bins Slider")) {
                    if (this.slidersCheckBox.isSelected()) {
                        this.displaySliders(true);
                    } else {
                        this.displaySliders(false);
                    }
                    break block11;
                }
                throw new ParaProfException("The menu item '" + string + "' is not implemented!");
            }
            catch (Exception exception) {
                ParaProfUtils.handleException(exception);
            }
        }
    }

    private void displaySliders(boolean bl) {
        Container container = this.getContentPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (bl) {
            container.remove((Component)this.chartPanel);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.numBinsLabel, gridBagConstraints, 0, 1, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.7;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.numBinsSlider, gridBagConstraints, 1, 1, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.99;
            this.addCompItem((Component)this.chartPanel, gridBagConstraints, 0, 2, 2, 1);
        } else {
            container.remove(this.numBinsLabel);
            container.remove(this.numBinsSlider);
            container.remove((Component)this.chartPanel);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.addCompItem((Component)this.chartPanel, gridBagConstraints, 0, 1, 1, 1);
        }
        this.validate();
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.ppTrial.isTimeMetric()) {
                this.unitsSubMenu.setEnabled(true);
            } else {
                this.unitsSubMenu.setEnabled(false);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.setNumBins(this.numBinsSlider.getValue());
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.redraw();
        } else if (string.equals("colorEvent")) {
            this.redraw();
        } else if (string.equals("dataEvent")) {
            this.dataSorter.setSelectedMetricID(this.ppTrial.getDefaultMetricID());
            this.sortLocalData();
            this.redraw();
        } else if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        }
    }

    public void help(boolean bl) {
        ParaProf.getHelpWindow().clearText();
        if (bl) {
            ParaProf.getHelpWindow().show();
        }
        ParaProf.getHelpWindow().writeText("This is the histogram window");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("This window shows you a histogram of all of the values for this function.");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("Use the options menu to select different types of data to display.");
        ParaProf.getHelpWindow().writeText("");
    }

    private void sortLocalData() {
        this.data = this.dataSorter.getFunctionData(this.function, false, false);
        this.redraw();
    }

    public String getHeaderString() {
        if (this.ppTrial.getDataSource().getPhasesPresent()) {
            String string = this.function.isCallPathFunction() ? "Phase: " + UtilFncs.getLeftSide((String)this.function.getName()) + "\nName: " + UtilFncs.getRightSide((String)this.function.getName()) : "Name: " + this.function.getName();
            string = string + "\nMetric: " + this.ppTrial.getMetricName(this.dataSorter.getSelectedMetricID()) + "\nValue: " + this.dataSorter.getValueType();
            if (this.dataSorter.getValueType() == ValueType.NUMCALLS || this.dataSorter.getValueType() == ValueType.NUMSUBR) {
                return string;
            }
            return string + "\nUnits: " + UtilFncs.getUnitsString((int)this.units, (boolean)this.dataSorter.isTimeMetric(), (boolean)this.dataSorter.isDerivedMetric()) + "\n";
        }
        if (this.dataSorter.getValueType() == ValueType.NUMCALLS || this.dataSorter.getValueType() == ValueType.NUMSUBR) {
            return "Metric Name: " + this.ppTrial.getMetricName(this.ppTrial.getDefaultMetricID()) + "\n" + "Name: " + ParaProfUtils.getDisplayName(this.function) + "\n" + "Value Type: " + this.dataSorter.getValueType() + "\n";
        }
        return "Metric Name: " + this.ppTrial.getMetricName(this.ppTrial.getDefaultMetricID()) + "\n" + "Name: " + ParaProfUtils.getDisplayName(this.function) + "\n" + "Value Type: " + this.dataSorter.getValueType() + "\n" + "Units: " + UtilFncs.getUnitsString((int)this.units, (boolean)this.ppTrial.isTimeMetric(), (boolean)this.ppTrial.isDerivedMetric()) + "\n";
    }

    public List getData() {
        return this.data;
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        try {
            ((Component)this).setVisible(false);
            this.ppTrial.deleteObserver(this);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    public int units() {
        if (!this.dataSorter.isTimeMetric()) {
            return 0;
        }
        if (this.dataSorter.getValueType() == ValueType.NUMCALLS || this.dataSorter.getValueType() == ValueType.NUMSUBR) {
            return 0;
        }
        return this.units;
    }

    public void setNumBins(int n) {
        this.numBins = Math.max(1, n);
        this.redraw();
    }

    public int getNumBins() {
        return this.numBins;
    }

    private JFreeChart createChart() {
        Object object;
        Object object2;
        HistogramDataset histogramDataset = new HistogramDataset();
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = true;
        int n = 0;
        while (n < this.data.size()) {
            object2 = (PPFunctionProfile)this.data.get(n);
            double d3 = ((PPFunctionProfile)object2).getValue();
            if (bl) {
                d2 = d3;
                bl = false;
            }
            d = Math.max(d, d3);
            d2 = Math.min(d2, d3);
            ++n;
        }
        object2 = new double[this.data.size()];
        int n2 = 0;
        while (n2 < this.data.size()) {
            object = (PPFunctionProfile)this.data.get(n2);
            object2[n2] = ((PPFunctionProfile)object).getValue();
            ++n2;
        }
        histogramDataset.addSeries(this.function.getName(), (double[])object2, this.numBins, d2, d);
        object = this.dataSorter.getValueType().toString();
        if (this.dataSorter.getValueType() != ValueType.NUMCALLS && this.dataSorter.getValueType() != ValueType.NUMSUBR) {
            object = (String)object + " " + this.ppTrial.getMetricName(this.dataSorter.getSelectedMetricID()) + " (" + UtilFncs.getUnitsString((int)this.units, (boolean)this.dataSorter.isTimeMetric(), (boolean)this.dataSorter.isDerivedMetric()) + ")";
        }
        JFreeChart jFreeChart = ChartFactory.createHistogram((String)this.function.getName(), (String)object, (String)"Threads", (IntervalXYDataset)histogramDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        jFreeChart.getXYPlot().getDomainAxis().setUpperBound(d);
        jFreeChart.getXYPlot().getDomainAxis().setLowerBound(d2);
        NumberAxis numberAxis = (NumberAxis)jFreeChart.getXYPlot().getDomainAxis();
        numberAxis.setNumberFormatOverride(ParaProfUtils.createNumberFormatter(this.units()));
        numberAxis.setTickLabelsVisible(true);
        numberAxis.setTickUnit(new NumberTickUnit((d - d2) / 10.0));
        final double d4 = (d - d2) / (double)this.numBins;
        XYItemRenderer xYItemRenderer = jFreeChart.getXYPlot().getRenderer();
        xYItemRenderer.setToolTipGenerator(new XYToolTipGenerator(){

            public String generateToolTip(XYDataset xYDataset, int n, int n2) {
                String string = UtilFncs.getOutputString((int)HistogramWindow.this.units(), (double)(xYDataset.getXValue(n, n2) - d4 / 2.0), (int)5);
                String string2 = UtilFncs.getOutputString((int)HistogramWindow.this.units(), (double)(xYDataset.getXValue(n, n2) + d4 / 2.0), (int)5);
                return "<html>Number of threads: " + (int)xYDataset.getYValue(n, n2) + "<br>Range minimum: " + string + "<br>Range maximum: " + string2 + "</html>";
            }
        });
        if (this.numBins < 25) {
            ((XYBarRenderer)jFreeChart.getXYPlot().getRenderer()).setMargin(0.1);
        }
        ((XYBarRenderer)jFreeChart.getXYPlot().getRenderer()).setOutlinePaint((Paint)Color.black);
        return jFreeChart;
    }

    private void redraw() {
        if (this.chartPanel != null) {
            this.chartPanel.setChart(this.createChart());
        }
    }

    public void setUnits(int n) {
        this.units = n;
        this.redraw();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return this.chartPanel.print(graphics, pageFormat, n);
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        this.chartPanel.setDoubleBuffered(false);
        this.chartPanel.paintAll(graphics2D);
        this.chartPanel.setDoubleBuffered(true);
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        return this.chartPanel.getSize();
    }
}

